package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1

import dev.hnaderi.k8s.client._

/** Pointer for JSONSchemaProps */
final case class JSONSchemaPropsPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps] {
  def exclusiveMaximum : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"exclusiveMaximum")
  def format : Pointer.Plain[String] = Pointer.Plain(currentPath / s"format")
  def ref : Pointer.Plain[String] = Pointer.Plain(currentPath / s"$$ref")
  def nullable : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"nullable")
  def `x-kubernetes-map-type` : Pointer.Plain[String] = Pointer.Plain(currentPath / s"x-kubernetes-map-type")
  def pattern : Pointer.Plain[String] = Pointer.Plain(currentPath / s"pattern")
  def description : Pointer.Plain[String] = Pointer.Plain(currentPath / s"description")
  def anyOf : ListPointer[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps] = ListPointer(currentPath / s"anyOf")
  def `x-kubernetes-list-type` : Pointer.Plain[String] = Pointer.Plain(currentPath / s"x-kubernetes-list-type")
  def patternProperties : MapPointer[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps] = MapPointer(currentPath / s"patternProperties")
  def items : Pointer.Plain[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrArray] = Pointer.Plain(currentPath / s"items")
  def additionalItems : Pointer.Plain[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrBool] = Pointer.Plain(currentPath / s"additionalItems")
  def maxProperties : Pointer.Plain[Long] = Pointer.Plain(currentPath / s"maxProperties")
  def maxItems : Pointer.Plain[Long] = Pointer.Plain(currentPath / s"maxItems")
  def `x-kubernetes-int-or-string` : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"x-kubernetes-int-or-string")
  def `x-kubernetes-embedded-resource` : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"x-kubernetes-embedded-resource")
  def maximum : Pointer.Plain[Double] = Pointer.Plain(currentPath / s"maximum")
  def multipleOf : Pointer.Plain[Double] = Pointer.Plain(currentPath / s"multipleOf")
  def id : Pointer.Plain[String] = Pointer.Plain(currentPath / s"id")
  def properties : MapPointer[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps] = MapPointer(currentPath / s"properties")
  def exclusiveMinimum : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"exclusiveMinimum")
  def `x-kubernetes-validations` : ListPointer[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule] = ListPointer(currentPath / s"x-kubernetes-validations")
  def `enum` : ListPointer[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON] = ListPointer(currentPath / s"enum")
  def `x-kubernetes-preserve-unknown-fields` : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"x-kubernetes-preserve-unknown-fields")
  def additionalProperties : Pointer.Plain[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrBool] = Pointer.Plain(currentPath / s"additionalProperties")
  def default : Pointer.Plain[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON] = Pointer.Plain(currentPath / s"default")
  def minItems : Pointer.Plain[Long] = Pointer.Plain(currentPath / s"minItems")
  def not :  io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsPointer = io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsPointer(currentPath / s"not")
  def definitions : MapPointer[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps] = MapPointer(currentPath / s"definitions")
  def minLength : Pointer.Plain[Long] = Pointer.Plain(currentPath / s"minLength")
  def `x-kubernetes-list-map-keys` : ListPointer[String] = ListPointer(currentPath / s"x-kubernetes-list-map-keys")
  def title : Pointer.Plain[String] = Pointer.Plain(currentPath / s"title")
  def minimum : Pointer.Plain[Double] = Pointer.Plain(currentPath / s"minimum")
  def `type` : Pointer.Plain[String] = Pointer.Plain(currentPath / s"type")
  def required : ListPointer[String] = ListPointer(currentPath / s"required")
  def example : Pointer.Plain[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON] = Pointer.Plain(currentPath / s"example")
  def schema : Pointer.Plain[String] = Pointer.Plain(currentPath / s"$$schema")
  def oneOf : ListPointer[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps] = ListPointer(currentPath / s"oneOf")
  def uniqueItems : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"uniqueItems")
  def minProperties : Pointer.Plain[Long] = Pointer.Plain(currentPath / s"minProperties")
  def dependencies : MapPointer[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrStringArray] = MapPointer(currentPath / s"dependencies")
  def externalDocs :  io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ExternalDocumentationPointer = io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ExternalDocumentationPointer(currentPath / s"externalDocs")
  def maxLength : Pointer.Plain[Long] = Pointer.Plain(currentPath / s"maxLength")
  def allOf : ListPointer[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps] = ListPointer(currentPath / s"allOf")
}


