package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for SecretVolumeSource */
final case class SecretVolumeSourcePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.SecretVolumeSource] {
  def defaultMode : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"defaultMode")
  def items : ListPointer[io.k8s.api.core.v1.KeyToPath] = ListPointer(currentPath / s"items")
  def optional : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"optional")
  def secretName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"secretName")
}


