package io.k8s.api.node.v1

import dev.hnaderi.k8s.client._

/** Pointer for RuntimeClass */
final case class RuntimeClassPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.node.v1.RuntimeClass] {
  def handler : Pointer.Plain[String] = Pointer.Plain(currentPath / s"handler")
  def scheduling :  io.k8s.api.node.v1.SchedulingPointer = io.k8s.api.node.v1.SchedulingPointer(currentPath / s"scheduling")
  def overhead :  io.k8s.api.node.v1.OverheadPointer = io.k8s.api.node.v1.OverheadPointer(currentPath / s"overhead")
  def metadata :  io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer = io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer(currentPath / s"metadata")
}


