package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for Event */
final case class EventPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.Event] {
  def involvedObject :  io.k8s.api.core.v1.ObjectReferencePointer = io.k8s.api.core.v1.ObjectReferencePointer(currentPath / s"involvedObject")
  def metadata :  io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer = io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer(currentPath / s"metadata")
  def series :  io.k8s.api.core.v1.EventSeriesPointer = io.k8s.api.core.v1.EventSeriesPointer(currentPath / s"series")
  def count : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"count")
  def source :  io.k8s.api.core.v1.EventSourcePointer = io.k8s.api.core.v1.EventSourcePointer(currentPath / s"source")
  def reportingComponent : Pointer.Plain[String] = Pointer.Plain(currentPath / s"reportingComponent")
  def reason : Pointer.Plain[String] = Pointer.Plain(currentPath / s"reason")
  def related :  io.k8s.api.core.v1.ObjectReferencePointer = io.k8s.api.core.v1.ObjectReferencePointer(currentPath / s"related")
  def eventTime : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = Pointer.Plain(currentPath / s"eventTime")
  def lastTimestamp : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"lastTimestamp")
  def message : Pointer.Plain[String] = Pointer.Plain(currentPath / s"message")
  def firstTimestamp : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"firstTimestamp")
  def `type` : Pointer.Plain[String] = Pointer.Plain(currentPath / s"type")
  def reportingInstance : Pointer.Plain[String] = Pointer.Plain(currentPath / s"reportingInstance")
  def action : Pointer.Plain[String] = Pointer.Plain(currentPath / s"action")
}


