package io.k8s.api.authorization.v1

import dev.hnaderi.k8s.client._

/** Pointer for ResourceRule */
final case class ResourceRulePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.authorization.v1.ResourceRule] {
  def verbs : ListPointer[String] = ListPointer(currentPath / s"verbs")
  def apiGroups : ListPointer[String] = ListPointer(currentPath / s"apiGroups")
  def resourceNames : ListPointer[String] = ListPointer(currentPath / s"resourceNames")
  def resources : ListPointer[String] = ListPointer(currentPath / s"resources")
}


