package io.k8s.api.apps.v1

import dev.hnaderi.k8s.client._

/** Pointer for StatefulSet */
final case class StatefulSetPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.apps.v1.StatefulSet] {
  def status :  io.k8s.api.apps.v1.StatefulSetStatusPointer = io.k8s.api.apps.v1.StatefulSetStatusPointer(currentPath / s"status")
  def spec :  io.k8s.api.apps.v1.StatefulSetSpecPointer = io.k8s.api.apps.v1.StatefulSetSpecPointer(currentPath / s"spec")
  def metadata :  io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer = io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer(currentPath / s"metadata")
}


