package dev.hnaderi.k8s.client.pointers.io.k8s.api.storage.v1

import dev.hnaderi.k8s.client._

final case class CSIDriverSpecPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.storage.v1.CSIDriverSpec] {
  def volumeLifecycleModes : ListPointer[String] = ListPointer(currentPath / s"volumeLifecycleModes")
  def podInfoOnMount : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"podInfoOnMount")
  def attachRequired : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"attachRequired")
  def requiresRepublish : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"requiresRepublish")
  def fsGroupPolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"fsGroupPolicy")
  def storageCapacity : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"storageCapacity")
  def tokenRequests : ListPointer[io.k8s.api.storage.v1.TokenRequest] = ListPointer(currentPath / s"tokenRequests")
  def seLinuxMount : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"seLinuxMount")
}


