package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class SecretPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.Secret] {
  def data : MapPointer[String] = MapPointer(currentPath / s"data")
  def immutable : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"immutable")
  def metadata :  pointers.io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer = pointers.io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer(currentPath / s"metadata")
  def `type` : Pointer.Plain[String] = Pointer.Plain(currentPath / s"type")
  def stringData : MapPointer[String] = MapPointer(currentPath / s"stringData")
}


