package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class ReplicationControllerStatusPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.ReplicationControllerStatus] {
  def replicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"replicas")
  def conditions : ListPointer[io.k8s.api.core.v1.ReplicationControllerCondition] = ListPointer(currentPath / s"conditions")
  def availableReplicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"availableReplicas")
  def observedGeneration : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"observedGeneration")
  def readyReplicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"readyReplicas")
  def fullyLabeledReplicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"fullyLabeledReplicas")
}


