package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class PodSpecPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.PodSpec] {
  def containers : ListPointer[io.k8s.api.core.v1.Container] = ListPointer(currentPath / s"containers")
  def priority : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"priority")
  def hostIPC : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"hostIPC")
  def serviceAccount : Pointer.Plain[String] = Pointer.Plain(currentPath / s"serviceAccount")
  def schedulerName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"schedulerName")
  def hostname : Pointer.Plain[String] = Pointer.Plain(currentPath / s"hostname")
  def imagePullSecrets : ListPointer[io.k8s.api.core.v1.LocalObjectReference] = ListPointer(currentPath / s"imagePullSecrets")
  def affinity :  pointers.io.k8s.api.core.v1.AffinityPointer = pointers.io.k8s.api.core.v1.AffinityPointer(currentPath / s"affinity")
  def os :  pointers.io.k8s.api.core.v1.PodOSPointer = pointers.io.k8s.api.core.v1.PodOSPointer(currentPath / s"os")
  def nodeName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"nodeName")
  def ephemeralContainers : ListPointer[io.k8s.api.core.v1.EphemeralContainer] = ListPointer(currentPath / s"ephemeralContainers")
  def initContainers : ListPointer[io.k8s.api.core.v1.Container] = ListPointer(currentPath / s"initContainers")
  def shareProcessNamespace : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"shareProcessNamespace")
  def setHostnameAsFQDN : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"setHostnameAsFQDN")
  def enableServiceLinks : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"enableServiceLinks")
  def preemptionPolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"preemptionPolicy")
  def dnsPolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"dnsPolicy")
  def volumes : ListPointer[io.k8s.api.core.v1.Volume] = ListPointer(currentPath / s"volumes")
  def hostAliases : ListPointer[io.k8s.api.core.v1.HostAlias] = ListPointer(currentPath / s"hostAliases")
  def subdomain : Pointer.Plain[String] = Pointer.Plain(currentPath / s"subdomain")
  def topologySpreadConstraints : ListPointer[io.k8s.api.core.v1.TopologySpreadConstraint] = ListPointer(currentPath / s"topologySpreadConstraints")
  def overhead : MapPointer[io.k8s.apimachinery.pkg.api.resource.Quantity] = MapPointer(currentPath / s"overhead")
  def tolerations : ListPointer[io.k8s.api.core.v1.Toleration] = ListPointer(currentPath / s"tolerations")
  def automountServiceAccountToken : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"automountServiceAccountToken")
  def nodeSelector : MapPointer[String] = MapPointer(currentPath / s"nodeSelector")
  def hostPID : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"hostPID")
  def terminationGracePeriodSeconds : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"terminationGracePeriodSeconds")
  def dnsConfig :  pointers.io.k8s.api.core.v1.PodDNSConfigPointer = pointers.io.k8s.api.core.v1.PodDNSConfigPointer(currentPath / s"dnsConfig")
  def priorityClassName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"priorityClassName")
  def serviceAccountName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"serviceAccountName")
  def restartPolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"restartPolicy")
  def hostUsers : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"hostUsers")
  def runtimeClassName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"runtimeClassName")
  def readinessGates : ListPointer[io.k8s.api.core.v1.PodReadinessGate] = ListPointer(currentPath / s"readinessGates")
  def activeDeadlineSeconds : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"activeDeadlineSeconds")
  def hostNetwork : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"hostNetwork")
  def securityContext :  pointers.io.k8s.api.core.v1.PodSecurityContextPointer = pointers.io.k8s.api.core.v1.PodSecurityContextPointer(currentPath / s"securityContext")
}


