package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class PersistentVolumeSpecPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.PersistentVolumeSpec] {
  def scaleIO :  pointers.io.k8s.api.core.v1.ScaleIOPersistentVolumeSourcePointer = pointers.io.k8s.api.core.v1.ScaleIOPersistentVolumeSourcePointer(currentPath / s"scaleIO")
  def csi :  pointers.io.k8s.api.core.v1.CSIPersistentVolumeSourcePointer = pointers.io.k8s.api.core.v1.CSIPersistentVolumeSourcePointer(currentPath / s"csi")
  def accessModes : ListPointer[String] = ListPointer(currentPath / s"accessModes")
  def mountOptions : ListPointer[String] = ListPointer(currentPath / s"mountOptions")
  def nodeAffinity :  pointers.io.k8s.api.core.v1.VolumeNodeAffinityPointer = pointers.io.k8s.api.core.v1.VolumeNodeAffinityPointer(currentPath / s"nodeAffinity")
  def azureDisk :  pointers.io.k8s.api.core.v1.AzureDiskVolumeSourcePointer = pointers.io.k8s.api.core.v1.AzureDiskVolumeSourcePointer(currentPath / s"azureDisk")
  def azureFile :  pointers.io.k8s.api.core.v1.AzureFilePersistentVolumeSourcePointer = pointers.io.k8s.api.core.v1.AzureFilePersistentVolumeSourcePointer(currentPath / s"azureFile")
  def hostPath :  pointers.io.k8s.api.core.v1.HostPathVolumeSourcePointer = pointers.io.k8s.api.core.v1.HostPathVolumeSourcePointer(currentPath / s"hostPath")
  def rbd :  pointers.io.k8s.api.core.v1.RBDPersistentVolumeSourcePointer = pointers.io.k8s.api.core.v1.RBDPersistentVolumeSourcePointer(currentPath / s"rbd")
  def portworxVolume :  pointers.io.k8s.api.core.v1.PortworxVolumeSourcePointer = pointers.io.k8s.api.core.v1.PortworxVolumeSourcePointer(currentPath / s"portworxVolume")
  def persistentVolumeReclaimPolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"persistentVolumeReclaimPolicy")
  def glusterfs :  pointers.io.k8s.api.core.v1.GlusterfsPersistentVolumeSourcePointer = pointers.io.k8s.api.core.v1.GlusterfsPersistentVolumeSourcePointer(currentPath / s"glusterfs")
  def volumeMode : Pointer.Plain[String] = Pointer.Plain(currentPath / s"volumeMode")
  def flocker :  pointers.io.k8s.api.core.v1.FlockerVolumeSourcePointer = pointers.io.k8s.api.core.v1.FlockerVolumeSourcePointer(currentPath / s"flocker")
  def claimRef :  pointers.io.k8s.api.core.v1.ObjectReferencePointer = pointers.io.k8s.api.core.v1.ObjectReferencePointer(currentPath / s"claimRef")
  def fc :  pointers.io.k8s.api.core.v1.FCVolumeSourcePointer = pointers.io.k8s.api.core.v1.FCVolumeSourcePointer(currentPath / s"fc")
  def local :  pointers.io.k8s.api.core.v1.LocalVolumeSourcePointer = pointers.io.k8s.api.core.v1.LocalVolumeSourcePointer(currentPath / s"local")
  def storageClassName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"storageClassName")
  def photonPersistentDisk :  pointers.io.k8s.api.core.v1.PhotonPersistentDiskVolumeSourcePointer = pointers.io.k8s.api.core.v1.PhotonPersistentDiskVolumeSourcePointer(currentPath / s"photonPersistentDisk")
  def gcePersistentDisk :  pointers.io.k8s.api.core.v1.GCEPersistentDiskVolumeSourcePointer = pointers.io.k8s.api.core.v1.GCEPersistentDiskVolumeSourcePointer(currentPath / s"gcePersistentDisk")
  def vsphereVolume :  pointers.io.k8s.api.core.v1.VsphereVirtualDiskVolumeSourcePointer = pointers.io.k8s.api.core.v1.VsphereVirtualDiskVolumeSourcePointer(currentPath / s"vsphereVolume")
  def iscsi :  pointers.io.k8s.api.core.v1.ISCSIPersistentVolumeSourcePointer = pointers.io.k8s.api.core.v1.ISCSIPersistentVolumeSourcePointer(currentPath / s"iscsi")
  def cinder :  pointers.io.k8s.api.core.v1.CinderPersistentVolumeSourcePointer = pointers.io.k8s.api.core.v1.CinderPersistentVolumeSourcePointer(currentPath / s"cinder")
  def cephfs :  pointers.io.k8s.api.core.v1.CephFSPersistentVolumeSourcePointer = pointers.io.k8s.api.core.v1.CephFSPersistentVolumeSourcePointer(currentPath / s"cephfs")
  def awsElasticBlockStore :  pointers.io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSourcePointer = pointers.io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSourcePointer(currentPath / s"awsElasticBlockStore")
  def flexVolume :  pointers.io.k8s.api.core.v1.FlexPersistentVolumeSourcePointer = pointers.io.k8s.api.core.v1.FlexPersistentVolumeSourcePointer(currentPath / s"flexVolume")
  def nfs :  pointers.io.k8s.api.core.v1.NFSVolumeSourcePointer = pointers.io.k8s.api.core.v1.NFSVolumeSourcePointer(currentPath / s"nfs")
  def quobyte :  pointers.io.k8s.api.core.v1.QuobyteVolumeSourcePointer = pointers.io.k8s.api.core.v1.QuobyteVolumeSourcePointer(currentPath / s"quobyte")
  def storageos :  pointers.io.k8s.api.core.v1.StorageOSPersistentVolumeSourcePointer = pointers.io.k8s.api.core.v1.StorageOSPersistentVolumeSourcePointer(currentPath / s"storageos")
  def capacity : MapPointer[io.k8s.apimachinery.pkg.api.resource.Quantity] = MapPointer(currentPath / s"capacity")
}


