package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class HTTPGetActionPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.HTTPGetAction] {
  def port : Pointer.Plain[io.k8s.apimachinery.pkg.util.intstr.IntOrString] = Pointer.Plain(currentPath / s"port")
  def path : Pointer.Plain[String] = Pointer.Plain(currentPath / s"path")
  def host : Pointer.Plain[String] = Pointer.Plain(currentPath / s"host")
  def scheme : Pointer.Plain[String] = Pointer.Plain(currentPath / s"scheme")
  def httpHeaders : ListPointer[io.k8s.api.core.v1.HTTPHeader] = ListPointer(currentPath / s"httpHeaders")
}


