package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class FlexVolumeSourcePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.FlexVolumeSource] {
  def driver : Pointer.Plain[String] = Pointer.Plain(currentPath / s"driver")
  def readOnly : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"readOnly")
  def fsType : Pointer.Plain[String] = Pointer.Plain(currentPath / s"fsType")
  def secretRef :  pointers.io.k8s.api.core.v1.LocalObjectReferencePointer = pointers.io.k8s.api.core.v1.LocalObjectReferencePointer(currentPath / s"secretRef")
  def options : MapPointer[String] = MapPointer(currentPath / s"options")
}


