package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class EventPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.Event] {
  def involvedObject :  pointers.io.k8s.api.core.v1.ObjectReferencePointer = pointers.io.k8s.api.core.v1.ObjectReferencePointer(currentPath / s"involvedObject")
  def metadata :  pointers.io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer = pointers.io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer(currentPath / s"metadata")
  def series :  pointers.io.k8s.api.core.v1.EventSeriesPointer = pointers.io.k8s.api.core.v1.EventSeriesPointer(currentPath / s"series")
  def count : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"count")
  def source :  pointers.io.k8s.api.core.v1.EventSourcePointer = pointers.io.k8s.api.core.v1.EventSourcePointer(currentPath / s"source")
  def reportingComponent : Pointer.Plain[String] = Pointer.Plain(currentPath / s"reportingComponent")
  def reason : Pointer.Plain[String] = Pointer.Plain(currentPath / s"reason")
  def related :  pointers.io.k8s.api.core.v1.ObjectReferencePointer = pointers.io.k8s.api.core.v1.ObjectReferencePointer(currentPath / s"related")
  def eventTime : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = Pointer.Plain(currentPath / s"eventTime")
  def lastTimestamp : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"lastTimestamp")
  def message : Pointer.Plain[String] = Pointer.Plain(currentPath / s"message")
  def firstTimestamp : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"firstTimestamp")
  def `type` : Pointer.Plain[String] = Pointer.Plain(currentPath / s"type")
  def reportingInstance : Pointer.Plain[String] = Pointer.Plain(currentPath / s"reportingInstance")
  def action : Pointer.Plain[String] = Pointer.Plain(currentPath / s"action")
}


