package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class ContainerStatusPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.ContainerStatus] {
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def image : Pointer.Plain[String] = Pointer.Plain(currentPath / s"image")
  def restartCount : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"restartCount")
  def ready : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"ready")
  def imageID : Pointer.Plain[String] = Pointer.Plain(currentPath / s"imageID")
  def state :  pointers.io.k8s.api.core.v1.ContainerStatePointer = pointers.io.k8s.api.core.v1.ContainerStatePointer(currentPath / s"state")
  def lastState :  pointers.io.k8s.api.core.v1.ContainerStatePointer = pointers.io.k8s.api.core.v1.ContainerStatePointer(currentPath / s"lastState")
  def containerID : Pointer.Plain[String] = Pointer.Plain(currentPath / s"containerID")
  def started : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"started")
}


