package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class CSIPersistentVolumeSourcePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.CSIPersistentVolumeSource] {
  def volumeHandle : Pointer.Plain[String] = Pointer.Plain(currentPath / s"volumeHandle")
  def driver : Pointer.Plain[String] = Pointer.Plain(currentPath / s"driver")
  def nodeStageSecretRef :  pointers.io.k8s.api.core.v1.SecretReferencePointer = pointers.io.k8s.api.core.v1.SecretReferencePointer(currentPath / s"nodeStageSecretRef")
  def readOnly : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"readOnly")
  def fsType : Pointer.Plain[String] = Pointer.Plain(currentPath / s"fsType")
  def controllerPublishSecretRef :  pointers.io.k8s.api.core.v1.SecretReferencePointer = pointers.io.k8s.api.core.v1.SecretReferencePointer(currentPath / s"controllerPublishSecretRef")
  def volumeAttributes : MapPointer[String] = MapPointer(currentPath / s"volumeAttributes")
  def controllerExpandSecretRef :  pointers.io.k8s.api.core.v1.SecretReferencePointer = pointers.io.k8s.api.core.v1.SecretReferencePointer(currentPath / s"controllerExpandSecretRef")
  def nodeExpandSecretRef :  pointers.io.k8s.api.core.v1.SecretReferencePointer = pointers.io.k8s.api.core.v1.SecretReferencePointer(currentPath / s"nodeExpandSecretRef")
  def nodePublishSecretRef :  pointers.io.k8s.api.core.v1.SecretReferencePointer = pointers.io.k8s.api.core.v1.SecretReferencePointer(currentPath / s"nodePublishSecretRef")
}


