package io.k8s.api.admissionregistration.v1

import dev.hnaderi.k8s.client._

/** Pointer for MutatingWebhook */
final case class MutatingWebhookPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.admissionregistration.v1.MutatingWebhook] {
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def sideEffects : Pointer.Plain[String] = Pointer.Plain(currentPath / s"sideEffects")
  def clientConfig :  io.k8s.api.admissionregistration.v1.WebhookClientConfigPointer = io.k8s.api.admissionregistration.v1.WebhookClientConfigPointer(currentPath / s"clientConfig")
  def admissionReviewVersions : ListPointer[String] = ListPointer(currentPath / s"admissionReviewVersions")
  def timeoutSeconds : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"timeoutSeconds")
  def matchConditions : ListPointer[io.k8s.api.admissionregistration.v1.MatchCondition] = ListPointer(currentPath / s"matchConditions")
  def matchPolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"matchPolicy")
  def namespaceSelector :  io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer = io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer(currentPath / s"namespaceSelector")
  def failurePolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"failurePolicy")
  def reinvocationPolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"reinvocationPolicy")
  def rules : ListPointer[io.k8s.api.admissionregistration.v1.RuleWithOperations] = ListPointer(currentPath / s"rules")
  def objectSelector :  io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer = io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer(currentPath / s"objectSelector")
}


