package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for ContainerState */
final case class ContainerStatePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.ContainerState] {
  def running :  io.k8s.api.core.v1.ContainerStateRunningPointer = io.k8s.api.core.v1.ContainerStateRunningPointer(currentPath / s"running")
  def terminated :  io.k8s.api.core.v1.ContainerStateTerminatedPointer = io.k8s.api.core.v1.ContainerStateTerminatedPointer(currentPath / s"terminated")
  def waiting :  io.k8s.api.core.v1.ContainerStateWaitingPointer = io.k8s.api.core.v1.ContainerStateWaitingPointer(currentPath / s"waiting")
}


