package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s.client._

/** Pointer for StatusDetails */
final case class StatusDetailsPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails] {
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def causes : ListPointer[io.k8s.apimachinery.pkg.apis.meta.v1.StatusCause] = ListPointer(currentPath / s"causes")
  def uid : Pointer.Plain[String] = Pointer.Plain(currentPath / s"uid")
  def retryAfterSeconds : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"retryAfterSeconds")
  def group : Pointer.Plain[String] = Pointer.Plain(currentPath / s"group")
}


