package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s.client._

/** Pointer for APIResource */
final case class APIResourcePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.apimachinery.pkg.apis.meta.v1.APIResource] {
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def verbs : ListPointer[String] = ListPointer(currentPath / s"verbs")
  def namespaced : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"namespaced")
  def singularName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"singularName")
  def version : Pointer.Plain[String] = Pointer.Plain(currentPath / s"version")
  def categories : ListPointer[String] = ListPointer(currentPath / s"categories")
  def shortNames : ListPointer[String] = ListPointer(currentPath / s"shortNames")
  def storageVersionHash : Pointer.Plain[String] = Pointer.Plain(currentPath / s"storageVersionHash")
  def group : Pointer.Plain[String] = Pointer.Plain(currentPath / s"group")
}


