package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for SecurityContext */
final case class SecurityContextPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.SecurityContext] {
  def capabilities :  io.k8s.api.core.v1.CapabilitiesPointer = io.k8s.api.core.v1.CapabilitiesPointer(currentPath / s"capabilities")
  def readOnlyRootFilesystem : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"readOnlyRootFilesystem")
  def allowPrivilegeEscalation : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"allowPrivilegeEscalation")
  def procMount : Pointer.Plain[String] = Pointer.Plain(currentPath / s"procMount")
  def runAsGroup : Pointer.Plain[Long] = Pointer.Plain(currentPath / s"runAsGroup")
  def seccompProfile :  io.k8s.api.core.v1.SeccompProfilePointer = io.k8s.api.core.v1.SeccompProfilePointer(currentPath / s"seccompProfile")
  def windowsOptions :  io.k8s.api.core.v1.WindowsSecurityContextOptionsPointer = io.k8s.api.core.v1.WindowsSecurityContextOptionsPointer(currentPath / s"windowsOptions")
  def seLinuxOptions :  io.k8s.api.core.v1.SELinuxOptionsPointer = io.k8s.api.core.v1.SELinuxOptionsPointer(currentPath / s"seLinuxOptions")
  def runAsUser : Pointer.Plain[Long] = Pointer.Plain(currentPath / s"runAsUser")
  def privileged : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"privileged")
  def appArmorProfile :  io.k8s.api.core.v1.AppArmorProfilePointer = io.k8s.api.core.v1.AppArmorProfilePointer(currentPath / s"appArmorProfile")
  def runAsNonRoot : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"runAsNonRoot")
}


