package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s.client._

/** Pointer for OwnerReference */
final case class OwnerReferencePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference] {
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def uid : Pointer.Plain[String] = Pointer.Plain(currentPath / s"uid")
  def kind : Pointer.Plain[String] = Pointer.Plain(currentPath / s"kind")
  def apiVersion : Pointer.Plain[String] = Pointer.Plain(currentPath / s"apiVersion")
  def blockOwnerDeletion : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"blockOwnerDeletion")
  def controller : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"controller")
}


