package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for PodAffinityTerm */
final case class PodAffinityTermPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.PodAffinityTerm] {
  def topologyKey : Pointer.Plain[String] = Pointer.Plain(currentPath / s"topologyKey")
  def matchLabelKeys : ListPointer[String] = ListPointer(currentPath / s"matchLabelKeys")
  def labelSelector :  io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer = io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer(currentPath / s"labelSelector")
  def namespaceSelector :  io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer = io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer(currentPath / s"namespaceSelector")
  def mismatchLabelKeys : ListPointer[String] = ListPointer(currentPath / s"mismatchLabelKeys")
  def namespaces : ListPointer[String] = ListPointer(currentPath / s"namespaces")
}


