package io.k8s.api.apps.v1

import dev.hnaderi.k8s.client._

/** Pointer for DaemonSetStatus */
final case class DaemonSetStatusPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.apps.v1.DaemonSetStatus] {
  def numberMisscheduled : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"numberMisscheduled")
  def currentNumberScheduled : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"currentNumberScheduled")
  def desiredNumberScheduled : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"desiredNumberScheduled")
  def numberReady : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"numberReady")
  def conditions : ListPointer[io.k8s.api.apps.v1.DaemonSetCondition] = ListPointer(currentPath / s"conditions")
  def updatedNumberScheduled : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"updatedNumberScheduled")
  def collisionCount : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"collisionCount")
  def numberUnavailable : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"numberUnavailable")
  def observedGeneration : Pointer.Plain[Long] = Pointer.Plain(currentPath / s"observedGeneration")
  def numberAvailable : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"numberAvailable")
}


