package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for NodeConfigStatus */
final case class NodeConfigStatusPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.NodeConfigStatus] {
  def active :  io.k8s.api.core.v1.NodeConfigSourcePointer = io.k8s.api.core.v1.NodeConfigSourcePointer(currentPath / s"active")
  def assigned :  io.k8s.api.core.v1.NodeConfigSourcePointer = io.k8s.api.core.v1.NodeConfigSourcePointer(currentPath / s"assigned")
  def error : Pointer.Plain[String] = Pointer.Plain(currentPath / s"error")
  def lastKnownGood :  io.k8s.api.core.v1.NodeConfigSourcePointer = io.k8s.api.core.v1.NodeConfigSourcePointer(currentPath / s"lastKnownGood")
}


