package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for ServicePort */
final case class ServicePortPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.ServicePort] {
  def port : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"port")
  def nodePort : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"nodePort")
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def targetPort : Pointer.Plain[io.k8s.apimachinery.pkg.util.intstr.IntOrString] = Pointer.Plain(currentPath / s"targetPort")
  def protocol : Pointer.Plain[String] = Pointer.Plain(currentPath / s"protocol")
  def appProtocol : Pointer.Plain[String] = Pointer.Plain(currentPath / s"appProtocol")
}


