package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for ObjectReference */
final case class ObjectReferencePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.ObjectReference] {
  def fieldPath : Pointer.Plain[String] = Pointer.Plain(currentPath / s"fieldPath")
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def resourceVersion : Pointer.Plain[String] = Pointer.Plain(currentPath / s"resourceVersion")
  def uid : Pointer.Plain[String] = Pointer.Plain(currentPath / s"uid")
  def namespace : Pointer.Plain[String] = Pointer.Plain(currentPath / s"namespace")
}


