package io.k8s.api.policy.v1

import dev.hnaderi.k8s.client._

/** Pointer for PodDisruptionBudgetStatus */
final case class PodDisruptionBudgetStatusPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.policy.v1.PodDisruptionBudgetStatus] {
  def disruptionsAllowed : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"disruptionsAllowed")
  def desiredHealthy : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"desiredHealthy")
  def expectedPods : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"expectedPods")
  def currentHealthy : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"currentHealthy")
  def conditions : ListPointer[io.k8s.apimachinery.pkg.apis.meta.v1.Condition] = ListPointer(currentPath / s"conditions")
  def disruptedPods : MapPointer[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = MapPointer(currentPath / s"disruptedPods")
  def observedGeneration : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"observedGeneration")
}


