package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for PodSecurityContext */
final case class PodSecurityContextPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.PodSecurityContext] {
  def fsGroupChangePolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"fsGroupChangePolicy")
  def sysctls : ListPointer[io.k8s.api.core.v1.Sysctl] = ListPointer(currentPath / s"sysctls")
  def fsGroup : Pointer.Plain[Long] = Pointer.Plain(currentPath / s"fsGroup")
  def supplementalGroups : ListPointer[Long] = ListPointer(currentPath / s"supplementalGroups")
  def runAsGroup : Pointer.Plain[Long] = Pointer.Plain(currentPath / s"runAsGroup")
  def seccompProfile :  io.k8s.api.core.v1.SeccompProfilePointer = io.k8s.api.core.v1.SeccompProfilePointer(currentPath / s"seccompProfile")
  def windowsOptions :  io.k8s.api.core.v1.WindowsSecurityContextOptionsPointer = io.k8s.api.core.v1.WindowsSecurityContextOptionsPointer(currentPath / s"windowsOptions")
  def seLinuxOptions :  io.k8s.api.core.v1.SELinuxOptionsPointer = io.k8s.api.core.v1.SELinuxOptionsPointer(currentPath / s"seLinuxOptions")
  def runAsUser : Pointer.Plain[Long] = Pointer.Plain(currentPath / s"runAsUser")
  def appArmorProfile :  io.k8s.api.core.v1.AppArmorProfilePointer = io.k8s.api.core.v1.AppArmorProfilePointer(currentPath / s"appArmorProfile")
  def runAsNonRoot : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"runAsNonRoot")
}


