package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for TopologySpreadConstraint */
final case class TopologySpreadConstraintPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.TopologySpreadConstraint] {
  def maxSkew : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"maxSkew")
  def topologyKey : Pointer.Plain[String] = Pointer.Plain(currentPath / s"topologyKey")
  def whenUnsatisfiable : Pointer.Plain[String] = Pointer.Plain(currentPath / s"whenUnsatisfiable")
  def matchLabelKeys : ListPointer[String] = ListPointer(currentPath / s"matchLabelKeys")
  def minDomains : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"minDomains")
  def labelSelector :  io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer = io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer(currentPath / s"labelSelector")
  def nodeAffinityPolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"nodeAffinityPolicy")
  def nodeTaintsPolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"nodeTaintsPolicy")
}


