package io.k8s.api.rbac.v1

import dev.hnaderi.k8s.client._

/** Pointer for Subject */
final case class SubjectPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.rbac.v1.Subject] {
  def kind : Pointer.Plain[String] = Pointer.Plain(currentPath / s"kind")
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def apiGroup : Pointer.Plain[String] = Pointer.Plain(currentPath / s"apiGroup")
  def namespace : Pointer.Plain[String] = Pointer.Plain(currentPath / s"namespace")
}


