package io.k8s.api.apps.v1

import dev.hnaderi.k8s.client._

/** Pointer for Deployment */
final case class DeploymentPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.apps.v1.Deployment] {
  def status :  io.k8s.api.apps.v1.DeploymentStatusPointer = io.k8s.api.apps.v1.DeploymentStatusPointer(currentPath / s"status")
  def spec :  io.k8s.api.apps.v1.DeploymentSpecPointer = io.k8s.api.apps.v1.DeploymentSpecPointer(currentPath / s"spec")
  def metadata :  io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer = io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer(currentPath / s"metadata")
}


