package dev.hnaderi.k8s
package circe

import io.circe._
import io.circe.syntax._
import cats.implicits._

object codecs extends ResourceCodecs {
  implicit val resourceEncoder : Encoder[KObject] = Encoder.instance{
    case o : io.k8s.apimachinery.pkg.apis.meta.v1.APIGroup => o.asJson
    case o : io.k8s.apimachinery.pkg.apis.meta.v1.APIGroupList => o.asJson
    case o : io.k8s.apimachinery.pkg.apis.meta.v1.APIResourceList => o.asJson
    case o : io.k8s.apimachinery.pkg.apis.meta.v1.APIVersions => o.asJson
    case o : io.k8s.api.core.v1.Binding => o.asJson
    case o : io.k8s.api.core.v1.ComponentStatus => o.asJson
    case o : io.k8s.api.core.v1.ComponentStatusList => o.asJson
    case o : io.k8s.api.core.v1.ConfigMap => o.asJson
    case o : io.k8s.api.core.v1.ConfigMapList => o.asJson
    case o : io.k8s.api.core.v1.Endpoints => o.asJson
    case o : io.k8s.api.core.v1.EndpointsList => o.asJson
    case o : io.k8s.api.core.v1.Event => o.asJson
    case o : io.k8s.api.core.v1.EventList => o.asJson
    case o : io.k8s.api.core.v1.LimitRange => o.asJson
    case o : io.k8s.api.core.v1.LimitRangeList => o.asJson
    case o : io.k8s.api.core.v1.Namespace => o.asJson
    case o : io.k8s.api.core.v1.NamespaceList => o.asJson
    case o : io.k8s.api.core.v1.Node => o.asJson
    case o : io.k8s.api.core.v1.NodeList => o.asJson
    case o : io.k8s.api.core.v1.PersistentVolume => o.asJson
    case o : io.k8s.api.core.v1.PersistentVolumeClaim => o.asJson
    case o : io.k8s.api.core.v1.PersistentVolumeClaimList => o.asJson
    case o : io.k8s.api.core.v1.PersistentVolumeList => o.asJson
    case o : io.k8s.api.core.v1.Pod => o.asJson
    case o : io.k8s.api.core.v1.PodList => o.asJson
    case o : io.k8s.api.core.v1.PodTemplate => o.asJson
    case o : io.k8s.api.core.v1.PodTemplateList => o.asJson
    case o : io.k8s.api.core.v1.ReplicationController => o.asJson
    case o : io.k8s.api.core.v1.ReplicationControllerList => o.asJson
    case o : io.k8s.api.core.v1.ResourceQuota => o.asJson
    case o : io.k8s.api.core.v1.ResourceQuotaList => o.asJson
    case o : io.k8s.api.core.v1.Secret => o.asJson
    case o : io.k8s.api.core.v1.SecretList => o.asJson
    case o : io.k8s.api.core.v1.Service => o.asJson
    case o : io.k8s.api.core.v1.ServiceAccount => o.asJson
    case o : io.k8s.api.core.v1.ServiceAccountList => o.asJson
    case o : io.k8s.api.core.v1.ServiceList => o.asJson
    case o : io.k8s.apimachinery.pkg.apis.meta.v1.Status => o.asJson
    case o : io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration => o.asJson
    case o : io.k8s.api.admissionregistration.v1.MutatingWebhookConfigurationList => o.asJson
    case o : io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration => o.asJson
    case o : io.k8s.api.admissionregistration.v1.ValidatingWebhookConfigurationList => o.asJson
    case o : io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition => o.asJson
    case o : io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList => o.asJson
    case o : io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIService => o.asJson
    case o : io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceList => o.asJson
    case o : io.k8s.api.apps.v1.ControllerRevision => o.asJson
    case o : io.k8s.api.apps.v1.ControllerRevisionList => o.asJson
    case o : io.k8s.api.apps.v1.DaemonSet => o.asJson
    case o : io.k8s.api.apps.v1.DaemonSetList => o.asJson
    case o : io.k8s.api.apps.v1.Deployment => o.asJson
    case o : io.k8s.api.apps.v1.DeploymentList => o.asJson
    case o : io.k8s.api.apps.v1.ReplicaSet => o.asJson
    case o : io.k8s.api.apps.v1.ReplicaSetList => o.asJson
    case o : io.k8s.api.apps.v1.StatefulSet => o.asJson
    case o : io.k8s.api.apps.v1.StatefulSetList => o.asJson
    case o : io.k8s.api.authentication.v1.TokenRequest => o.asJson
    case o : io.k8s.api.authentication.v1.TokenReview => o.asJson
    case o : io.k8s.api.authorization.v1.LocalSubjectAccessReview => o.asJson
    case o : io.k8s.api.authorization.v1.SelfSubjectAccessReview => o.asJson
    case o : io.k8s.api.authorization.v1.SelfSubjectRulesReview => o.asJson
    case o : io.k8s.api.authorization.v1.SubjectAccessReview => o.asJson
    case o : io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler => o.asJson
    case o : io.k8s.api.autoscaling.v2.HorizontalPodAutoscaler => o.asJson
    case o : io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler => o.asJson
    case o : io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList => o.asJson
    case o : io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerList => o.asJson
    case o : io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList => o.asJson
    case o : io.k8s.api.autoscaling.v1.Scale => o.asJson
    case o : io.k8s.api.batch.v1.CronJob => o.asJson
    case o : io.k8s.api.batch.v1.CronJobList => o.asJson
    case o : io.k8s.api.batch.v1.Job => o.asJson
    case o : io.k8s.api.batch.v1.JobList => o.asJson
    case o : io.k8s.api.certificates.v1.CertificateSigningRequest => o.asJson
    case o : io.k8s.api.certificates.v1.CertificateSigningRequestList => o.asJson
    case o : io.k8s.api.coordination.v1.Lease => o.asJson
    case o : io.k8s.api.coordination.v1.LeaseList => o.asJson
    case o : io.k8s.api.discovery.v1.EndpointSlice => o.asJson
    case o : io.k8s.api.discovery.v1.EndpointSliceList => o.asJson
    case o : io.k8s.api.events.v1.Event => o.asJson
    case o : io.k8s.api.events.v1.EventList => o.asJson
    case o : io.k8s.api.flowcontrol.v1beta1.FlowSchema => o.asJson
    case o : io.k8s.api.flowcontrol.v1beta2.FlowSchema => o.asJson
    case o : io.k8s.api.flowcontrol.v1beta1.FlowSchemaList => o.asJson
    case o : io.k8s.api.flowcontrol.v1beta2.FlowSchemaList => o.asJson
    case o : io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfiguration => o.asJson
    case o : io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfiguration => o.asJson
    case o : io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationList => o.asJson
    case o : io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationList => o.asJson
    case o : io.k8s.api.apiserverinternal.v1alpha1.StorageVersion => o.asJson
    case o : io.k8s.api.apiserverinternal.v1alpha1.StorageVersionList => o.asJson
    case o : io.k8s.api.networking.v1alpha1.ClusterCIDR => o.asJson
    case o : io.k8s.api.networking.v1alpha1.ClusterCIDRList => o.asJson
    case o : io.k8s.api.networking.v1.Ingress => o.asJson
    case o : io.k8s.api.networking.v1.IngressClass => o.asJson
    case o : io.k8s.api.networking.v1.IngressClassList => o.asJson
    case o : io.k8s.api.networking.v1.IngressList => o.asJson
    case o : io.k8s.api.networking.v1.NetworkPolicy => o.asJson
    case o : io.k8s.api.networking.v1.NetworkPolicyList => o.asJson
    case o : io.k8s.api.node.v1.RuntimeClass => o.asJson
    case o : io.k8s.api.node.v1.RuntimeClassList => o.asJson
    case o : io.k8s.api.policy.v1.Eviction => o.asJson
    case o : io.k8s.api.policy.v1.PodDisruptionBudget => o.asJson
    case o : io.k8s.api.policy.v1.PodDisruptionBudgetList => o.asJson
    case o : io.k8s.api.rbac.v1.ClusterRole => o.asJson
    case o : io.k8s.api.rbac.v1.ClusterRoleBinding => o.asJson
    case o : io.k8s.api.rbac.v1.ClusterRoleBindingList => o.asJson
    case o : io.k8s.api.rbac.v1.ClusterRoleList => o.asJson
    case o : io.k8s.api.rbac.v1.Role => o.asJson
    case o : io.k8s.api.rbac.v1.RoleBinding => o.asJson
    case o : io.k8s.api.rbac.v1.RoleBindingList => o.asJson
    case o : io.k8s.api.rbac.v1.RoleList => o.asJson
    case o : io.k8s.api.scheduling.v1.PriorityClass => o.asJson
    case o : io.k8s.api.scheduling.v1.PriorityClassList => o.asJson
    case o : io.k8s.api.storage.v1.CSIDriver => o.asJson
    case o : io.k8s.api.storage.v1.CSIDriverList => o.asJson
    case o : io.k8s.api.storage.v1.CSINode => o.asJson
    case o : io.k8s.api.storage.v1.CSINodeList => o.asJson
    case o : io.k8s.api.storage.v1.CSIStorageCapacity => o.asJson
    case o : io.k8s.api.storage.v1beta1.CSIStorageCapacity => o.asJson
    case o : io.k8s.api.storage.v1.CSIStorageCapacityList => o.asJson
    case o : io.k8s.api.storage.v1beta1.CSIStorageCapacityList => o.asJson
    case o : io.k8s.api.storage.v1.StorageClass => o.asJson
    case o : io.k8s.api.storage.v1.StorageClassList => o.asJson
    case o : io.k8s.api.storage.v1.VolumeAttachment => o.asJson
    case o : io.k8s.api.storage.v1.VolumeAttachmentList => o.asJson
}
    private val groupDecoder : (String, String) => Decoder[KObject]  = {
    case ("APIGroup", "v1") => codecs.io_k8s_apimachinery_pkg_apis_meta_v1APIGroupDecoder.widen
    case ("APIGroupList", "v1") => codecs.io_k8s_apimachinery_pkg_apis_meta_v1APIGroupListDecoder.widen
    case ("APIResourceList", "v1") => codecs.io_k8s_apimachinery_pkg_apis_meta_v1APIResourceListDecoder.widen
    case ("APIVersions", "v1") => codecs.io_k8s_apimachinery_pkg_apis_meta_v1APIVersionsDecoder.widen
    case ("Binding", "v1") => codecs.io_k8s_api_core_v1BindingDecoder.widen
    case ("ComponentStatus", "v1") => codecs.io_k8s_api_core_v1ComponentStatusDecoder.widen
    case ("ComponentStatusList", "v1") => codecs.io_k8s_api_core_v1ComponentStatusListDecoder.widen
    case ("ConfigMap", "v1") => codecs.io_k8s_api_core_v1ConfigMapDecoder.widen
    case ("ConfigMapList", "v1") => codecs.io_k8s_api_core_v1ConfigMapListDecoder.widen
    case ("Endpoints", "v1") => codecs.io_k8s_api_core_v1EndpointsDecoder.widen
    case ("EndpointsList", "v1") => codecs.io_k8s_api_core_v1EndpointsListDecoder.widen
    case ("Event", "v1") => codecs.io_k8s_api_core_v1EventDecoder.widen
    case ("EventList", "v1") => codecs.io_k8s_api_core_v1EventListDecoder.widen
    case ("LimitRange", "v1") => codecs.io_k8s_api_core_v1LimitRangeDecoder.widen
    case ("LimitRangeList", "v1") => codecs.io_k8s_api_core_v1LimitRangeListDecoder.widen
    case ("Namespace", "v1") => codecs.io_k8s_api_core_v1NamespaceDecoder.widen
    case ("NamespaceList", "v1") => codecs.io_k8s_api_core_v1NamespaceListDecoder.widen
    case ("Node", "v1") => codecs.io_k8s_api_core_v1NodeDecoder.widen
    case ("NodeList", "v1") => codecs.io_k8s_api_core_v1NodeListDecoder.widen
    case ("PersistentVolume", "v1") => codecs.io_k8s_api_core_v1PersistentVolumeDecoder.widen
    case ("PersistentVolumeClaim", "v1") => codecs.io_k8s_api_core_v1PersistentVolumeClaimDecoder.widen
    case ("PersistentVolumeClaimList", "v1") => codecs.io_k8s_api_core_v1PersistentVolumeClaimListDecoder.widen
    case ("PersistentVolumeList", "v1") => codecs.io_k8s_api_core_v1PersistentVolumeListDecoder.widen
    case ("Pod", "v1") => codecs.io_k8s_api_core_v1PodDecoder.widen
    case ("PodList", "v1") => codecs.io_k8s_api_core_v1PodListDecoder.widen
    case ("PodTemplate", "v1") => codecs.io_k8s_api_core_v1PodTemplateDecoder.widen
    case ("PodTemplateList", "v1") => codecs.io_k8s_api_core_v1PodTemplateListDecoder.widen
    case ("ReplicationController", "v1") => codecs.io_k8s_api_core_v1ReplicationControllerDecoder.widen
    case ("ReplicationControllerList", "v1") => codecs.io_k8s_api_core_v1ReplicationControllerListDecoder.widen
    case ("ResourceQuota", "v1") => codecs.io_k8s_api_core_v1ResourceQuotaDecoder.widen
    case ("ResourceQuotaList", "v1") => codecs.io_k8s_api_core_v1ResourceQuotaListDecoder.widen
    case ("Secret", "v1") => codecs.io_k8s_api_core_v1SecretDecoder.widen
    case ("SecretList", "v1") => codecs.io_k8s_api_core_v1SecretListDecoder.widen
    case ("Service", "v1") => codecs.io_k8s_api_core_v1ServiceDecoder.widen
    case ("ServiceAccount", "v1") => codecs.io_k8s_api_core_v1ServiceAccountDecoder.widen
    case ("ServiceAccountList", "v1") => codecs.io_k8s_api_core_v1ServiceAccountListDecoder.widen
    case ("ServiceList", "v1") => codecs.io_k8s_api_core_v1ServiceListDecoder.widen
    case ("Status", "v1") => codecs.io_k8s_apimachinery_pkg_apis_meta_v1StatusDecoder.widen
    case (kind, version) => Decoder.failedWithMessage(s"Unknown kubernetes object: group: , kind: $kind, version: $version")
}
  private val groupauthorization_k8s_ioDecoder : (String, String) => Decoder[KObject]  = {
    case ("LocalSubjectAccessReview", "v1") => codecs.io_k8s_api_authorization_v1LocalSubjectAccessReviewDecoder.widen
    case ("SelfSubjectAccessReview", "v1") => codecs.io_k8s_api_authorization_v1SelfSubjectAccessReviewDecoder.widen
    case ("SelfSubjectRulesReview", "v1") => codecs.io_k8s_api_authorization_v1SelfSubjectRulesReviewDecoder.widen
    case ("SubjectAccessReview", "v1") => codecs.io_k8s_api_authorization_v1SubjectAccessReviewDecoder.widen
    case (kind, version) => Decoder.failedWithMessage(s"Unknown kubernetes object: group: authorization.k8s.io, kind: $kind, version: $version")
}
  private val groupevents_k8s_ioDecoder : (String, String) => Decoder[KObject]  = {
    case ("Event", "v1") => codecs.io_k8s_api_events_v1EventDecoder.widen
    case ("EventList", "v1") => codecs.io_k8s_api_events_v1EventListDecoder.widen
    case (kind, version) => Decoder.failedWithMessage(s"Unknown kubernetes object: group: events.k8s.io, kind: $kind, version: $version")
}
  private val groupapiextensions_k8s_ioDecoder : (String, String) => Decoder[KObject]  = {
    case ("CustomResourceDefinition", "v1") => codecs.io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceDefinitionDecoder.widen
    case ("CustomResourceDefinitionList", "v1") => codecs.io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceDefinitionListDecoder.widen
    case (kind, version) => Decoder.failedWithMessage(s"Unknown kubernetes object: group: apiextensions.k8s.io, kind: $kind, version: $version")
}
  private val groupcertificates_k8s_ioDecoder : (String, String) => Decoder[KObject]  = {
    case ("CertificateSigningRequest", "v1") => codecs.io_k8s_api_certificates_v1CertificateSigningRequestDecoder.widen
    case ("CertificateSigningRequestList", "v1") => codecs.io_k8s_api_certificates_v1CertificateSigningRequestListDecoder.widen
    case (kind, version) => Decoder.failedWithMessage(s"Unknown kubernetes object: group: certificates.k8s.io, kind: $kind, version: $version")
}
  private val groupadmissionregistration_k8s_ioDecoder : (String, String) => Decoder[KObject]  = {
    case ("MutatingWebhookConfiguration", "v1") => codecs.io_k8s_api_admissionregistration_v1MutatingWebhookConfigurationDecoder.widen
    case ("MutatingWebhookConfigurationList", "v1") => codecs.io_k8s_api_admissionregistration_v1MutatingWebhookConfigurationListDecoder.widen
    case ("ValidatingWebhookConfiguration", "v1") => codecs.io_k8s_api_admissionregistration_v1ValidatingWebhookConfigurationDecoder.widen
    case ("ValidatingWebhookConfigurationList", "v1") => codecs.io_k8s_api_admissionregistration_v1ValidatingWebhookConfigurationListDecoder.widen
    case (kind, version) => Decoder.failedWithMessage(s"Unknown kubernetes object: group: admissionregistration.k8s.io, kind: $kind, version: $version")
}
  private val groupauthentication_k8s_ioDecoder : (String, String) => Decoder[KObject]  = {
    case ("TokenRequest", "v1") => codecs.io_k8s_api_authentication_v1TokenRequestDecoder.widen
    case ("TokenReview", "v1") => codecs.io_k8s_api_authentication_v1TokenReviewDecoder.widen
    case (kind, version) => Decoder.failedWithMessage(s"Unknown kubernetes object: group: authentication.k8s.io, kind: $kind, version: $version")
}
  private val groupinternal_apiserver_k8s_ioDecoder : (String, String) => Decoder[KObject]  = {
    case ("StorageVersion", "v1alpha1") => codecs.io_k8s_api_apiserverinternal_v1alpha1StorageVersionDecoder.widen
    case ("StorageVersionList", "v1alpha1") => codecs.io_k8s_api_apiserverinternal_v1alpha1StorageVersionListDecoder.widen
    case (kind, version) => Decoder.failedWithMessage(s"Unknown kubernetes object: group: internal.apiserver.k8s.io, kind: $kind, version: $version")
}
  private val groupdiscovery_k8s_ioDecoder : (String, String) => Decoder[KObject]  = {
    case ("EndpointSlice", "v1") => codecs.io_k8s_api_discovery_v1EndpointSliceDecoder.widen
    case ("EndpointSliceList", "v1") => codecs.io_k8s_api_discovery_v1EndpointSliceListDecoder.widen
    case (kind, version) => Decoder.failedWithMessage(s"Unknown kubernetes object: group: discovery.k8s.io, kind: $kind, version: $version")
}
  private val groupautoscalingDecoder : (String, String) => Decoder[KObject]  = {
    case ("HorizontalPodAutoscaler", "v1") => codecs.io_k8s_api_autoscaling_v1HorizontalPodAutoscalerDecoder.widen
    case ("HorizontalPodAutoscaler", "v2") => codecs.io_k8s_api_autoscaling_v2HorizontalPodAutoscalerDecoder.widen
    case ("HorizontalPodAutoscaler", "v2beta2") => codecs.io_k8s_api_autoscaling_v2beta2HorizontalPodAutoscalerDecoder.widen
    case ("HorizontalPodAutoscalerList", "v1") => codecs.io_k8s_api_autoscaling_v1HorizontalPodAutoscalerListDecoder.widen
    case ("HorizontalPodAutoscalerList", "v2") => codecs.io_k8s_api_autoscaling_v2HorizontalPodAutoscalerListDecoder.widen
    case ("HorizontalPodAutoscalerList", "v2beta2") => codecs.io_k8s_api_autoscaling_v2beta2HorizontalPodAutoscalerListDecoder.widen
    case ("Scale", "v1") => codecs.io_k8s_api_autoscaling_v1ScaleDecoder.widen
    case (kind, version) => Decoder.failedWithMessage(s"Unknown kubernetes object: group: autoscaling, kind: $kind, version: $version")
}
  private val grouprbac_authorization_k8s_ioDecoder : (String, String) => Decoder[KObject]  = {
    case ("ClusterRole", "v1") => codecs.io_k8s_api_rbac_v1ClusterRoleDecoder.widen
    case ("ClusterRoleBinding", "v1") => codecs.io_k8s_api_rbac_v1ClusterRoleBindingDecoder.widen
    case ("ClusterRoleBindingList", "v1") => codecs.io_k8s_api_rbac_v1ClusterRoleBindingListDecoder.widen
    case ("ClusterRoleList", "v1") => codecs.io_k8s_api_rbac_v1ClusterRoleListDecoder.widen
    case ("Role", "v1") => codecs.io_k8s_api_rbac_v1RoleDecoder.widen
    case ("RoleBinding", "v1") => codecs.io_k8s_api_rbac_v1RoleBindingDecoder.widen
    case ("RoleBindingList", "v1") => codecs.io_k8s_api_rbac_v1RoleBindingListDecoder.widen
    case ("RoleList", "v1") => codecs.io_k8s_api_rbac_v1RoleListDecoder.widen
    case (kind, version) => Decoder.failedWithMessage(s"Unknown kubernetes object: group: rbac.authorization.k8s.io, kind: $kind, version: $version")
}
  private val groupcoordination_k8s_ioDecoder : (String, String) => Decoder[KObject]  = {
    case ("Lease", "v1") => codecs.io_k8s_api_coordination_v1LeaseDecoder.widen
    case ("LeaseList", "v1") => codecs.io_k8s_api_coordination_v1LeaseListDecoder.widen
    case (kind, version) => Decoder.failedWithMessage(s"Unknown kubernetes object: group: coordination.k8s.io, kind: $kind, version: $version")
}
  private val groupbatchDecoder : (String, String) => Decoder[KObject]  = {
    case ("CronJob", "v1") => codecs.io_k8s_api_batch_v1CronJobDecoder.widen
    case ("CronJobList", "v1") => codecs.io_k8s_api_batch_v1CronJobListDecoder.widen
    case ("Job", "v1") => codecs.io_k8s_api_batch_v1JobDecoder.widen
    case ("JobList", "v1") => codecs.io_k8s_api_batch_v1JobListDecoder.widen
    case (kind, version) => Decoder.failedWithMessage(s"Unknown kubernetes object: group: batch, kind: $kind, version: $version")
}
  private val groupnode_k8s_ioDecoder : (String, String) => Decoder[KObject]  = {
    case ("RuntimeClass", "v1") => codecs.io_k8s_api_node_v1RuntimeClassDecoder.widen
    case ("RuntimeClassList", "v1") => codecs.io_k8s_api_node_v1RuntimeClassListDecoder.widen
    case (kind, version) => Decoder.failedWithMessage(s"Unknown kubernetes object: group: node.k8s.io, kind: $kind, version: $version")
}
  private val groupnetworking_k8s_ioDecoder : (String, String) => Decoder[KObject]  = {
    case ("ClusterCIDR", "v1alpha1") => codecs.io_k8s_api_networking_v1alpha1ClusterCIDRDecoder.widen
    case ("ClusterCIDRList", "v1alpha1") => codecs.io_k8s_api_networking_v1alpha1ClusterCIDRListDecoder.widen
    case ("Ingress", "v1") => codecs.io_k8s_api_networking_v1IngressDecoder.widen
    case ("IngressClass", "v1") => codecs.io_k8s_api_networking_v1IngressClassDecoder.widen
    case ("IngressClassList", "v1") => codecs.io_k8s_api_networking_v1IngressClassListDecoder.widen
    case ("IngressList", "v1") => codecs.io_k8s_api_networking_v1IngressListDecoder.widen
    case ("NetworkPolicy", "v1") => codecs.io_k8s_api_networking_v1NetworkPolicyDecoder.widen
    case ("NetworkPolicyList", "v1") => codecs.io_k8s_api_networking_v1NetworkPolicyListDecoder.widen
    case (kind, version) => Decoder.failedWithMessage(s"Unknown kubernetes object: group: networking.k8s.io, kind: $kind, version: $version")
}
  private val groupflowcontrol_apiserver_k8s_ioDecoder : (String, String) => Decoder[KObject]  = {
    case ("FlowSchema", "v1beta1") => codecs.io_k8s_api_flowcontrol_v1beta1FlowSchemaDecoder.widen
    case ("FlowSchema", "v1beta2") => codecs.io_k8s_api_flowcontrol_v1beta2FlowSchemaDecoder.widen
    case ("FlowSchemaList", "v1beta1") => codecs.io_k8s_api_flowcontrol_v1beta1FlowSchemaListDecoder.widen
    case ("FlowSchemaList", "v1beta2") => codecs.io_k8s_api_flowcontrol_v1beta2FlowSchemaListDecoder.widen
    case ("PriorityLevelConfiguration", "v1beta1") => codecs.io_k8s_api_flowcontrol_v1beta1PriorityLevelConfigurationDecoder.widen
    case ("PriorityLevelConfiguration", "v1beta2") => codecs.io_k8s_api_flowcontrol_v1beta2PriorityLevelConfigurationDecoder.widen
    case ("PriorityLevelConfigurationList", "v1beta1") => codecs.io_k8s_api_flowcontrol_v1beta1PriorityLevelConfigurationListDecoder.widen
    case ("PriorityLevelConfigurationList", "v1beta2") => codecs.io_k8s_api_flowcontrol_v1beta2PriorityLevelConfigurationListDecoder.widen
    case (kind, version) => Decoder.failedWithMessage(s"Unknown kubernetes object: group: flowcontrol.apiserver.k8s.io, kind: $kind, version: $version")
}
  private val grouppolicyDecoder : (String, String) => Decoder[KObject]  = {
    case ("Eviction", "v1") => codecs.io_k8s_api_policy_v1EvictionDecoder.widen
    case ("PodDisruptionBudget", "v1") => codecs.io_k8s_api_policy_v1PodDisruptionBudgetDecoder.widen
    case ("PodDisruptionBudgetList", "v1") => codecs.io_k8s_api_policy_v1PodDisruptionBudgetListDecoder.widen
    case (kind, version) => Decoder.failedWithMessage(s"Unknown kubernetes object: group: policy, kind: $kind, version: $version")
}
  private val groupscheduling_k8s_ioDecoder : (String, String) => Decoder[KObject]  = {
    case ("PriorityClass", "v1") => codecs.io_k8s_api_scheduling_v1PriorityClassDecoder.widen
    case ("PriorityClassList", "v1") => codecs.io_k8s_api_scheduling_v1PriorityClassListDecoder.widen
    case (kind, version) => Decoder.failedWithMessage(s"Unknown kubernetes object: group: scheduling.k8s.io, kind: $kind, version: $version")
}
  private val groupstorage_k8s_ioDecoder : (String, String) => Decoder[KObject]  = {
    case ("CSIDriver", "v1") => codecs.io_k8s_api_storage_v1CSIDriverDecoder.widen
    case ("CSIDriverList", "v1") => codecs.io_k8s_api_storage_v1CSIDriverListDecoder.widen
    case ("CSINode", "v1") => codecs.io_k8s_api_storage_v1CSINodeDecoder.widen
    case ("CSINodeList", "v1") => codecs.io_k8s_api_storage_v1CSINodeListDecoder.widen
    case ("CSIStorageCapacity", "v1") => codecs.io_k8s_api_storage_v1CSIStorageCapacityDecoder.widen
    case ("CSIStorageCapacity", "v1beta1") => codecs.io_k8s_api_storage_v1beta1CSIStorageCapacityDecoder.widen
    case ("CSIStorageCapacityList", "v1") => codecs.io_k8s_api_storage_v1CSIStorageCapacityListDecoder.widen
    case ("CSIStorageCapacityList", "v1beta1") => codecs.io_k8s_api_storage_v1beta1CSIStorageCapacityListDecoder.widen
    case ("StorageClass", "v1") => codecs.io_k8s_api_storage_v1StorageClassDecoder.widen
    case ("StorageClassList", "v1") => codecs.io_k8s_api_storage_v1StorageClassListDecoder.widen
    case ("VolumeAttachment", "v1") => codecs.io_k8s_api_storage_v1VolumeAttachmentDecoder.widen
    case ("VolumeAttachmentList", "v1") => codecs.io_k8s_api_storage_v1VolumeAttachmentListDecoder.widen
    case (kind, version) => Decoder.failedWithMessage(s"Unknown kubernetes object: group: storage.k8s.io, kind: $kind, version: $version")
}
  private val groupappsDecoder : (String, String) => Decoder[KObject]  = {
    case ("ControllerRevision", "v1") => codecs.io_k8s_api_apps_v1ControllerRevisionDecoder.widen
    case ("ControllerRevisionList", "v1") => codecs.io_k8s_api_apps_v1ControllerRevisionListDecoder.widen
    case ("DaemonSet", "v1") => codecs.io_k8s_api_apps_v1DaemonSetDecoder.widen
    case ("DaemonSetList", "v1") => codecs.io_k8s_api_apps_v1DaemonSetListDecoder.widen
    case ("Deployment", "v1") => codecs.io_k8s_api_apps_v1DeploymentDecoder.widen
    case ("DeploymentList", "v1") => codecs.io_k8s_api_apps_v1DeploymentListDecoder.widen
    case ("ReplicaSet", "v1") => codecs.io_k8s_api_apps_v1ReplicaSetDecoder.widen
    case ("ReplicaSetList", "v1") => codecs.io_k8s_api_apps_v1ReplicaSetListDecoder.widen
    case ("StatefulSet", "v1") => codecs.io_k8s_api_apps_v1StatefulSetDecoder.widen
    case ("StatefulSetList", "v1") => codecs.io_k8s_api_apps_v1StatefulSetListDecoder.widen
    case (kind, version) => Decoder.failedWithMessage(s"Unknown kubernetes object: group: apps, kind: $kind, version: $version")
}
  private val groupapiregistration_k8s_ioDecoder : (String, String) => Decoder[KObject]  = {
    case ("APIService", "v1") => codecs.io_k8s_kube_aggregator_pkg_apis_apiregistration_v1APIServiceDecoder.widen
    case ("APIServiceList", "v1") => codecs.io_k8s_kube_aggregator_pkg_apis_apiregistration_v1APIServiceListDecoder.widen
    case (kind, version) => Decoder.failedWithMessage(s"Unknown kubernetes object: group: apiregistration.k8s.io, kind: $kind, version: $version")
}
  implicit val resourceDecoder : Decoder[KObject] = (c: HCursor) => c.as[ResourceKind].flatMap { rk =>
    rk.group match {
     case "" => c.as(groupDecoder(rk.kind, rk.version))
     case "admissionregistration.k8s.io" => c.as(groupadmissionregistration_k8s_ioDecoder(rk.kind, rk.version))
     case "apiextensions.k8s.io" => c.as(groupapiextensions_k8s_ioDecoder(rk.kind, rk.version))
     case "apiregistration.k8s.io" => c.as(groupapiregistration_k8s_ioDecoder(rk.kind, rk.version))
     case "apps" => c.as(groupappsDecoder(rk.kind, rk.version))
     case "authentication.k8s.io" => c.as(groupauthentication_k8s_ioDecoder(rk.kind, rk.version))
     case "authorization.k8s.io" => c.as(groupauthorization_k8s_ioDecoder(rk.kind, rk.version))
     case "autoscaling" => c.as(groupautoscalingDecoder(rk.kind, rk.version))
     case "batch" => c.as(groupbatchDecoder(rk.kind, rk.version))
     case "certificates.k8s.io" => c.as(groupcertificates_k8s_ioDecoder(rk.kind, rk.version))
     case "coordination.k8s.io" => c.as(groupcoordination_k8s_ioDecoder(rk.kind, rk.version))
     case "discovery.k8s.io" => c.as(groupdiscovery_k8s_ioDecoder(rk.kind, rk.version))
     case "events.k8s.io" => c.as(groupevents_k8s_ioDecoder(rk.kind, rk.version))
     case "flowcontrol.apiserver.k8s.io" => c.as(groupflowcontrol_apiserver_k8s_ioDecoder(rk.kind, rk.version))
     case "internal.apiserver.k8s.io" => c.as(groupinternal_apiserver_k8s_ioDecoder(rk.kind, rk.version))
     case "networking.k8s.io" => c.as(groupnetworking_k8s_ioDecoder(rk.kind, rk.version))
     case "node.k8s.io" => c.as(groupnode_k8s_ioDecoder(rk.kind, rk.version))
     case "policy" => c.as(grouppolicyDecoder(rk.kind, rk.version))
     case "rbac.authorization.k8s.io" => c.as(grouprbac_authorization_k8s_ioDecoder(rk.kind, rk.version))
     case "scheduling.k8s.io" => c.as(groupscheduling_k8s_ioDecoder(rk.kind, rk.version))
     case "storage.k8s.io" => c.as(groupstorage_k8s_ioDecoder(rk.kind, rk.version))
      case unknown => c.as(Decoder.failedWithMessage(s"Unknown kubernetes group id: $unknown"))
  }
}

}
