package dev.hnaderi.k8s
package circe

import io.circe._
import io.circe.syntax._
import PrimitiveCodecs._
import InternalCodecs._

trait ResourceCodecs {

    implicit lazy val io_k8s_api_core_v1LimitRangeEncoder : Encoder[io.k8s.api.core.v1.LimitRange] = o =>
      Json.obj(
        "metadata" -> o.metadata.asJson,
      "spec" -> o.spec.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1LimitRangeDecoder : Decoder[io.k8s.api.core.v1.LimitRange] = (c: HCursor) => for {
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
       spec <- c.get[Option[io.k8s.api.core.v1.LimitRangeSpec]]("spec")
    } yield io.k8s.api.core.v1.LimitRange(
      metadata = metadata,
      spec = spec
    )

    implicit lazy val io_k8s_api_autoscaling_v1HorizontalPodAutoscalerEncoder : Encoder[io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v1HorizontalPodAutoscalerDecoder : Decoder[io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerStatus]]("status")
       spec <- c.get[Option[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_autoscaling_v1HorizontalPodAutoscalerListEncoder : Encoder[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v1HorizontalPodAutoscalerListDecoder : Decoder[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_storage_v1beta1CSIStorageCapacityEncoder : Encoder[io.k8s.api.storage.v1beta1.CSIStorageCapacity] = o =>
      Json.obj(
        "storageClassName" -> o.storageClassName.asJson,
      "maximumVolumeSize" -> o.maximumVolumeSize.asJson,
      "nodeTopology" -> o.nodeTopology.asJson,
      "metadata" -> o.metadata.asJson,
      "capacity" -> o.capacity.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_storage_v1beta1CSIStorageCapacityDecoder : Decoder[io.k8s.api.storage.v1beta1.CSIStorageCapacity] = (c: HCursor) => for {
       storageClassName <- c.get[String]("storageClassName")
       maximumVolumeSize <- c.get[Option[io.k8s.apimachinery.pkg.api.resource.Quantity]]("maximumVolumeSize")
       nodeTopology <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]]("nodeTopology")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
       capacity <- c.get[Option[io.k8s.apimachinery.pkg.api.resource.Quantity]]("capacity")
    } yield io.k8s.api.storage.v1beta1.CSIStorageCapacity(
      storageClassName = storageClassName,
      maximumVolumeSize = maximumVolumeSize,
      nodeTopology = nodeTopology,
      metadata = metadata,
      capacity = capacity
    )

    implicit lazy val io_k8s_api_authorization_v1SubjectAccessReviewEncoder : Encoder[io.k8s.api.authorization.v1.SubjectAccessReview] = o =>
      Json.obj(
        "spec" -> o.spec.asJson,
      "status" -> o.status.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_authorization_v1SubjectAccessReviewDecoder : Decoder[io.k8s.api.authorization.v1.SubjectAccessReview] = (c: HCursor) => for {
       spec <- c.get[io.k8s.api.authorization.v1.SubjectAccessReviewSpec]("spec")
       status <- c.get[Option[io.k8s.api.authorization.v1.SubjectAccessReviewStatus]]("status")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.authorization.v1.SubjectAccessReview(
      spec = spec,
      status = status,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_apiserverinternal_v1alpha1StorageVersionListEncoder : Encoder[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_apiserverinternal_v1alpha1StorageVersionListDecoder : Decoder[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.apiserverinternal.v1alpha1.StorageVersion]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.apiserverinternal.v1alpha1.StorageVersionList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1APIVersionsEncoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.APIVersions] = o =>
      Json.obj(
        "serverAddressByClientCIDRs" -> o.serverAddressByClientCIDRs.asJson,
      "versions" -> o.versions.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1APIVersionsDecoder : Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.APIVersions] = (c: HCursor) => for {
       serverAddressByClientCIDRs <- c.get[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR]]("serverAddressByClientCIDRs")
       versions <- c.get[Seq[String]]("versions")
    } yield io.k8s.apimachinery.pkg.apis.meta.v1.APIVersions(
      serverAddressByClientCIDRs = serverAddressByClientCIDRs,
      versions = versions
    )

    implicit lazy val io_k8s_api_networking_v1IngressClassEncoder : Encoder[io.k8s.api.networking.v1.IngressClass] = o =>
      Json.obj(
        "metadata" -> o.metadata.asJson,
      "spec" -> o.spec.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_networking_v1IngressClassDecoder : Decoder[io.k8s.api.networking.v1.IngressClass] = (c: HCursor) => for {
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
       spec <- c.get[Option[io.k8s.api.networking.v1.IngressClassSpec]]("spec")
    } yield io.k8s.api.networking.v1.IngressClass(
      metadata = metadata,
      spec = spec
    )

    implicit lazy val io_k8s_api_storage_v1CSINodeListEncoder : Encoder[io.k8s.api.storage.v1.CSINodeList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_storage_v1CSINodeListDecoder : Decoder[io.k8s.api.storage.v1.CSINodeList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.storage.v1.CSINode]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.storage.v1.CSINodeList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1ConfigMapListEncoder : Encoder[io.k8s.api.core.v1.ConfigMapList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1ConfigMapListDecoder : Decoder[io.k8s.api.core.v1.ConfigMapList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.core.v1.ConfigMap]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.core.v1.ConfigMapList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_batch_v1CronJobListEncoder : Encoder[io.k8s.api.batch.v1.CronJobList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_batch_v1CronJobListDecoder : Decoder[io.k8s.api.batch.v1.CronJobList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.batch.v1.CronJob]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.batch.v1.CronJobList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1SecretListEncoder : Encoder[io.k8s.api.core.v1.SecretList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1SecretListDecoder : Decoder[io.k8s.api.core.v1.SecretList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.core.v1.Secret]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.core.v1.SecretList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_discovery_v1EndpointSliceEncoder : Encoder[io.k8s.api.discovery.v1.EndpointSlice] = o =>
      Json.obj(
        "endpoints" -> o.endpoints.asJson,
      "addressType" -> o.addressType.asJson,
      "ports" -> o.ports.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_discovery_v1EndpointSliceDecoder : Decoder[io.k8s.api.discovery.v1.EndpointSlice] = (c: HCursor) => for {
       endpoints <- c.get[Seq[io.k8s.api.discovery.v1.Endpoint]]("endpoints")
       addressType <- c.get[String]("addressType")
       ports <- c.get[Option[Seq[io.k8s.api.discovery.v1.EndpointPort]]]("ports")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.discovery.v1.EndpointSlice(
      endpoints = endpoints,
      addressType = addressType,
      ports = ports,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_authorization_v1SelfSubjectRulesReviewEncoder : Encoder[io.k8s.api.authorization.v1.SelfSubjectRulesReview] = o =>
      Json.obj(
        "spec" -> o.spec.asJson,
      "status" -> o.status.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_authorization_v1SelfSubjectRulesReviewDecoder : Decoder[io.k8s.api.authorization.v1.SelfSubjectRulesReview] = (c: HCursor) => for {
       spec <- c.get[io.k8s.api.authorization.v1.SelfSubjectRulesReviewSpec]("spec")
       status <- c.get[Option[io.k8s.api.authorization.v1.SubjectRulesReviewStatus]]("status")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.authorization.v1.SelfSubjectRulesReview(
      spec = spec,
      status = status,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_rbac_v1ClusterRoleListEncoder : Encoder[io.k8s.api.rbac.v1.ClusterRoleList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_rbac_v1ClusterRoleListDecoder : Decoder[io.k8s.api.rbac.v1.ClusterRoleList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.rbac.v1.ClusterRole]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.rbac.v1.ClusterRoleList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceDefinitionEncoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition] = o =>
      Json.obj(
        "spec" -> o.spec.asJson,
      "status" -> o.status.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceDefinitionDecoder : Decoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition] = (c: HCursor) => for {
       spec <- c.get[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec]("spec")
       status <- c.get[Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionStatus]]("status")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition(
      spec = spec,
      status = status,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta2PriorityLevelConfigurationEncoder : Encoder[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfiguration] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta2PriorityLevelConfigurationDecoder : Decoder[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfiguration] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationStatus]]("status")
       spec <- c.get[Option[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfiguration(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_networking_v1alpha1ClusterCIDRListEncoder : Encoder[io.k8s.api.networking.v1alpha1.ClusterCIDRList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_networking_v1alpha1ClusterCIDRListDecoder : Decoder[io.k8s.api.networking.v1alpha1.ClusterCIDRList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.networking.v1alpha1.ClusterCIDR]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.networking.v1alpha1.ClusterCIDRList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_admissionregistration_v1ValidatingWebhookConfigurationEncoder : Encoder[io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration] = o =>
      Json.obj(
        "metadata" -> o.metadata.asJson,
      "webhooks" -> o.webhooks.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_admissionregistration_v1ValidatingWebhookConfigurationDecoder : Decoder[io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration] = (c: HCursor) => for {
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
       webhooks <- c.get[Option[Seq[io.k8s.api.admissionregistration.v1.ValidatingWebhook]]]("webhooks")
    } yield io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration(
      metadata = metadata,
      webhooks = webhooks
    )

    implicit lazy val io_k8s_api_admissionregistration_v1ValidatingWebhookConfigurationListEncoder : Encoder[io.k8s.api.admissionregistration.v1.ValidatingWebhookConfigurationList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_admissionregistration_v1ValidatingWebhookConfigurationListDecoder : Decoder[io.k8s.api.admissionregistration.v1.ValidatingWebhookConfigurationList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.admissionregistration.v1.ValidatingWebhookConfigurationList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_apps_v1StatefulSetListEncoder : Encoder[io.k8s.api.apps.v1.StatefulSetList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_apps_v1StatefulSetListDecoder : Decoder[io.k8s.api.apps.v1.StatefulSetList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.apps.v1.StatefulSet]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.apps.v1.StatefulSetList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1ServiceAccountEncoder : Encoder[io.k8s.api.core.v1.ServiceAccount] = o =>
      Json.obj(
        "imagePullSecrets" -> o.imagePullSecrets.asJson,
      "secrets" -> o.secrets.asJson,
      "automountServiceAccountToken" -> o.automountServiceAccountToken.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1ServiceAccountDecoder : Decoder[io.k8s.api.core.v1.ServiceAccount] = (c: HCursor) => for {
       imagePullSecrets <- c.get[Option[Seq[io.k8s.api.core.v1.LocalObjectReference]]]("imagePullSecrets")
       secrets <- c.get[Option[Seq[io.k8s.api.core.v1.ObjectReference]]]("secrets")
       automountServiceAccountToken <- c.get[Option[Boolean]]("automountServiceAccountToken")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.core.v1.ServiceAccount(
      imagePullSecrets = imagePullSecrets,
      secrets = secrets,
      automountServiceAccountToken = automountServiceAccountToken,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1PersistentVolumeEncoder : Encoder[io.k8s.api.core.v1.PersistentVolume] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1PersistentVolumeDecoder : Decoder[io.k8s.api.core.v1.PersistentVolume] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.core.v1.PersistentVolumeStatus]]("status")
       spec <- c.get[Option[io.k8s.api.core.v1.PersistentVolumeSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.core.v1.PersistentVolume(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_coordination_v1LeaseEncoder : Encoder[io.k8s.api.coordination.v1.Lease] = o =>
      Json.obj(
        "metadata" -> o.metadata.asJson,
      "spec" -> o.spec.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_coordination_v1LeaseDecoder : Decoder[io.k8s.api.coordination.v1.Lease] = (c: HCursor) => for {
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
       spec <- c.get[Option[io.k8s.api.coordination.v1.LeaseSpec]]("spec")
    } yield io.k8s.api.coordination.v1.Lease(
      metadata = metadata,
      spec = spec
    )

    implicit lazy val io_k8s_api_rbac_v1ClusterRoleBindingEncoder : Encoder[io.k8s.api.rbac.v1.ClusterRoleBinding] = o =>
      Json.obj(
        "roleRef" -> o.roleRef.asJson,
      "subjects" -> o.subjects.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_rbac_v1ClusterRoleBindingDecoder : Decoder[io.k8s.api.rbac.v1.ClusterRoleBinding] = (c: HCursor) => for {
       roleRef <- c.get[io.k8s.api.rbac.v1.RoleRef]("roleRef")
       subjects <- c.get[Option[Seq[io.k8s.api.rbac.v1.Subject]]]("subjects")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.rbac.v1.ClusterRoleBinding(
      roleRef = roleRef,
      subjects = subjects,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_apiserverinternal_v1alpha1StorageVersionEncoder : Encoder[io.k8s.api.apiserverinternal.v1alpha1.StorageVersion] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_apiserverinternal_v1alpha1StorageVersionDecoder : Decoder[io.k8s.api.apiserverinternal.v1alpha1.StorageVersion] = (c: HCursor) => for {
       status <- c.get[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionStatus]("status")
       spec <- c.get[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionSpec]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.apiserverinternal.v1alpha1.StorageVersion(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_batch_v1JobEncoder : Encoder[io.k8s.api.batch.v1.Job] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_batch_v1JobDecoder : Decoder[io.k8s.api.batch.v1.Job] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.batch.v1.JobStatus]]("status")
       spec <- c.get[Option[io.k8s.api.batch.v1.JobSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.batch.v1.Job(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1PodListEncoder : Encoder[io.k8s.api.core.v1.PodList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1PodListDecoder : Decoder[io.k8s.api.core.v1.PodList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.core.v1.Pod]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.core.v1.PodList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_admissionregistration_v1MutatingWebhookConfigurationListEncoder : Encoder[io.k8s.api.admissionregistration.v1.MutatingWebhookConfigurationList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_admissionregistration_v1MutatingWebhookConfigurationListDecoder : Decoder[io.k8s.api.admissionregistration.v1.MutatingWebhookConfigurationList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.admissionregistration.v1.MutatingWebhookConfigurationList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1PodEncoder : Encoder[io.k8s.api.core.v1.Pod] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1PodDecoder : Decoder[io.k8s.api.core.v1.Pod] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.core.v1.PodStatus]]("status")
       spec <- c.get[Option[io.k8s.api.core.v1.PodSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.core.v1.Pod(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1ComponentStatusEncoder : Encoder[io.k8s.api.core.v1.ComponentStatus] = o =>
      Json.obj(
        "conditions" -> o.conditions.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1ComponentStatusDecoder : Decoder[io.k8s.api.core.v1.ComponentStatus] = (c: HCursor) => for {
       conditions <- c.get[Option[Seq[io.k8s.api.core.v1.ComponentCondition]]]("conditions")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.core.v1.ComponentStatus(
      conditions = conditions,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_coordination_v1LeaseListEncoder : Encoder[io.k8s.api.coordination.v1.LeaseList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_coordination_v1LeaseListDecoder : Decoder[io.k8s.api.coordination.v1.LeaseList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.coordination.v1.Lease]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.coordination.v1.LeaseList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_events_v1EventListEncoder : Encoder[io.k8s.api.events.v1.EventList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_events_v1EventListDecoder : Decoder[io.k8s.api.events.v1.EventList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.events.v1.Event]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.events.v1.EventList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_kube_aggregator_pkg_apis_apiregistration_v1APIServiceEncoder : Encoder[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIService] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_kube_aggregator_pkg_apis_apiregistration_v1APIServiceDecoder : Decoder[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIService] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceStatus]]("status")
       spec <- c.get[Option[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIService(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_networking_v1alpha1ClusterCIDREncoder : Encoder[io.k8s.api.networking.v1alpha1.ClusterCIDR] = o =>
      Json.obj(
        "metadata" -> o.metadata.asJson,
      "spec" -> o.spec.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_networking_v1alpha1ClusterCIDRDecoder : Decoder[io.k8s.api.networking.v1alpha1.ClusterCIDR] = (c: HCursor) => for {
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
       spec <- c.get[Option[io.k8s.api.networking.v1alpha1.ClusterCIDRSpec]]("spec")
    } yield io.k8s.api.networking.v1alpha1.ClusterCIDR(
      metadata = metadata,
      spec = spec
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta2PriorityLevelConfigurationListEncoder : Encoder[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta2PriorityLevelConfigurationListDecoder : Decoder[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfiguration]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_autoscaling_v1ScaleEncoder : Encoder[io.k8s.api.autoscaling.v1.Scale] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v1ScaleDecoder : Decoder[io.k8s.api.autoscaling.v1.Scale] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.autoscaling.v1.ScaleStatus]]("status")
       spec <- c.get[Option[io.k8s.api.autoscaling.v1.ScaleSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.autoscaling.v1.Scale(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2HorizontalPodAutoscalerEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2HorizontalPodAutoscalerDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerStatus]]("status")
       spec <- c.get[Option[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1StatusEncoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.Status] = o =>
      Json.obj(
        "reason" -> o.reason.asJson,
      "code" -> o.code.asJson,
      "status" -> o.status.asJson,
      "details" -> o.details.asJson,
      "metadata" -> o.metadata.asJson,
      "message" -> o.message.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1StatusDecoder : Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.Status] = (c: HCursor) => for {
       reason <- c.get[Option[String]]("reason")
       code <- c.get[Option[Int]]("code")
       status <- c.get[Option[String]]("status")
       details <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails]]("details")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
       message <- c.get[Option[String]]("message")
    } yield io.k8s.apimachinery.pkg.apis.meta.v1.Status(
      reason = reason,
      code = code,
      status = status,
      details = details,
      metadata = metadata,
      message = message
    )

    implicit lazy val io_k8s_api_rbac_v1RoleListEncoder : Encoder[io.k8s.api.rbac.v1.RoleList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_rbac_v1RoleListDecoder : Decoder[io.k8s.api.rbac.v1.RoleList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.rbac.v1.Role]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.rbac.v1.RoleList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1EventListEncoder : Encoder[io.k8s.api.core.v1.EventList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1EventListDecoder : Decoder[io.k8s.api.core.v1.EventList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.core.v1.Event]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.core.v1.EventList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_apps_v1ControllerRevisionEncoder : Encoder[io.k8s.api.apps.v1.ControllerRevision] = o =>
      Json.obj(
        "revision" -> o.revision.asJson,
      "data" -> o.data.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_apps_v1ControllerRevisionDecoder : Decoder[io.k8s.api.apps.v1.ControllerRevision] = (c: HCursor) => for {
       revision <- c.get[Int]("revision")
       data <- c.get[Option[io.k8s.apimachinery.pkg.runtime.RawExtension]]("data")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.apps.v1.ControllerRevision(
      revision = revision,
      data = data,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1PodTemplateListEncoder : Encoder[io.k8s.api.core.v1.PodTemplateList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1PodTemplateListDecoder : Decoder[io.k8s.api.core.v1.PodTemplateList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.core.v1.PodTemplate]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.core.v1.PodTemplateList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_admissionregistration_v1MutatingWebhookConfigurationEncoder : Encoder[io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration] = o =>
      Json.obj(
        "metadata" -> o.metadata.asJson,
      "webhooks" -> o.webhooks.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_admissionregistration_v1MutatingWebhookConfigurationDecoder : Decoder[io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration] = (c: HCursor) => for {
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
       webhooks <- c.get[Option[Seq[io.k8s.api.admissionregistration.v1.MutatingWebhook]]]("webhooks")
    } yield io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration(
      metadata = metadata,
      webhooks = webhooks
    )

    implicit lazy val io_k8s_api_apps_v1StatefulSetEncoder : Encoder[io.k8s.api.apps.v1.StatefulSet] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_apps_v1StatefulSetDecoder : Decoder[io.k8s.api.apps.v1.StatefulSet] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.apps.v1.StatefulSetStatus]]("status")
       spec <- c.get[Option[io.k8s.api.apps.v1.StatefulSetSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.apps.v1.StatefulSet(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1ServiceAccountListEncoder : Encoder[io.k8s.api.core.v1.ServiceAccountList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1ServiceAccountListDecoder : Decoder[io.k8s.api.core.v1.ServiceAccountList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.core.v1.ServiceAccount]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.core.v1.ServiceAccountList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_kube_aggregator_pkg_apis_apiregistration_v1APIServiceListEncoder : Encoder[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_kube_aggregator_pkg_apis_apiregistration_v1APIServiceListDecoder : Decoder[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIService]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1APIResourceListEncoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.APIResourceList] = o =>
      Json.obj(
        "groupVersion" -> o.groupVersion.asJson,
      "resources" -> o.resources.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1APIResourceListDecoder : Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.APIResourceList] = (c: HCursor) => for {
       groupVersion <- c.get[String]("groupVersion")
       resources <- c.get[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.APIResource]]("resources")
    } yield io.k8s.apimachinery.pkg.apis.meta.v1.APIResourceList(
      groupVersion = groupVersion,
      resources = resources
    )

    implicit lazy val io_k8s_api_core_v1LimitRangeListEncoder : Encoder[io.k8s.api.core.v1.LimitRangeList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1LimitRangeListDecoder : Decoder[io.k8s.api.core.v1.LimitRangeList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.core.v1.LimitRange]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.core.v1.LimitRangeList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_policy_v1PodDisruptionBudgetEncoder : Encoder[io.k8s.api.policy.v1.PodDisruptionBudget] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_policy_v1PodDisruptionBudgetDecoder : Decoder[io.k8s.api.policy.v1.PodDisruptionBudget] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.policy.v1.PodDisruptionBudgetStatus]]("status")
       spec <- c.get[Option[io.k8s.api.policy.v1.PodDisruptionBudgetSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.policy.v1.PodDisruptionBudget(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_networking_v1IngressEncoder : Encoder[io.k8s.api.networking.v1.Ingress] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_networking_v1IngressDecoder : Decoder[io.k8s.api.networking.v1.Ingress] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.networking.v1.IngressStatus]]("status")
       spec <- c.get[Option[io.k8s.api.networking.v1.IngressSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.networking.v1.Ingress(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_networking_v1IngressClassListEncoder : Encoder[io.k8s.api.networking.v1.IngressClassList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_networking_v1IngressClassListDecoder : Decoder[io.k8s.api.networking.v1.IngressClassList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.networking.v1.IngressClass]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.networking.v1.IngressClassList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_certificates_v1CertificateSigningRequestListEncoder : Encoder[io.k8s.api.certificates.v1.CertificateSigningRequestList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_certificates_v1CertificateSigningRequestListDecoder : Decoder[io.k8s.api.certificates.v1.CertificateSigningRequestList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.certificates.v1.CertificateSigningRequest]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.certificates.v1.CertificateSigningRequestList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta2FlowSchemaListEncoder : Encoder[io.k8s.api.flowcontrol.v1beta2.FlowSchemaList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta2FlowSchemaListDecoder : Decoder[io.k8s.api.flowcontrol.v1beta2.FlowSchemaList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.flowcontrol.v1beta2.FlowSchema]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.flowcontrol.v1beta2.FlowSchemaList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_storage_v1CSIStorageCapacityEncoder : Encoder[io.k8s.api.storage.v1.CSIStorageCapacity] = o =>
      Json.obj(
        "storageClassName" -> o.storageClassName.asJson,
      "maximumVolumeSize" -> o.maximumVolumeSize.asJson,
      "nodeTopology" -> o.nodeTopology.asJson,
      "metadata" -> o.metadata.asJson,
      "capacity" -> o.capacity.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_storage_v1CSIStorageCapacityDecoder : Decoder[io.k8s.api.storage.v1.CSIStorageCapacity] = (c: HCursor) => for {
       storageClassName <- c.get[String]("storageClassName")
       maximumVolumeSize <- c.get[Option[io.k8s.apimachinery.pkg.api.resource.Quantity]]("maximumVolumeSize")
       nodeTopology <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]]("nodeTopology")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
       capacity <- c.get[Option[io.k8s.apimachinery.pkg.api.resource.Quantity]]("capacity")
    } yield io.k8s.api.storage.v1.CSIStorageCapacity(
      storageClassName = storageClassName,
      maximumVolumeSize = maximumVolumeSize,
      nodeTopology = nodeTopology,
      metadata = metadata,
      capacity = capacity
    )

    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceDefinitionListEncoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceDefinitionListDecoder : Decoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_events_v1EventEncoder : Encoder[io.k8s.api.events.v1.Event] = o =>
      Json.obj(
        "eventTime" -> o.eventTime.asJson,
      "regarding" -> o.regarding.asJson,
      "series" -> o.series.asJson,
      "reason" -> o.reason.asJson,
      "deprecatedCount" -> o.deprecatedCount.asJson,
      "related" -> o.related.asJson,
      "deprecatedFirstTimestamp" -> o.deprecatedFirstTimestamp.asJson,
      "note" -> o.note.asJson,
      "reportingController" -> o.reportingController.asJson,
      "metadata" -> o.metadata.asJson,
      "deprecatedSource" -> o.deprecatedSource.asJson,
      "type" -> o.`type`.asJson,
      "deprecatedLastTimestamp" -> o.deprecatedLastTimestamp.asJson,
      "reportingInstance" -> o.reportingInstance.asJson,
      "action" -> o.action.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_events_v1EventDecoder : Decoder[io.k8s.api.events.v1.Event] = (c: HCursor) => for {
       eventTime <- c.get[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime]("eventTime")
       regarding <- c.get[Option[io.k8s.api.core.v1.ObjectReference]]("regarding")
       series <- c.get[Option[io.k8s.api.events.v1.EventSeries]]("series")
       reason <- c.get[Option[String]]("reason")
       deprecatedCount <- c.get[Option[Int]]("deprecatedCount")
       related <- c.get[Option[io.k8s.api.core.v1.ObjectReference]]("related")
       deprecatedFirstTimestamp <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("deprecatedFirstTimestamp")
       note <- c.get[Option[String]]("note")
       reportingController <- c.get[Option[String]]("reportingController")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
       deprecatedSource <- c.get[Option[io.k8s.api.core.v1.EventSource]]("deprecatedSource")
       `type` <- c.get[Option[String]]("type")
       deprecatedLastTimestamp <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("deprecatedLastTimestamp")
       reportingInstance <- c.get[Option[String]]("reportingInstance")
       action <- c.get[Option[String]]("action")
    } yield io.k8s.api.events.v1.Event(
      eventTime = eventTime,
      regarding = regarding,
      series = series,
      reason = reason,
      deprecatedCount = deprecatedCount,
      related = related,
      deprecatedFirstTimestamp = deprecatedFirstTimestamp,
      note = note,
      reportingController = reportingController,
      metadata = metadata,
      deprecatedSource = deprecatedSource,
      `type` = `type`,
      deprecatedLastTimestamp = deprecatedLastTimestamp,
      reportingInstance = reportingInstance,
      action = action
    )

    implicit lazy val io_k8s_api_apps_v1DaemonSetEncoder : Encoder[io.k8s.api.apps.v1.DaemonSet] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_apps_v1DaemonSetDecoder : Decoder[io.k8s.api.apps.v1.DaemonSet] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.apps.v1.DaemonSetStatus]]("status")
       spec <- c.get[Option[io.k8s.api.apps.v1.DaemonSetSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.apps.v1.DaemonSet(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_authorization_v1SelfSubjectAccessReviewEncoder : Encoder[io.k8s.api.authorization.v1.SelfSubjectAccessReview] = o =>
      Json.obj(
        "spec" -> o.spec.asJson,
      "status" -> o.status.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_authorization_v1SelfSubjectAccessReviewDecoder : Decoder[io.k8s.api.authorization.v1.SelfSubjectAccessReview] = (c: HCursor) => for {
       spec <- c.get[io.k8s.api.authorization.v1.SelfSubjectAccessReviewSpec]("spec")
       status <- c.get[Option[io.k8s.api.authorization.v1.SubjectAccessReviewStatus]]("status")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.authorization.v1.SelfSubjectAccessReview(
      spec = spec,
      status = status,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_batch_v1JobListEncoder : Encoder[io.k8s.api.batch.v1.JobList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_batch_v1JobListDecoder : Decoder[io.k8s.api.batch.v1.JobList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.batch.v1.Job]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.batch.v1.JobList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_rbac_v1RoleBindingEncoder : Encoder[io.k8s.api.rbac.v1.RoleBinding] = o =>
      Json.obj(
        "roleRef" -> o.roleRef.asJson,
      "subjects" -> o.subjects.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_rbac_v1RoleBindingDecoder : Decoder[io.k8s.api.rbac.v1.RoleBinding] = (c: HCursor) => for {
       roleRef <- c.get[io.k8s.api.rbac.v1.RoleRef]("roleRef")
       subjects <- c.get[Option[Seq[io.k8s.api.rbac.v1.Subject]]]("subjects")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.rbac.v1.RoleBinding(
      roleRef = roleRef,
      subjects = subjects,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta1PriorityLevelConfigurationListEncoder : Encoder[io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta1PriorityLevelConfigurationListDecoder : Decoder[io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfiguration]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1SecretEncoder : Encoder[io.k8s.api.core.v1.Secret] = o =>
      Json.obj(
        "data" -> o.data.asJson,
      "immutable" -> o.immutable.asJson,
      "metadata" -> o.metadata.asJson,
      "type" -> o.`type`.asJson,
      "stringData" -> o.stringData.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1SecretDecoder : Decoder[io.k8s.api.core.v1.Secret] = (c: HCursor) => for {
       data <- c.get[Option[Map[String, String]]]("data")
       immutable <- c.get[Option[Boolean]]("immutable")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
       `type` <- c.get[Option[String]]("type")
       stringData <- c.get[Option[Map[String, String]]]("stringData")
    } yield io.k8s.api.core.v1.Secret(
      data = data,
      immutable = immutable,
      metadata = metadata,
      `type` = `type`,
      stringData = stringData
    )

    implicit lazy val io_k8s_api_core_v1ResourceQuotaEncoder : Encoder[io.k8s.api.core.v1.ResourceQuota] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1ResourceQuotaDecoder : Decoder[io.k8s.api.core.v1.ResourceQuota] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.core.v1.ResourceQuotaStatus]]("status")
       spec <- c.get[Option[io.k8s.api.core.v1.ResourceQuotaSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.core.v1.ResourceQuota(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_apps_v1DeploymentListEncoder : Encoder[io.k8s.api.apps.v1.DeploymentList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_apps_v1DeploymentListDecoder : Decoder[io.k8s.api.apps.v1.DeploymentList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.apps.v1.Deployment]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.apps.v1.DeploymentList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_storage_v1beta1CSIStorageCapacityListEncoder : Encoder[io.k8s.api.storage.v1beta1.CSIStorageCapacityList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_storage_v1beta1CSIStorageCapacityListDecoder : Decoder[io.k8s.api.storage.v1beta1.CSIStorageCapacityList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.storage.v1beta1.CSIStorageCapacity]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.storage.v1beta1.CSIStorageCapacityList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1BindingEncoder : Encoder[io.k8s.api.core.v1.Binding] = o =>
      Json.obj(
        "target" -> o.target.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1BindingDecoder : Decoder[io.k8s.api.core.v1.Binding] = (c: HCursor) => for {
       target <- c.get[io.k8s.api.core.v1.ObjectReference]("target")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.core.v1.Binding(
      target = target,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_batch_v1CronJobEncoder : Encoder[io.k8s.api.batch.v1.CronJob] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_batch_v1CronJobDecoder : Decoder[io.k8s.api.batch.v1.CronJob] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.batch.v1.CronJobStatus]]("status")
       spec <- c.get[Option[io.k8s.api.batch.v1.CronJobSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.batch.v1.CronJob(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_storage_v1CSINodeEncoder : Encoder[io.k8s.api.storage.v1.CSINode] = o =>
      Json.obj(
        "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_storage_v1CSINodeDecoder : Decoder[io.k8s.api.storage.v1.CSINode] = (c: HCursor) => for {
       spec <- c.get[io.k8s.api.storage.v1.CSINodeSpec]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.storage.v1.CSINode(
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_storage_v1CSIDriverEncoder : Encoder[io.k8s.api.storage.v1.CSIDriver] = o =>
      Json.obj(
        "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_storage_v1CSIDriverDecoder : Decoder[io.k8s.api.storage.v1.CSIDriver] = (c: HCursor) => for {
       spec <- c.get[io.k8s.api.storage.v1.CSIDriverSpec]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.storage.v1.CSIDriver(
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1EndpointsListEncoder : Encoder[io.k8s.api.core.v1.EndpointsList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1EndpointsListDecoder : Decoder[io.k8s.api.core.v1.EndpointsList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.core.v1.Endpoints]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.core.v1.EndpointsList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_node_v1RuntimeClassListEncoder : Encoder[io.k8s.api.node.v1.RuntimeClassList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_node_v1RuntimeClassListDecoder : Decoder[io.k8s.api.node.v1.RuntimeClassList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.node.v1.RuntimeClass]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.node.v1.RuntimeClassList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1ReplicationControllerEncoder : Encoder[io.k8s.api.core.v1.ReplicationController] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1ReplicationControllerDecoder : Decoder[io.k8s.api.core.v1.ReplicationController] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.core.v1.ReplicationControllerStatus]]("status")
       spec <- c.get[Option[io.k8s.api.core.v1.ReplicationControllerSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.core.v1.ReplicationController(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_rbac_v1ClusterRoleEncoder : Encoder[io.k8s.api.rbac.v1.ClusterRole] = o =>
      Json.obj(
        "aggregationRule" -> o.aggregationRule.asJson,
      "metadata" -> o.metadata.asJson,
      "rules" -> o.rules.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_rbac_v1ClusterRoleDecoder : Decoder[io.k8s.api.rbac.v1.ClusterRole] = (c: HCursor) => for {
       aggregationRule <- c.get[Option[io.k8s.api.rbac.v1.AggregationRule]]("aggregationRule")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
       rules <- c.get[Option[Seq[io.k8s.api.rbac.v1.PolicyRule]]]("rules")
    } yield io.k8s.api.rbac.v1.ClusterRole(
      aggregationRule = aggregationRule,
      metadata = metadata,
      rules = rules
    )

    implicit lazy val io_k8s_api_scheduling_v1PriorityClassListEncoder : Encoder[io.k8s.api.scheduling.v1.PriorityClassList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_scheduling_v1PriorityClassListDecoder : Decoder[io.k8s.api.scheduling.v1.PriorityClassList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.scheduling.v1.PriorityClass]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.scheduling.v1.PriorityClassList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_storage_v1VolumeAttachmentListEncoder : Encoder[io.k8s.api.storage.v1.VolumeAttachmentList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_storage_v1VolumeAttachmentListDecoder : Decoder[io.k8s.api.storage.v1.VolumeAttachmentList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.storage.v1.VolumeAttachment]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.storage.v1.VolumeAttachmentList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_authentication_v1TokenRequestEncoder : Encoder[io.k8s.api.authentication.v1.TokenRequest] = o =>
      Json.obj(
        "spec" -> o.spec.asJson,
      "status" -> o.status.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_authentication_v1TokenRequestDecoder : Decoder[io.k8s.api.authentication.v1.TokenRequest] = (c: HCursor) => for {
       spec <- c.get[io.k8s.api.authentication.v1.TokenRequestSpec]("spec")
       status <- c.get[Option[io.k8s.api.authentication.v1.TokenRequestStatus]]("status")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.authentication.v1.TokenRequest(
      spec = spec,
      status = status,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1PersistentVolumeClaimEncoder : Encoder[io.k8s.api.core.v1.PersistentVolumeClaim] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1PersistentVolumeClaimDecoder : Decoder[io.k8s.api.core.v1.PersistentVolumeClaim] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.core.v1.PersistentVolumeClaimStatus]]("status")
       spec <- c.get[Option[io.k8s.api.core.v1.PersistentVolumeClaimSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.core.v1.PersistentVolumeClaim(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1PodTemplateEncoder : Encoder[io.k8s.api.core.v1.PodTemplate] = o =>
      Json.obj(
        "metadata" -> o.metadata.asJson,
      "template" -> o.template.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1PodTemplateDecoder : Decoder[io.k8s.api.core.v1.PodTemplate] = (c: HCursor) => for {
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
       template <- c.get[Option[io.k8s.api.core.v1.PodTemplateSpec]]("template")
    } yield io.k8s.api.core.v1.PodTemplate(
      metadata = metadata,
      template = template
    )

    implicit lazy val io_k8s_api_storage_v1CSIDriverListEncoder : Encoder[io.k8s.api.storage.v1.CSIDriverList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_storage_v1CSIDriverListDecoder : Decoder[io.k8s.api.storage.v1.CSIDriverList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.storage.v1.CSIDriver]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.storage.v1.CSIDriverList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_networking_v1IngressListEncoder : Encoder[io.k8s.api.networking.v1.IngressList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_networking_v1IngressListDecoder : Decoder[io.k8s.api.networking.v1.IngressList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.networking.v1.Ingress]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.networking.v1.IngressList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_policy_v1EvictionEncoder : Encoder[io.k8s.api.policy.v1.Eviction] = o =>
      Json.obj(
        "deleteOptions" -> o.deleteOptions.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_policy_v1EvictionDecoder : Decoder[io.k8s.api.policy.v1.Eviction] = (c: HCursor) => for {
       deleteOptions <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions]]("deleteOptions")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.policy.v1.Eviction(
      deleteOptions = deleteOptions,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2HorizontalPodAutoscalerListEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2HorizontalPodAutoscalerListDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1EndpointsEncoder : Encoder[io.k8s.api.core.v1.Endpoints] = o =>
      Json.obj(
        "metadata" -> o.metadata.asJson,
      "subsets" -> o.subsets.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1EndpointsDecoder : Decoder[io.k8s.api.core.v1.Endpoints] = (c: HCursor) => for {
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
       subsets <- c.get[Option[Seq[io.k8s.api.core.v1.EndpointSubset]]]("subsets")
    } yield io.k8s.api.core.v1.Endpoints(
      metadata = metadata,
      subsets = subsets
    )

    implicit lazy val io_k8s_api_core_v1PersistentVolumeListEncoder : Encoder[io.k8s.api.core.v1.PersistentVolumeList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1PersistentVolumeListDecoder : Decoder[io.k8s.api.core.v1.PersistentVolumeList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.core.v1.PersistentVolume]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.core.v1.PersistentVolumeList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta1FlowSchemaEncoder : Encoder[io.k8s.api.flowcontrol.v1beta1.FlowSchema] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta1FlowSchemaDecoder : Decoder[io.k8s.api.flowcontrol.v1beta1.FlowSchema] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.flowcontrol.v1beta1.FlowSchemaStatus]]("status")
       spec <- c.get[Option[io.k8s.api.flowcontrol.v1beta1.FlowSchemaSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.flowcontrol.v1beta1.FlowSchema(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_node_v1RuntimeClassEncoder : Encoder[io.k8s.api.node.v1.RuntimeClass] = o =>
      Json.obj(
        "handler" -> o.handler.asJson,
      "scheduling" -> o.scheduling.asJson,
      "overhead" -> o.overhead.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_node_v1RuntimeClassDecoder : Decoder[io.k8s.api.node.v1.RuntimeClass] = (c: HCursor) => for {
       handler <- c.get[String]("handler")
       scheduling <- c.get[Option[io.k8s.api.node.v1.Scheduling]]("scheduling")
       overhead <- c.get[Option[io.k8s.api.node.v1.Overhead]]("overhead")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.node.v1.RuntimeClass(
      handler = handler,
      scheduling = scheduling,
      overhead = overhead,
      metadata = metadata
    )

    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1APIGroupListEncoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.APIGroupList] = o =>
      Json.obj(
        "groups" -> o.groups.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1APIGroupListDecoder : Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.APIGroupList] = (c: HCursor) => for {
       groups <- c.get[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.APIGroup]]("groups")
    } yield io.k8s.apimachinery.pkg.apis.meta.v1.APIGroupList(
      groups = groups
    )

    implicit lazy val io_k8s_api_autoscaling_v2HorizontalPodAutoscalerListEncoder : Encoder[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2HorizontalPodAutoscalerListDecoder : Decoder[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.autoscaling.v2.HorizontalPodAutoscaler]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1ServiceEncoder : Encoder[io.k8s.api.core.v1.Service] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1ServiceDecoder : Decoder[io.k8s.api.core.v1.Service] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.core.v1.ServiceStatus]]("status")
       spec <- c.get[Option[io.k8s.api.core.v1.ServiceSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.core.v1.Service(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_storage_v1StorageClassEncoder : Encoder[io.k8s.api.storage.v1.StorageClass] = o =>
      Json.obj(
        "provisioner" -> o.provisioner.asJson,
      "mountOptions" -> o.mountOptions.asJson,
      "reclaimPolicy" -> o.reclaimPolicy.asJson,
      "volumeBindingMode" -> o.volumeBindingMode.asJson,
      "metadata" -> o.metadata.asJson,
      "allowVolumeExpansion" -> o.allowVolumeExpansion.asJson,
      "allowedTopologies" -> o.allowedTopologies.asJson,
      "parameters" -> o.parameters.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_storage_v1StorageClassDecoder : Decoder[io.k8s.api.storage.v1.StorageClass] = (c: HCursor) => for {
       provisioner <- c.get[String]("provisioner")
       mountOptions <- c.get[Option[Seq[String]]]("mountOptions")
       reclaimPolicy <- c.get[Option[String]]("reclaimPolicy")
       volumeBindingMode <- c.get[Option[String]]("volumeBindingMode")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
       allowVolumeExpansion <- c.get[Option[Boolean]]("allowVolumeExpansion")
       allowedTopologies <- c.get[Option[Seq[io.k8s.api.core.v1.TopologySelectorTerm]]]("allowedTopologies")
       parameters <- c.get[Option[Map[String, String]]]("parameters")
    } yield io.k8s.api.storage.v1.StorageClass(
      provisioner = provisioner,
      mountOptions = mountOptions,
      reclaimPolicy = reclaimPolicy,
      volumeBindingMode = volumeBindingMode,
      metadata = metadata,
      allowVolumeExpansion = allowVolumeExpansion,
      allowedTopologies = allowedTopologies,
      parameters = parameters
    )

    implicit lazy val io_k8s_api_apps_v1DaemonSetListEncoder : Encoder[io.k8s.api.apps.v1.DaemonSetList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_apps_v1DaemonSetListDecoder : Decoder[io.k8s.api.apps.v1.DaemonSetList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.apps.v1.DaemonSet]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.apps.v1.DaemonSetList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1EventEncoder : Encoder[io.k8s.api.core.v1.Event] = o =>
      Json.obj(
        "involvedObject" -> o.involvedObject.asJson,
      "metadata" -> o.metadata.asJson,
      "series" -> o.series.asJson,
      "count" -> o.count.asJson,
      "source" -> o.source.asJson,
      "reportingComponent" -> o.reportingComponent.asJson,
      "reason" -> o.reason.asJson,
      "related" -> o.related.asJson,
      "eventTime" -> o.eventTime.asJson,
      "lastTimestamp" -> o.lastTimestamp.asJson,
      "message" -> o.message.asJson,
      "firstTimestamp" -> o.firstTimestamp.asJson,
      "type" -> o.`type`.asJson,
      "reportingInstance" -> o.reportingInstance.asJson,
      "action" -> o.action.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1EventDecoder : Decoder[io.k8s.api.core.v1.Event] = (c: HCursor) => for {
       involvedObject <- c.get[io.k8s.api.core.v1.ObjectReference]("involvedObject")
       metadata <- c.get[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
       series <- c.get[Option[io.k8s.api.core.v1.EventSeries]]("series")
       count <- c.get[Option[Int]]("count")
       source <- c.get[Option[io.k8s.api.core.v1.EventSource]]("source")
       reportingComponent <- c.get[Option[String]]("reportingComponent")
       reason <- c.get[Option[String]]("reason")
       related <- c.get[Option[io.k8s.api.core.v1.ObjectReference]]("related")
       eventTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime]]("eventTime")
       lastTimestamp <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastTimestamp")
       message <- c.get[Option[String]]("message")
       firstTimestamp <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("firstTimestamp")
       `type` <- c.get[Option[String]]("type")
       reportingInstance <- c.get[Option[String]]("reportingInstance")
       action <- c.get[Option[String]]("action")
    } yield io.k8s.api.core.v1.Event(
      involvedObject = involvedObject,
      metadata = metadata,
      series = series,
      count = count,
      source = source,
      reportingComponent = reportingComponent,
      reason = reason,
      related = related,
      eventTime = eventTime,
      lastTimestamp = lastTimestamp,
      message = message,
      firstTimestamp = firstTimestamp,
      `type` = `type`,
      reportingInstance = reportingInstance,
      action = action
    )

    implicit lazy val io_k8s_api_apps_v1ReplicaSetEncoder : Encoder[io.k8s.api.apps.v1.ReplicaSet] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_apps_v1ReplicaSetDecoder : Decoder[io.k8s.api.apps.v1.ReplicaSet] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.apps.v1.ReplicaSetStatus]]("status")
       spec <- c.get[Option[io.k8s.api.apps.v1.ReplicaSetSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.apps.v1.ReplicaSet(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_authorization_v1LocalSubjectAccessReviewEncoder : Encoder[io.k8s.api.authorization.v1.LocalSubjectAccessReview] = o =>
      Json.obj(
        "spec" -> o.spec.asJson,
      "status" -> o.status.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_authorization_v1LocalSubjectAccessReviewDecoder : Decoder[io.k8s.api.authorization.v1.LocalSubjectAccessReview] = (c: HCursor) => for {
       spec <- c.get[io.k8s.api.authorization.v1.SubjectAccessReviewSpec]("spec")
       status <- c.get[Option[io.k8s.api.authorization.v1.SubjectAccessReviewStatus]]("status")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.authorization.v1.LocalSubjectAccessReview(
      spec = spec,
      status = status,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_rbac_v1ClusterRoleBindingListEncoder : Encoder[io.k8s.api.rbac.v1.ClusterRoleBindingList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_rbac_v1ClusterRoleBindingListDecoder : Decoder[io.k8s.api.rbac.v1.ClusterRoleBindingList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.rbac.v1.ClusterRoleBinding]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.rbac.v1.ClusterRoleBindingList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_apps_v1ControllerRevisionListEncoder : Encoder[io.k8s.api.apps.v1.ControllerRevisionList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_apps_v1ControllerRevisionListDecoder : Decoder[io.k8s.api.apps.v1.ControllerRevisionList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.apps.v1.ControllerRevision]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.apps.v1.ControllerRevisionList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta1FlowSchemaListEncoder : Encoder[io.k8s.api.flowcontrol.v1beta1.FlowSchemaList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta1FlowSchemaListDecoder : Decoder[io.k8s.api.flowcontrol.v1beta1.FlowSchemaList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.flowcontrol.v1beta1.FlowSchema]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.flowcontrol.v1beta1.FlowSchemaList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_authentication_v1TokenReviewEncoder : Encoder[io.k8s.api.authentication.v1.TokenReview] = o =>
      Json.obj(
        "spec" -> o.spec.asJson,
      "status" -> o.status.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_authentication_v1TokenReviewDecoder : Decoder[io.k8s.api.authentication.v1.TokenReview] = (c: HCursor) => for {
       spec <- c.get[io.k8s.api.authentication.v1.TokenReviewSpec]("spec")
       status <- c.get[Option[io.k8s.api.authentication.v1.TokenReviewStatus]]("status")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.authentication.v1.TokenReview(
      spec = spec,
      status = status,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_policy_v1PodDisruptionBudgetListEncoder : Encoder[io.k8s.api.policy.v1.PodDisruptionBudgetList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_policy_v1PodDisruptionBudgetListDecoder : Decoder[io.k8s.api.policy.v1.PodDisruptionBudgetList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.policy.v1.PodDisruptionBudget]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.policy.v1.PodDisruptionBudgetList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_apps_v1DeploymentEncoder : Encoder[io.k8s.api.apps.v1.Deployment] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_apps_v1DeploymentDecoder : Decoder[io.k8s.api.apps.v1.Deployment] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.apps.v1.DeploymentStatus]]("status")
       spec <- c.get[Option[io.k8s.api.apps.v1.DeploymentSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.apps.v1.Deployment(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1ServiceListEncoder : Encoder[io.k8s.api.core.v1.ServiceList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1ServiceListDecoder : Decoder[io.k8s.api.core.v1.ServiceList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.core.v1.Service]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.core.v1.ServiceList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1ConfigMapEncoder : Encoder[io.k8s.api.core.v1.ConfigMap] = o =>
      Json.obj(
        "data" -> o.data.asJson,
      "immutable" -> o.immutable.asJson,
      "binaryData" -> o.binaryData.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1ConfigMapDecoder : Decoder[io.k8s.api.core.v1.ConfigMap] = (c: HCursor) => for {
       data <- c.get[Option[Map[String, String]]]("data")
       immutable <- c.get[Option[Boolean]]("immutable")
       binaryData <- c.get[Option[Map[String, String]]]("binaryData")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.core.v1.ConfigMap(
      data = data,
      immutable = immutable,
      binaryData = binaryData,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1NodeListEncoder : Encoder[io.k8s.api.core.v1.NodeList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1NodeListDecoder : Decoder[io.k8s.api.core.v1.NodeList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.core.v1.Node]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.core.v1.NodeList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1APIGroupEncoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.APIGroup] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "versions" -> o.versions.asJson,
      "preferredVersion" -> o.preferredVersion.asJson,
      "serverAddressByClientCIDRs" -> o.serverAddressByClientCIDRs.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1APIGroupDecoder : Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.APIGroup] = (c: HCursor) => for {
       name <- c.get[String]("name")
       versions <- c.get[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery]]("versions")
       preferredVersion <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery]]("preferredVersion")
       serverAddressByClientCIDRs <- c.get[Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR]]]("serverAddressByClientCIDRs")
    } yield io.k8s.apimachinery.pkg.apis.meta.v1.APIGroup(
      name = name,
      versions = versions,
      preferredVersion = preferredVersion,
      serverAddressByClientCIDRs = serverAddressByClientCIDRs
    )

    implicit lazy val io_k8s_api_core_v1ComponentStatusListEncoder : Encoder[io.k8s.api.core.v1.ComponentStatusList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1ComponentStatusListDecoder : Decoder[io.k8s.api.core.v1.ComponentStatusList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.core.v1.ComponentStatus]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.core.v1.ComponentStatusList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1ResourceQuotaListEncoder : Encoder[io.k8s.api.core.v1.ResourceQuotaList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1ResourceQuotaListDecoder : Decoder[io.k8s.api.core.v1.ResourceQuotaList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.core.v1.ResourceQuota]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.core.v1.ResourceQuotaList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_storage_v1VolumeAttachmentEncoder : Encoder[io.k8s.api.storage.v1.VolumeAttachment] = o =>
      Json.obj(
        "spec" -> o.spec.asJson,
      "status" -> o.status.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_storage_v1VolumeAttachmentDecoder : Decoder[io.k8s.api.storage.v1.VolumeAttachment] = (c: HCursor) => for {
       spec <- c.get[io.k8s.api.storage.v1.VolumeAttachmentSpec]("spec")
       status <- c.get[Option[io.k8s.api.storage.v1.VolumeAttachmentStatus]]("status")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.storage.v1.VolumeAttachment(
      spec = spec,
      status = status,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1NodeEncoder : Encoder[io.k8s.api.core.v1.Node] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1NodeDecoder : Decoder[io.k8s.api.core.v1.Node] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.core.v1.NodeStatus]]("status")
       spec <- c.get[Option[io.k8s.api.core.v1.NodeSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.core.v1.Node(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_rbac_v1RoleBindingListEncoder : Encoder[io.k8s.api.rbac.v1.RoleBindingList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_rbac_v1RoleBindingListDecoder : Decoder[io.k8s.api.rbac.v1.RoleBindingList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.rbac.v1.RoleBinding]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.rbac.v1.RoleBindingList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_certificates_v1CertificateSigningRequestEncoder : Encoder[io.k8s.api.certificates.v1.CertificateSigningRequest] = o =>
      Json.obj(
        "spec" -> o.spec.asJson,
      "status" -> o.status.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_certificates_v1CertificateSigningRequestDecoder : Decoder[io.k8s.api.certificates.v1.CertificateSigningRequest] = (c: HCursor) => for {
       spec <- c.get[io.k8s.api.certificates.v1.CertificateSigningRequestSpec]("spec")
       status <- c.get[Option[io.k8s.api.certificates.v1.CertificateSigningRequestStatus]]("status")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.certificates.v1.CertificateSigningRequest(
      spec = spec,
      status = status,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_autoscaling_v2HorizontalPodAutoscalerEncoder : Encoder[io.k8s.api.autoscaling.v2.HorizontalPodAutoscaler] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2HorizontalPodAutoscalerDecoder : Decoder[io.k8s.api.autoscaling.v2.HorizontalPodAutoscaler] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerStatus]]("status")
       spec <- c.get[Option[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.autoscaling.v2.HorizontalPodAutoscaler(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_rbac_v1RoleEncoder : Encoder[io.k8s.api.rbac.v1.Role] = o =>
      Json.obj(
        "metadata" -> o.metadata.asJson,
      "rules" -> o.rules.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_rbac_v1RoleDecoder : Decoder[io.k8s.api.rbac.v1.Role] = (c: HCursor) => for {
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
       rules <- c.get[Option[Seq[io.k8s.api.rbac.v1.PolicyRule]]]("rules")
    } yield io.k8s.api.rbac.v1.Role(
      metadata = metadata,
      rules = rules
    )

    implicit lazy val io_k8s_api_apps_v1ReplicaSetListEncoder : Encoder[io.k8s.api.apps.v1.ReplicaSetList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_apps_v1ReplicaSetListDecoder : Decoder[io.k8s.api.apps.v1.ReplicaSetList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.apps.v1.ReplicaSet]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.apps.v1.ReplicaSetList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1NamespaceEncoder : Encoder[io.k8s.api.core.v1.Namespace] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1NamespaceDecoder : Decoder[io.k8s.api.core.v1.Namespace] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.core.v1.NamespaceStatus]]("status")
       spec <- c.get[Option[io.k8s.api.core.v1.NamespaceSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.core.v1.Namespace(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1ReplicationControllerListEncoder : Encoder[io.k8s.api.core.v1.ReplicationControllerList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1ReplicationControllerListDecoder : Decoder[io.k8s.api.core.v1.ReplicationControllerList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.core.v1.ReplicationController]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.core.v1.ReplicationControllerList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_storage_v1CSIStorageCapacityListEncoder : Encoder[io.k8s.api.storage.v1.CSIStorageCapacityList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_storage_v1CSIStorageCapacityListDecoder : Decoder[io.k8s.api.storage.v1.CSIStorageCapacityList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.storage.v1.CSIStorageCapacity]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.storage.v1.CSIStorageCapacityList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1NamespaceListEncoder : Encoder[io.k8s.api.core.v1.NamespaceList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1NamespaceListDecoder : Decoder[io.k8s.api.core.v1.NamespaceList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.core.v1.Namespace]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.core.v1.NamespaceList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta2FlowSchemaEncoder : Encoder[io.k8s.api.flowcontrol.v1beta2.FlowSchema] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta2FlowSchemaDecoder : Decoder[io.k8s.api.flowcontrol.v1beta2.FlowSchema] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.flowcontrol.v1beta2.FlowSchemaStatus]]("status")
       spec <- c.get[Option[io.k8s.api.flowcontrol.v1beta2.FlowSchemaSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.flowcontrol.v1beta2.FlowSchema(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_networking_v1NetworkPolicyListEncoder : Encoder[io.k8s.api.networking.v1.NetworkPolicyList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_networking_v1NetworkPolicyListDecoder : Decoder[io.k8s.api.networking.v1.NetworkPolicyList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.networking.v1.NetworkPolicy]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.networking.v1.NetworkPolicyList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_scheduling_v1PriorityClassEncoder : Encoder[io.k8s.api.scheduling.v1.PriorityClass] = o =>
      Json.obj(
        "value" -> o.value.asJson,
      "description" -> o.description.asJson,
      "globalDefault" -> o.globalDefault.asJson,
      "preemptionPolicy" -> o.preemptionPolicy.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_scheduling_v1PriorityClassDecoder : Decoder[io.k8s.api.scheduling.v1.PriorityClass] = (c: HCursor) => for {
       value <- c.get[Int]("value")
       description <- c.get[Option[String]]("description")
       globalDefault <- c.get[Option[Boolean]]("globalDefault")
       preemptionPolicy <- c.get[Option[String]]("preemptionPolicy")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.scheduling.v1.PriorityClass(
      value = value,
      description = description,
      globalDefault = globalDefault,
      preemptionPolicy = preemptionPolicy,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_discovery_v1EndpointSliceListEncoder : Encoder[io.k8s.api.discovery.v1.EndpointSliceList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_discovery_v1EndpointSliceListDecoder : Decoder[io.k8s.api.discovery.v1.EndpointSliceList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.discovery.v1.EndpointSlice]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.discovery.v1.EndpointSliceList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_storage_v1StorageClassListEncoder : Encoder[io.k8s.api.storage.v1.StorageClassList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_storage_v1StorageClassListDecoder : Decoder[io.k8s.api.storage.v1.StorageClassList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.storage.v1.StorageClass]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.storage.v1.StorageClassList(
      items = items,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta1PriorityLevelConfigurationEncoder : Encoder[io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfiguration] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta1PriorityLevelConfigurationDecoder : Decoder[io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfiguration] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationStatus]]("status")
       spec <- c.get[Option[io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationSpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfiguration(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_networking_v1NetworkPolicyEncoder : Encoder[io.k8s.api.networking.v1.NetworkPolicy] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "spec" -> o.spec.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_networking_v1NetworkPolicyDecoder : Decoder[io.k8s.api.networking.v1.NetworkPolicy] = (c: HCursor) => for {
       status <- c.get[Option[io.k8s.api.networking.v1.NetworkPolicyStatus]]("status")
       spec <- c.get[Option[io.k8s.api.networking.v1.NetworkPolicySpec]]("spec")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
    } yield io.k8s.api.networking.v1.NetworkPolicy(
      status = status,
      spec = spec,
      metadata = metadata
    )

    implicit lazy val io_k8s_api_core_v1PersistentVolumeClaimListEncoder : Encoder[io.k8s.api.core.v1.PersistentVolumeClaimList] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "metadata" -> o.metadata.asJson,
      "kind" -> o.kind.asJson,
      "apiVersion" -> o.apiVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1PersistentVolumeClaimListDecoder : Decoder[io.k8s.api.core.v1.PersistentVolumeClaimList] = (c: HCursor) => for {
       items <- c.get[Seq[io.k8s.api.core.v1.PersistentVolumeClaim]]("items")
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]]("metadata")
    } yield io.k8s.api.core.v1.PersistentVolumeClaimList(
      items = items,
      metadata = metadata
    )
}
object ResourceCodecs extends ResourceCodecs

