package dev.hnaderi.k8s
package circe

import io.circe._
import io.circe.syntax._
import PrimitiveCodecs._
import codecs._

private[circe] object InternalCodecs {

    implicit lazy val io_k8s_api_flowcontrol_v1beta2PriorityLevelConfigurationSpecEncoder : Encoder[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationSpec] = o =>
      Json.obj(
        "limited" -> o.limited.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta2PriorityLevelConfigurationSpecDecoder : Decoder[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationSpec] = (c: HCursor) => for {
       limited <- c.get[Option[io.k8s.api.flowcontrol.v1beta2.LimitedPriorityLevelConfiguration]]("limited")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationSpec(
      limited = limited,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_core_v1TaintEncoder : Encoder[io.k8s.api.core.v1.Taint] = o =>
      Json.obj(
        "effect" -> o.effect.asJson,
      "key" -> o.key.asJson,
      "timeAdded" -> o.timeAdded.asJson,
      "value" -> o.value.asJson
      )
    implicit lazy val io_k8s_api_core_v1TaintDecoder : Decoder[io.k8s.api.core.v1.Taint] = (c: HCursor) => for {
       effect <- c.get[String]("effect")
       key <- c.get[String]("key")
       timeAdded <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("timeAdded")
       value <- c.get[Option[String]]("value")
    } yield io.k8s.api.core.v1.Taint(
      effect = effect,
      key = key,
      timeAdded = timeAdded,
      value = value
    )

    implicit lazy val io_k8s_api_core_v1CinderVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.CinderVolumeSource] = o =>
      Json.obj(
        "fsType" -> o.fsType.asJson,
      "readOnly" -> o.readOnly.asJson,
      "secretRef" -> o.secretRef.asJson,
      "volumeID" -> o.volumeID.asJson
      )
    implicit lazy val io_k8s_api_core_v1CinderVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.CinderVolumeSource] = (c: HCursor) => for {
       fsType <- c.get[Option[String]]("fsType")
       readOnly <- c.get[Option[Boolean]]("readOnly")
       secretRef <- c.get[Option[io.k8s.api.core.v1.LocalObjectReference]]("secretRef")
       volumeID <- c.get[String]("volumeID")
    } yield io.k8s.api.core.v1.CinderVolumeSource(
      fsType = fsType,
      readOnly = readOnly,
      secretRef = secretRef,
      volumeID = volumeID
    )

    implicit lazy val io_k8s_api_autoscaling_v2HPAScalingRulesEncoder : Encoder[io.k8s.api.autoscaling.v2.HPAScalingRules] = o =>
      Json.obj(
        "policies" -> o.policies.asJson,
      "selectPolicy" -> o.selectPolicy.asJson,
      "stabilizationWindowSeconds" -> o.stabilizationWindowSeconds.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2HPAScalingRulesDecoder : Decoder[io.k8s.api.autoscaling.v2.HPAScalingRules] = (c: HCursor) => for {
       policies <- c.get[Option[Seq[io.k8s.api.autoscaling.v2.HPAScalingPolicy]]]("policies")
       selectPolicy <- c.get[Option[String]]("selectPolicy")
       stabilizationWindowSeconds <- c.get[Option[Int]]("stabilizationWindowSeconds")
    } yield io.k8s.api.autoscaling.v2.HPAScalingRules(
      policies = policies,
      selectPolicy = selectPolicy,
      stabilizationWindowSeconds = stabilizationWindowSeconds
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta1PriorityLevelConfigurationSpecEncoder : Encoder[io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationSpec] = o =>
      Json.obj(
        "limited" -> o.limited.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta1PriorityLevelConfigurationSpecDecoder : Decoder[io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationSpec] = (c: HCursor) => for {
       limited <- c.get[Option[io.k8s.api.flowcontrol.v1beta1.LimitedPriorityLevelConfiguration]]("limited")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationSpec(
      limited = limited,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta1ServiceAccountSubjectEncoder : Encoder[io.k8s.api.flowcontrol.v1beta1.ServiceAccountSubject] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "namespace" -> o.namespace.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta1ServiceAccountSubjectDecoder : Decoder[io.k8s.api.flowcontrol.v1beta1.ServiceAccountSubject] = (c: HCursor) => for {
       name <- c.get[String]("name")
       namespace <- c.get[String]("namespace")
    } yield io.k8s.api.flowcontrol.v1beta1.ServiceAccountSubject(
      name = name,
      namespace = namespace
    )

    implicit lazy val io_k8s_api_batch_v1JobTemplateSpecEncoder : Encoder[io.k8s.api.batch.v1.JobTemplateSpec] = o =>
      Json.obj(
        "metadata" -> o.metadata.asJson,
      "spec" -> o.spec.asJson
      )
    implicit lazy val io_k8s_api_batch_v1JobTemplateSpecDecoder : Decoder[io.k8s.api.batch.v1.JobTemplateSpec] = (c: HCursor) => for {
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
       spec <- c.get[Option[io.k8s.api.batch.v1.JobSpec]]("spec")
    } yield io.k8s.api.batch.v1.JobTemplateSpec(
      metadata = metadata,
      spec = spec
    )

    implicit lazy val io_k8s_api_networking_v1IngressClassSpecEncoder : Encoder[io.k8s.api.networking.v1.IngressClassSpec] = o =>
      Json.obj(
        "controller" -> o.controller.asJson,
      "parameters" -> o.parameters.asJson
      )
    implicit lazy val io_k8s_api_networking_v1IngressClassSpecDecoder : Decoder[io.k8s.api.networking.v1.IngressClassSpec] = (c: HCursor) => for {
       controller <- c.get[Option[String]]("controller")
       parameters <- c.get[Option[io.k8s.api.networking.v1.IngressClassParametersReference]]("parameters")
    } yield io.k8s.api.networking.v1.IngressClassSpec(
      controller = controller,
      parameters = parameters
    )

    implicit lazy val io_k8s_api_core_v1ServiceSpecEncoder : Encoder[io.k8s.api.core.v1.ServiceSpec] = o =>
      Json.obj(
        "sessionAffinityConfig" -> o.sessionAffinityConfig.asJson,
      "loadBalancerSourceRanges" -> o.loadBalancerSourceRanges.asJson,
      "sessionAffinity" -> o.sessionAffinity.asJson,
      "clusterIPs" -> o.clusterIPs.asJson,
      "externalTrafficPolicy" -> o.externalTrafficPolicy.asJson,
      "loadBalancerIP" -> o.loadBalancerIP.asJson,
      "clusterIP" -> o.clusterIP.asJson,
      "ports" -> o.ports.asJson,
      "healthCheckNodePort" -> o.healthCheckNodePort.asJson,
      "allocateLoadBalancerNodePorts" -> o.allocateLoadBalancerNodePorts.asJson,
      "externalIPs" -> o.externalIPs.asJson,
      "ipFamilies" -> o.ipFamilies.asJson,
      "internalTrafficPolicy" -> o.internalTrafficPolicy.asJson,
      "externalName" -> o.externalName.asJson,
      "ipFamilyPolicy" -> o.ipFamilyPolicy.asJson,
      "type" -> o.`type`.asJson,
      "selector" -> o.selector.asJson,
      "loadBalancerClass" -> o.loadBalancerClass.asJson,
      "publishNotReadyAddresses" -> o.publishNotReadyAddresses.asJson
      )
    implicit lazy val io_k8s_api_core_v1ServiceSpecDecoder : Decoder[io.k8s.api.core.v1.ServiceSpec] = (c: HCursor) => for {
       sessionAffinityConfig <- c.get[Option[io.k8s.api.core.v1.SessionAffinityConfig]]("sessionAffinityConfig")
       loadBalancerSourceRanges <- c.get[Option[Seq[String]]]("loadBalancerSourceRanges")
       sessionAffinity <- c.get[Option[String]]("sessionAffinity")
       clusterIPs <- c.get[Option[Seq[String]]]("clusterIPs")
       externalTrafficPolicy <- c.get[Option[String]]("externalTrafficPolicy")
       loadBalancerIP <- c.get[Option[String]]("loadBalancerIP")
       clusterIP <- c.get[Option[String]]("clusterIP")
       ports <- c.get[Option[Seq[io.k8s.api.core.v1.ServicePort]]]("ports")
       healthCheckNodePort <- c.get[Option[Int]]("healthCheckNodePort")
       allocateLoadBalancerNodePorts <- c.get[Option[Boolean]]("allocateLoadBalancerNodePorts")
       externalIPs <- c.get[Option[Seq[String]]]("externalIPs")
       ipFamilies <- c.get[Option[Seq[String]]]("ipFamilies")
       internalTrafficPolicy <- c.get[Option[String]]("internalTrafficPolicy")
       externalName <- c.get[Option[String]]("externalName")
       ipFamilyPolicy <- c.get[Option[String]]("ipFamilyPolicy")
       `type` <- c.get[Option[String]]("type")
       selector <- c.get[Option[Map[String, String]]]("selector")
       loadBalancerClass <- c.get[Option[String]]("loadBalancerClass")
       publishNotReadyAddresses <- c.get[Option[Boolean]]("publishNotReadyAddresses")
    } yield io.k8s.api.core.v1.ServiceSpec(
      sessionAffinityConfig = sessionAffinityConfig,
      loadBalancerSourceRanges = loadBalancerSourceRanges,
      sessionAffinity = sessionAffinity,
      clusterIPs = clusterIPs,
      externalTrafficPolicy = externalTrafficPolicy,
      loadBalancerIP = loadBalancerIP,
      clusterIP = clusterIP,
      ports = ports,
      healthCheckNodePort = healthCheckNodePort,
      allocateLoadBalancerNodePorts = allocateLoadBalancerNodePorts,
      externalIPs = externalIPs,
      ipFamilies = ipFamilies,
      internalTrafficPolicy = internalTrafficPolicy,
      externalName = externalName,
      ipFamilyPolicy = ipFamilyPolicy,
      `type` = `type`,
      selector = selector,
      loadBalancerClass = loadBalancerClass,
      publishNotReadyAddresses = publishNotReadyAddresses
    )

    implicit lazy val io_k8s_api_apps_v1DaemonSetStatusEncoder : Encoder[io.k8s.api.apps.v1.DaemonSetStatus] = o =>
      Json.obj(
        "conditions" -> o.conditions.asJson,
      "updatedNumberScheduled" -> o.updatedNumberScheduled.asJson,
      "numberMisscheduled" -> o.numberMisscheduled.asJson,
      "collisionCount" -> o.collisionCount.asJson,
      "currentNumberScheduled" -> o.currentNumberScheduled.asJson,
      "numberUnavailable" -> o.numberUnavailable.asJson,
      "observedGeneration" -> o.observedGeneration.asJson,
      "desiredNumberScheduled" -> o.desiredNumberScheduled.asJson,
      "numberReady" -> o.numberReady.asJson,
      "numberAvailable" -> o.numberAvailable.asJson
      )
    implicit lazy val io_k8s_api_apps_v1DaemonSetStatusDecoder : Decoder[io.k8s.api.apps.v1.DaemonSetStatus] = (c: HCursor) => for {
       conditions <- c.get[Option[Seq[io.k8s.api.apps.v1.DaemonSetCondition]]]("conditions")
       updatedNumberScheduled <- c.get[Option[Int]]("updatedNumberScheduled")
       numberMisscheduled <- c.get[Int]("numberMisscheduled")
       collisionCount <- c.get[Option[Int]]("collisionCount")
       currentNumberScheduled <- c.get[Int]("currentNumberScheduled")
       numberUnavailable <- c.get[Option[Int]]("numberUnavailable")
       observedGeneration <- c.get[Option[Int]]("observedGeneration")
       desiredNumberScheduled <- c.get[Int]("desiredNumberScheduled")
       numberReady <- c.get[Int]("numberReady")
       numberAvailable <- c.get[Option[Int]]("numberAvailable")
    } yield io.k8s.api.apps.v1.DaemonSetStatus(
      conditions = conditions,
      updatedNumberScheduled = updatedNumberScheduled,
      numberMisscheduled = numberMisscheduled,
      collisionCount = collisionCount,
      currentNumberScheduled = currentNumberScheduled,
      numberUnavailable = numberUnavailable,
      observedGeneration = observedGeneration,
      desiredNumberScheduled = desiredNumberScheduled,
      numberReady = numberReady,
      numberAvailable = numberAvailable
    )

    implicit lazy val io_k8s_api_apps_v1RollingUpdateStatefulSetStrategyEncoder : Encoder[io.k8s.api.apps.v1.RollingUpdateStatefulSetStrategy] = o =>
      Json.obj(
        "maxUnavailable" -> o.maxUnavailable.asJson,
      "partition" -> o.partition.asJson
      )
    implicit lazy val io_k8s_api_apps_v1RollingUpdateStatefulSetStrategyDecoder : Decoder[io.k8s.api.apps.v1.RollingUpdateStatefulSetStrategy] = (c: HCursor) => for {
       maxUnavailable <- c.get[Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString]]("maxUnavailable")
       partition <- c.get[Option[Int]]("partition")
    } yield io.k8s.api.apps.v1.RollingUpdateStatefulSetStrategy(
      maxUnavailable = maxUnavailable,
      partition = partition
    )

    implicit lazy val io_k8s_api_core_v1ObjectReferenceEncoder : Encoder[io.k8s.api.core.v1.ObjectReference] = o =>
      Json.obj(
        "fieldPath" -> o.fieldPath.asJson,
      "name" -> o.name.asJson,
      "resourceVersion" -> o.resourceVersion.asJson,
      "uid" -> o.uid.asJson,
      "namespace" -> o.namespace.asJson
      )
    implicit lazy val io_k8s_api_core_v1ObjectReferenceDecoder : Decoder[io.k8s.api.core.v1.ObjectReference] = (c: HCursor) => for {
       fieldPath <- c.get[Option[String]]("fieldPath")
       name <- c.get[Option[String]]("name")
       resourceVersion <- c.get[Option[String]]("resourceVersion")
       uid <- c.get[Option[String]]("uid")
       namespace <- c.get[Option[String]]("namespace")
    } yield io.k8s.api.core.v1.ObjectReference(
      fieldPath = fieldPath,
      name = name,
      resourceVersion = resourceVersion,
      uid = uid,
      namespace = namespace
    )

    implicit lazy val io_k8s_api_core_v1EphemeralVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.EphemeralVolumeSource] = o =>
      Json.obj(
        "volumeClaimTemplate" -> o.volumeClaimTemplate.asJson
      )
    implicit lazy val io_k8s_api_core_v1EphemeralVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.EphemeralVolumeSource] = (c: HCursor) => for {
       volumeClaimTemplate <- c.get[Option[io.k8s.api.core.v1.PersistentVolumeClaimTemplate]]("volumeClaimTemplate")
    } yield io.k8s.api.core.v1.EphemeralVolumeSource(
      volumeClaimTemplate = volumeClaimTemplate
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta2FlowSchemaConditionEncoder : Encoder[io.k8s.api.flowcontrol.v1beta2.FlowSchemaCondition] = o =>
      Json.obj(
        "reason" -> o.reason.asJson,
      "status" -> o.status.asJson,
      "lastTransitionTime" -> o.lastTransitionTime.asJson,
      "message" -> o.message.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta2FlowSchemaConditionDecoder : Decoder[io.k8s.api.flowcontrol.v1beta2.FlowSchemaCondition] = (c: HCursor) => for {
       reason <- c.get[Option[String]]("reason")
       status <- c.get[Option[String]]("status")
       lastTransitionTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastTransitionTime")
       message <- c.get[Option[String]]("message")
       `type` <- c.get[Option[String]]("type")
    } yield io.k8s.api.flowcontrol.v1beta2.FlowSchemaCondition(
      reason = reason,
      status = status,
      lastTransitionTime = lastTransitionTime,
      message = message,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_apps_v1StatefulSetPersistentVolumeClaimRetentionPolicyEncoder : Encoder[io.k8s.api.apps.v1.StatefulSetPersistentVolumeClaimRetentionPolicy] = o =>
      Json.obj(
        "whenDeleted" -> o.whenDeleted.asJson,
      "whenScaled" -> o.whenScaled.asJson
      )
    implicit lazy val io_k8s_api_apps_v1StatefulSetPersistentVolumeClaimRetentionPolicyDecoder : Decoder[io.k8s.api.apps.v1.StatefulSetPersistentVolumeClaimRetentionPolicy] = (c: HCursor) => for {
       whenDeleted <- c.get[Option[String]]("whenDeleted")
       whenScaled <- c.get[Option[String]]("whenScaled")
    } yield io.k8s.api.apps.v1.StatefulSetPersistentVolumeClaimRetentionPolicy(
      whenDeleted = whenDeleted,
      whenScaled = whenScaled
    )

    implicit lazy val io_k8s_api_apps_v1DaemonSetConditionEncoder : Encoder[io.k8s.api.apps.v1.DaemonSetCondition] = o =>
      Json.obj(
        "reason" -> o.reason.asJson,
      "status" -> o.status.asJson,
      "lastTransitionTime" -> o.lastTransitionTime.asJson,
      "message" -> o.message.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_apps_v1DaemonSetConditionDecoder : Decoder[io.k8s.api.apps.v1.DaemonSetCondition] = (c: HCursor) => for {
       reason <- c.get[Option[String]]("reason")
       status <- c.get[String]("status")
       lastTransitionTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastTransitionTime")
       message <- c.get[Option[String]]("message")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.apps.v1.DaemonSetCondition(
      reason = reason,
      status = status,
      lastTransitionTime = lastTransitionTime,
      message = message,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_storage_v1VolumeAttachmentSourceEncoder : Encoder[io.k8s.api.storage.v1.VolumeAttachmentSource] = o =>
      Json.obj(
        "inlineVolumeSpec" -> o.inlineVolumeSpec.asJson,
      "persistentVolumeName" -> o.persistentVolumeName.asJson
      )
    implicit lazy val io_k8s_api_storage_v1VolumeAttachmentSourceDecoder : Decoder[io.k8s.api.storage.v1.VolumeAttachmentSource] = (c: HCursor) => for {
       inlineVolumeSpec <- c.get[Option[io.k8s.api.core.v1.PersistentVolumeSpec]]("inlineVolumeSpec")
       persistentVolumeName <- c.get[Option[String]]("persistentVolumeName")
    } yield io.k8s.api.storage.v1.VolumeAttachmentSource(
      inlineVolumeSpec = inlineVolumeSpec,
      persistentVolumeName = persistentVolumeName
    )

    implicit lazy val io_k8s_api_core_v1PreferredSchedulingTermEncoder : Encoder[io.k8s.api.core.v1.PreferredSchedulingTerm] = o =>
      Json.obj(
        "preference" -> o.preference.asJson,
      "weight" -> o.weight.asJson
      )
    implicit lazy val io_k8s_api_core_v1PreferredSchedulingTermDecoder : Decoder[io.k8s.api.core.v1.PreferredSchedulingTerm] = (c: HCursor) => for {
       preference <- c.get[io.k8s.api.core.v1.NodeSelectorTerm]("preference")
       weight <- c.get[Int]("weight")
    } yield io.k8s.api.core.v1.PreferredSchedulingTerm(
      preference = preference,
      weight = weight
    )

    implicit lazy val io_k8s_api_apps_v1StatefulSetStatusEncoder : Encoder[io.k8s.api.apps.v1.StatefulSetStatus] = o =>
      Json.obj(
        "conditions" -> o.conditions.asJson,
      "collisionCount" -> o.collisionCount.asJson,
      "replicas" -> o.replicas.asJson,
      "availableReplicas" -> o.availableReplicas.asJson,
      "observedGeneration" -> o.observedGeneration.asJson,
      "currentRevision" -> o.currentRevision.asJson,
      "currentReplicas" -> o.currentReplicas.asJson,
      "updateRevision" -> o.updateRevision.asJson,
      "updatedReplicas" -> o.updatedReplicas.asJson,
      "readyReplicas" -> o.readyReplicas.asJson
      )
    implicit lazy val io_k8s_api_apps_v1StatefulSetStatusDecoder : Decoder[io.k8s.api.apps.v1.StatefulSetStatus] = (c: HCursor) => for {
       conditions <- c.get[Option[Seq[io.k8s.api.apps.v1.StatefulSetCondition]]]("conditions")
       collisionCount <- c.get[Option[Int]]("collisionCount")
       replicas <- c.get[Int]("replicas")
       availableReplicas <- c.get[Option[Int]]("availableReplicas")
       observedGeneration <- c.get[Option[Int]]("observedGeneration")
       currentRevision <- c.get[Option[String]]("currentRevision")
       currentReplicas <- c.get[Option[Int]]("currentReplicas")
       updateRevision <- c.get[Option[String]]("updateRevision")
       updatedReplicas <- c.get[Option[Int]]("updatedReplicas")
       readyReplicas <- c.get[Option[Int]]("readyReplicas")
    } yield io.k8s.api.apps.v1.StatefulSetStatus(
      conditions = conditions,
      collisionCount = collisionCount,
      replicas = replicas,
      availableReplicas = availableReplicas,
      observedGeneration = observedGeneration,
      currentRevision = currentRevision,
      currentReplicas = currentReplicas,
      updateRevision = updateRevision,
      updatedReplicas = updatedReplicas,
      readyReplicas = readyReplicas
    )

    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1APIResourceEncoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.APIResource] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "verbs" -> o.verbs.asJson,
      "version" -> o.version.asJson,
      "categories" -> o.categories.asJson,
      "namespaced" -> o.namespaced.asJson,
      "shortNames" -> o.shortNames.asJson,
      "storageVersionHash" -> o.storageVersionHash.asJson,
      "singularName" -> o.singularName.asJson,
      "group" -> o.group.asJson
      )
    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1APIResourceDecoder : Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.APIResource] = (c: HCursor) => for {
       name <- c.get[String]("name")
       verbs <- c.get[Seq[String]]("verbs")
       version <- c.get[Option[String]]("version")
       categories <- c.get[Option[Seq[String]]]("categories")
       namespaced <- c.get[Boolean]("namespaced")
       shortNames <- c.get[Option[Seq[String]]]("shortNames")
       storageVersionHash <- c.get[Option[String]]("storageVersionHash")
       singularName <- c.get[String]("singularName")
       group <- c.get[Option[String]]("group")
    } yield io.k8s.apimachinery.pkg.apis.meta.v1.APIResource(
      name = name,
      verbs = verbs,
      version = version,
      categories = categories,
      namespaced = namespaced,
      shortNames = shortNames,
      storageVersionHash = storageVersionHash,
      singularName = singularName,
      group = group
    )

    implicit lazy val io_k8s_api_autoscaling_v2MetricSpecEncoder : Encoder[io.k8s.api.autoscaling.v2.MetricSpec] = o =>
      Json.obj(
        "object" -> o.`object`.asJson,
      "external" -> o.external.asJson,
      "containerResource" -> o.containerResource.asJson,
      "resource" -> o.resource.asJson,
      "pods" -> o.pods.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2MetricSpecDecoder : Decoder[io.k8s.api.autoscaling.v2.MetricSpec] = (c: HCursor) => for {
       `object` <- c.get[Option[io.k8s.api.autoscaling.v2.ObjectMetricSource]]("object")
       external <- c.get[Option[io.k8s.api.autoscaling.v2.ExternalMetricSource]]("external")
       containerResource <- c.get[Option[io.k8s.api.autoscaling.v2.ContainerResourceMetricSource]]("containerResource")
       resource <- c.get[Option[io.k8s.api.autoscaling.v2.ResourceMetricSource]]("resource")
       pods <- c.get[Option[io.k8s.api.autoscaling.v2.PodsMetricSource]]("pods")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.autoscaling.v2.MetricSpec(
      `object` = `object`,
      external = external,
      containerResource = containerResource,
      resource = resource,
      pods = pods,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_apps_v1ReplicaSetSpecEncoder : Encoder[io.k8s.api.apps.v1.ReplicaSetSpec] = o =>
      Json.obj(
        "minReadySeconds" -> o.minReadySeconds.asJson,
      "replicas" -> o.replicas.asJson,
      "selector" -> o.selector.asJson,
      "template" -> o.template.asJson
      )
    implicit lazy val io_k8s_api_apps_v1ReplicaSetSpecDecoder : Decoder[io.k8s.api.apps.v1.ReplicaSetSpec] = (c: HCursor) => for {
       minReadySeconds <- c.get[Option[Int]]("minReadySeconds")
       replicas <- c.get[Option[Int]]("replicas")
       selector <- c.get[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]("selector")
       template <- c.get[Option[io.k8s.api.core.v1.PodTemplateSpec]]("template")
    } yield io.k8s.api.apps.v1.ReplicaSetSpec(
      minReadySeconds = minReadySeconds,
      replicas = replicas,
      selector = selector,
      template = template
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta1FlowSchemaSpecEncoder : Encoder[io.k8s.api.flowcontrol.v1beta1.FlowSchemaSpec] = o =>
      Json.obj(
        "distinguisherMethod" -> o.distinguisherMethod.asJson,
      "matchingPrecedence" -> o.matchingPrecedence.asJson,
      "priorityLevelConfiguration" -> o.priorityLevelConfiguration.asJson,
      "rules" -> o.rules.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta1FlowSchemaSpecDecoder : Decoder[io.k8s.api.flowcontrol.v1beta1.FlowSchemaSpec] = (c: HCursor) => for {
       distinguisherMethod <- c.get[Option[io.k8s.api.flowcontrol.v1beta1.FlowDistinguisherMethod]]("distinguisherMethod")
       matchingPrecedence <- c.get[Option[Int]]("matchingPrecedence")
       priorityLevelConfiguration <- c.get[io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationReference]("priorityLevelConfiguration")
       rules <- c.get[Option[Seq[io.k8s.api.flowcontrol.v1beta1.PolicyRulesWithSubjects]]]("rules")
    } yield io.k8s.api.flowcontrol.v1beta1.FlowSchemaSpec(
      distinguisherMethod = distinguisherMethod,
      matchingPrecedence = matchingPrecedence,
      priorityLevelConfiguration = priorityLevelConfiguration,
      rules = rules
    )

    implicit lazy val io_k8s_api_core_v1StorageOSVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.StorageOSVolumeSource] = o =>
      Json.obj(
        "volumeNamespace" -> o.volumeNamespace.asJson,
      "readOnly" -> o.readOnly.asJson,
      "fsType" -> o.fsType.asJson,
      "secretRef" -> o.secretRef.asJson,
      "volumeName" -> o.volumeName.asJson
      )
    implicit lazy val io_k8s_api_core_v1StorageOSVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.StorageOSVolumeSource] = (c: HCursor) => for {
       volumeNamespace <- c.get[Option[String]]("volumeNamespace")
       readOnly <- c.get[Option[Boolean]]("readOnly")
       fsType <- c.get[Option[String]]("fsType")
       secretRef <- c.get[Option[io.k8s.api.core.v1.LocalObjectReference]]("secretRef")
       volumeName <- c.get[Option[String]]("volumeName")
    } yield io.k8s.api.core.v1.StorageOSVolumeSource(
      volumeNamespace = volumeNamespace,
      readOnly = readOnly,
      fsType = fsType,
      secretRef = secretRef,
      volumeName = volumeName
    )

    implicit lazy val io_k8s_api_core_v1SessionAffinityConfigEncoder : Encoder[io.k8s.api.core.v1.SessionAffinityConfig] = o =>
      Json.obj(
        "clientIP" -> o.clientIP.asJson
      )
    implicit lazy val io_k8s_api_core_v1SessionAffinityConfigDecoder : Decoder[io.k8s.api.core.v1.SessionAffinityConfig] = (c: HCursor) => for {
       clientIP <- c.get[Option[io.k8s.api.core.v1.ClientIPConfig]]("clientIP")
    } yield io.k8s.api.core.v1.SessionAffinityConfig(
      clientIP = clientIP
    )

    implicit lazy val io_k8s_api_discovery_v1EndpointEncoder : Encoder[io.k8s.api.discovery.v1.Endpoint] = o =>
      Json.obj(
        "conditions" -> o.conditions.asJson,
      "targetRef" -> o.targetRef.asJson,
      "hostname" -> o.hostname.asJson,
      "nodeName" -> o.nodeName.asJson,
      "hints" -> o.hints.asJson,
      "deprecatedTopology" -> o.deprecatedTopology.asJson,
      "zone" -> o.zone.asJson,
      "addresses" -> o.addresses.asJson
      )
    implicit lazy val io_k8s_api_discovery_v1EndpointDecoder : Decoder[io.k8s.api.discovery.v1.Endpoint] = (c: HCursor) => for {
       conditions <- c.get[Option[io.k8s.api.discovery.v1.EndpointConditions]]("conditions")
       targetRef <- c.get[Option[io.k8s.api.core.v1.ObjectReference]]("targetRef")
       hostname <- c.get[Option[String]]("hostname")
       nodeName <- c.get[Option[String]]("nodeName")
       hints <- c.get[Option[io.k8s.api.discovery.v1.EndpointHints]]("hints")
       deprecatedTopology <- c.get[Option[Map[String, String]]]("deprecatedTopology")
       zone <- c.get[Option[String]]("zone")
       addresses <- c.get[Seq[String]]("addresses")
    } yield io.k8s.api.discovery.v1.Endpoint(
      conditions = conditions,
      targetRef = targetRef,
      hostname = hostname,
      nodeName = nodeName,
      hints = hints,
      deprecatedTopology = deprecatedTopology,
      zone = zone,
      addresses = addresses
    )

    implicit lazy val io_k8s_api_batch_v1CronJobStatusEncoder : Encoder[io.k8s.api.batch.v1.CronJobStatus] = o =>
      Json.obj(
        "active" -> o.active.asJson,
      "lastScheduleTime" -> o.lastScheduleTime.asJson,
      "lastSuccessfulTime" -> o.lastSuccessfulTime.asJson
      )
    implicit lazy val io_k8s_api_batch_v1CronJobStatusDecoder : Decoder[io.k8s.api.batch.v1.CronJobStatus] = (c: HCursor) => for {
       active <- c.get[Option[Seq[io.k8s.api.core.v1.ObjectReference]]]("active")
       lastScheduleTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastScheduleTime")
       lastSuccessfulTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastSuccessfulTime")
    } yield io.k8s.api.batch.v1.CronJobStatus(
      active = active,
      lastScheduleTime = lastScheduleTime,
      lastSuccessfulTime = lastSuccessfulTime
    )

    implicit lazy val io_k8s_api_core_v1ContainerEncoder : Encoder[io.k8s.api.core.v1.Container] = o =>
      Json.obj(
        "readinessProbe" -> o.readinessProbe.asJson,
      "name" -> o.name.asJson,
      "livenessProbe" -> o.livenessProbe.asJson,
      "lifecycle" -> o.lifecycle.asJson,
      "image" -> o.image.asJson,
      "stdinOnce" -> o.stdinOnce.asJson,
      "ports" -> o.ports.asJson,
      "startupProbe" -> o.startupProbe.asJson,
      "command" -> o.command.asJson,
      "terminationMessagePolicy" -> o.terminationMessagePolicy.asJson,
      "stdin" -> o.stdin.asJson,
      "terminationMessagePath" -> o.terminationMessagePath.asJson,
      "resources" -> o.resources.asJson,
      "envFrom" -> o.envFrom.asJson,
      "volumeDevices" -> o.volumeDevices.asJson,
      "args" -> o.args.asJson,
      "tty" -> o.tty.asJson,
      "imagePullPolicy" -> o.imagePullPolicy.asJson,
      "workingDir" -> o.workingDir.asJson,
      "volumeMounts" -> o.volumeMounts.asJson,
      "env" -> o.env.asJson,
      "securityContext" -> o.securityContext.asJson
      )
    implicit lazy val io_k8s_api_core_v1ContainerDecoder : Decoder[io.k8s.api.core.v1.Container] = (c: HCursor) => for {
       readinessProbe <- c.get[Option[io.k8s.api.core.v1.Probe]]("readinessProbe")
       name <- c.get[String]("name")
       livenessProbe <- c.get[Option[io.k8s.api.core.v1.Probe]]("livenessProbe")
       lifecycle <- c.get[Option[io.k8s.api.core.v1.Lifecycle]]("lifecycle")
       image <- c.get[Option[String]]("image")
       stdinOnce <- c.get[Option[Boolean]]("stdinOnce")
       ports <- c.get[Option[Seq[io.k8s.api.core.v1.ContainerPort]]]("ports")
       startupProbe <- c.get[Option[io.k8s.api.core.v1.Probe]]("startupProbe")
       command <- c.get[Option[Seq[String]]]("command")
       terminationMessagePolicy <- c.get[Option[String]]("terminationMessagePolicy")
       stdin <- c.get[Option[Boolean]]("stdin")
       terminationMessagePath <- c.get[Option[String]]("terminationMessagePath")
       resources <- c.get[Option[io.k8s.api.core.v1.ResourceRequirements]]("resources")
       envFrom <- c.get[Option[Seq[io.k8s.api.core.v1.EnvFromSource]]]("envFrom")
       volumeDevices <- c.get[Option[Seq[io.k8s.api.core.v1.VolumeDevice]]]("volumeDevices")
       args <- c.get[Option[Seq[String]]]("args")
       tty <- c.get[Option[Boolean]]("tty")
       imagePullPolicy <- c.get[Option[String]]("imagePullPolicy")
       workingDir <- c.get[Option[String]]("workingDir")
       volumeMounts <- c.get[Option[Seq[io.k8s.api.core.v1.VolumeMount]]]("volumeMounts")
       env <- c.get[Option[Seq[io.k8s.api.core.v1.EnvVar]]]("env")
       securityContext <- c.get[Option[io.k8s.api.core.v1.SecurityContext]]("securityContext")
    } yield io.k8s.api.core.v1.Container(
      readinessProbe = readinessProbe,
      name = name,
      livenessProbe = livenessProbe,
      lifecycle = lifecycle,
      image = image,
      stdinOnce = stdinOnce,
      ports = ports,
      startupProbe = startupProbe,
      command = command,
      terminationMessagePolicy = terminationMessagePolicy,
      stdin = stdin,
      terminationMessagePath = terminationMessagePath,
      resources = resources,
      envFrom = envFrom,
      volumeDevices = volumeDevices,
      args = args,
      tty = tty,
      imagePullPolicy = imagePullPolicy,
      workingDir = workingDir,
      volumeMounts = volumeMounts,
      env = env,
      securityContext = securityContext
    )

    implicit lazy val io_k8s_api_core_v1EmptyDirVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.EmptyDirVolumeSource] = o =>
      Json.obj(
        "medium" -> o.medium.asJson,
      "sizeLimit" -> o.sizeLimit.asJson
      )
    implicit lazy val io_k8s_api_core_v1EmptyDirVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.EmptyDirVolumeSource] = (c: HCursor) => for {
       medium <- c.get[Option[String]]("medium")
       sizeLimit <- c.get[Option[io.k8s.apimachinery.pkg.api.resource.Quantity]]("sizeLimit")
    } yield io.k8s.api.core.v1.EmptyDirVolumeSource(
      medium = medium,
      sizeLimit = sizeLimit
    )

    implicit lazy val io_k8s_api_autoscaling_v1ScaleSpecEncoder : Encoder[io.k8s.api.autoscaling.v1.ScaleSpec] = o =>
      Json.obj(
        "replicas" -> o.replicas.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v1ScaleSpecDecoder : Decoder[io.k8s.api.autoscaling.v1.ScaleSpec] = (c: HCursor) => for {
       replicas <- c.get[Option[Int]]("replicas")
    } yield io.k8s.api.autoscaling.v1.ScaleSpec(
      replicas = replicas
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta1QueuingConfigurationEncoder : Encoder[io.k8s.api.flowcontrol.v1beta1.QueuingConfiguration] = o =>
      Json.obj(
        "handSize" -> o.handSize.asJson,
      "queueLengthLimit" -> o.queueLengthLimit.asJson,
      "queues" -> o.queues.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta1QueuingConfigurationDecoder : Decoder[io.k8s.api.flowcontrol.v1beta1.QueuingConfiguration] = (c: HCursor) => for {
       handSize <- c.get[Option[Int]]("handSize")
       queueLengthLimit <- c.get[Option[Int]]("queueLengthLimit")
       queues <- c.get[Option[Int]]("queues")
    } yield io.k8s.api.flowcontrol.v1beta1.QueuingConfiguration(
      handSize = handSize,
      queueLengthLimit = queueLengthLimit,
      queues = queues
    )

    implicit lazy val io_k8s_api_autoscaling_v2CrossVersionObjectReferenceEncoder : Encoder[io.k8s.api.autoscaling.v2.CrossVersionObjectReference] = o =>
      Json.obj(
        "name" -> o.name.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2CrossVersionObjectReferenceDecoder : Decoder[io.k8s.api.autoscaling.v2.CrossVersionObjectReference] = (c: HCursor) => for {
       name <- c.get[String]("name")
    } yield io.k8s.api.autoscaling.v2.CrossVersionObjectReference(
      name = name
    )

    implicit lazy val io_k8s_api_rbac_v1AggregationRuleEncoder : Encoder[io.k8s.api.rbac.v1.AggregationRule] = o =>
      Json.obj(
        "clusterRoleSelectors" -> o.clusterRoleSelectors.asJson
      )
    implicit lazy val io_k8s_api_rbac_v1AggregationRuleDecoder : Decoder[io.k8s.api.rbac.v1.AggregationRule] = (c: HCursor) => for {
       clusterRoleSelectors <- c.get[Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]]]("clusterRoleSelectors")
    } yield io.k8s.api.rbac.v1.AggregationRule(
      clusterRoleSelectors = clusterRoleSelectors
    )

    implicit lazy val io_k8s_api_coordination_v1LeaseSpecEncoder : Encoder[io.k8s.api.coordination.v1.LeaseSpec] = o =>
      Json.obj(
        "leaseTransitions" -> o.leaseTransitions.asJson,
      "holderIdentity" -> o.holderIdentity.asJson,
      "leaseDurationSeconds" -> o.leaseDurationSeconds.asJson,
      "renewTime" -> o.renewTime.asJson,
      "acquireTime" -> o.acquireTime.asJson
      )
    implicit lazy val io_k8s_api_coordination_v1LeaseSpecDecoder : Decoder[io.k8s.api.coordination.v1.LeaseSpec] = (c: HCursor) => for {
       leaseTransitions <- c.get[Option[Int]]("leaseTransitions")
       holderIdentity <- c.get[Option[String]]("holderIdentity")
       leaseDurationSeconds <- c.get[Option[Int]]("leaseDurationSeconds")
       renewTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime]]("renewTime")
       acquireTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime]]("acquireTime")
    } yield io.k8s.api.coordination.v1.LeaseSpec(
      leaseTransitions = leaseTransitions,
      holderIdentity = holderIdentity,
      leaseDurationSeconds = leaseDurationSeconds,
      renewTime = renewTime,
      acquireTime = acquireTime
    )

    implicit lazy val io_k8s_api_core_v1LimitRangeSpecEncoder : Encoder[io.k8s.api.core.v1.LimitRangeSpec] = o =>
      Json.obj(
        "limits" -> o.limits.asJson
      )
    implicit lazy val io_k8s_api_core_v1LimitRangeSpecDecoder : Decoder[io.k8s.api.core.v1.LimitRangeSpec] = (c: HCursor) => for {
       limits <- c.get[Seq[io.k8s.api.core.v1.LimitRangeItem]]("limits")
    } yield io.k8s.api.core.v1.LimitRangeSpec(
      limits = limits
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2MetricIdentifierEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.MetricIdentifier] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "selector" -> o.selector.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2MetricIdentifierDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.MetricIdentifier] = (c: HCursor) => for {
       name <- c.get[String]("name")
       selector <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]]("selector")
    } yield io.k8s.api.autoscaling.v2beta2.MetricIdentifier(
      name = name,
      selector = selector
    )

    implicit lazy val io_k8s_api_core_v1ContainerStateEncoder : Encoder[io.k8s.api.core.v1.ContainerState] = o =>
      Json.obj(
        "running" -> o.running.asJson,
      "terminated" -> o.terminated.asJson,
      "waiting" -> o.waiting.asJson
      )
    implicit lazy val io_k8s_api_core_v1ContainerStateDecoder : Decoder[io.k8s.api.core.v1.ContainerState] = (c: HCursor) => for {
       running <- c.get[Option[io.k8s.api.core.v1.ContainerStateRunning]]("running")
       terminated <- c.get[Option[io.k8s.api.core.v1.ContainerStateTerminated]]("terminated")
       waiting <- c.get[Option[io.k8s.api.core.v1.ContainerStateWaiting]]("waiting")
    } yield io.k8s.api.core.v1.ContainerState(
      running = running,
      terminated = terminated,
      waiting = waiting
    )

    implicit lazy val io_k8s_api_core_v1HostPathVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.HostPathVolumeSource] = o =>
      Json.obj(
        "path" -> o.path.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_core_v1HostPathVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.HostPathVolumeSource] = (c: HCursor) => for {
       path <- c.get[String]("path")
       `type` <- c.get[Option[String]]("type")
    } yield io.k8s.api.core.v1.HostPathVolumeSource(
      path = path,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_core_v1NodeStatusEncoder : Encoder[io.k8s.api.core.v1.NodeStatus] = o =>
      Json.obj(
        "volumesInUse" -> o.volumesInUse.asJson,
      "conditions" -> o.conditions.asJson,
      "nodeInfo" -> o.nodeInfo.asJson,
      "volumesAttached" -> o.volumesAttached.asJson,
      "phase" -> o.phase.asJson,
      "config" -> o.config.asJson,
      "allocatable" -> o.allocatable.asJson,
      "images" -> o.images.asJson,
      "daemonEndpoints" -> o.daemonEndpoints.asJson,
      "addresses" -> o.addresses.asJson,
      "capacity" -> o.capacity.asJson
      )
    implicit lazy val io_k8s_api_core_v1NodeStatusDecoder : Decoder[io.k8s.api.core.v1.NodeStatus] = (c: HCursor) => for {
       volumesInUse <- c.get[Option[Seq[String]]]("volumesInUse")
       conditions <- c.get[Option[Seq[io.k8s.api.core.v1.NodeCondition]]]("conditions")
       nodeInfo <- c.get[Option[io.k8s.api.core.v1.NodeSystemInfo]]("nodeInfo")
       volumesAttached <- c.get[Option[Seq[io.k8s.api.core.v1.AttachedVolume]]]("volumesAttached")
       phase <- c.get[Option[String]]("phase")
       config <- c.get[Option[io.k8s.api.core.v1.NodeConfigStatus]]("config")
       allocatable <- c.get[Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]]("allocatable")
       images <- c.get[Option[Seq[io.k8s.api.core.v1.ContainerImage]]]("images")
       daemonEndpoints <- c.get[Option[io.k8s.api.core.v1.NodeDaemonEndpoints]]("daemonEndpoints")
       addresses <- c.get[Option[Seq[io.k8s.api.core.v1.NodeAddress]]]("addresses")
       capacity <- c.get[Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]]("capacity")
    } yield io.k8s.api.core.v1.NodeStatus(
      volumesInUse = volumesInUse,
      conditions = conditions,
      nodeInfo = nodeInfo,
      volumesAttached = volumesAttached,
      phase = phase,
      config = config,
      allocatable = allocatable,
      images = images,
      daemonEndpoints = daemonEndpoints,
      addresses = addresses,
      capacity = capacity
    )

    implicit lazy val io_k8s_api_networking_v1IngressRuleEncoder : Encoder[io.k8s.api.networking.v1.IngressRule] = o =>
      Json.obj(
        "host" -> o.host.asJson,
      "http" -> o.http.asJson
      )
    implicit lazy val io_k8s_api_networking_v1IngressRuleDecoder : Decoder[io.k8s.api.networking.v1.IngressRule] = (c: HCursor) => for {
       host <- c.get[Option[String]]("host")
       http <- c.get[Option[io.k8s.api.networking.v1.HTTPIngressRuleValue]]("http")
    } yield io.k8s.api.networking.v1.IngressRule(
      host = host,
      http = http
    )

    implicit lazy val io_k8s_api_core_v1TCPSocketActionEncoder : Encoder[io.k8s.api.core.v1.TCPSocketAction] = o =>
      Json.obj(
        "host" -> o.host.asJson,
      "port" -> o.port.asJson
      )
    implicit lazy val io_k8s_api_core_v1TCPSocketActionDecoder : Decoder[io.k8s.api.core.v1.TCPSocketAction] = (c: HCursor) => for {
       host <- c.get[Option[String]]("host")
       port <- c.get[io.k8s.apimachinery.pkg.util.intstr.IntOrString]("port")
    } yield io.k8s.api.core.v1.TCPSocketAction(
      host = host,
      port = port
    )

    implicit lazy val io_k8s_api_core_v1SecurityContextEncoder : Encoder[io.k8s.api.core.v1.SecurityContext] = o =>
      Json.obj(
        "capabilities" -> o.capabilities.asJson,
      "readOnlyRootFilesystem" -> o.readOnlyRootFilesystem.asJson,
      "allowPrivilegeEscalation" -> o.allowPrivilegeEscalation.asJson,
      "procMount" -> o.procMount.asJson,
      "runAsGroup" -> o.runAsGroup.asJson,
      "seccompProfile" -> o.seccompProfile.asJson,
      "windowsOptions" -> o.windowsOptions.asJson,
      "seLinuxOptions" -> o.seLinuxOptions.asJson,
      "runAsUser" -> o.runAsUser.asJson,
      "privileged" -> o.privileged.asJson,
      "runAsNonRoot" -> o.runAsNonRoot.asJson
      )
    implicit lazy val io_k8s_api_core_v1SecurityContextDecoder : Decoder[io.k8s.api.core.v1.SecurityContext] = (c: HCursor) => for {
       capabilities <- c.get[Option[io.k8s.api.core.v1.Capabilities]]("capabilities")
       readOnlyRootFilesystem <- c.get[Option[Boolean]]("readOnlyRootFilesystem")
       allowPrivilegeEscalation <- c.get[Option[Boolean]]("allowPrivilegeEscalation")
       procMount <- c.get[Option[String]]("procMount")
       runAsGroup <- c.get[Option[Int]]("runAsGroup")
       seccompProfile <- c.get[Option[io.k8s.api.core.v1.SeccompProfile]]("seccompProfile")
       windowsOptions <- c.get[Option[io.k8s.api.core.v1.WindowsSecurityContextOptions]]("windowsOptions")
       seLinuxOptions <- c.get[Option[io.k8s.api.core.v1.SELinuxOptions]]("seLinuxOptions")
       runAsUser <- c.get[Option[Int]]("runAsUser")
       privileged <- c.get[Option[Boolean]]("privileged")
       runAsNonRoot <- c.get[Option[Boolean]]("runAsNonRoot")
    } yield io.k8s.api.core.v1.SecurityContext(
      capabilities = capabilities,
      readOnlyRootFilesystem = readOnlyRootFilesystem,
      allowPrivilegeEscalation = allowPrivilegeEscalation,
      procMount = procMount,
      runAsGroup = runAsGroup,
      seccompProfile = seccompProfile,
      windowsOptions = windowsOptions,
      seLinuxOptions = seLinuxOptions,
      runAsUser = runAsUser,
      privileged = privileged,
      runAsNonRoot = runAsNonRoot
    )

    implicit lazy val io_k8s_api_authorization_v1ResourceRuleEncoder : Encoder[io.k8s.api.authorization.v1.ResourceRule] = o =>
      Json.obj(
        "apiGroups" -> o.apiGroups.asJson,
      "resourceNames" -> o.resourceNames.asJson,
      "resources" -> o.resources.asJson,
      "verbs" -> o.verbs.asJson
      )
    implicit lazy val io_k8s_api_authorization_v1ResourceRuleDecoder : Decoder[io.k8s.api.authorization.v1.ResourceRule] = (c: HCursor) => for {
       apiGroups <- c.get[Option[Seq[String]]]("apiGroups")
       resourceNames <- c.get[Option[Seq[String]]]("resourceNames")
       resources <- c.get[Option[Seq[String]]]("resources")
       verbs <- c.get[Seq[String]]("verbs")
    } yield io.k8s.api.authorization.v1.ResourceRule(
      apiGroups = apiGroups,
      resourceNames = resourceNames,
      resources = resources,
      verbs = verbs
    )

    implicit lazy val io_k8s_api_certificates_v1CertificateSigningRequestStatusEncoder : Encoder[io.k8s.api.certificates.v1.CertificateSigningRequestStatus] = o =>
      Json.obj(
        "certificate" -> o.certificate.asJson,
      "conditions" -> o.conditions.asJson
      )
    implicit lazy val io_k8s_api_certificates_v1CertificateSigningRequestStatusDecoder : Decoder[io.k8s.api.certificates.v1.CertificateSigningRequestStatus] = (c: HCursor) => for {
       certificate <- c.get[Option[String]]("certificate")
       conditions <- c.get[Option[Seq[io.k8s.api.certificates.v1.CertificateSigningRequestCondition]]]("conditions")
    } yield io.k8s.api.certificates.v1.CertificateSigningRequestStatus(
      certificate = certificate,
      conditions = conditions
    )

    implicit lazy val io_k8s_api_batch_v1PodFailurePolicyRuleEncoder : Encoder[io.k8s.api.batch.v1.PodFailurePolicyRule] = o =>
      Json.obj(
        "action" -> o.action.asJson,
      "onExitCodes" -> o.onExitCodes.asJson,
      "onPodConditions" -> o.onPodConditions.asJson
      )
    implicit lazy val io_k8s_api_batch_v1PodFailurePolicyRuleDecoder : Decoder[io.k8s.api.batch.v1.PodFailurePolicyRule] = (c: HCursor) => for {
       action <- c.get[String]("action")
       onExitCodes <- c.get[Option[io.k8s.api.batch.v1.PodFailurePolicyOnExitCodesRequirement]]("onExitCodes")
       onPodConditions <- c.get[Seq[io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern]]("onPodConditions")
    } yield io.k8s.api.batch.v1.PodFailurePolicyRule(
      action = action,
      onExitCodes = onExitCodes,
      onPodConditions = onPodConditions
    )

    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1ListMetaEncoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = o =>
      Json.obj(
        "continue" -> o.continue.asJson,
      "remainingItemCount" -> o.remainingItemCount.asJson,
      "resourceVersion" -> o.resourceVersion.asJson,
      "selfLink" -> o.selfLink.asJson
      )
    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1ListMetaDecoder : Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = (c: HCursor) => for {
       continue <- c.get[Option[String]]("continue")
       remainingItemCount <- c.get[Option[Int]]("remainingItemCount")
       resourceVersion <- c.get[Option[String]]("resourceVersion")
       selfLink <- c.get[Option[String]]("selfLink")
    } yield io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta(
      continue = continue,
      remainingItemCount = remainingItemCount,
      resourceVersion = resourceVersion,
      selfLink = selfLink
    )

    implicit lazy val io_k8s_api_autoscaling_v1HorizontalPodAutoscalerStatusEncoder : Encoder[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerStatus] = o =>
      Json.obj(
        "desiredReplicas" -> o.desiredReplicas.asJson,
      "lastScaleTime" -> o.lastScaleTime.asJson,
      "observedGeneration" -> o.observedGeneration.asJson,
      "currentReplicas" -> o.currentReplicas.asJson,
      "currentCPUUtilizationPercentage" -> o.currentCPUUtilizationPercentage.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v1HorizontalPodAutoscalerStatusDecoder : Decoder[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerStatus] = (c: HCursor) => for {
       desiredReplicas <- c.get[Int]("desiredReplicas")
       lastScaleTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastScaleTime")
       observedGeneration <- c.get[Option[Int]]("observedGeneration")
       currentReplicas <- c.get[Int]("currentReplicas")
       currentCPUUtilizationPercentage <- c.get[Option[Int]]("currentCPUUtilizationPercentage")
    } yield io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerStatus(
      desiredReplicas = desiredReplicas,
      lastScaleTime = lastScaleTime,
      observedGeneration = observedGeneration,
      currentReplicas = currentReplicas,
      currentCPUUtilizationPercentage = currentCPUUtilizationPercentage
    )

    implicit lazy val io_k8s_api_core_v1GitRepoVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.GitRepoVolumeSource] = o =>
      Json.obj(
        "directory" -> o.directory.asJson,
      "repository" -> o.repository.asJson,
      "revision" -> o.revision.asJson
      )
    implicit lazy val io_k8s_api_core_v1GitRepoVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.GitRepoVolumeSource] = (c: HCursor) => for {
       directory <- c.get[Option[String]]("directory")
       repository <- c.get[String]("repository")
       revision <- c.get[Option[String]]("revision")
    } yield io.k8s.api.core.v1.GitRepoVolumeSource(
      directory = directory,
      repository = repository,
      revision = revision
    )

    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceDefinitionStatusEncoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionStatus] = o =>
      Json.obj(
        "acceptedNames" -> o.acceptedNames.asJson,
      "conditions" -> o.conditions.asJson,
      "storedVersions" -> o.storedVersions.asJson
      )
    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceDefinitionStatusDecoder : Decoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionStatus] = (c: HCursor) => for {
       acceptedNames <- c.get[Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames]]("acceptedNames")
       conditions <- c.get[Option[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionCondition]]]("conditions")
       storedVersions <- c.get[Option[Seq[String]]]("storedVersions")
    } yield io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionStatus(
      acceptedNames = acceptedNames,
      conditions = conditions,
      storedVersions = storedVersions
    )

    implicit lazy val io_k8s_api_core_v1ReplicationControllerStatusEncoder : Encoder[io.k8s.api.core.v1.ReplicationControllerStatus] = o =>
      Json.obj(
        "conditions" -> o.conditions.asJson,
      "replicas" -> o.replicas.asJson,
      "availableReplicas" -> o.availableReplicas.asJson,
      "observedGeneration" -> o.observedGeneration.asJson,
      "readyReplicas" -> o.readyReplicas.asJson,
      "fullyLabeledReplicas" -> o.fullyLabeledReplicas.asJson
      )
    implicit lazy val io_k8s_api_core_v1ReplicationControllerStatusDecoder : Decoder[io.k8s.api.core.v1.ReplicationControllerStatus] = (c: HCursor) => for {
       conditions <- c.get[Option[Seq[io.k8s.api.core.v1.ReplicationControllerCondition]]]("conditions")
       replicas <- c.get[Int]("replicas")
       availableReplicas <- c.get[Option[Int]]("availableReplicas")
       observedGeneration <- c.get[Option[Int]]("observedGeneration")
       readyReplicas <- c.get[Option[Int]]("readyReplicas")
       fullyLabeledReplicas <- c.get[Option[Int]]("fullyLabeledReplicas")
    } yield io.k8s.api.core.v1.ReplicationControllerStatus(
      conditions = conditions,
      replicas = replicas,
      availableReplicas = availableReplicas,
      observedGeneration = observedGeneration,
      readyReplicas = readyReplicas,
      fullyLabeledReplicas = fullyLabeledReplicas
    )

    implicit lazy val io_k8s_api_autoscaling_v2MetricTargetEncoder : Encoder[io.k8s.api.autoscaling.v2.MetricTarget] = o =>
      Json.obj(
        "averageUtilization" -> o.averageUtilization.asJson,
      "averageValue" -> o.averageValue.asJson,
      "type" -> o.`type`.asJson,
      "value" -> o.value.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2MetricTargetDecoder : Decoder[io.k8s.api.autoscaling.v2.MetricTarget] = (c: HCursor) => for {
       averageUtilization <- c.get[Option[Int]]("averageUtilization")
       averageValue <- c.get[Option[io.k8s.apimachinery.pkg.api.resource.Quantity]]("averageValue")
       `type` <- c.get[String]("type")
       value <- c.get[Option[io.k8s.apimachinery.pkg.api.resource.Quantity]]("value")
    } yield io.k8s.api.autoscaling.v2.MetricTarget(
      averageUtilization = averageUtilization,
      averageValue = averageValue,
      `type` = `type`,
      value = value
    )

    implicit lazy val io_k8s_api_core_v1ISCSIVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.ISCSIVolumeSource] = o =>
      Json.obj(
        "portals" -> o.portals.asJson,
      "readOnly" -> o.readOnly.asJson,
      "chapAuthDiscovery" -> o.chapAuthDiscovery.asJson,
      "fsType" -> o.fsType.asJson,
      "secretRef" -> o.secretRef.asJson,
      "iqn" -> o.iqn.asJson,
      "initiatorName" -> o.initiatorName.asJson,
      "iscsiInterface" -> o.iscsiInterface.asJson,
      "targetPortal" -> o.targetPortal.asJson,
      "lun" -> o.lun.asJson,
      "chapAuthSession" -> o.chapAuthSession.asJson
      )
    implicit lazy val io_k8s_api_core_v1ISCSIVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.ISCSIVolumeSource] = (c: HCursor) => for {
       portals <- c.get[Option[Seq[String]]]("portals")
       readOnly <- c.get[Option[Boolean]]("readOnly")
       chapAuthDiscovery <- c.get[Option[Boolean]]("chapAuthDiscovery")
       fsType <- c.get[Option[String]]("fsType")
       secretRef <- c.get[Option[io.k8s.api.core.v1.LocalObjectReference]]("secretRef")
       iqn <- c.get[String]("iqn")
       initiatorName <- c.get[Option[String]]("initiatorName")
       iscsiInterface <- c.get[Option[String]]("iscsiInterface")
       targetPortal <- c.get[String]("targetPortal")
       lun <- c.get[Int]("lun")
       chapAuthSession <- c.get[Option[Boolean]]("chapAuthSession")
    } yield io.k8s.api.core.v1.ISCSIVolumeSource(
      portals = portals,
      readOnly = readOnly,
      chapAuthDiscovery = chapAuthDiscovery,
      fsType = fsType,
      secretRef = secretRef,
      iqn = iqn,
      initiatorName = initiatorName,
      iscsiInterface = iscsiInterface,
      targetPortal = targetPortal,
      lun = lun,
      chapAuthSession = chapAuthSession
    )

    implicit lazy val io_k8s_api_networking_v1IPBlockEncoder : Encoder[io.k8s.api.networking.v1.IPBlock] = o =>
      Json.obj(
        "cidr" -> o.cidr.asJson,
      "except" -> o.except.asJson
      )
    implicit lazy val io_k8s_api_networking_v1IPBlockDecoder : Decoder[io.k8s.api.networking.v1.IPBlock] = (c: HCursor) => for {
       cidr <- c.get[String]("cidr")
       except <- c.get[Option[Seq[String]]]("except")
    } yield io.k8s.api.networking.v1.IPBlock(
      cidr = cidr,
      except = except
    )

    implicit lazy val io_k8s_api_authentication_v1BoundObjectReferenceEncoder : Encoder[io.k8s.api.authentication.v1.BoundObjectReference] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "uid" -> o.uid.asJson
      )
    implicit lazy val io_k8s_api_authentication_v1BoundObjectReferenceDecoder : Decoder[io.k8s.api.authentication.v1.BoundObjectReference] = (c: HCursor) => for {
       name <- c.get[Option[String]]("name")
       uid <- c.get[Option[String]]("uid")
    } yield io.k8s.api.authentication.v1.BoundObjectReference(
      name = name,
      uid = uid
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta2FlowSchemaSpecEncoder : Encoder[io.k8s.api.flowcontrol.v1beta2.FlowSchemaSpec] = o =>
      Json.obj(
        "distinguisherMethod" -> o.distinguisherMethod.asJson,
      "matchingPrecedence" -> o.matchingPrecedence.asJson,
      "priorityLevelConfiguration" -> o.priorityLevelConfiguration.asJson,
      "rules" -> o.rules.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta2FlowSchemaSpecDecoder : Decoder[io.k8s.api.flowcontrol.v1beta2.FlowSchemaSpec] = (c: HCursor) => for {
       distinguisherMethod <- c.get[Option[io.k8s.api.flowcontrol.v1beta2.FlowDistinguisherMethod]]("distinguisherMethod")
       matchingPrecedence <- c.get[Option[Int]]("matchingPrecedence")
       priorityLevelConfiguration <- c.get[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationReference]("priorityLevelConfiguration")
       rules <- c.get[Option[Seq[io.k8s.api.flowcontrol.v1beta2.PolicyRulesWithSubjects]]]("rules")
    } yield io.k8s.api.flowcontrol.v1beta2.FlowSchemaSpec(
      distinguisherMethod = distinguisherMethod,
      matchingPrecedence = matchingPrecedence,
      priorityLevelConfiguration = priorityLevelConfiguration,
      rules = rules
    )

    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1ValidationRuleEncoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule] = o =>
      Json.obj(
        "message" -> o.message.asJson,
      "rule" -> o.rule.asJson
      )
    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1ValidationRuleDecoder : Decoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule] = (c: HCursor) => for {
       message <- c.get[Option[String]]("message")
       rule <- c.get[String]("rule")
    } yield io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule(
      message = message,
      rule = rule
    )

    implicit lazy val io_k8s_api_apps_v1DeploymentSpecEncoder : Encoder[io.k8s.api.apps.v1.DeploymentSpec] = o =>
      Json.obj(
        "minReadySeconds" -> o.minReadySeconds.asJson,
      "progressDeadlineSeconds" -> o.progressDeadlineSeconds.asJson,
      "replicas" -> o.replicas.asJson,
      "revisionHistoryLimit" -> o.revisionHistoryLimit.asJson,
      "paused" -> o.paused.asJson,
      "strategy" -> o.strategy.asJson,
      "template" -> o.template.asJson,
      "selector" -> o.selector.asJson
      )
    implicit lazy val io_k8s_api_apps_v1DeploymentSpecDecoder : Decoder[io.k8s.api.apps.v1.DeploymentSpec] = (c: HCursor) => for {
       minReadySeconds <- c.get[Option[Int]]("minReadySeconds")
       progressDeadlineSeconds <- c.get[Option[Int]]("progressDeadlineSeconds")
       replicas <- c.get[Option[Int]]("replicas")
       revisionHistoryLimit <- c.get[Option[Int]]("revisionHistoryLimit")
       paused <- c.get[Option[Boolean]]("paused")
       strategy <- c.get[Option[io.k8s.api.apps.v1.DeploymentStrategy]]("strategy")
       template <- c.get[io.k8s.api.core.v1.PodTemplateSpec]("template")
       selector <- c.get[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]("selector")
    } yield io.k8s.api.apps.v1.DeploymentSpec(
      minReadySeconds = minReadySeconds,
      progressDeadlineSeconds = progressDeadlineSeconds,
      replicas = replicas,
      revisionHistoryLimit = revisionHistoryLimit,
      paused = paused,
      strategy = strategy,
      template = template,
      selector = selector
    )

    implicit lazy val io_k8s_api_autoscaling_v2ResourceMetricSourceEncoder : Encoder[io.k8s.api.autoscaling.v2.ResourceMetricSource] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "target" -> o.target.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2ResourceMetricSourceDecoder : Decoder[io.k8s.api.autoscaling.v2.ResourceMetricSource] = (c: HCursor) => for {
       name <- c.get[String]("name")
       target <- c.get[io.k8s.api.autoscaling.v2.MetricTarget]("target")
    } yield io.k8s.api.autoscaling.v2.ResourceMetricSource(
      name = name,
      target = target
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2ContainerResourceMetricSourceEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.ContainerResourceMetricSource] = o =>
      Json.obj(
        "container" -> o.container.asJson,
      "name" -> o.name.asJson,
      "target" -> o.target.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2ContainerResourceMetricSourceDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.ContainerResourceMetricSource] = (c: HCursor) => for {
       container <- c.get[String]("container")
       name <- c.get[String]("name")
       target <- c.get[io.k8s.api.autoscaling.v2beta2.MetricTarget]("target")
    } yield io.k8s.api.autoscaling.v2beta2.ContainerResourceMetricSource(
      container = container,
      name = name,
      target = target
    )

    implicit lazy val io_k8s_api_authentication_v1TokenReviewStatusEncoder : Encoder[io.k8s.api.authentication.v1.TokenReviewStatus] = o =>
      Json.obj(
        "audiences" -> o.audiences.asJson,
      "authenticated" -> o.authenticated.asJson,
      "error" -> o.error.asJson,
      "user" -> o.user.asJson
      )
    implicit lazy val io_k8s_api_authentication_v1TokenReviewStatusDecoder : Decoder[io.k8s.api.authentication.v1.TokenReviewStatus] = (c: HCursor) => for {
       audiences <- c.get[Option[Seq[String]]]("audiences")
       authenticated <- c.get[Option[Boolean]]("authenticated")
       error <- c.get[Option[String]]("error")
       user <- c.get[Option[io.k8s.api.authentication.v1.UserInfo]]("user")
    } yield io.k8s.api.authentication.v1.TokenReviewStatus(
      audiences = audiences,
      authenticated = authenticated,
      error = error,
      user = user
    )

    implicit lazy val io_k8s_kube_aggregator_pkg_apis_apiregistration_v1APIServiceConditionEncoder : Encoder[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceCondition] = o =>
      Json.obj(
        "reason" -> o.reason.asJson,
      "status" -> o.status.asJson,
      "lastTransitionTime" -> o.lastTransitionTime.asJson,
      "message" -> o.message.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_kube_aggregator_pkg_apis_apiregistration_v1APIServiceConditionDecoder : Decoder[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceCondition] = (c: HCursor) => for {
       reason <- c.get[Option[String]]("reason")
       status <- c.get[String]("status")
       lastTransitionTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastTransitionTime")
       message <- c.get[Option[String]]("message")
       `type` <- c.get[String]("type")
    } yield io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceCondition(
      reason = reason,
      status = status,
      lastTransitionTime = lastTransitionTime,
      message = message,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_admissionregistration_v1MutatingWebhookEncoder : Encoder[io.k8s.api.admissionregistration.v1.MutatingWebhook] = o =>
      Json.obj(
        "timeoutSeconds" -> o.timeoutSeconds.asJson,
      "name" -> o.name.asJson,
      "matchPolicy" -> o.matchPolicy.asJson,
      "namespaceSelector" -> o.namespaceSelector.asJson,
      "sideEffects" -> o.sideEffects.asJson,
      "clientConfig" -> o.clientConfig.asJson,
      "failurePolicy" -> o.failurePolicy.asJson,
      "reinvocationPolicy" -> o.reinvocationPolicy.asJson,
      "rules" -> o.rules.asJson,
      "admissionReviewVersions" -> o.admissionReviewVersions.asJson,
      "objectSelector" -> o.objectSelector.asJson
      )
    implicit lazy val io_k8s_api_admissionregistration_v1MutatingWebhookDecoder : Decoder[io.k8s.api.admissionregistration.v1.MutatingWebhook] = (c: HCursor) => for {
       timeoutSeconds <- c.get[Option[Int]]("timeoutSeconds")
       name <- c.get[String]("name")
       matchPolicy <- c.get[Option[String]]("matchPolicy")
       namespaceSelector <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]]("namespaceSelector")
       sideEffects <- c.get[String]("sideEffects")
       clientConfig <- c.get[io.k8s.api.admissionregistration.v1.WebhookClientConfig]("clientConfig")
       failurePolicy <- c.get[Option[String]]("failurePolicy")
       reinvocationPolicy <- c.get[Option[String]]("reinvocationPolicy")
       rules <- c.get[Option[Seq[io.k8s.api.admissionregistration.v1.RuleWithOperations]]]("rules")
       admissionReviewVersions <- c.get[Seq[String]]("admissionReviewVersions")
       objectSelector <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]]("objectSelector")
    } yield io.k8s.api.admissionregistration.v1.MutatingWebhook(
      timeoutSeconds = timeoutSeconds,
      name = name,
      matchPolicy = matchPolicy,
      namespaceSelector = namespaceSelector,
      sideEffects = sideEffects,
      clientConfig = clientConfig,
      failurePolicy = failurePolicy,
      reinvocationPolicy = reinvocationPolicy,
      rules = rules,
      admissionReviewVersions = admissionReviewVersions,
      objectSelector = objectSelector
    )

    implicit lazy val io_k8s_api_core_v1EnvVarSourceEncoder : Encoder[io.k8s.api.core.v1.EnvVarSource] = o =>
      Json.obj(
        "configMapKeyRef" -> o.configMapKeyRef.asJson,
      "fieldRef" -> o.fieldRef.asJson,
      "resourceFieldRef" -> o.resourceFieldRef.asJson,
      "secretKeyRef" -> o.secretKeyRef.asJson
      )
    implicit lazy val io_k8s_api_core_v1EnvVarSourceDecoder : Decoder[io.k8s.api.core.v1.EnvVarSource] = (c: HCursor) => for {
       configMapKeyRef <- c.get[Option[io.k8s.api.core.v1.ConfigMapKeySelector]]("configMapKeyRef")
       fieldRef <- c.get[Option[io.k8s.api.core.v1.ObjectFieldSelector]]("fieldRef")
       resourceFieldRef <- c.get[Option[io.k8s.api.core.v1.ResourceFieldSelector]]("resourceFieldRef")
       secretKeyRef <- c.get[Option[io.k8s.api.core.v1.SecretKeySelector]]("secretKeyRef")
    } yield io.k8s.api.core.v1.EnvVarSource(
      configMapKeyRef = configMapKeyRef,
      fieldRef = fieldRef,
      resourceFieldRef = resourceFieldRef,
      secretKeyRef = secretKeyRef
    )

    implicit lazy val io_k8s_api_certificates_v1CertificateSigningRequestConditionEncoder : Encoder[io.k8s.api.certificates.v1.CertificateSigningRequestCondition] = o =>
      Json.obj(
        "lastUpdateTime" -> o.lastUpdateTime.asJson,
      "reason" -> o.reason.asJson,
      "status" -> o.status.asJson,
      "lastTransitionTime" -> o.lastTransitionTime.asJson,
      "message" -> o.message.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_certificates_v1CertificateSigningRequestConditionDecoder : Decoder[io.k8s.api.certificates.v1.CertificateSigningRequestCondition] = (c: HCursor) => for {
       lastUpdateTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastUpdateTime")
       reason <- c.get[Option[String]]("reason")
       status <- c.get[String]("status")
       lastTransitionTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastTransitionTime")
       message <- c.get[Option[String]]("message")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.certificates.v1.CertificateSigningRequestCondition(
      lastUpdateTime = lastUpdateTime,
      reason = reason,
      status = status,
      lastTransitionTime = lastTransitionTime,
      message = message,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_core_v1FlockerVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.FlockerVolumeSource] = o =>
      Json.obj(
        "datasetName" -> o.datasetName.asJson,
      "datasetUUID" -> o.datasetUUID.asJson
      )
    implicit lazy val io_k8s_api_core_v1FlockerVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.FlockerVolumeSource] = (c: HCursor) => for {
       datasetName <- c.get[Option[String]]("datasetName")
       datasetUUID <- c.get[Option[String]]("datasetUUID")
    } yield io.k8s.api.core.v1.FlockerVolumeSource(
      datasetName = datasetName,
      datasetUUID = datasetUUID
    )

    implicit lazy val io_k8s_api_core_v1ScopedResourceSelectorRequirementEncoder : Encoder[io.k8s.api.core.v1.ScopedResourceSelectorRequirement] = o =>
      Json.obj(
        "operator" -> o.operator.asJson,
      "scopeName" -> o.scopeName.asJson,
      "values" -> o.values.asJson
      )
    implicit lazy val io_k8s_api_core_v1ScopedResourceSelectorRequirementDecoder : Decoder[io.k8s.api.core.v1.ScopedResourceSelectorRequirement] = (c: HCursor) => for {
       operator <- c.get[String]("operator")
       scopeName <- c.get[String]("scopeName")
       values <- c.get[Option[Seq[String]]]("values")
    } yield io.k8s.api.core.v1.ScopedResourceSelectorRequirement(
      operator = operator,
      scopeName = scopeName,
      values = values
    )

    implicit lazy val io_k8s_api_core_v1NodeConfigSourceEncoder : Encoder[io.k8s.api.core.v1.NodeConfigSource] = o =>
      Json.obj(
        "configMap" -> o.configMap.asJson
      )
    implicit lazy val io_k8s_api_core_v1NodeConfigSourceDecoder : Decoder[io.k8s.api.core.v1.NodeConfigSource] = (c: HCursor) => for {
       configMap <- c.get[Option[io.k8s.api.core.v1.ConfigMapNodeConfigSource]]("configMap")
    } yield io.k8s.api.core.v1.NodeConfigSource(
      configMap = configMap
    )

    implicit lazy val io_k8s_api_core_v1NamespaceConditionEncoder : Encoder[io.k8s.api.core.v1.NamespaceCondition] = o =>
      Json.obj(
        "reason" -> o.reason.asJson,
      "status" -> o.status.asJson,
      "lastTransitionTime" -> o.lastTransitionTime.asJson,
      "message" -> o.message.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_core_v1NamespaceConditionDecoder : Decoder[io.k8s.api.core.v1.NamespaceCondition] = (c: HCursor) => for {
       reason <- c.get[Option[String]]("reason")
       status <- c.get[String]("status")
       lastTransitionTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastTransitionTime")
       message <- c.get[Option[String]]("message")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.core.v1.NamespaceCondition(
      reason = reason,
      status = status,
      lastTransitionTime = lastTransitionTime,
      message = message,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta2PriorityLevelConfigurationConditionEncoder : Encoder[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationCondition] = o =>
      Json.obj(
        "reason" -> o.reason.asJson,
      "status" -> o.status.asJson,
      "lastTransitionTime" -> o.lastTransitionTime.asJson,
      "message" -> o.message.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta2PriorityLevelConfigurationConditionDecoder : Decoder[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationCondition] = (c: HCursor) => for {
       reason <- c.get[Option[String]]("reason")
       status <- c.get[Option[String]]("status")
       lastTransitionTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastTransitionTime")
       message <- c.get[Option[String]]("message")
       `type` <- c.get[Option[String]]("type")
    } yield io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationCondition(
      reason = reason,
      status = status,
      lastTransitionTime = lastTransitionTime,
      message = message,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_core_v1NodeSelectorTermEncoder : Encoder[io.k8s.api.core.v1.NodeSelectorTerm] = o =>
      Json.obj(
        "matchExpressions" -> o.matchExpressions.asJson,
      "matchFields" -> o.matchFields.asJson
      )
    implicit lazy val io_k8s_api_core_v1NodeSelectorTermDecoder : Decoder[io.k8s.api.core.v1.NodeSelectorTerm] = (c: HCursor) => for {
       matchExpressions <- c.get[Option[Seq[io.k8s.api.core.v1.NodeSelectorRequirement]]]("matchExpressions")
       matchFields <- c.get[Option[Seq[io.k8s.api.core.v1.NodeSelectorRequirement]]]("matchFields")
    } yield io.k8s.api.core.v1.NodeSelectorTerm(
      matchExpressions = matchExpressions,
      matchFields = matchFields
    )

    implicit lazy val io_k8s_api_core_v1PortStatusEncoder : Encoder[io.k8s.api.core.v1.PortStatus] = o =>
      Json.obj(
        "error" -> o.error.asJson,
      "port" -> o.port.asJson,
      "protocol" -> o.protocol.asJson
      )
    implicit lazy val io_k8s_api_core_v1PortStatusDecoder : Decoder[io.k8s.api.core.v1.PortStatus] = (c: HCursor) => for {
       error <- c.get[Option[String]]("error")
       port <- c.get[Int]("port")
       protocol <- c.get[String]("protocol")
    } yield io.k8s.api.core.v1.PortStatus(
      error = error,
      port = port,
      protocol = protocol
    )

    implicit lazy val io_k8s_api_core_v1PodDNSConfigEncoder : Encoder[io.k8s.api.core.v1.PodDNSConfig] = o =>
      Json.obj(
        "nameservers" -> o.nameservers.asJson,
      "options" -> o.options.asJson,
      "searches" -> o.searches.asJson
      )
    implicit lazy val io_k8s_api_core_v1PodDNSConfigDecoder : Decoder[io.k8s.api.core.v1.PodDNSConfig] = (c: HCursor) => for {
       nameservers <- c.get[Option[Seq[String]]]("nameservers")
       options <- c.get[Option[Seq[io.k8s.api.core.v1.PodDNSConfigOption]]]("options")
       searches <- c.get[Option[Seq[String]]]("searches")
    } yield io.k8s.api.core.v1.PodDNSConfig(
      nameservers = nameservers,
      options = options,
      searches = searches
    )

    implicit lazy val io_k8s_api_networking_v1IngressSpecEncoder : Encoder[io.k8s.api.networking.v1.IngressSpec] = o =>
      Json.obj(
        "defaultBackend" -> o.defaultBackend.asJson,
      "ingressClassName" -> o.ingressClassName.asJson,
      "rules" -> o.rules.asJson,
      "tls" -> o.tls.asJson
      )
    implicit lazy val io_k8s_api_networking_v1IngressSpecDecoder : Decoder[io.k8s.api.networking.v1.IngressSpec] = (c: HCursor) => for {
       defaultBackend <- c.get[Option[io.k8s.api.networking.v1.IngressBackend]]("defaultBackend")
       ingressClassName <- c.get[Option[String]]("ingressClassName")
       rules <- c.get[Option[Seq[io.k8s.api.networking.v1.IngressRule]]]("rules")
       tls <- c.get[Option[Seq[io.k8s.api.networking.v1.IngressTLS]]]("tls")
    } yield io.k8s.api.networking.v1.IngressSpec(
      defaultBackend = defaultBackend,
      ingressClassName = ingressClassName,
      rules = rules,
      tls = tls
    )

    implicit lazy val io_k8s_api_apps_v1StatefulSetSpecEncoder : Encoder[io.k8s.api.apps.v1.StatefulSetSpec] = o =>
      Json.obj(
        "minReadySeconds" -> o.minReadySeconds.asJson,
      "serviceName" -> o.serviceName.asJson,
      "replicas" -> o.replicas.asJson,
      "revisionHistoryLimit" -> o.revisionHistoryLimit.asJson,
      "podManagementPolicy" -> o.podManagementPolicy.asJson,
      "volumeClaimTemplates" -> o.volumeClaimTemplates.asJson,
      "persistentVolumeClaimRetentionPolicy" -> o.persistentVolumeClaimRetentionPolicy.asJson,
      "template" -> o.template.asJson,
      "selector" -> o.selector.asJson,
      "updateStrategy" -> o.updateStrategy.asJson
      )
    implicit lazy val io_k8s_api_apps_v1StatefulSetSpecDecoder : Decoder[io.k8s.api.apps.v1.StatefulSetSpec] = (c: HCursor) => for {
       minReadySeconds <- c.get[Option[Int]]("minReadySeconds")
       serviceName <- c.get[String]("serviceName")
       replicas <- c.get[Option[Int]]("replicas")
       revisionHistoryLimit <- c.get[Option[Int]]("revisionHistoryLimit")
       podManagementPolicy <- c.get[Option[String]]("podManagementPolicy")
       volumeClaimTemplates <- c.get[Option[Seq[io.k8s.api.core.v1.PersistentVolumeClaim]]]("volumeClaimTemplates")
       persistentVolumeClaimRetentionPolicy <- c.get[Option[io.k8s.api.apps.v1.StatefulSetPersistentVolumeClaimRetentionPolicy]]("persistentVolumeClaimRetentionPolicy")
       template <- c.get[io.k8s.api.core.v1.PodTemplateSpec]("template")
       selector <- c.get[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]("selector")
       updateStrategy <- c.get[Option[io.k8s.api.apps.v1.StatefulSetUpdateStrategy]]("updateStrategy")
    } yield io.k8s.api.apps.v1.StatefulSetSpec(
      minReadySeconds = minReadySeconds,
      serviceName = serviceName,
      replicas = replicas,
      revisionHistoryLimit = revisionHistoryLimit,
      podManagementPolicy = podManagementPolicy,
      volumeClaimTemplates = volumeClaimTemplates,
      persistentVolumeClaimRetentionPolicy = persistentVolumeClaimRetentionPolicy,
      template = template,
      selector = selector,
      updateStrategy = updateStrategy
    )

    implicit lazy val io_k8s_api_rbac_v1RoleRefEncoder : Encoder[io.k8s.api.rbac.v1.RoleRef] = o =>
      Json.obj(
        "apiGroup" -> o.apiGroup.asJson,
      "name" -> o.name.asJson
      )
    implicit lazy val io_k8s_api_rbac_v1RoleRefDecoder : Decoder[io.k8s.api.rbac.v1.RoleRef] = (c: HCursor) => for {
       apiGroup <- c.get[String]("apiGroup")
       name <- c.get[String]("name")
    } yield io.k8s.api.rbac.v1.RoleRef(
      apiGroup = apiGroup,
      name = name
    )

    implicit lazy val io_k8s_api_core_v1ObjectFieldSelectorEncoder : Encoder[io.k8s.api.core.v1.ObjectFieldSelector] = o =>
      Json.obj(
        "fieldPath" -> o.fieldPath.asJson
      )
    implicit lazy val io_k8s_api_core_v1ObjectFieldSelectorDecoder : Decoder[io.k8s.api.core.v1.ObjectFieldSelector] = (c: HCursor) => for {
       fieldPath <- c.get[String]("fieldPath")
    } yield io.k8s.api.core.v1.ObjectFieldSelector(
      fieldPath = fieldPath
    )

    implicit lazy val io_k8s_api_core_v1NamespaceSpecEncoder : Encoder[io.k8s.api.core.v1.NamespaceSpec] = o =>
      Json.obj(
        "finalizers" -> o.finalizers.asJson
      )
    implicit lazy val io_k8s_api_core_v1NamespaceSpecDecoder : Decoder[io.k8s.api.core.v1.NamespaceSpec] = (c: HCursor) => for {
       finalizers <- c.get[Option[Seq[String]]]("finalizers")
    } yield io.k8s.api.core.v1.NamespaceSpec(
      finalizers = finalizers
    )

    implicit lazy val io_k8s_api_storage_v1VolumeNodeResourcesEncoder : Encoder[io.k8s.api.storage.v1.VolumeNodeResources] = o =>
      Json.obj(
        "count" -> o.count.asJson
      )
    implicit lazy val io_k8s_api_storage_v1VolumeNodeResourcesDecoder : Decoder[io.k8s.api.storage.v1.VolumeNodeResources] = (c: HCursor) => for {
       count <- c.get[Option[Int]]("count")
    } yield io.k8s.api.storage.v1.VolumeNodeResources(
      count = count
    )

    implicit lazy val io_k8s_api_core_v1CephFSVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.CephFSVolumeSource] = o =>
      Json.obj(
        "path" -> o.path.asJson,
      "readOnly" -> o.readOnly.asJson,
      "secretRef" -> o.secretRef.asJson,
      "secretFile" -> o.secretFile.asJson,
      "monitors" -> o.monitors.asJson,
      "user" -> o.user.asJson
      )
    implicit lazy val io_k8s_api_core_v1CephFSVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.CephFSVolumeSource] = (c: HCursor) => for {
       path <- c.get[Option[String]]("path")
       readOnly <- c.get[Option[Boolean]]("readOnly")
       secretRef <- c.get[Option[io.k8s.api.core.v1.LocalObjectReference]]("secretRef")
       secretFile <- c.get[Option[String]]("secretFile")
       monitors <- c.get[Seq[String]]("monitors")
       user <- c.get[Option[String]]("user")
    } yield io.k8s.api.core.v1.CephFSVolumeSource(
      path = path,
      readOnly = readOnly,
      secretRef = secretRef,
      secretFile = secretFile,
      monitors = monitors,
      user = user
    )

    implicit lazy val io_k8s_api_admissionregistration_v1ValidatingWebhookEncoder : Encoder[io.k8s.api.admissionregistration.v1.ValidatingWebhook] = o =>
      Json.obj(
        "timeoutSeconds" -> o.timeoutSeconds.asJson,
      "name" -> o.name.asJson,
      "matchPolicy" -> o.matchPolicy.asJson,
      "namespaceSelector" -> o.namespaceSelector.asJson,
      "sideEffects" -> o.sideEffects.asJson,
      "clientConfig" -> o.clientConfig.asJson,
      "failurePolicy" -> o.failurePolicy.asJson,
      "rules" -> o.rules.asJson,
      "admissionReviewVersions" -> o.admissionReviewVersions.asJson,
      "objectSelector" -> o.objectSelector.asJson
      )
    implicit lazy val io_k8s_api_admissionregistration_v1ValidatingWebhookDecoder : Decoder[io.k8s.api.admissionregistration.v1.ValidatingWebhook] = (c: HCursor) => for {
       timeoutSeconds <- c.get[Option[Int]]("timeoutSeconds")
       name <- c.get[String]("name")
       matchPolicy <- c.get[Option[String]]("matchPolicy")
       namespaceSelector <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]]("namespaceSelector")
       sideEffects <- c.get[String]("sideEffects")
       clientConfig <- c.get[io.k8s.api.admissionregistration.v1.WebhookClientConfig]("clientConfig")
       failurePolicy <- c.get[Option[String]]("failurePolicy")
       rules <- c.get[Option[Seq[io.k8s.api.admissionregistration.v1.RuleWithOperations]]]("rules")
       admissionReviewVersions <- c.get[Seq[String]]("admissionReviewVersions")
       objectSelector <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]]("objectSelector")
    } yield io.k8s.api.admissionregistration.v1.ValidatingWebhook(
      timeoutSeconds = timeoutSeconds,
      name = name,
      matchPolicy = matchPolicy,
      namespaceSelector = namespaceSelector,
      sideEffects = sideEffects,
      clientConfig = clientConfig,
      failurePolicy = failurePolicy,
      rules = rules,
      admissionReviewVersions = admissionReviewVersions,
      objectSelector = objectSelector
    )

    implicit lazy val io_k8s_api_networking_v1NetworkPolicyPeerEncoder : Encoder[io.k8s.api.networking.v1.NetworkPolicyPeer] = o =>
      Json.obj(
        "ipBlock" -> o.ipBlock.asJson,
      "namespaceSelector" -> o.namespaceSelector.asJson,
      "podSelector" -> o.podSelector.asJson
      )
    implicit lazy val io_k8s_api_networking_v1NetworkPolicyPeerDecoder : Decoder[io.k8s.api.networking.v1.NetworkPolicyPeer] = (c: HCursor) => for {
       ipBlock <- c.get[Option[io.k8s.api.networking.v1.IPBlock]]("ipBlock")
       namespaceSelector <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]]("namespaceSelector")
       podSelector <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]]("podSelector")
    } yield io.k8s.api.networking.v1.NetworkPolicyPeer(
      ipBlock = ipBlock,
      namespaceSelector = namespaceSelector,
      podSelector = podSelector
    )

    implicit lazy val io_k8s_api_authentication_v1TokenReviewSpecEncoder : Encoder[io.k8s.api.authentication.v1.TokenReviewSpec] = o =>
      Json.obj(
        "audiences" -> o.audiences.asJson,
      "token" -> o.token.asJson
      )
    implicit lazy val io_k8s_api_authentication_v1TokenReviewSpecDecoder : Decoder[io.k8s.api.authentication.v1.TokenReviewSpec] = (c: HCursor) => for {
       audiences <- c.get[Option[Seq[String]]]("audiences")
       token <- c.get[Option[String]]("token")
    } yield io.k8s.api.authentication.v1.TokenReviewSpec(
      audiences = audiences,
      token = token
    )

    implicit lazy val io_k8s_api_core_v1SeccompProfileEncoder : Encoder[io.k8s.api.core.v1.SeccompProfile] = o =>
      Json.obj(
        "localhostProfile" -> o.localhostProfile.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_core_v1SeccompProfileDecoder : Decoder[io.k8s.api.core.v1.SeccompProfile] = (c: HCursor) => for {
       localhostProfile <- c.get[Option[String]]("localhostProfile")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.core.v1.SeccompProfile(
      localhostProfile = localhostProfile,
      `type` = `type`
    )

    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceDefinitionConditionEncoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionCondition] = o =>
      Json.obj(
        "reason" -> o.reason.asJson,
      "status" -> o.status.asJson,
      "lastTransitionTime" -> o.lastTransitionTime.asJson,
      "message" -> o.message.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceDefinitionConditionDecoder : Decoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionCondition] = (c: HCursor) => for {
       reason <- c.get[Option[String]]("reason")
       status <- c.get[String]("status")
       lastTransitionTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastTransitionTime")
       message <- c.get[Option[String]]("message")
       `type` <- c.get[String]("type")
    } yield io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionCondition(
      reason = reason,
      status = status,
      lastTransitionTime = lastTransitionTime,
      message = message,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_autoscaling_v2ExternalMetricStatusEncoder : Encoder[io.k8s.api.autoscaling.v2.ExternalMetricStatus] = o =>
      Json.obj(
        "current" -> o.current.asJson,
      "metric" -> o.metric.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2ExternalMetricStatusDecoder : Decoder[io.k8s.api.autoscaling.v2.ExternalMetricStatus] = (c: HCursor) => for {
       current <- c.get[io.k8s.api.autoscaling.v2.MetricValueStatus]("current")
       metric <- c.get[io.k8s.api.autoscaling.v2.MetricIdentifier]("metric")
    } yield io.k8s.api.autoscaling.v2.ExternalMetricStatus(
      current = current,
      metric = metric
    )

    implicit lazy val io_k8s_api_core_v1ResourceQuotaSpecEncoder : Encoder[io.k8s.api.core.v1.ResourceQuotaSpec] = o =>
      Json.obj(
        "hard" -> o.hard.asJson,
      "scopeSelector" -> o.scopeSelector.asJson,
      "scopes" -> o.scopes.asJson
      )
    implicit lazy val io_k8s_api_core_v1ResourceQuotaSpecDecoder : Decoder[io.k8s.api.core.v1.ResourceQuotaSpec] = (c: HCursor) => for {
       hard <- c.get[Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]]("hard")
       scopeSelector <- c.get[Option[io.k8s.api.core.v1.ScopeSelector]]("scopeSelector")
       scopes <- c.get[Option[Seq[String]]]("scopes")
    } yield io.k8s.api.core.v1.ResourceQuotaSpec(
      hard = hard,
      scopeSelector = scopeSelector,
      scopes = scopes
    )

    implicit lazy val io_k8s_api_autoscaling_v2PodsMetricStatusEncoder : Encoder[io.k8s.api.autoscaling.v2.PodsMetricStatus] = o =>
      Json.obj(
        "current" -> o.current.asJson,
      "metric" -> o.metric.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2PodsMetricStatusDecoder : Decoder[io.k8s.api.autoscaling.v2.PodsMetricStatus] = (c: HCursor) => for {
       current <- c.get[io.k8s.api.autoscaling.v2.MetricValueStatus]("current")
       metric <- c.get[io.k8s.api.autoscaling.v2.MetricIdentifier]("metric")
    } yield io.k8s.api.autoscaling.v2.PodsMetricStatus(
      current = current,
      metric = metric
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta1PriorityLevelConfigurationStatusEncoder : Encoder[io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationStatus] = o =>
      Json.obj(
        "conditions" -> o.conditions.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta1PriorityLevelConfigurationStatusDecoder : Decoder[io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationStatus] = (c: HCursor) => for {
       conditions <- c.get[Option[Seq[io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationCondition]]]("conditions")
    } yield io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationStatus(
      conditions = conditions
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta2PriorityLevelConfigurationReferenceEncoder : Encoder[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationReference] = o =>
      Json.obj(
        "name" -> o.name.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta2PriorityLevelConfigurationReferenceDecoder : Decoder[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationReference] = (c: HCursor) => for {
       name <- c.get[String]("name")
    } yield io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationReference(
      name = name
    )

    implicit lazy val io_k8s_api_core_v1PodAffinityTermEncoder : Encoder[io.k8s.api.core.v1.PodAffinityTerm] = o =>
      Json.obj(
        "labelSelector" -> o.labelSelector.asJson,
      "namespaceSelector" -> o.namespaceSelector.asJson,
      "namespaces" -> o.namespaces.asJson,
      "topologyKey" -> o.topologyKey.asJson
      )
    implicit lazy val io_k8s_api_core_v1PodAffinityTermDecoder : Decoder[io.k8s.api.core.v1.PodAffinityTerm] = (c: HCursor) => for {
       labelSelector <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]]("labelSelector")
       namespaceSelector <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]]("namespaceSelector")
       namespaces <- c.get[Option[Seq[String]]]("namespaces")
       topologyKey <- c.get[String]("topologyKey")
    } yield io.k8s.api.core.v1.PodAffinityTerm(
      labelSelector = labelSelector,
      namespaceSelector = namespaceSelector,
      namespaces = namespaces,
      topologyKey = topologyKey
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta1UserSubjectEncoder : Encoder[io.k8s.api.flowcontrol.v1beta1.UserSubject] = o =>
      Json.obj(
        "name" -> o.name.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta1UserSubjectDecoder : Decoder[io.k8s.api.flowcontrol.v1beta1.UserSubject] = (c: HCursor) => for {
       name <- c.get[String]("name")
    } yield io.k8s.api.flowcontrol.v1beta1.UserSubject(
      name = name
    )

    implicit lazy val io_k8s_api_admissionregistration_v1ServiceReferenceEncoder : Encoder[io.k8s.api.admissionregistration.v1.ServiceReference] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "namespace" -> o.namespace.asJson,
      "path" -> o.path.asJson,
      "port" -> o.port.asJson
      )
    implicit lazy val io_k8s_api_admissionregistration_v1ServiceReferenceDecoder : Decoder[io.k8s.api.admissionregistration.v1.ServiceReference] = (c: HCursor) => for {
       name <- c.get[String]("name")
       namespace <- c.get[String]("namespace")
       path <- c.get[Option[String]]("path")
       port <- c.get[Option[Int]]("port")
    } yield io.k8s.api.admissionregistration.v1.ServiceReference(
      name = name,
      namespace = namespace,
      path = path,
      port = port
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2CrossVersionObjectReferenceEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference] = o =>
      Json.obj(
        "name" -> o.name.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2CrossVersionObjectReferenceDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference] = (c: HCursor) => for {
       name <- c.get[String]("name")
    } yield io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference(
      name = name
    )

    implicit lazy val io_k8s_api_authorization_v1ResourceAttributesEncoder : Encoder[io.k8s.api.authorization.v1.ResourceAttributes] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "version" -> o.version.asJson,
      "resource" -> o.resource.asJson,
      "verb" -> o.verb.asJson,
      "group" -> o.group.asJson,
      "subresource" -> o.subresource.asJson,
      "namespace" -> o.namespace.asJson
      )
    implicit lazy val io_k8s_api_authorization_v1ResourceAttributesDecoder : Decoder[io.k8s.api.authorization.v1.ResourceAttributes] = (c: HCursor) => for {
       name <- c.get[Option[String]]("name")
       version <- c.get[Option[String]]("version")
       resource <- c.get[Option[String]]("resource")
       verb <- c.get[Option[String]]("verb")
       group <- c.get[Option[String]]("group")
       subresource <- c.get[Option[String]]("subresource")
       namespace <- c.get[Option[String]]("namespace")
    } yield io.k8s.api.authorization.v1.ResourceAttributes(
      name = name,
      version = version,
      resource = resource,
      verb = verb,
      group = group,
      subresource = subresource,
      namespace = namespace
    )

    implicit lazy val io_k8s_api_apps_v1DaemonSetUpdateStrategyEncoder : Encoder[io.k8s.api.apps.v1.DaemonSetUpdateStrategy] = o =>
      Json.obj(
        "rollingUpdate" -> o.rollingUpdate.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_apps_v1DaemonSetUpdateStrategyDecoder : Decoder[io.k8s.api.apps.v1.DaemonSetUpdateStrategy] = (c: HCursor) => for {
       rollingUpdate <- c.get[Option[io.k8s.api.apps.v1.RollingUpdateDaemonSet]]("rollingUpdate")
       `type` <- c.get[Option[String]]("type")
    } yield io.k8s.api.apps.v1.DaemonSetUpdateStrategy(
      rollingUpdate = rollingUpdate,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_autoscaling_v2ObjectMetricSourceEncoder : Encoder[io.k8s.api.autoscaling.v2.ObjectMetricSource] = o =>
      Json.obj(
        "describedObject" -> o.describedObject.asJson,
      "metric" -> o.metric.asJson,
      "target" -> o.target.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2ObjectMetricSourceDecoder : Decoder[io.k8s.api.autoscaling.v2.ObjectMetricSource] = (c: HCursor) => for {
       describedObject <- c.get[io.k8s.api.autoscaling.v2.CrossVersionObjectReference]("describedObject")
       metric <- c.get[io.k8s.api.autoscaling.v2.MetricIdentifier]("metric")
       target <- c.get[io.k8s.api.autoscaling.v2.MetricTarget]("target")
    } yield io.k8s.api.autoscaling.v2.ObjectMetricSource(
      describedObject = describedObject,
      metric = metric,
      target = target
    )

    implicit lazy val io_k8s_api_core_v1SysctlEncoder : Encoder[io.k8s.api.core.v1.Sysctl] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "value" -> o.value.asJson
      )
    implicit lazy val io_k8s_api_core_v1SysctlDecoder : Decoder[io.k8s.api.core.v1.Sysctl] = (c: HCursor) => for {
       name <- c.get[String]("name")
       value <- c.get[String]("value")
    } yield io.k8s.api.core.v1.Sysctl(
      name = name,
      value = value
    )

    implicit lazy val io_k8s_api_core_v1FCVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.FCVolumeSource] = o =>
      Json.obj(
        "targetWWNs" -> o.targetWWNs.asJson,
      "readOnly" -> o.readOnly.asJson,
      "fsType" -> o.fsType.asJson,
      "wwids" -> o.wwids.asJson,
      "lun" -> o.lun.asJson
      )
    implicit lazy val io_k8s_api_core_v1FCVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.FCVolumeSource] = (c: HCursor) => for {
       targetWWNs <- c.get[Option[Seq[String]]]("targetWWNs")
       readOnly <- c.get[Option[Boolean]]("readOnly")
       fsType <- c.get[Option[String]]("fsType")
       wwids <- c.get[Option[Seq[String]]]("wwids")
       lun <- c.get[Option[Int]]("lun")
    } yield io.k8s.api.core.v1.FCVolumeSource(
      targetWWNs = targetWWNs,
      readOnly = readOnly,
      fsType = fsType,
      wwids = wwids,
      lun = lun
    )

    implicit lazy val io_k8s_api_core_v1NamespaceStatusEncoder : Encoder[io.k8s.api.core.v1.NamespaceStatus] = o =>
      Json.obj(
        "conditions" -> o.conditions.asJson,
      "phase" -> o.phase.asJson
      )
    implicit lazy val io_k8s_api_core_v1NamespaceStatusDecoder : Decoder[io.k8s.api.core.v1.NamespaceStatus] = (c: HCursor) => for {
       conditions <- c.get[Option[Seq[io.k8s.api.core.v1.NamespaceCondition]]]("conditions")
       phase <- c.get[Option[String]]("phase")
    } yield io.k8s.api.core.v1.NamespaceStatus(
      conditions = conditions,
      phase = phase
    )

    implicit lazy val io_k8s_api_core_v1PodTemplateSpecEncoder : Encoder[io.k8s.api.core.v1.PodTemplateSpec] = o =>
      Json.obj(
        "metadata" -> o.metadata.asJson,
      "spec" -> o.spec.asJson
      )
    implicit lazy val io_k8s_api_core_v1PodTemplateSpecDecoder : Decoder[io.k8s.api.core.v1.PodTemplateSpec] = (c: HCursor) => for {
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
       spec <- c.get[Option[io.k8s.api.core.v1.PodSpec]]("spec")
    } yield io.k8s.api.core.v1.PodTemplateSpec(
      metadata = metadata,
      spec = spec
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta1ResourcePolicyRuleEncoder : Encoder[io.k8s.api.flowcontrol.v1beta1.ResourcePolicyRule] = o =>
      Json.obj(
        "clusterScope" -> o.clusterScope.asJson,
      "verbs" -> o.verbs.asJson,
      "apiGroups" -> o.apiGroups.asJson,
      "namespaces" -> o.namespaces.asJson,
      "resources" -> o.resources.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta1ResourcePolicyRuleDecoder : Decoder[io.k8s.api.flowcontrol.v1beta1.ResourcePolicyRule] = (c: HCursor) => for {
       clusterScope <- c.get[Option[Boolean]]("clusterScope")
       verbs <- c.get[Seq[String]]("verbs")
       apiGroups <- c.get[Seq[String]]("apiGroups")
       namespaces <- c.get[Option[Seq[String]]]("namespaces")
       resources <- c.get[Seq[String]]("resources")
    } yield io.k8s.api.flowcontrol.v1beta1.ResourcePolicyRule(
      clusterScope = clusterScope,
      verbs = verbs,
      apiGroups = apiGroups,
      namespaces = namespaces,
      resources = resources
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2PodsMetricStatusEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.PodsMetricStatus] = o =>
      Json.obj(
        "current" -> o.current.asJson,
      "metric" -> o.metric.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2PodsMetricStatusDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.PodsMetricStatus] = (c: HCursor) => for {
       current <- c.get[io.k8s.api.autoscaling.v2beta2.MetricValueStatus]("current")
       metric <- c.get[io.k8s.api.autoscaling.v2beta2.MetricIdentifier]("metric")
    } yield io.k8s.api.autoscaling.v2beta2.PodsMetricStatus(
      current = current,
      metric = metric
    )

    implicit lazy val io_k8s_api_core_v1ServiceAccountTokenProjectionEncoder : Encoder[io.k8s.api.core.v1.ServiceAccountTokenProjection] = o =>
      Json.obj(
        "audience" -> o.audience.asJson,
      "expirationSeconds" -> o.expirationSeconds.asJson,
      "path" -> o.path.asJson
      )
    implicit lazy val io_k8s_api_core_v1ServiceAccountTokenProjectionDecoder : Decoder[io.k8s.api.core.v1.ServiceAccountTokenProjection] = (c: HCursor) => for {
       audience <- c.get[Option[String]]("audience")
       expirationSeconds <- c.get[Option[Int]]("expirationSeconds")
       path <- c.get[String]("path")
    } yield io.k8s.api.core.v1.ServiceAccountTokenProjection(
      audience = audience,
      expirationSeconds = expirationSeconds,
      path = path
    )

    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1GroupVersionForDiscoveryEncoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery] = o =>
      Json.obj(
        "groupVersion" -> o.groupVersion.asJson,
      "version" -> o.version.asJson
      )
    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1GroupVersionForDiscoveryDecoder : Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery] = (c: HCursor) => for {
       groupVersion <- c.get[String]("groupVersion")
       version <- c.get[String]("version")
    } yield io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery(
      groupVersion = groupVersion,
      version = version
    )

    implicit lazy val io_k8s_api_core_v1CapabilitiesEncoder : Encoder[io.k8s.api.core.v1.Capabilities] = o =>
      Json.obj(
        "add" -> o.add.asJson,
      "drop" -> o.drop.asJson
      )
    implicit lazy val io_k8s_api_core_v1CapabilitiesDecoder : Decoder[io.k8s.api.core.v1.Capabilities] = (c: HCursor) => for {
       add <- c.get[Option[Seq[String]]]("add")
       drop <- c.get[Option[Seq[String]]]("drop")
    } yield io.k8s.api.core.v1.Capabilities(
      add = add,
      drop = drop
    )

    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1WatchEventEncoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.WatchEvent] = o =>
      Json.obj(
        "object" -> o.`object`.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1WatchEventDecoder : Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.WatchEvent] = (c: HCursor) => for {
       `object` <- c.get[io.k8s.apimachinery.pkg.runtime.RawExtension]("object")
       `type` <- c.get[String]("type")
    } yield io.k8s.apimachinery.pkg.apis.meta.v1.WatchEvent(
      `object` = `object`,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_admissionregistration_v1RuleWithOperationsEncoder : Encoder[io.k8s.api.admissionregistration.v1.RuleWithOperations] = o =>
      Json.obj(
        "operations" -> o.operations.asJson,
      "apiVersions" -> o.apiVersions.asJson,
      "scope" -> o.scope.asJson,
      "apiGroups" -> o.apiGroups.asJson,
      "resources" -> o.resources.asJson
      )
    implicit lazy val io_k8s_api_admissionregistration_v1RuleWithOperationsDecoder : Decoder[io.k8s.api.admissionregistration.v1.RuleWithOperations] = (c: HCursor) => for {
       operations <- c.get[Option[Seq[String]]]("operations")
       apiVersions <- c.get[Option[Seq[String]]]("apiVersions")
       scope <- c.get[Option[String]]("scope")
       apiGroups <- c.get[Option[Seq[String]]]("apiGroups")
       resources <- c.get[Option[Seq[String]]]("resources")
    } yield io.k8s.api.admissionregistration.v1.RuleWithOperations(
      operations = operations,
      apiVersions = apiVersions,
      scope = scope,
      apiGroups = apiGroups,
      resources = resources
    )

    implicit lazy val io_k8s_api_autoscaling_v2ResourceMetricStatusEncoder : Encoder[io.k8s.api.autoscaling.v2.ResourceMetricStatus] = o =>
      Json.obj(
        "current" -> o.current.asJson,
      "name" -> o.name.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2ResourceMetricStatusDecoder : Decoder[io.k8s.api.autoscaling.v2.ResourceMetricStatus] = (c: HCursor) => for {
       current <- c.get[io.k8s.api.autoscaling.v2.MetricValueStatus]("current")
       name <- c.get[String]("name")
    } yield io.k8s.api.autoscaling.v2.ResourceMetricStatus(
      current = current,
      name = name
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta1GroupSubjectEncoder : Encoder[io.k8s.api.flowcontrol.v1beta1.GroupSubject] = o =>
      Json.obj(
        "name" -> o.name.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta1GroupSubjectDecoder : Decoder[io.k8s.api.flowcontrol.v1beta1.GroupSubject] = (c: HCursor) => for {
       name <- c.get[String]("name")
    } yield io.k8s.api.flowcontrol.v1beta1.GroupSubject(
      name = name
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta2ServiceAccountSubjectEncoder : Encoder[io.k8s.api.flowcontrol.v1beta2.ServiceAccountSubject] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "namespace" -> o.namespace.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta2ServiceAccountSubjectDecoder : Decoder[io.k8s.api.flowcontrol.v1beta2.ServiceAccountSubject] = (c: HCursor) => for {
       name <- c.get[String]("name")
       namespace <- c.get[String]("namespace")
    } yield io.k8s.api.flowcontrol.v1beta2.ServiceAccountSubject(
      name = name,
      namespace = namespace
    )

    implicit lazy val io_k8s_api_core_v1FlexPersistentVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.FlexPersistentVolumeSource] = o =>
      Json.obj(
        "readOnly" -> o.readOnly.asJson,
      "fsType" -> o.fsType.asJson,
      "secretRef" -> o.secretRef.asJson,
      "options" -> o.options.asJson,
      "driver" -> o.driver.asJson
      )
    implicit lazy val io_k8s_api_core_v1FlexPersistentVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.FlexPersistentVolumeSource] = (c: HCursor) => for {
       readOnly <- c.get[Option[Boolean]]("readOnly")
       fsType <- c.get[Option[String]]("fsType")
       secretRef <- c.get[Option[io.k8s.api.core.v1.SecretReference]]("secretRef")
       options <- c.get[Option[Map[String, String]]]("options")
       driver <- c.get[String]("driver")
    } yield io.k8s.api.core.v1.FlexPersistentVolumeSource(
      readOnly = readOnly,
      fsType = fsType,
      secretRef = secretRef,
      options = options,
      driver = driver
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2HPAScalingRulesEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.HPAScalingRules] = o =>
      Json.obj(
        "policies" -> o.policies.asJson,
      "selectPolicy" -> o.selectPolicy.asJson,
      "stabilizationWindowSeconds" -> o.stabilizationWindowSeconds.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2HPAScalingRulesDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.HPAScalingRules] = (c: HCursor) => for {
       policies <- c.get[Option[Seq[io.k8s.api.autoscaling.v2beta2.HPAScalingPolicy]]]("policies")
       selectPolicy <- c.get[Option[String]]("selectPolicy")
       stabilizationWindowSeconds <- c.get[Option[Int]]("stabilizationWindowSeconds")
    } yield io.k8s.api.autoscaling.v2beta2.HPAScalingRules(
      policies = policies,
      selectPolicy = selectPolicy,
      stabilizationWindowSeconds = stabilizationWindowSeconds
    )

    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1LabelSelectorEncoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = o =>
      Json.obj(
        "matchExpressions" -> o.matchExpressions.asJson,
      "matchLabels" -> o.matchLabels.asJson
      )
    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1LabelSelectorDecoder : Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = (c: HCursor) => for {
       matchExpressions <- c.get[Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement]]]("matchExpressions")
       matchLabels <- c.get[Option[Map[String, String]]]("matchLabels")
    } yield io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector(
      matchExpressions = matchExpressions,
      matchLabels = matchLabels
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta1FlowSchemaStatusEncoder : Encoder[io.k8s.api.flowcontrol.v1beta1.FlowSchemaStatus] = o =>
      Json.obj(
        "conditions" -> o.conditions.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta1FlowSchemaStatusDecoder : Decoder[io.k8s.api.flowcontrol.v1beta1.FlowSchemaStatus] = (c: HCursor) => for {
       conditions <- c.get[Option[Seq[io.k8s.api.flowcontrol.v1beta1.FlowSchemaCondition]]]("conditions")
    } yield io.k8s.api.flowcontrol.v1beta1.FlowSchemaStatus(
      conditions = conditions
    )

    implicit lazy val io_k8s_api_storage_v1CSIDriverSpecEncoder : Encoder[io.k8s.api.storage.v1.CSIDriverSpec] = o =>
      Json.obj(
        "volumeLifecycleModes" -> o.volumeLifecycleModes.asJson,
      "podInfoOnMount" -> o.podInfoOnMount.asJson,
      "attachRequired" -> o.attachRequired.asJson,
      "requiresRepublish" -> o.requiresRepublish.asJson,
      "fsGroupPolicy" -> o.fsGroupPolicy.asJson,
      "storageCapacity" -> o.storageCapacity.asJson,
      "tokenRequests" -> o.tokenRequests.asJson,
      "seLinuxMount" -> o.seLinuxMount.asJson
      )
    implicit lazy val io_k8s_api_storage_v1CSIDriverSpecDecoder : Decoder[io.k8s.api.storage.v1.CSIDriverSpec] = (c: HCursor) => for {
       volumeLifecycleModes <- c.get[Option[Seq[String]]]("volumeLifecycleModes")
       podInfoOnMount <- c.get[Option[Boolean]]("podInfoOnMount")
       attachRequired <- c.get[Option[Boolean]]("attachRequired")
       requiresRepublish <- c.get[Option[Boolean]]("requiresRepublish")
       fsGroupPolicy <- c.get[Option[String]]("fsGroupPolicy")
       storageCapacity <- c.get[Option[Boolean]]("storageCapacity")
       tokenRequests <- c.get[Option[Seq[io.k8s.api.storage.v1.TokenRequest]]]("tokenRequests")
       seLinuxMount <- c.get[Option[Boolean]]("seLinuxMount")
    } yield io.k8s.api.storage.v1.CSIDriverSpec(
      volumeLifecycleModes = volumeLifecycleModes,
      podInfoOnMount = podInfoOnMount,
      attachRequired = attachRequired,
      requiresRepublish = requiresRepublish,
      fsGroupPolicy = fsGroupPolicy,
      storageCapacity = storageCapacity,
      tokenRequests = tokenRequests,
      seLinuxMount = seLinuxMount
    )

    implicit lazy val io_k8s_api_autoscaling_v1CrossVersionObjectReferenceEncoder : Encoder[io.k8s.api.autoscaling.v1.CrossVersionObjectReference] = o =>
      Json.obj(
        "name" -> o.name.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v1CrossVersionObjectReferenceDecoder : Decoder[io.k8s.api.autoscaling.v1.CrossVersionObjectReference] = (c: HCursor) => for {
       name <- c.get[String]("name")
    } yield io.k8s.api.autoscaling.v1.CrossVersionObjectReference(
      name = name
    )

    implicit lazy val io_k8s_api_autoscaling_v2MetricValueStatusEncoder : Encoder[io.k8s.api.autoscaling.v2.MetricValueStatus] = o =>
      Json.obj(
        "averageUtilization" -> o.averageUtilization.asJson,
      "averageValue" -> o.averageValue.asJson,
      "value" -> o.value.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2MetricValueStatusDecoder : Decoder[io.k8s.api.autoscaling.v2.MetricValueStatus] = (c: HCursor) => for {
       averageUtilization <- c.get[Option[Int]]("averageUtilization")
       averageValue <- c.get[Option[io.k8s.apimachinery.pkg.api.resource.Quantity]]("averageValue")
       value <- c.get[Option[io.k8s.apimachinery.pkg.api.resource.Quantity]]("value")
    } yield io.k8s.api.autoscaling.v2.MetricValueStatus(
      averageUtilization = averageUtilization,
      averageValue = averageValue,
      value = value
    )

    implicit lazy val io_k8s_api_core_v1PodReadinessGateEncoder : Encoder[io.k8s.api.core.v1.PodReadinessGate] = o =>
      Json.obj(
        "conditionType" -> o.conditionType.asJson
      )
    implicit lazy val io_k8s_api_core_v1PodReadinessGateDecoder : Decoder[io.k8s.api.core.v1.PodReadinessGate] = (c: HCursor) => for {
       conditionType <- c.get[String]("conditionType")
    } yield io.k8s.api.core.v1.PodReadinessGate(
      conditionType = conditionType
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2MetricStatusEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.MetricStatus] = o =>
      Json.obj(
        "object" -> o.`object`.asJson,
      "external" -> o.external.asJson,
      "containerResource" -> o.containerResource.asJson,
      "resource" -> o.resource.asJson,
      "pods" -> o.pods.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2MetricStatusDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.MetricStatus] = (c: HCursor) => for {
       `object` <- c.get[Option[io.k8s.api.autoscaling.v2beta2.ObjectMetricStatus]]("object")
       external <- c.get[Option[io.k8s.api.autoscaling.v2beta2.ExternalMetricStatus]]("external")
       containerResource <- c.get[Option[io.k8s.api.autoscaling.v2beta2.ContainerResourceMetricStatus]]("containerResource")
       resource <- c.get[Option[io.k8s.api.autoscaling.v2beta2.ResourceMetricStatus]]("resource")
       pods <- c.get[Option[io.k8s.api.autoscaling.v2beta2.PodsMetricStatus]]("pods")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.autoscaling.v2beta2.MetricStatus(
      `object` = `object`,
      external = external,
      containerResource = containerResource,
      resource = resource,
      pods = pods,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_core_v1LifecycleEncoder : Encoder[io.k8s.api.core.v1.Lifecycle] = o =>
      Json.obj(
        "postStart" -> o.postStart.asJson,
      "preStop" -> o.preStop.asJson
      )
    implicit lazy val io_k8s_api_core_v1LifecycleDecoder : Decoder[io.k8s.api.core.v1.Lifecycle] = (c: HCursor) => for {
       postStart <- c.get[Option[io.k8s.api.core.v1.LifecycleHandler]]("postStart")
       preStop <- c.get[Option[io.k8s.api.core.v1.LifecycleHandler]]("preStop")
    } yield io.k8s.api.core.v1.Lifecycle(
      postStart = postStart,
      preStop = preStop
    )

    implicit lazy val io_k8s_api_networking_v1IngressServiceBackendEncoder : Encoder[io.k8s.api.networking.v1.IngressServiceBackend] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "port" -> o.port.asJson
      )
    implicit lazy val io_k8s_api_networking_v1IngressServiceBackendDecoder : Decoder[io.k8s.api.networking.v1.IngressServiceBackend] = (c: HCursor) => for {
       name <- c.get[String]("name")
       port <- c.get[Option[io.k8s.api.networking.v1.ServiceBackendPort]]("port")
    } yield io.k8s.api.networking.v1.IngressServiceBackend(
      name = name,
      port = port
    )

    implicit lazy val io_k8s_api_core_v1AttachedVolumeEncoder : Encoder[io.k8s.api.core.v1.AttachedVolume] = o =>
      Json.obj(
        "devicePath" -> o.devicePath.asJson,
      "name" -> o.name.asJson
      )
    implicit lazy val io_k8s_api_core_v1AttachedVolumeDecoder : Decoder[io.k8s.api.core.v1.AttachedVolume] = (c: HCursor) => for {
       devicePath <- c.get[String]("devicePath")
       name <- c.get[String]("name")
    } yield io.k8s.api.core.v1.AttachedVolume(
      devicePath = devicePath,
      name = name
    )

    implicit lazy val io_k8s_api_discovery_v1ForZoneEncoder : Encoder[io.k8s.api.discovery.v1.ForZone] = o =>
      Json.obj(
        "name" -> o.name.asJson
      )
    implicit lazy val io_k8s_api_discovery_v1ForZoneDecoder : Decoder[io.k8s.api.discovery.v1.ForZone] = (c: HCursor) => for {
       name <- c.get[String]("name")
    } yield io.k8s.api.discovery.v1.ForZone(
      name = name
    )

    implicit lazy val io_k8s_api_core_v1SecretEnvSourceEncoder : Encoder[io.k8s.api.core.v1.SecretEnvSource] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "optional" -> o.optional.asJson
      )
    implicit lazy val io_k8s_api_core_v1SecretEnvSourceDecoder : Decoder[io.k8s.api.core.v1.SecretEnvSource] = (c: HCursor) => for {
       name <- c.get[Option[String]]("name")
       optional <- c.get[Option[Boolean]]("optional")
    } yield io.k8s.api.core.v1.SecretEnvSource(
      name = name,
      optional = optional
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2ObjectMetricStatusEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.ObjectMetricStatus] = o =>
      Json.obj(
        "current" -> o.current.asJson,
      "describedObject" -> o.describedObject.asJson,
      "metric" -> o.metric.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2ObjectMetricStatusDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.ObjectMetricStatus] = (c: HCursor) => for {
       current <- c.get[io.k8s.api.autoscaling.v2beta2.MetricValueStatus]("current")
       describedObject <- c.get[io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference]("describedObject")
       metric <- c.get[io.k8s.api.autoscaling.v2beta2.MetricIdentifier]("metric")
    } yield io.k8s.api.autoscaling.v2beta2.ObjectMetricStatus(
      current = current,
      describedObject = describedObject,
      metric = metric
    )

    implicit lazy val io_k8s_kube_aggregator_pkg_apis_apiregistration_v1APIServiceSpecEncoder : Encoder[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceSpec] = o =>
      Json.obj(
        "caBundle" -> o.caBundle.asJson,
      "versionPriority" -> o.versionPriority.asJson,
      "service" -> o.service.asJson,
      "version" -> o.version.asJson,
      "groupPriorityMinimum" -> o.groupPriorityMinimum.asJson,
      "group" -> o.group.asJson,
      "insecureSkipTLSVerify" -> o.insecureSkipTLSVerify.asJson
      )
    implicit lazy val io_k8s_kube_aggregator_pkg_apis_apiregistration_v1APIServiceSpecDecoder : Decoder[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceSpec] = (c: HCursor) => for {
       caBundle <- c.get[Option[String]]("caBundle")
       versionPriority <- c.get[Int]("versionPriority")
       service <- c.get[Option[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.ServiceReference]]("service")
       version <- c.get[Option[String]]("version")
       groupPriorityMinimum <- c.get[Int]("groupPriorityMinimum")
       group <- c.get[Option[String]]("group")
       insecureSkipTLSVerify <- c.get[Option[Boolean]]("insecureSkipTLSVerify")
    } yield io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceSpec(
      caBundle = caBundle,
      versionPriority = versionPriority,
      service = service,
      version = version,
      groupPriorityMinimum = groupPriorityMinimum,
      group = group,
      insecureSkipTLSVerify = insecureSkipTLSVerify
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta1FlowDistinguisherMethodEncoder : Encoder[io.k8s.api.flowcontrol.v1beta1.FlowDistinguisherMethod] = o =>
      Json.obj(
        "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta1FlowDistinguisherMethodDecoder : Decoder[io.k8s.api.flowcontrol.v1beta1.FlowDistinguisherMethod] = (c: HCursor) => for {
       `type` <- c.get[String]("type")
    } yield io.k8s.api.flowcontrol.v1beta1.FlowDistinguisherMethod(
      `type` = `type`
    )

    implicit lazy val io_k8s_api_discovery_v1EndpointHintsEncoder : Encoder[io.k8s.api.discovery.v1.EndpointHints] = o =>
      Json.obj(
        "forZones" -> o.forZones.asJson
      )
    implicit lazy val io_k8s_api_discovery_v1EndpointHintsDecoder : Decoder[io.k8s.api.discovery.v1.EndpointHints] = (c: HCursor) => for {
       forZones <- c.get[Option[Seq[io.k8s.api.discovery.v1.ForZone]]]("forZones")
    } yield io.k8s.api.discovery.v1.EndpointHints(
      forZones = forZones
    )

    implicit lazy val io_k8s_api_core_v1ComponentConditionEncoder : Encoder[io.k8s.api.core.v1.ComponentCondition] = o =>
      Json.obj(
        "error" -> o.error.asJson,
      "message" -> o.message.asJson,
      "status" -> o.status.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_core_v1ComponentConditionDecoder : Decoder[io.k8s.api.core.v1.ComponentCondition] = (c: HCursor) => for {
       error <- c.get[Option[String]]("error")
       message <- c.get[Option[String]]("message")
       status <- c.get[String]("status")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.core.v1.ComponentCondition(
      error = error,
      message = message,
      status = status,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_batch_v1JobSpecEncoder : Encoder[io.k8s.api.batch.v1.JobSpec] = o =>
      Json.obj(
        "parallelism" -> o.parallelism.asJson,
      "completionMode" -> o.completionMode.asJson,
      "podFailurePolicy" -> o.podFailurePolicy.asJson,
      "manualSelector" -> o.manualSelector.asJson,
      "suspend" -> o.suspend.asJson,
      "template" -> o.template.asJson,
      "backoffLimit" -> o.backoffLimit.asJson,
      "activeDeadlineSeconds" -> o.activeDeadlineSeconds.asJson,
      "completions" -> o.completions.asJson,
      "ttlSecondsAfterFinished" -> o.ttlSecondsAfterFinished.asJson,
      "selector" -> o.selector.asJson
      )
    implicit lazy val io_k8s_api_batch_v1JobSpecDecoder : Decoder[io.k8s.api.batch.v1.JobSpec] = (c: HCursor) => for {
       parallelism <- c.get[Option[Int]]("parallelism")
       completionMode <- c.get[Option[String]]("completionMode")
       podFailurePolicy <- c.get[Option[io.k8s.api.batch.v1.PodFailurePolicy]]("podFailurePolicy")
       manualSelector <- c.get[Option[Boolean]]("manualSelector")
       suspend <- c.get[Option[Boolean]]("suspend")
       template <- c.get[io.k8s.api.core.v1.PodTemplateSpec]("template")
       backoffLimit <- c.get[Option[Int]]("backoffLimit")
       activeDeadlineSeconds <- c.get[Option[Int]]("activeDeadlineSeconds")
       completions <- c.get[Option[Int]]("completions")
       ttlSecondsAfterFinished <- c.get[Option[Int]]("ttlSecondsAfterFinished")
       selector <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]]("selector")
    } yield io.k8s.api.batch.v1.JobSpec(
      parallelism = parallelism,
      completionMode = completionMode,
      podFailurePolicy = podFailurePolicy,
      manualSelector = manualSelector,
      suspend = suspend,
      template = template,
      backoffLimit = backoffLimit,
      activeDeadlineSeconds = activeDeadlineSeconds,
      completions = completions,
      ttlSecondsAfterFinished = ttlSecondsAfterFinished,
      selector = selector
    )

    implicit lazy val io_k8s_api_discovery_v1EndpointConditionsEncoder : Encoder[io.k8s.api.discovery.v1.EndpointConditions] = o =>
      Json.obj(
        "ready" -> o.ready.asJson,
      "serving" -> o.serving.asJson,
      "terminating" -> o.terminating.asJson
      )
    implicit lazy val io_k8s_api_discovery_v1EndpointConditionsDecoder : Decoder[io.k8s.api.discovery.v1.EndpointConditions] = (c: HCursor) => for {
       ready <- c.get[Option[Boolean]]("ready")
       serving <- c.get[Option[Boolean]]("serving")
       terminating <- c.get[Option[Boolean]]("terminating")
    } yield io.k8s.api.discovery.v1.EndpointConditions(
      ready = ready,
      serving = serving,
      terminating = terminating
    )

    implicit lazy val io_k8s_api_core_v1ResourceRequirementsEncoder : Encoder[io.k8s.api.core.v1.ResourceRequirements] = o =>
      Json.obj(
        "limits" -> o.limits.asJson,
      "requests" -> o.requests.asJson
      )
    implicit lazy val io_k8s_api_core_v1ResourceRequirementsDecoder : Decoder[io.k8s.api.core.v1.ResourceRequirements] = (c: HCursor) => for {
       limits <- c.get[Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]]("limits")
       requests <- c.get[Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]]("requests")
    } yield io.k8s.api.core.v1.ResourceRequirements(
      limits = limits,
      requests = requests
    )

    implicit lazy val io_k8s_api_batch_v1PodFailurePolicyOnPodConditionsPatternEncoder : Encoder[io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern] = o =>
      Json.obj(
        "status" -> o.status.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_batch_v1PodFailurePolicyOnPodConditionsPatternDecoder : Decoder[io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern] = (c: HCursor) => for {
       status <- c.get[String]("status")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern(
      status = status,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_core_v1VolumeProjectionEncoder : Encoder[io.k8s.api.core.v1.VolumeProjection] = o =>
      Json.obj(
        "configMap" -> o.configMap.asJson,
      "downwardAPI" -> o.downwardAPI.asJson,
      "secret" -> o.secret.asJson,
      "serviceAccountToken" -> o.serviceAccountToken.asJson
      )
    implicit lazy val io_k8s_api_core_v1VolumeProjectionDecoder : Decoder[io.k8s.api.core.v1.VolumeProjection] = (c: HCursor) => for {
       configMap <- c.get[Option[io.k8s.api.core.v1.ConfigMapProjection]]("configMap")
       downwardAPI <- c.get[Option[io.k8s.api.core.v1.DownwardAPIProjection]]("downwardAPI")
       secret <- c.get[Option[io.k8s.api.core.v1.SecretProjection]]("secret")
       serviceAccountToken <- c.get[Option[io.k8s.api.core.v1.ServiceAccountTokenProjection]]("serviceAccountToken")
    } yield io.k8s.api.core.v1.VolumeProjection(
      configMap = configMap,
      downwardAPI = downwardAPI,
      secret = secret,
      serviceAccountToken = serviceAccountToken
    )

    implicit lazy val io_k8s_api_core_v1ContainerPortEncoder : Encoder[io.k8s.api.core.v1.ContainerPort] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "containerPort" -> o.containerPort.asJson,
      "hostPort" -> o.hostPort.asJson,
      "hostIP" -> o.hostIP.asJson,
      "protocol" -> o.protocol.asJson
      )
    implicit lazy val io_k8s_api_core_v1ContainerPortDecoder : Decoder[io.k8s.api.core.v1.ContainerPort] = (c: HCursor) => for {
       name <- c.get[Option[String]]("name")
       containerPort <- c.get[Int]("containerPort")
       hostPort <- c.get[Option[Int]]("hostPort")
       hostIP <- c.get[Option[String]]("hostIP")
       protocol <- c.get[Option[String]]("protocol")
    } yield io.k8s.api.core.v1.ContainerPort(
      name = name,
      containerPort = containerPort,
      hostPort = hostPort,
      hostIP = hostIP,
      protocol = protocol
    )

    implicit lazy val io_k8s_api_events_v1EventSeriesEncoder : Encoder[io.k8s.api.events.v1.EventSeries] = o =>
      Json.obj(
        "count" -> o.count.asJson,
      "lastObservedTime" -> o.lastObservedTime.asJson
      )
    implicit lazy val io_k8s_api_events_v1EventSeriesDecoder : Decoder[io.k8s.api.events.v1.EventSeries] = (c: HCursor) => for {
       count <- c.get[Int]("count")
       lastObservedTime <- c.get[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime]("lastObservedTime")
    } yield io.k8s.api.events.v1.EventSeries(
      count = count,
      lastObservedTime = lastObservedTime
    )

    implicit lazy val io_k8s_api_core_v1TolerationEncoder : Encoder[io.k8s.api.core.v1.Toleration] = o =>
      Json.obj(
        "effect" -> o.effect.asJson,
      "key" -> o.key.asJson,
      "tolerationSeconds" -> o.tolerationSeconds.asJson,
      "operator" -> o.operator.asJson,
      "value" -> o.value.asJson
      )
    implicit lazy val io_k8s_api_core_v1TolerationDecoder : Decoder[io.k8s.api.core.v1.Toleration] = (c: HCursor) => for {
       effect <- c.get[Option[String]]("effect")
       key <- c.get[Option[String]]("key")
       tolerationSeconds <- c.get[Option[Int]]("tolerationSeconds")
       operator <- c.get[Option[String]]("operator")
       value <- c.get[Option[String]]("value")
    } yield io.k8s.api.core.v1.Toleration(
      effect = effect,
      key = key,
      tolerationSeconds = tolerationSeconds,
      operator = operator,
      value = value
    )

    implicit lazy val io_k8s_api_core_v1ScaleIOVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.ScaleIOVolumeSource] = o =>
      Json.obj(
        "system" -> o.system.asJson,
      "readOnly" -> o.readOnly.asJson,
      "fsType" -> o.fsType.asJson,
      "secretRef" -> o.secretRef.asJson,
      "storagePool" -> o.storagePool.asJson,
      "gateway" -> o.gateway.asJson,
      "protectionDomain" -> o.protectionDomain.asJson,
      "volumeName" -> o.volumeName.asJson,
      "sslEnabled" -> o.sslEnabled.asJson,
      "storageMode" -> o.storageMode.asJson
      )
    implicit lazy val io_k8s_api_core_v1ScaleIOVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.ScaleIOVolumeSource] = (c: HCursor) => for {
       system <- c.get[String]("system")
       readOnly <- c.get[Option[Boolean]]("readOnly")
       fsType <- c.get[Option[String]]("fsType")
       secretRef <- c.get[io.k8s.api.core.v1.LocalObjectReference]("secretRef")
       storagePool <- c.get[Option[String]]("storagePool")
       gateway <- c.get[String]("gateway")
       protectionDomain <- c.get[Option[String]]("protectionDomain")
       volumeName <- c.get[Option[String]]("volumeName")
       sslEnabled <- c.get[Option[Boolean]]("sslEnabled")
       storageMode <- c.get[Option[String]]("storageMode")
    } yield io.k8s.api.core.v1.ScaleIOVolumeSource(
      system = system,
      readOnly = readOnly,
      fsType = fsType,
      secretRef = secretRef,
      storagePool = storagePool,
      gateway = gateway,
      protectionDomain = protectionDomain,
      volumeName = volumeName,
      sslEnabled = sslEnabled,
      storageMode = storageMode
    )

    implicit lazy val io_k8s_api_core_v1GCEPersistentDiskVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.GCEPersistentDiskVolumeSource] = o =>
      Json.obj(
        "fsType" -> o.fsType.asJson,
      "partition" -> o.partition.asJson,
      "pdName" -> o.pdName.asJson,
      "readOnly" -> o.readOnly.asJson
      )
    implicit lazy val io_k8s_api_core_v1GCEPersistentDiskVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.GCEPersistentDiskVolumeSource] = (c: HCursor) => for {
       fsType <- c.get[Option[String]]("fsType")
       partition <- c.get[Option[Int]]("partition")
       pdName <- c.get[String]("pdName")
       readOnly <- c.get[Option[Boolean]]("readOnly")
    } yield io.k8s.api.core.v1.GCEPersistentDiskVolumeSource(
      fsType = fsType,
      partition = partition,
      pdName = pdName,
      readOnly = readOnly
    )

    implicit lazy val io_k8s_api_core_v1CSIVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.CSIVolumeSource] = o =>
      Json.obj(
        "readOnly" -> o.readOnly.asJson,
      "fsType" -> o.fsType.asJson,
      "driver" -> o.driver.asJson,
      "volumeAttributes" -> o.volumeAttributes.asJson,
      "nodePublishSecretRef" -> o.nodePublishSecretRef.asJson
      )
    implicit lazy val io_k8s_api_core_v1CSIVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.CSIVolumeSource] = (c: HCursor) => for {
       readOnly <- c.get[Option[Boolean]]("readOnly")
       fsType <- c.get[Option[String]]("fsType")
       driver <- c.get[String]("driver")
       volumeAttributes <- c.get[Option[Map[String, String]]]("volumeAttributes")
       nodePublishSecretRef <- c.get[Option[io.k8s.api.core.v1.LocalObjectReference]]("nodePublishSecretRef")
    } yield io.k8s.api.core.v1.CSIVolumeSource(
      readOnly = readOnly,
      fsType = fsType,
      driver = driver,
      volumeAttributes = volumeAttributes,
      nodePublishSecretRef = nodePublishSecretRef
    )

    implicit lazy val io_k8s_api_networking_v1NetworkPolicyStatusEncoder : Encoder[io.k8s.api.networking.v1.NetworkPolicyStatus] = o =>
      Json.obj(
        "conditions" -> o.conditions.asJson
      )
    implicit lazy val io_k8s_api_networking_v1NetworkPolicyStatusDecoder : Decoder[io.k8s.api.networking.v1.NetworkPolicyStatus] = (c: HCursor) => for {
       conditions <- c.get[Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]]]("conditions")
    } yield io.k8s.api.networking.v1.NetworkPolicyStatus(
      conditions = conditions
    )

    implicit lazy val io_k8s_api_core_v1WeightedPodAffinityTermEncoder : Encoder[io.k8s.api.core.v1.WeightedPodAffinityTerm] = o =>
      Json.obj(
        "podAffinityTerm" -> o.podAffinityTerm.asJson,
      "weight" -> o.weight.asJson
      )
    implicit lazy val io_k8s_api_core_v1WeightedPodAffinityTermDecoder : Decoder[io.k8s.api.core.v1.WeightedPodAffinityTerm] = (c: HCursor) => for {
       podAffinityTerm <- c.get[io.k8s.api.core.v1.PodAffinityTerm]("podAffinityTerm")
       weight <- c.get[Int]("weight")
    } yield io.k8s.api.core.v1.WeightedPodAffinityTerm(
      podAffinityTerm = podAffinityTerm,
      weight = weight
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta2SubjectEncoder : Encoder[io.k8s.api.flowcontrol.v1beta2.Subject] = o =>
      Json.obj(
        "group" -> o.group.asJson,
      "serviceAccount" -> o.serviceAccount.asJson,
      "user" -> o.user.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta2SubjectDecoder : Decoder[io.k8s.api.flowcontrol.v1beta2.Subject] = (c: HCursor) => for {
       group <- c.get[Option[io.k8s.api.flowcontrol.v1beta2.GroupSubject]]("group")
       serviceAccount <- c.get[Option[io.k8s.api.flowcontrol.v1beta2.ServiceAccountSubject]]("serviceAccount")
       user <- c.get[Option[io.k8s.api.flowcontrol.v1beta2.UserSubject]]("user")
    } yield io.k8s.api.flowcontrol.v1beta2.Subject(
      group = group,
      serviceAccount = serviceAccount,
      user = user
    )

    implicit lazy val io_k8s_api_authorization_v1SelfSubjectAccessReviewSpecEncoder : Encoder[io.k8s.api.authorization.v1.SelfSubjectAccessReviewSpec] = o =>
      Json.obj(
        "nonResourceAttributes" -> o.nonResourceAttributes.asJson,
      "resourceAttributes" -> o.resourceAttributes.asJson
      )
    implicit lazy val io_k8s_api_authorization_v1SelfSubjectAccessReviewSpecDecoder : Decoder[io.k8s.api.authorization.v1.SelfSubjectAccessReviewSpec] = (c: HCursor) => for {
       nonResourceAttributes <- c.get[Option[io.k8s.api.authorization.v1.NonResourceAttributes]]("nonResourceAttributes")
       resourceAttributes <- c.get[Option[io.k8s.api.authorization.v1.ResourceAttributes]]("resourceAttributes")
    } yield io.k8s.api.authorization.v1.SelfSubjectAccessReviewSpec(
      nonResourceAttributes = nonResourceAttributes,
      resourceAttributes = resourceAttributes
    )

    implicit lazy val io_k8s_api_core_v1ServiceStatusEncoder : Encoder[io.k8s.api.core.v1.ServiceStatus] = o =>
      Json.obj(
        "conditions" -> o.conditions.asJson,
      "loadBalancer" -> o.loadBalancer.asJson
      )
    implicit lazy val io_k8s_api_core_v1ServiceStatusDecoder : Decoder[io.k8s.api.core.v1.ServiceStatus] = (c: HCursor) => for {
       conditions <- c.get[Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]]]("conditions")
       loadBalancer <- c.get[Option[io.k8s.api.core.v1.LoadBalancerStatus]]("loadBalancer")
    } yield io.k8s.api.core.v1.ServiceStatus(
      conditions = conditions,
      loadBalancer = loadBalancer
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2ExternalMetricStatusEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.ExternalMetricStatus] = o =>
      Json.obj(
        "current" -> o.current.asJson,
      "metric" -> o.metric.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2ExternalMetricStatusDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.ExternalMetricStatus] = (c: HCursor) => for {
       current <- c.get[io.k8s.api.autoscaling.v2beta2.MetricValueStatus]("current")
       metric <- c.get[io.k8s.api.autoscaling.v2beta2.MetricIdentifier]("metric")
    } yield io.k8s.api.autoscaling.v2beta2.ExternalMetricStatus(
      current = current,
      metric = metric
    )

    implicit lazy val io_k8s_api_rbac_v1SubjectEncoder : Encoder[io.k8s.api.rbac.v1.Subject] = o =>
      Json.obj(
        "apiGroup" -> o.apiGroup.asJson,
      "name" -> o.name.asJson,
      "namespace" -> o.namespace.asJson
      )
    implicit lazy val io_k8s_api_rbac_v1SubjectDecoder : Decoder[io.k8s.api.rbac.v1.Subject] = (c: HCursor) => for {
       apiGroup <- c.get[Option[String]]("apiGroup")
       name <- c.get[String]("name")
       namespace <- c.get[Option[String]]("namespace")
    } yield io.k8s.api.rbac.v1.Subject(
      apiGroup = apiGroup,
      name = name,
      namespace = namespace
    )

    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1WebhookConversionEncoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookConversion] = o =>
      Json.obj(
        "clientConfig" -> o.clientConfig.asJson,
      "conversionReviewVersions" -> o.conversionReviewVersions.asJson
      )
    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1WebhookConversionDecoder : Decoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookConversion] = (c: HCursor) => for {
       clientConfig <- c.get[Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookClientConfig]]("clientConfig")
       conversionReviewVersions <- c.get[Seq[String]]("conversionReviewVersions")
    } yield io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookConversion(
      clientConfig = clientConfig,
      conversionReviewVersions = conversionReviewVersions
    )

    implicit lazy val io_k8s_api_core_v1NodeAffinityEncoder : Encoder[io.k8s.api.core.v1.NodeAffinity] = o =>
      Json.obj(
        "preferredDuringSchedulingIgnoredDuringExecution" -> o.preferredDuringSchedulingIgnoredDuringExecution.asJson,
      "requiredDuringSchedulingIgnoredDuringExecution" -> o.requiredDuringSchedulingIgnoredDuringExecution.asJson
      )
    implicit lazy val io_k8s_api_core_v1NodeAffinityDecoder : Decoder[io.k8s.api.core.v1.NodeAffinity] = (c: HCursor) => for {
       preferredDuringSchedulingIgnoredDuringExecution <- c.get[Option[Seq[io.k8s.api.core.v1.PreferredSchedulingTerm]]]("preferredDuringSchedulingIgnoredDuringExecution")
       requiredDuringSchedulingIgnoredDuringExecution <- c.get[Option[io.k8s.api.core.v1.NodeSelector]]("requiredDuringSchedulingIgnoredDuringExecution")
    } yield io.k8s.api.core.v1.NodeAffinity(
      preferredDuringSchedulingIgnoredDuringExecution = preferredDuringSchedulingIgnoredDuringExecution,
      requiredDuringSchedulingIgnoredDuringExecution = requiredDuringSchedulingIgnoredDuringExecution
    )

    implicit lazy val io_k8s_api_core_v1PodStatusEncoder : Encoder[io.k8s.api.core.v1.PodStatus] = o =>
      Json.obj(
        "conditions" -> o.conditions.asJson,
      "qosClass" -> o.qosClass.asJson,
      "startTime" -> o.startTime.asJson,
      "phase" -> o.phase.asJson,
      "reason" -> o.reason.asJson,
      "ephemeralContainerStatuses" -> o.ephemeralContainerStatuses.asJson,
      "hostIP" -> o.hostIP.asJson,
      "message" -> o.message.asJson,
      "containerStatuses" -> o.containerStatuses.asJson,
      "podIP" -> o.podIP.asJson,
      "nominatedNodeName" -> o.nominatedNodeName.asJson,
      "podIPs" -> o.podIPs.asJson,
      "initContainerStatuses" -> o.initContainerStatuses.asJson
      )
    implicit lazy val io_k8s_api_core_v1PodStatusDecoder : Decoder[io.k8s.api.core.v1.PodStatus] = (c: HCursor) => for {
       conditions <- c.get[Option[Seq[io.k8s.api.core.v1.PodCondition]]]("conditions")
       qosClass <- c.get[Option[String]]("qosClass")
       startTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("startTime")
       phase <- c.get[Option[String]]("phase")
       reason <- c.get[Option[String]]("reason")
       ephemeralContainerStatuses <- c.get[Option[Seq[io.k8s.api.core.v1.ContainerStatus]]]("ephemeralContainerStatuses")
       hostIP <- c.get[Option[String]]("hostIP")
       message <- c.get[Option[String]]("message")
       containerStatuses <- c.get[Option[Seq[io.k8s.api.core.v1.ContainerStatus]]]("containerStatuses")
       podIP <- c.get[Option[String]]("podIP")
       nominatedNodeName <- c.get[Option[String]]("nominatedNodeName")
       podIPs <- c.get[Option[Seq[io.k8s.api.core.v1.PodIP]]]("podIPs")
       initContainerStatuses <- c.get[Option[Seq[io.k8s.api.core.v1.ContainerStatus]]]("initContainerStatuses")
    } yield io.k8s.api.core.v1.PodStatus(
      conditions = conditions,
      qosClass = qosClass,
      startTime = startTime,
      phase = phase,
      reason = reason,
      ephemeralContainerStatuses = ephemeralContainerStatuses,
      hostIP = hostIP,
      message = message,
      containerStatuses = containerStatuses,
      podIP = podIP,
      nominatedNodeName = nominatedNodeName,
      podIPs = podIPs,
      initContainerStatuses = initContainerStatuses
    )

    implicit lazy val io_k8s_api_core_v1StorageOSPersistentVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.StorageOSPersistentVolumeSource] = o =>
      Json.obj(
        "volumeNamespace" -> o.volumeNamespace.asJson,
      "readOnly" -> o.readOnly.asJson,
      "fsType" -> o.fsType.asJson,
      "secretRef" -> o.secretRef.asJson,
      "volumeName" -> o.volumeName.asJson
      )
    implicit lazy val io_k8s_api_core_v1StorageOSPersistentVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.StorageOSPersistentVolumeSource] = (c: HCursor) => for {
       volumeNamespace <- c.get[Option[String]]("volumeNamespace")
       readOnly <- c.get[Option[Boolean]]("readOnly")
       fsType <- c.get[Option[String]]("fsType")
       secretRef <- c.get[Option[io.k8s.api.core.v1.ObjectReference]]("secretRef")
       volumeName <- c.get[Option[String]]("volumeName")
    } yield io.k8s.api.core.v1.StorageOSPersistentVolumeSource(
      volumeNamespace = volumeNamespace,
      readOnly = readOnly,
      fsType = fsType,
      secretRef = secretRef,
      volumeName = volumeName
    )

    implicit lazy val io_k8s_api_admissionregistration_v1WebhookClientConfigEncoder : Encoder[io.k8s.api.admissionregistration.v1.WebhookClientConfig] = o =>
      Json.obj(
        "caBundle" -> o.caBundle.asJson,
      "service" -> o.service.asJson,
      "url" -> o.url.asJson
      )
    implicit lazy val io_k8s_api_admissionregistration_v1WebhookClientConfigDecoder : Decoder[io.k8s.api.admissionregistration.v1.WebhookClientConfig] = (c: HCursor) => for {
       caBundle <- c.get[Option[String]]("caBundle")
       service <- c.get[Option[io.k8s.api.admissionregistration.v1.ServiceReference]]("service")
       url <- c.get[Option[String]]("url")
    } yield io.k8s.api.admissionregistration.v1.WebhookClientConfig(
      caBundle = caBundle,
      service = service,
      url = url
    )

    implicit lazy val io_k8s_api_core_v1ContainerStatusEncoder : Encoder[io.k8s.api.core.v1.ContainerStatus] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "state" -> o.state.asJson,
      "image" -> o.image.asJson,
      "restartCount" -> o.restartCount.asJson,
      "ready" -> o.ready.asJson,
      "lastState" -> o.lastState.asJson,
      "imageID" -> o.imageID.asJson,
      "containerID" -> o.containerID.asJson,
      "started" -> o.started.asJson
      )
    implicit lazy val io_k8s_api_core_v1ContainerStatusDecoder : Decoder[io.k8s.api.core.v1.ContainerStatus] = (c: HCursor) => for {
       name <- c.get[String]("name")
       state <- c.get[Option[io.k8s.api.core.v1.ContainerState]]("state")
       image <- c.get[String]("image")
       restartCount <- c.get[Int]("restartCount")
       ready <- c.get[Boolean]("ready")
       lastState <- c.get[Option[io.k8s.api.core.v1.ContainerState]]("lastState")
       imageID <- c.get[String]("imageID")
       containerID <- c.get[Option[String]]("containerID")
       started <- c.get[Option[Boolean]]("started")
    } yield io.k8s.api.core.v1.ContainerStatus(
      name = name,
      state = state,
      image = image,
      restartCount = restartCount,
      ready = ready,
      lastState = lastState,
      imageID = imageID,
      containerID = containerID,
      started = started
    )

    implicit lazy val io_k8s_api_core_v1ResourceFieldSelectorEncoder : Encoder[io.k8s.api.core.v1.ResourceFieldSelector] = o =>
      Json.obj(
        "containerName" -> o.containerName.asJson,
      "divisor" -> o.divisor.asJson,
      "resource" -> o.resource.asJson
      )
    implicit lazy val io_k8s_api_core_v1ResourceFieldSelectorDecoder : Decoder[io.k8s.api.core.v1.ResourceFieldSelector] = (c: HCursor) => for {
       containerName <- c.get[Option[String]]("containerName")
       divisor <- c.get[Option[io.k8s.apimachinery.pkg.api.resource.Quantity]]("divisor")
       resource <- c.get[String]("resource")
    } yield io.k8s.api.core.v1.ResourceFieldSelector(
      containerName = containerName,
      divisor = divisor,
      resource = resource
    )

    implicit lazy val io_k8s_api_core_v1KeyToPathEncoder : Encoder[io.k8s.api.core.v1.KeyToPath] = o =>
      Json.obj(
        "key" -> o.key.asJson,
      "mode" -> o.mode.asJson,
      "path" -> o.path.asJson
      )
    implicit lazy val io_k8s_api_core_v1KeyToPathDecoder : Decoder[io.k8s.api.core.v1.KeyToPath] = (c: HCursor) => for {
       key <- c.get[String]("key")
       mode <- c.get[Option[Int]]("mode")
       path <- c.get[String]("path")
    } yield io.k8s.api.core.v1.KeyToPath(
      key = key,
      mode = mode,
      path = path
    )

    implicit lazy val io_k8s_api_authorization_v1SubjectRulesReviewStatusEncoder : Encoder[io.k8s.api.authorization.v1.SubjectRulesReviewStatus] = o =>
      Json.obj(
        "evaluationError" -> o.evaluationError.asJson,
      "incomplete" -> o.incomplete.asJson,
      "nonResourceRules" -> o.nonResourceRules.asJson,
      "resourceRules" -> o.resourceRules.asJson
      )
    implicit lazy val io_k8s_api_authorization_v1SubjectRulesReviewStatusDecoder : Decoder[io.k8s.api.authorization.v1.SubjectRulesReviewStatus] = (c: HCursor) => for {
       evaluationError <- c.get[Option[String]]("evaluationError")
       incomplete <- c.get[Boolean]("incomplete")
       nonResourceRules <- c.get[Seq[io.k8s.api.authorization.v1.NonResourceRule]]("nonResourceRules")
       resourceRules <- c.get[Seq[io.k8s.api.authorization.v1.ResourceRule]]("resourceRules")
    } yield io.k8s.api.authorization.v1.SubjectRulesReviewStatus(
      evaluationError = evaluationError,
      incomplete = incomplete,
      nonResourceRules = nonResourceRules,
      resourceRules = resourceRules
    )

    implicit lazy val io_k8s_api_core_v1ScaleIOPersistentVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.ScaleIOPersistentVolumeSource] = o =>
      Json.obj(
        "system" -> o.system.asJson,
      "readOnly" -> o.readOnly.asJson,
      "fsType" -> o.fsType.asJson,
      "secretRef" -> o.secretRef.asJson,
      "storagePool" -> o.storagePool.asJson,
      "gateway" -> o.gateway.asJson,
      "protectionDomain" -> o.protectionDomain.asJson,
      "volumeName" -> o.volumeName.asJson,
      "sslEnabled" -> o.sslEnabled.asJson,
      "storageMode" -> o.storageMode.asJson
      )
    implicit lazy val io_k8s_api_core_v1ScaleIOPersistentVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.ScaleIOPersistentVolumeSource] = (c: HCursor) => for {
       system <- c.get[String]("system")
       readOnly <- c.get[Option[Boolean]]("readOnly")
       fsType <- c.get[Option[String]]("fsType")
       secretRef <- c.get[io.k8s.api.core.v1.SecretReference]("secretRef")
       storagePool <- c.get[Option[String]]("storagePool")
       gateway <- c.get[String]("gateway")
       protectionDomain <- c.get[Option[String]]("protectionDomain")
       volumeName <- c.get[Option[String]]("volumeName")
       sslEnabled <- c.get[Option[Boolean]]("sslEnabled")
       storageMode <- c.get[Option[String]]("storageMode")
    } yield io.k8s.api.core.v1.ScaleIOPersistentVolumeSource(
      system = system,
      readOnly = readOnly,
      fsType = fsType,
      secretRef = secretRef,
      storagePool = storagePool,
      gateway = gateway,
      protectionDomain = protectionDomain,
      volumeName = volumeName,
      sslEnabled = sslEnabled,
      storageMode = storageMode
    )

    implicit lazy val io_k8s_api_batch_v1PodFailurePolicyEncoder : Encoder[io.k8s.api.batch.v1.PodFailurePolicy] = o =>
      Json.obj(
        "rules" -> o.rules.asJson
      )
    implicit lazy val io_k8s_api_batch_v1PodFailurePolicyDecoder : Decoder[io.k8s.api.batch.v1.PodFailurePolicy] = (c: HCursor) => for {
       rules <- c.get[Seq[io.k8s.api.batch.v1.PodFailurePolicyRule]]("rules")
    } yield io.k8s.api.batch.v1.PodFailurePolicy(
      rules = rules
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta2QueuingConfigurationEncoder : Encoder[io.k8s.api.flowcontrol.v1beta2.QueuingConfiguration] = o =>
      Json.obj(
        "handSize" -> o.handSize.asJson,
      "queueLengthLimit" -> o.queueLengthLimit.asJson,
      "queues" -> o.queues.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta2QueuingConfigurationDecoder : Decoder[io.k8s.api.flowcontrol.v1beta2.QueuingConfiguration] = (c: HCursor) => for {
       handSize <- c.get[Option[Int]]("handSize")
       queueLengthLimit <- c.get[Option[Int]]("queueLengthLimit")
       queues <- c.get[Option[Int]]("queues")
    } yield io.k8s.api.flowcontrol.v1beta2.QueuingConfiguration(
      handSize = handSize,
      queueLengthLimit = queueLengthLimit,
      queues = queues
    )

    implicit lazy val io_k8s_api_networking_v1NetworkPolicyIngressRuleEncoder : Encoder[io.k8s.api.networking.v1.NetworkPolicyIngressRule] = o =>
      Json.obj(
        "from" -> o.from.asJson,
      "ports" -> o.ports.asJson
      )
    implicit lazy val io_k8s_api_networking_v1NetworkPolicyIngressRuleDecoder : Decoder[io.k8s.api.networking.v1.NetworkPolicyIngressRule] = (c: HCursor) => for {
       from <- c.get[Option[Seq[io.k8s.api.networking.v1.NetworkPolicyPeer]]]("from")
       ports <- c.get[Option[Seq[io.k8s.api.networking.v1.NetworkPolicyPort]]]("ports")
    } yield io.k8s.api.networking.v1.NetworkPolicyIngressRule(
      from = from,
      ports = ports
    )

    implicit lazy val io_k8s_api_core_v1LoadBalancerIngressEncoder : Encoder[io.k8s.api.core.v1.LoadBalancerIngress] = o =>
      Json.obj(
        "hostname" -> o.hostname.asJson,
      "ip" -> o.ip.asJson,
      "ports" -> o.ports.asJson
      )
    implicit lazy val io_k8s_api_core_v1LoadBalancerIngressDecoder : Decoder[io.k8s.api.core.v1.LoadBalancerIngress] = (c: HCursor) => for {
       hostname <- c.get[Option[String]]("hostname")
       ip <- c.get[Option[String]]("ip")
       ports <- c.get[Option[Seq[io.k8s.api.core.v1.PortStatus]]]("ports")
    } yield io.k8s.api.core.v1.LoadBalancerIngress(
      hostname = hostname,
      ip = ip,
      ports = ports
    )

    implicit lazy val io_k8s_api_apiserverinternal_v1alpha1ServerStorageVersionEncoder : Encoder[io.k8s.api.apiserverinternal.v1alpha1.ServerStorageVersion] = o =>
      Json.obj(
        "apiServerID" -> o.apiServerID.asJson,
      "decodableVersions" -> o.decodableVersions.asJson,
      "encodingVersion" -> o.encodingVersion.asJson
      )
    implicit lazy val io_k8s_api_apiserverinternal_v1alpha1ServerStorageVersionDecoder : Decoder[io.k8s.api.apiserverinternal.v1alpha1.ServerStorageVersion] = (c: HCursor) => for {
       apiServerID <- c.get[Option[String]]("apiServerID")
       decodableVersions <- c.get[Option[Seq[String]]]("decodableVersions")
       encodingVersion <- c.get[Option[String]]("encodingVersion")
    } yield io.k8s.api.apiserverinternal.v1alpha1.ServerStorageVersion(
      apiServerID = apiServerID,
      decodableVersions = decodableVersions,
      encodingVersion = encodingVersion
    )

    implicit lazy val io_k8s_api_autoscaling_v1HorizontalPodAutoscalerSpecEncoder : Encoder[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec] = o =>
      Json.obj(
        "maxReplicas" -> o.maxReplicas.asJson,
      "minReplicas" -> o.minReplicas.asJson,
      "scaleTargetRef" -> o.scaleTargetRef.asJson,
      "targetCPUUtilizationPercentage" -> o.targetCPUUtilizationPercentage.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v1HorizontalPodAutoscalerSpecDecoder : Decoder[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec] = (c: HCursor) => for {
       maxReplicas <- c.get[Int]("maxReplicas")
       minReplicas <- c.get[Option[Int]]("minReplicas")
       scaleTargetRef <- c.get[io.k8s.api.autoscaling.v1.CrossVersionObjectReference]("scaleTargetRef")
       targetCPUUtilizationPercentage <- c.get[Option[Int]]("targetCPUUtilizationPercentage")
    } yield io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec(
      maxReplicas = maxReplicas,
      minReplicas = minReplicas,
      scaleTargetRef = scaleTargetRef,
      targetCPUUtilizationPercentage = targetCPUUtilizationPercentage
    )

    implicit lazy val io_k8s_api_core_v1PersistentVolumeSpecEncoder : Encoder[io.k8s.api.core.v1.PersistentVolumeSpec] = o =>
      Json.obj(
        "scaleIO" -> o.scaleIO.asJson,
      "csi" -> o.csi.asJson,
      "accessModes" -> o.accessModes.asJson,
      "mountOptions" -> o.mountOptions.asJson,
      "nodeAffinity" -> o.nodeAffinity.asJson,
      "azureDisk" -> o.azureDisk.asJson,
      "azureFile" -> o.azureFile.asJson,
      "hostPath" -> o.hostPath.asJson,
      "rbd" -> o.rbd.asJson,
      "portworxVolume" -> o.portworxVolume.asJson,
      "persistentVolumeReclaimPolicy" -> o.persistentVolumeReclaimPolicy.asJson,
      "glusterfs" -> o.glusterfs.asJson,
      "volumeMode" -> o.volumeMode.asJson,
      "flocker" -> o.flocker.asJson,
      "claimRef" -> o.claimRef.asJson,
      "fc" -> o.fc.asJson,
      "local" -> o.local.asJson,
      "storageClassName" -> o.storageClassName.asJson,
      "photonPersistentDisk" -> o.photonPersistentDisk.asJson,
      "gcePersistentDisk" -> o.gcePersistentDisk.asJson,
      "vsphereVolume" -> o.vsphereVolume.asJson,
      "iscsi" -> o.iscsi.asJson,
      "cinder" -> o.cinder.asJson,
      "cephfs" -> o.cephfs.asJson,
      "awsElasticBlockStore" -> o.awsElasticBlockStore.asJson,
      "flexVolume" -> o.flexVolume.asJson,
      "nfs" -> o.nfs.asJson,
      "quobyte" -> o.quobyte.asJson,
      "storageos" -> o.storageos.asJson,
      "capacity" -> o.capacity.asJson
      )
    implicit lazy val io_k8s_api_core_v1PersistentVolumeSpecDecoder : Decoder[io.k8s.api.core.v1.PersistentVolumeSpec] = (c: HCursor) => for {
       scaleIO <- c.get[Option[io.k8s.api.core.v1.ScaleIOPersistentVolumeSource]]("scaleIO")
       csi <- c.get[Option[io.k8s.api.core.v1.CSIPersistentVolumeSource]]("csi")
       accessModes <- c.get[Option[Seq[String]]]("accessModes")
       mountOptions <- c.get[Option[Seq[String]]]("mountOptions")
       nodeAffinity <- c.get[Option[io.k8s.api.core.v1.VolumeNodeAffinity]]("nodeAffinity")
       azureDisk <- c.get[Option[io.k8s.api.core.v1.AzureDiskVolumeSource]]("azureDisk")
       azureFile <- c.get[Option[io.k8s.api.core.v1.AzureFilePersistentVolumeSource]]("azureFile")
       hostPath <- c.get[Option[io.k8s.api.core.v1.HostPathVolumeSource]]("hostPath")
       rbd <- c.get[Option[io.k8s.api.core.v1.RBDPersistentVolumeSource]]("rbd")
       portworxVolume <- c.get[Option[io.k8s.api.core.v1.PortworxVolumeSource]]("portworxVolume")
       persistentVolumeReclaimPolicy <- c.get[Option[String]]("persistentVolumeReclaimPolicy")
       glusterfs <- c.get[Option[io.k8s.api.core.v1.GlusterfsPersistentVolumeSource]]("glusterfs")
       volumeMode <- c.get[Option[String]]("volumeMode")
       flocker <- c.get[Option[io.k8s.api.core.v1.FlockerVolumeSource]]("flocker")
       claimRef <- c.get[Option[io.k8s.api.core.v1.ObjectReference]]("claimRef")
       fc <- c.get[Option[io.k8s.api.core.v1.FCVolumeSource]]("fc")
       local <- c.get[Option[io.k8s.api.core.v1.LocalVolumeSource]]("local")
       storageClassName <- c.get[Option[String]]("storageClassName")
       photonPersistentDisk <- c.get[Option[io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource]]("photonPersistentDisk")
       gcePersistentDisk <- c.get[Option[io.k8s.api.core.v1.GCEPersistentDiskVolumeSource]]("gcePersistentDisk")
       vsphereVolume <- c.get[Option[io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource]]("vsphereVolume")
       iscsi <- c.get[Option[io.k8s.api.core.v1.ISCSIPersistentVolumeSource]]("iscsi")
       cinder <- c.get[Option[io.k8s.api.core.v1.CinderPersistentVolumeSource]]("cinder")
       cephfs <- c.get[Option[io.k8s.api.core.v1.CephFSPersistentVolumeSource]]("cephfs")
       awsElasticBlockStore <- c.get[Option[io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource]]("awsElasticBlockStore")
       flexVolume <- c.get[Option[io.k8s.api.core.v1.FlexPersistentVolumeSource]]("flexVolume")
       nfs <- c.get[Option[io.k8s.api.core.v1.NFSVolumeSource]]("nfs")
       quobyte <- c.get[Option[io.k8s.api.core.v1.QuobyteVolumeSource]]("quobyte")
       storageos <- c.get[Option[io.k8s.api.core.v1.StorageOSPersistentVolumeSource]]("storageos")
       capacity <- c.get[Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]]("capacity")
    } yield io.k8s.api.core.v1.PersistentVolumeSpec(
      scaleIO = scaleIO,
      csi = csi,
      accessModes = accessModes,
      mountOptions = mountOptions,
      nodeAffinity = nodeAffinity,
      azureDisk = azureDisk,
      azureFile = azureFile,
      hostPath = hostPath,
      rbd = rbd,
      portworxVolume = portworxVolume,
      persistentVolumeReclaimPolicy = persistentVolumeReclaimPolicy,
      glusterfs = glusterfs,
      volumeMode = volumeMode,
      flocker = flocker,
      claimRef = claimRef,
      fc = fc,
      local = local,
      storageClassName = storageClassName,
      photonPersistentDisk = photonPersistentDisk,
      gcePersistentDisk = gcePersistentDisk,
      vsphereVolume = vsphereVolume,
      iscsi = iscsi,
      cinder = cinder,
      cephfs = cephfs,
      awsElasticBlockStore = awsElasticBlockStore,
      flexVolume = flexVolume,
      nfs = nfs,
      quobyte = quobyte,
      storageos = storageos,
      capacity = capacity
    )

    implicit lazy val io_k8s_api_core_v1PodSecurityContextEncoder : Encoder[io.k8s.api.core.v1.PodSecurityContext] = o =>
      Json.obj(
        "fsGroupChangePolicy" -> o.fsGroupChangePolicy.asJson,
      "sysctls" -> o.sysctls.asJson,
      "fsGroup" -> o.fsGroup.asJson,
      "supplementalGroups" -> o.supplementalGroups.asJson,
      "runAsGroup" -> o.runAsGroup.asJson,
      "seccompProfile" -> o.seccompProfile.asJson,
      "windowsOptions" -> o.windowsOptions.asJson,
      "seLinuxOptions" -> o.seLinuxOptions.asJson,
      "runAsUser" -> o.runAsUser.asJson,
      "runAsNonRoot" -> o.runAsNonRoot.asJson
      )
    implicit lazy val io_k8s_api_core_v1PodSecurityContextDecoder : Decoder[io.k8s.api.core.v1.PodSecurityContext] = (c: HCursor) => for {
       fsGroupChangePolicy <- c.get[Option[String]]("fsGroupChangePolicy")
       sysctls <- c.get[Option[Seq[io.k8s.api.core.v1.Sysctl]]]("sysctls")
       fsGroup <- c.get[Option[Int]]("fsGroup")
       supplementalGroups <- c.get[Option[Seq[Int]]]("supplementalGroups")
       runAsGroup <- c.get[Option[Int]]("runAsGroup")
       seccompProfile <- c.get[Option[io.k8s.api.core.v1.SeccompProfile]]("seccompProfile")
       windowsOptions <- c.get[Option[io.k8s.api.core.v1.WindowsSecurityContextOptions]]("windowsOptions")
       seLinuxOptions <- c.get[Option[io.k8s.api.core.v1.SELinuxOptions]]("seLinuxOptions")
       runAsUser <- c.get[Option[Int]]("runAsUser")
       runAsNonRoot <- c.get[Option[Boolean]]("runAsNonRoot")
    } yield io.k8s.api.core.v1.PodSecurityContext(
      fsGroupChangePolicy = fsGroupChangePolicy,
      sysctls = sysctls,
      fsGroup = fsGroup,
      supplementalGroups = supplementalGroups,
      runAsGroup = runAsGroup,
      seccompProfile = seccompProfile,
      windowsOptions = windowsOptions,
      seLinuxOptions = seLinuxOptions,
      runAsUser = runAsUser,
      runAsNonRoot = runAsNonRoot
    )

    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1PreconditionsEncoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.Preconditions] = o =>
      Json.obj(
        "resourceVersion" -> o.resourceVersion.asJson,
      "uid" -> o.uid.asJson
      )
    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1PreconditionsDecoder : Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.Preconditions] = (c: HCursor) => for {
       resourceVersion <- c.get[Option[String]]("resourceVersion")
       uid <- c.get[Option[String]]("uid")
    } yield io.k8s.apimachinery.pkg.apis.meta.v1.Preconditions(
      resourceVersion = resourceVersion,
      uid = uid
    )

    implicit lazy val io_k8s_api_core_v1PhotonPersistentDiskVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource] = o =>
      Json.obj(
        "fsType" -> o.fsType.asJson,
      "pdID" -> o.pdID.asJson
      )
    implicit lazy val io_k8s_api_core_v1PhotonPersistentDiskVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource] = (c: HCursor) => for {
       fsType <- c.get[Option[String]]("fsType")
       pdID <- c.get[String]("pdID")
    } yield io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource(
      fsType = fsType,
      pdID = pdID
    )

    implicit lazy val io_k8s_api_storage_v1VolumeErrorEncoder : Encoder[io.k8s.api.storage.v1.VolumeError] = o =>
      Json.obj(
        "message" -> o.message.asJson,
      "time" -> o.time.asJson
      )
    implicit lazy val io_k8s_api_storage_v1VolumeErrorDecoder : Decoder[io.k8s.api.storage.v1.VolumeError] = (c: HCursor) => for {
       message <- c.get[Option[String]]("message")
       time <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("time")
    } yield io.k8s.api.storage.v1.VolumeError(
      message = message,
      time = time
    )

    implicit lazy val io_k8s_api_apps_v1DaemonSetSpecEncoder : Encoder[io.k8s.api.apps.v1.DaemonSetSpec] = o =>
      Json.obj(
        "minReadySeconds" -> o.minReadySeconds.asJson,
      "revisionHistoryLimit" -> o.revisionHistoryLimit.asJson,
      "template" -> o.template.asJson,
      "selector" -> o.selector.asJson,
      "updateStrategy" -> o.updateStrategy.asJson
      )
    implicit lazy val io_k8s_api_apps_v1DaemonSetSpecDecoder : Decoder[io.k8s.api.apps.v1.DaemonSetSpec] = (c: HCursor) => for {
       minReadySeconds <- c.get[Option[Int]]("minReadySeconds")
       revisionHistoryLimit <- c.get[Option[Int]]("revisionHistoryLimit")
       template <- c.get[io.k8s.api.core.v1.PodTemplateSpec]("template")
       selector <- c.get[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]("selector")
       updateStrategy <- c.get[Option[io.k8s.api.apps.v1.DaemonSetUpdateStrategy]]("updateStrategy")
    } yield io.k8s.api.apps.v1.DaemonSetSpec(
      minReadySeconds = minReadySeconds,
      revisionHistoryLimit = revisionHistoryLimit,
      template = template,
      selector = selector,
      updateStrategy = updateStrategy
    )

    implicit lazy val io_k8s_api_core_v1HTTPHeaderEncoder : Encoder[io.k8s.api.core.v1.HTTPHeader] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "value" -> o.value.asJson
      )
    implicit lazy val io_k8s_api_core_v1HTTPHeaderDecoder : Decoder[io.k8s.api.core.v1.HTTPHeader] = (c: HCursor) => for {
       name <- c.get[String]("name")
       value <- c.get[String]("value")
    } yield io.k8s.api.core.v1.HTTPHeader(
      name = name,
      value = value
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta2ResourcePolicyRuleEncoder : Encoder[io.k8s.api.flowcontrol.v1beta2.ResourcePolicyRule] = o =>
      Json.obj(
        "clusterScope" -> o.clusterScope.asJson,
      "verbs" -> o.verbs.asJson,
      "apiGroups" -> o.apiGroups.asJson,
      "namespaces" -> o.namespaces.asJson,
      "resources" -> o.resources.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta2ResourcePolicyRuleDecoder : Decoder[io.k8s.api.flowcontrol.v1beta2.ResourcePolicyRule] = (c: HCursor) => for {
       clusterScope <- c.get[Option[Boolean]]("clusterScope")
       verbs <- c.get[Seq[String]]("verbs")
       apiGroups <- c.get[Seq[String]]("apiGroups")
       namespaces <- c.get[Option[Seq[String]]]("namespaces")
       resources <- c.get[Seq[String]]("resources")
    } yield io.k8s.api.flowcontrol.v1beta2.ResourcePolicyRule(
      clusterScope = clusterScope,
      verbs = verbs,
      apiGroups = apiGroups,
      namespaces = namespaces,
      resources = resources
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta2UserSubjectEncoder : Encoder[io.k8s.api.flowcontrol.v1beta2.UserSubject] = o =>
      Json.obj(
        "name" -> o.name.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta2UserSubjectDecoder : Decoder[io.k8s.api.flowcontrol.v1beta2.UserSubject] = (c: HCursor) => for {
       name <- c.get[String]("name")
    } yield io.k8s.api.flowcontrol.v1beta2.UserSubject(
      name = name
    )

    implicit lazy val io_k8s_api_storage_v1VolumeAttachmentStatusEncoder : Encoder[io.k8s.api.storage.v1.VolumeAttachmentStatus] = o =>
      Json.obj(
        "attachError" -> o.attachError.asJson,
      "attached" -> o.attached.asJson,
      "attachmentMetadata" -> o.attachmentMetadata.asJson,
      "detachError" -> o.detachError.asJson
      )
    implicit lazy val io_k8s_api_storage_v1VolumeAttachmentStatusDecoder : Decoder[io.k8s.api.storage.v1.VolumeAttachmentStatus] = (c: HCursor) => for {
       attachError <- c.get[Option[io.k8s.api.storage.v1.VolumeError]]("attachError")
       attached <- c.get[Boolean]("attached")
       attachmentMetadata <- c.get[Option[Map[String, String]]]("attachmentMetadata")
       detachError <- c.get[Option[io.k8s.api.storage.v1.VolumeError]]("detachError")
    } yield io.k8s.api.storage.v1.VolumeAttachmentStatus(
      attachError = attachError,
      attached = attached,
      attachmentMetadata = attachmentMetadata,
      detachError = detachError
    )

    implicit lazy val io_k8s_api_core_v1AzureFileVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.AzureFileVolumeSource] = o =>
      Json.obj(
        "readOnly" -> o.readOnly.asJson,
      "secretName" -> o.secretName.asJson,
      "shareName" -> o.shareName.asJson
      )
    implicit lazy val io_k8s_api_core_v1AzureFileVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.AzureFileVolumeSource] = (c: HCursor) => for {
       readOnly <- c.get[Option[Boolean]]("readOnly")
       secretName <- c.get[String]("secretName")
       shareName <- c.get[String]("shareName")
    } yield io.k8s.api.core.v1.AzureFileVolumeSource(
      readOnly = readOnly,
      secretName = secretName,
      shareName = shareName
    )

    implicit lazy val io_k8s_api_discovery_v1EndpointPortEncoder : Encoder[io.k8s.api.discovery.v1.EndpointPort] = o =>
      Json.obj(
        "appProtocol" -> o.appProtocol.asJson,
      "name" -> o.name.asJson,
      "port" -> o.port.asJson,
      "protocol" -> o.protocol.asJson
      )
    implicit lazy val io_k8s_api_discovery_v1EndpointPortDecoder : Decoder[io.k8s.api.discovery.v1.EndpointPort] = (c: HCursor) => for {
       appProtocol <- c.get[Option[String]]("appProtocol")
       name <- c.get[Option[String]]("name")
       port <- c.get[Option[Int]]("port")
       protocol <- c.get[Option[String]]("protocol")
    } yield io.k8s.api.discovery.v1.EndpointPort(
      appProtocol = appProtocol,
      name = name,
      port = port,
      protocol = protocol
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta1LimitResponseEncoder : Encoder[io.k8s.api.flowcontrol.v1beta1.LimitResponse] = o =>
      Json.obj(
        "queuing" -> o.queuing.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta1LimitResponseDecoder : Decoder[io.k8s.api.flowcontrol.v1beta1.LimitResponse] = (c: HCursor) => for {
       queuing <- c.get[Option[io.k8s.api.flowcontrol.v1beta1.QueuingConfiguration]]("queuing")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.flowcontrol.v1beta1.LimitResponse(
      queuing = queuing,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_networking_v1NetworkPolicyPortEncoder : Encoder[io.k8s.api.networking.v1.NetworkPolicyPort] = o =>
      Json.obj(
        "endPort" -> o.endPort.asJson,
      "port" -> o.port.asJson,
      "protocol" -> o.protocol.asJson
      )
    implicit lazy val io_k8s_api_networking_v1NetworkPolicyPortDecoder : Decoder[io.k8s.api.networking.v1.NetworkPolicyPort] = (c: HCursor) => for {
       endPort <- c.get[Option[Int]]("endPort")
       port <- c.get[Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString]]("port")
       protocol <- c.get[Option[String]]("protocol")
    } yield io.k8s.api.networking.v1.NetworkPolicyPort(
      endPort = endPort,
      port = port,
      protocol = protocol
    )

    implicit lazy val io_k8s_api_autoscaling_v2HorizontalPodAutoscalerBehaviorEncoder : Encoder[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerBehavior] = o =>
      Json.obj(
        "scaleDown" -> o.scaleDown.asJson,
      "scaleUp" -> o.scaleUp.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2HorizontalPodAutoscalerBehaviorDecoder : Decoder[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerBehavior] = (c: HCursor) => for {
       scaleDown <- c.get[Option[io.k8s.api.autoscaling.v2.HPAScalingRules]]("scaleDown")
       scaleUp <- c.get[Option[io.k8s.api.autoscaling.v2.HPAScalingRules]]("scaleUp")
    } yield io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerBehavior(
      scaleDown = scaleDown,
      scaleUp = scaleUp
    )

    implicit lazy val io_k8s_api_policy_v1PodDisruptionBudgetSpecEncoder : Encoder[io.k8s.api.policy.v1.PodDisruptionBudgetSpec] = o =>
      Json.obj(
        "maxUnavailable" -> o.maxUnavailable.asJson,
      "minAvailable" -> o.minAvailable.asJson,
      "selector" -> o.selector.asJson
      )
    implicit lazy val io_k8s_api_policy_v1PodDisruptionBudgetSpecDecoder : Decoder[io.k8s.api.policy.v1.PodDisruptionBudgetSpec] = (c: HCursor) => for {
       maxUnavailable <- c.get[Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString]]("maxUnavailable")
       minAvailable <- c.get[Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString]]("minAvailable")
       selector <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]]("selector")
    } yield io.k8s.api.policy.v1.PodDisruptionBudgetSpec(
      maxUnavailable = maxUnavailable,
      minAvailable = minAvailable,
      selector = selector
    )

    implicit lazy val io_k8s_api_core_v1SecretProjectionEncoder : Encoder[io.k8s.api.core.v1.SecretProjection] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "name" -> o.name.asJson,
      "optional" -> o.optional.asJson
      )
    implicit lazy val io_k8s_api_core_v1SecretProjectionDecoder : Decoder[io.k8s.api.core.v1.SecretProjection] = (c: HCursor) => for {
       items <- c.get[Option[Seq[io.k8s.api.core.v1.KeyToPath]]]("items")
       name <- c.get[Option[String]]("name")
       optional <- c.get[Option[Boolean]]("optional")
    } yield io.k8s.api.core.v1.SecretProjection(
      items = items,
      name = name,
      optional = optional
    )

    implicit lazy val io_k8s_api_core_v1EventSourceEncoder : Encoder[io.k8s.api.core.v1.EventSource] = o =>
      Json.obj(
        "component" -> o.component.asJson,
      "host" -> o.host.asJson
      )
    implicit lazy val io_k8s_api_core_v1EventSourceDecoder : Decoder[io.k8s.api.core.v1.EventSource] = (c: HCursor) => for {
       component <- c.get[Option[String]]("component")
       host <- c.get[Option[String]]("host")
    } yield io.k8s.api.core.v1.EventSource(
      component = component,
      host = host
    )

    implicit lazy val io_k8s_api_core_v1PodIPEncoder : Encoder[io.k8s.api.core.v1.PodIP] = o =>
      Json.obj(
        "ip" -> o.ip.asJson
      )
    implicit lazy val io_k8s_api_core_v1PodIPDecoder : Decoder[io.k8s.api.core.v1.PodIP] = (c: HCursor) => for {
       ip <- c.get[Option[String]]("ip")
    } yield io.k8s.api.core.v1.PodIP(
      ip = ip
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta2PolicyRulesWithSubjectsEncoder : Encoder[io.k8s.api.flowcontrol.v1beta2.PolicyRulesWithSubjects] = o =>
      Json.obj(
        "nonResourceRules" -> o.nonResourceRules.asJson,
      "resourceRules" -> o.resourceRules.asJson,
      "subjects" -> o.subjects.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta2PolicyRulesWithSubjectsDecoder : Decoder[io.k8s.api.flowcontrol.v1beta2.PolicyRulesWithSubjects] = (c: HCursor) => for {
       nonResourceRules <- c.get[Option[Seq[io.k8s.api.flowcontrol.v1beta2.NonResourcePolicyRule]]]("nonResourceRules")
       resourceRules <- c.get[Option[Seq[io.k8s.api.flowcontrol.v1beta2.ResourcePolicyRule]]]("resourceRules")
       subjects <- c.get[Seq[io.k8s.api.flowcontrol.v1beta2.Subject]]("subjects")
    } yield io.k8s.api.flowcontrol.v1beta2.PolicyRulesWithSubjects(
      nonResourceRules = nonResourceRules,
      resourceRules = resourceRules,
      subjects = subjects
    )

    implicit lazy val io_k8s_api_core_v1NodeSystemInfoEncoder : Encoder[io.k8s.api.core.v1.NodeSystemInfo] = o =>
      Json.obj(
        "systemUUID" -> o.systemUUID.asJson,
      "osImage" -> o.osImage.asJson,
      "machineID" -> o.machineID.asJson,
      "bootID" -> o.bootID.asJson,
      "architecture" -> o.architecture.asJson,
      "kubeletVersion" -> o.kubeletVersion.asJson,
      "operatingSystem" -> o.operatingSystem.asJson,
      "kubeProxyVersion" -> o.kubeProxyVersion.asJson,
      "containerRuntimeVersion" -> o.containerRuntimeVersion.asJson,
      "kernelVersion" -> o.kernelVersion.asJson
      )
    implicit lazy val io_k8s_api_core_v1NodeSystemInfoDecoder : Decoder[io.k8s.api.core.v1.NodeSystemInfo] = (c: HCursor) => for {
       systemUUID <- c.get[String]("systemUUID")
       osImage <- c.get[String]("osImage")
       machineID <- c.get[String]("machineID")
       bootID <- c.get[String]("bootID")
       architecture <- c.get[String]("architecture")
       kubeletVersion <- c.get[String]("kubeletVersion")
       operatingSystem <- c.get[String]("operatingSystem")
       kubeProxyVersion <- c.get[String]("kubeProxyVersion")
       containerRuntimeVersion <- c.get[String]("containerRuntimeVersion")
       kernelVersion <- c.get[String]("kernelVersion")
    } yield io.k8s.api.core.v1.NodeSystemInfo(
      systemUUID = systemUUID,
      osImage = osImage,
      machineID = machineID,
      bootID = bootID,
      architecture = architecture,
      kubeletVersion = kubeletVersion,
      operatingSystem = operatingSystem,
      kubeProxyVersion = kubeProxyVersion,
      containerRuntimeVersion = containerRuntimeVersion,
      kernelVersion = kernelVersion
    )

    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceDefinitionSpecEncoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec] = o =>
      Json.obj(
        "conversion" -> o.conversion.asJson,
      "versions" -> o.versions.asJson,
      "scope" -> o.scope.asJson,
      "names" -> o.names.asJson,
      "preserveUnknownFields" -> o.preserveUnknownFields.asJson,
      "group" -> o.group.asJson
      )
    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceDefinitionSpecDecoder : Decoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec] = (c: HCursor) => for {
       conversion <- c.get[Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion]]("conversion")
       versions <- c.get[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion]]("versions")
       scope <- c.get[String]("scope")
       names <- c.get[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames]("names")
       preserveUnknownFields <- c.get[Option[Boolean]]("preserveUnknownFields")
       group <- c.get[String]("group")
    } yield io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec(
      conversion = conversion,
      versions = versions,
      scope = scope,
      names = names,
      preserveUnknownFields = preserveUnknownFields,
      group = group
    )

    implicit lazy val io_k8s_api_node_v1OverheadEncoder : Encoder[io.k8s.api.node.v1.Overhead] = o =>
      Json.obj(
        "podFixed" -> o.podFixed.asJson
      )
    implicit lazy val io_k8s_api_node_v1OverheadDecoder : Decoder[io.k8s.api.node.v1.Overhead] = (c: HCursor) => for {
       podFixed <- c.get[Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]]("podFixed")
    } yield io.k8s.api.node.v1.Overhead(
      podFixed = podFixed
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta1PolicyRulesWithSubjectsEncoder : Encoder[io.k8s.api.flowcontrol.v1beta1.PolicyRulesWithSubjects] = o =>
      Json.obj(
        "nonResourceRules" -> o.nonResourceRules.asJson,
      "resourceRules" -> o.resourceRules.asJson,
      "subjects" -> o.subjects.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta1PolicyRulesWithSubjectsDecoder : Decoder[io.k8s.api.flowcontrol.v1beta1.PolicyRulesWithSubjects] = (c: HCursor) => for {
       nonResourceRules <- c.get[Option[Seq[io.k8s.api.flowcontrol.v1beta1.NonResourcePolicyRule]]]("nonResourceRules")
       resourceRules <- c.get[Option[Seq[io.k8s.api.flowcontrol.v1beta1.ResourcePolicyRule]]]("resourceRules")
       subjects <- c.get[Seq[io.k8s.api.flowcontrol.v1beta1.Subject]]("subjects")
    } yield io.k8s.api.flowcontrol.v1beta1.PolicyRulesWithSubjects(
      nonResourceRules = nonResourceRules,
      resourceRules = resourceRules,
      subjects = subjects
    )

    implicit lazy val io_k8s_api_storage_v1CSINodeSpecEncoder : Encoder[io.k8s.api.storage.v1.CSINodeSpec] = o =>
      Json.obj(
        "drivers" -> o.drivers.asJson
      )
    implicit lazy val io_k8s_api_storage_v1CSINodeSpecDecoder : Decoder[io.k8s.api.storage.v1.CSINodeSpec] = (c: HCursor) => for {
       drivers <- c.get[Seq[io.k8s.api.storage.v1.CSINodeDriver]]("drivers")
    } yield io.k8s.api.storage.v1.CSINodeSpec(
      drivers = drivers
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2ContainerResourceMetricStatusEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.ContainerResourceMetricStatus] = o =>
      Json.obj(
        "container" -> o.container.asJson,
      "current" -> o.current.asJson,
      "name" -> o.name.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2ContainerResourceMetricStatusDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.ContainerResourceMetricStatus] = (c: HCursor) => for {
       container <- c.get[String]("container")
       current <- c.get[io.k8s.api.autoscaling.v2beta2.MetricValueStatus]("current")
       name <- c.get[String]("name")
    } yield io.k8s.api.autoscaling.v2beta2.ContainerResourceMetricStatus(
      container = container,
      current = current,
      name = name
    )

    implicit lazy val io_k8s_api_core_v1ResourceQuotaStatusEncoder : Encoder[io.k8s.api.core.v1.ResourceQuotaStatus] = o =>
      Json.obj(
        "hard" -> o.hard.asJson,
      "used" -> o.used.asJson
      )
    implicit lazy val io_k8s_api_core_v1ResourceQuotaStatusDecoder : Decoder[io.k8s.api.core.v1.ResourceQuotaStatus] = (c: HCursor) => for {
       hard <- c.get[Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]]("hard")
       used <- c.get[Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]]("used")
    } yield io.k8s.api.core.v1.ResourceQuotaStatus(
      hard = hard,
      used = used
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta2FlowSchemaStatusEncoder : Encoder[io.k8s.api.flowcontrol.v1beta2.FlowSchemaStatus] = o =>
      Json.obj(
        "conditions" -> o.conditions.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta2FlowSchemaStatusDecoder : Decoder[io.k8s.api.flowcontrol.v1beta2.FlowSchemaStatus] = (c: HCursor) => for {
       conditions <- c.get[Option[Seq[io.k8s.api.flowcontrol.v1beta2.FlowSchemaCondition]]]("conditions")
    } yield io.k8s.api.flowcontrol.v1beta2.FlowSchemaStatus(
      conditions = conditions
    )

    implicit lazy val io_k8s_api_core_v1CephFSPersistentVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.CephFSPersistentVolumeSource] = o =>
      Json.obj(
        "path" -> o.path.asJson,
      "readOnly" -> o.readOnly.asJson,
      "secretRef" -> o.secretRef.asJson,
      "secretFile" -> o.secretFile.asJson,
      "monitors" -> o.monitors.asJson,
      "user" -> o.user.asJson
      )
    implicit lazy val io_k8s_api_core_v1CephFSPersistentVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.CephFSPersistentVolumeSource] = (c: HCursor) => for {
       path <- c.get[Option[String]]("path")
       readOnly <- c.get[Option[Boolean]]("readOnly")
       secretRef <- c.get[Option[io.k8s.api.core.v1.SecretReference]]("secretRef")
       secretFile <- c.get[Option[String]]("secretFile")
       monitors <- c.get[Seq[String]]("monitors")
       user <- c.get[Option[String]]("user")
    } yield io.k8s.api.core.v1.CephFSPersistentVolumeSource(
      path = path,
      readOnly = readOnly,
      secretRef = secretRef,
      secretFile = secretFile,
      monitors = monitors,
      user = user
    )

    implicit lazy val io_k8s_api_core_v1ScopeSelectorEncoder : Encoder[io.k8s.api.core.v1.ScopeSelector] = o =>
      Json.obj(
        "matchExpressions" -> o.matchExpressions.asJson
      )
    implicit lazy val io_k8s_api_core_v1ScopeSelectorDecoder : Decoder[io.k8s.api.core.v1.ScopeSelector] = (c: HCursor) => for {
       matchExpressions <- c.get[Option[Seq[io.k8s.api.core.v1.ScopedResourceSelectorRequirement]]]("matchExpressions")
    } yield io.k8s.api.core.v1.ScopeSelector(
      matchExpressions = matchExpressions
    )

    implicit lazy val io_k8s_api_core_v1VsphereVirtualDiskVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource] = o =>
      Json.obj(
        "fsType" -> o.fsType.asJson,
      "storagePolicyID" -> o.storagePolicyID.asJson,
      "storagePolicyName" -> o.storagePolicyName.asJson,
      "volumePath" -> o.volumePath.asJson
      )
    implicit lazy val io_k8s_api_core_v1VsphereVirtualDiskVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource] = (c: HCursor) => for {
       fsType <- c.get[Option[String]]("fsType")
       storagePolicyID <- c.get[Option[String]]("storagePolicyID")
       storagePolicyName <- c.get[Option[String]]("storagePolicyName")
       volumePath <- c.get[String]("volumePath")
    } yield io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource(
      fsType = fsType,
      storagePolicyID = storagePolicyID,
      storagePolicyName = storagePolicyName,
      volumePath = volumePath
    )

    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1WebhookClientConfigEncoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookClientConfig] = o =>
      Json.obj(
        "caBundle" -> o.caBundle.asJson,
      "service" -> o.service.asJson,
      "url" -> o.url.asJson
      )
    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1WebhookClientConfigDecoder : Decoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookClientConfig] = (c: HCursor) => for {
       caBundle <- c.get[Option[String]]("caBundle")
       service <- c.get[Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ServiceReference]]("service")
       url <- c.get[Option[String]]("url")
    } yield io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookClientConfig(
      caBundle = caBundle,
      service = service,
      url = url
    )

    implicit lazy val io_k8s_api_core_v1LimitRangeItemEncoder : Encoder[io.k8s.api.core.v1.LimitRangeItem] = o =>
      Json.obj(
        "defaultRequest" -> o.defaultRequest.asJson,
      "min" -> o.min.asJson,
      "maxLimitRequestRatio" -> o.maxLimitRequestRatio.asJson,
      "max" -> o.max.asJson,
      "default" -> o.default.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_core_v1LimitRangeItemDecoder : Decoder[io.k8s.api.core.v1.LimitRangeItem] = (c: HCursor) => for {
       defaultRequest <- c.get[Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]]("defaultRequest")
       min <- c.get[Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]]("min")
       maxLimitRequestRatio <- c.get[Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]]("maxLimitRequestRatio")
       max <- c.get[Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]]("max")
       default <- c.get[Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]]("default")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.core.v1.LimitRangeItem(
      defaultRequest = defaultRequest,
      min = min,
      maxLimitRequestRatio = maxLimitRequestRatio,
      max = max,
      default = default,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_authorization_v1NonResourceRuleEncoder : Encoder[io.k8s.api.authorization.v1.NonResourceRule] = o =>
      Json.obj(
        "nonResourceURLs" -> o.nonResourceURLs.asJson,
      "verbs" -> o.verbs.asJson
      )
    implicit lazy val io_k8s_api_authorization_v1NonResourceRuleDecoder : Decoder[io.k8s.api.authorization.v1.NonResourceRule] = (c: HCursor) => for {
       nonResourceURLs <- c.get[Option[Seq[String]]]("nonResourceURLs")
       verbs <- c.get[Seq[String]]("verbs")
    } yield io.k8s.api.authorization.v1.NonResourceRule(
      nonResourceURLs = nonResourceURLs,
      verbs = verbs
    )

    implicit lazy val io_k8s_api_storage_v1TokenRequestEncoder : Encoder[io.k8s.api.storage.v1.TokenRequest] = o =>
      Json.obj(
        "audience" -> o.audience.asJson,
      "expirationSeconds" -> o.expirationSeconds.asJson
      )
    implicit lazy val io_k8s_api_storage_v1TokenRequestDecoder : Decoder[io.k8s.api.storage.v1.TokenRequest] = (c: HCursor) => for {
       audience <- c.get[String]("audience")
       expirationSeconds <- c.get[Option[Int]]("expirationSeconds")
    } yield io.k8s.api.storage.v1.TokenRequest(
      audience = audience,
      expirationSeconds = expirationSeconds
    )

    implicit lazy val io_k8s_api_core_v1LocalObjectReferenceEncoder : Encoder[io.k8s.api.core.v1.LocalObjectReference] = o =>
      Json.obj(
        "name" -> o.name.asJson
      )
    implicit lazy val io_k8s_api_core_v1LocalObjectReferenceDecoder : Decoder[io.k8s.api.core.v1.LocalObjectReference] = (c: HCursor) => for {
       name <- c.get[Option[String]]("name")
    } yield io.k8s.api.core.v1.LocalObjectReference(
      name = name
    )

    implicit lazy val io_k8s_api_core_v1DaemonEndpointEncoder : Encoder[io.k8s.api.core.v1.DaemonEndpoint] = o =>
      Json.obj(
        "Port" -> o.Port.asJson
      )
    implicit lazy val io_k8s_api_core_v1DaemonEndpointDecoder : Decoder[io.k8s.api.core.v1.DaemonEndpoint] = (c: HCursor) => for {
       Port <- c.get[Int]("Port")
    } yield io.k8s.api.core.v1.DaemonEndpoint(
      Port = Port
    )

    implicit lazy val io_k8s_api_apiserverinternal_v1alpha1StorageVersionStatusEncoder : Encoder[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionStatus] = o =>
      Json.obj(
        "commonEncodingVersion" -> o.commonEncodingVersion.asJson,
      "conditions" -> o.conditions.asJson,
      "storageVersions" -> o.storageVersions.asJson
      )
    implicit lazy val io_k8s_api_apiserverinternal_v1alpha1StorageVersionStatusDecoder : Decoder[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionStatus] = (c: HCursor) => for {
       commonEncodingVersion <- c.get[Option[String]]("commonEncodingVersion")
       conditions <- c.get[Option[Seq[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionCondition]]]("conditions")
       storageVersions <- c.get[Option[Seq[io.k8s.api.apiserverinternal.v1alpha1.ServerStorageVersion]]]("storageVersions")
    } yield io.k8s.api.apiserverinternal.v1alpha1.StorageVersionStatus(
      commonEncodingVersion = commonEncodingVersion,
      conditions = conditions,
      storageVersions = storageVersions
    )

    implicit lazy val io_k8s_api_core_v1EndpointPortEncoder : Encoder[io.k8s.api.core.v1.EndpointPort] = o =>
      Json.obj(
        "appProtocol" -> o.appProtocol.asJson,
      "name" -> o.name.asJson,
      "port" -> o.port.asJson,
      "protocol" -> o.protocol.asJson
      )
    implicit lazy val io_k8s_api_core_v1EndpointPortDecoder : Decoder[io.k8s.api.core.v1.EndpointPort] = (c: HCursor) => for {
       appProtocol <- c.get[Option[String]]("appProtocol")
       name <- c.get[Option[String]]("name")
       port <- c.get[Int]("port")
       protocol <- c.get[Option[String]]("protocol")
    } yield io.k8s.api.core.v1.EndpointPort(
      appProtocol = appProtocol,
      name = name,
      port = port,
      protocol = protocol
    )

    implicit lazy val io_k8s_api_core_v1ConfigMapVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.ConfigMapVolumeSource] = o =>
      Json.obj(
        "defaultMode" -> o.defaultMode.asJson,
      "items" -> o.items.asJson,
      "name" -> o.name.asJson,
      "optional" -> o.optional.asJson
      )
    implicit lazy val io_k8s_api_core_v1ConfigMapVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.ConfigMapVolumeSource] = (c: HCursor) => for {
       defaultMode <- c.get[Option[Int]]("defaultMode")
       items <- c.get[Option[Seq[io.k8s.api.core.v1.KeyToPath]]]("items")
       name <- c.get[Option[String]]("name")
       optional <- c.get[Option[Boolean]]("optional")
    } yield io.k8s.api.core.v1.ConfigMapVolumeSource(
      defaultMode = defaultMode,
      items = items,
      name = name,
      optional = optional
    )

    implicit lazy val io_k8s_api_core_v1NodeSelectorRequirementEncoder : Encoder[io.k8s.api.core.v1.NodeSelectorRequirement] = o =>
      Json.obj(
        "key" -> o.key.asJson,
      "operator" -> o.operator.asJson,
      "values" -> o.values.asJson
      )
    implicit lazy val io_k8s_api_core_v1NodeSelectorRequirementDecoder : Decoder[io.k8s.api.core.v1.NodeSelectorRequirement] = (c: HCursor) => for {
       key <- c.get[String]("key")
       operator <- c.get[String]("operator")
       values <- c.get[Option[Seq[String]]]("values")
    } yield io.k8s.api.core.v1.NodeSelectorRequirement(
      key = key,
      operator = operator,
      values = values
    )

    implicit lazy val io_k8s_api_apps_v1RollingUpdateDaemonSetEncoder : Encoder[io.k8s.api.apps.v1.RollingUpdateDaemonSet] = o =>
      Json.obj(
        "maxSurge" -> o.maxSurge.asJson,
      "maxUnavailable" -> o.maxUnavailable.asJson
      )
    implicit lazy val io_k8s_api_apps_v1RollingUpdateDaemonSetDecoder : Decoder[io.k8s.api.apps.v1.RollingUpdateDaemonSet] = (c: HCursor) => for {
       maxSurge <- c.get[Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString]]("maxSurge")
       maxUnavailable <- c.get[Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString]]("maxUnavailable")
    } yield io.k8s.api.apps.v1.RollingUpdateDaemonSet(
      maxSurge = maxSurge,
      maxUnavailable = maxUnavailable
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta1PriorityLevelConfigurationReferenceEncoder : Encoder[io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationReference] = o =>
      Json.obj(
        "name" -> o.name.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta1PriorityLevelConfigurationReferenceDecoder : Decoder[io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationReference] = (c: HCursor) => for {
       name <- c.get[String]("name")
    } yield io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationReference(
      name = name
    )

    implicit lazy val io_k8s_api_autoscaling_v2HorizontalPodAutoscalerConditionEncoder : Encoder[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerCondition] = o =>
      Json.obj(
        "reason" -> o.reason.asJson,
      "status" -> o.status.asJson,
      "lastTransitionTime" -> o.lastTransitionTime.asJson,
      "message" -> o.message.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2HorizontalPodAutoscalerConditionDecoder : Decoder[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerCondition] = (c: HCursor) => for {
       reason <- c.get[Option[String]]("reason")
       status <- c.get[String]("status")
       lastTransitionTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastTransitionTime")
       message <- c.get[Option[String]]("message")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerCondition(
      reason = reason,
      status = status,
      lastTransitionTime = lastTransitionTime,
      message = message,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_networking_v1IngressStatusEncoder : Encoder[io.k8s.api.networking.v1.IngressStatus] = o =>
      Json.obj(
        "loadBalancer" -> o.loadBalancer.asJson
      )
    implicit lazy val io_k8s_api_networking_v1IngressStatusDecoder : Decoder[io.k8s.api.networking.v1.IngressStatus] = (c: HCursor) => for {
       loadBalancer <- c.get[Option[io.k8s.api.core.v1.LoadBalancerStatus]]("loadBalancer")
    } yield io.k8s.api.networking.v1.IngressStatus(
      loadBalancer = loadBalancer
    )

    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceConversionEncoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion] = o =>
      Json.obj(
        "strategy" -> o.strategy.asJson,
      "webhook" -> o.webhook.asJson
      )
    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceConversionDecoder : Decoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion] = (c: HCursor) => for {
       strategy <- c.get[String]("strategy")
       webhook <- c.get[Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookConversion]]("webhook")
    } yield io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion(
      strategy = strategy,
      webhook = webhook
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta1PriorityLevelConfigurationConditionEncoder : Encoder[io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationCondition] = o =>
      Json.obj(
        "reason" -> o.reason.asJson,
      "status" -> o.status.asJson,
      "lastTransitionTime" -> o.lastTransitionTime.asJson,
      "message" -> o.message.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta1PriorityLevelConfigurationConditionDecoder : Decoder[io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationCondition] = (c: HCursor) => for {
       reason <- c.get[Option[String]]("reason")
       status <- c.get[Option[String]]("status")
       lastTransitionTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastTransitionTime")
       message <- c.get[Option[String]]("message")
       `type` <- c.get[Option[String]]("type")
    } yield io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationCondition(
      reason = reason,
      status = status,
      lastTransitionTime = lastTransitionTime,
      message = message,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_authorization_v1SubjectAccessReviewStatusEncoder : Encoder[io.k8s.api.authorization.v1.SubjectAccessReviewStatus] = o =>
      Json.obj(
        "allowed" -> o.allowed.asJson,
      "denied" -> o.denied.asJson,
      "evaluationError" -> o.evaluationError.asJson,
      "reason" -> o.reason.asJson
      )
    implicit lazy val io_k8s_api_authorization_v1SubjectAccessReviewStatusDecoder : Decoder[io.k8s.api.authorization.v1.SubjectAccessReviewStatus] = (c: HCursor) => for {
       allowed <- c.get[Boolean]("allowed")
       denied <- c.get[Option[Boolean]]("denied")
       evaluationError <- c.get[Option[String]]("evaluationError")
       reason <- c.get[Option[String]]("reason")
    } yield io.k8s.api.authorization.v1.SubjectAccessReviewStatus(
      allowed = allowed,
      denied = denied,
      evaluationError = evaluationError,
      reason = reason
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2HorizontalPodAutoscalerBehaviorEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior] = o =>
      Json.obj(
        "scaleDown" -> o.scaleDown.asJson,
      "scaleUp" -> o.scaleUp.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2HorizontalPodAutoscalerBehaviorDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior] = (c: HCursor) => for {
       scaleDown <- c.get[Option[io.k8s.api.autoscaling.v2beta2.HPAScalingRules]]("scaleDown")
       scaleUp <- c.get[Option[io.k8s.api.autoscaling.v2beta2.HPAScalingRules]]("scaleUp")
    } yield io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior(
      scaleDown = scaleDown,
      scaleUp = scaleUp
    )

    implicit lazy val io_k8s_api_core_v1WindowsSecurityContextOptionsEncoder : Encoder[io.k8s.api.core.v1.WindowsSecurityContextOptions] = o =>
      Json.obj(
        "gmsaCredentialSpec" -> o.gmsaCredentialSpec.asJson,
      "gmsaCredentialSpecName" -> o.gmsaCredentialSpecName.asJson,
      "hostProcess" -> o.hostProcess.asJson,
      "runAsUserName" -> o.runAsUserName.asJson
      )
    implicit lazy val io_k8s_api_core_v1WindowsSecurityContextOptionsDecoder : Decoder[io.k8s.api.core.v1.WindowsSecurityContextOptions] = (c: HCursor) => for {
       gmsaCredentialSpec <- c.get[Option[String]]("gmsaCredentialSpec")
       gmsaCredentialSpecName <- c.get[Option[String]]("gmsaCredentialSpecName")
       hostProcess <- c.get[Option[Boolean]]("hostProcess")
       runAsUserName <- c.get[Option[String]]("runAsUserName")
    } yield io.k8s.api.core.v1.WindowsSecurityContextOptions(
      gmsaCredentialSpec = gmsaCredentialSpec,
      gmsaCredentialSpecName = gmsaCredentialSpecName,
      hostProcess = hostProcess,
      runAsUserName = runAsUserName
    )

    implicit lazy val io_k8s_api_autoscaling_v2HPAScalingPolicyEncoder : Encoder[io.k8s.api.autoscaling.v2.HPAScalingPolicy] = o =>
      Json.obj(
        "periodSeconds" -> o.periodSeconds.asJson,
      "type" -> o.`type`.asJson,
      "value" -> o.value.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2HPAScalingPolicyDecoder : Decoder[io.k8s.api.autoscaling.v2.HPAScalingPolicy] = (c: HCursor) => for {
       periodSeconds <- c.get[Int]("periodSeconds")
       `type` <- c.get[String]("type")
       value <- c.get[Int]("value")
    } yield io.k8s.api.autoscaling.v2.HPAScalingPolicy(
      periodSeconds = periodSeconds,
      `type` = `type`,
      value = value
    )

    implicit lazy val io_k8s_api_apps_v1DeploymentConditionEncoder : Encoder[io.k8s.api.apps.v1.DeploymentCondition] = o =>
      Json.obj(
        "lastUpdateTime" -> o.lastUpdateTime.asJson,
      "reason" -> o.reason.asJson,
      "status" -> o.status.asJson,
      "lastTransitionTime" -> o.lastTransitionTime.asJson,
      "message" -> o.message.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_apps_v1DeploymentConditionDecoder : Decoder[io.k8s.api.apps.v1.DeploymentCondition] = (c: HCursor) => for {
       lastUpdateTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastUpdateTime")
       reason <- c.get[Option[String]]("reason")
       status <- c.get[String]("status")
       lastTransitionTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastTransitionTime")
       message <- c.get[Option[String]]("message")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.apps.v1.DeploymentCondition(
      lastUpdateTime = lastUpdateTime,
      reason = reason,
      status = status,
      lastTransitionTime = lastTransitionTime,
      message = message,
      `type` = `type`
    )

    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1StatusCauseEncoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.StatusCause] = o =>
      Json.obj(
        "field" -> o.field.asJson,
      "message" -> o.message.asJson,
      "reason" -> o.reason.asJson
      )
    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1StatusCauseDecoder : Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.StatusCause] = (c: HCursor) => for {
       field <- c.get[Option[String]]("field")
       message <- c.get[Option[String]]("message")
       reason <- c.get[Option[String]]("reason")
    } yield io.k8s.apimachinery.pkg.apis.meta.v1.StatusCause(
      field = field,
      message = message,
      reason = reason
    )

    implicit lazy val io_k8s_api_authentication_v1TokenRequestStatusEncoder : Encoder[io.k8s.api.authentication.v1.TokenRequestStatus] = o =>
      Json.obj(
        "expirationTimestamp" -> o.expirationTimestamp.asJson,
      "token" -> o.token.asJson
      )
    implicit lazy val io_k8s_api_authentication_v1TokenRequestStatusDecoder : Decoder[io.k8s.api.authentication.v1.TokenRequestStatus] = (c: HCursor) => for {
       expirationTimestamp <- c.get[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("expirationTimestamp")
       token <- c.get[String]("token")
    } yield io.k8s.api.authentication.v1.TokenRequestStatus(
      expirationTimestamp = expirationTimestamp,
      token = token
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2ObjectMetricSourceEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.ObjectMetricSource] = o =>
      Json.obj(
        "describedObject" -> o.describedObject.asJson,
      "metric" -> o.metric.asJson,
      "target" -> o.target.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2ObjectMetricSourceDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.ObjectMetricSource] = (c: HCursor) => for {
       describedObject <- c.get[io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference]("describedObject")
       metric <- c.get[io.k8s.api.autoscaling.v2beta2.MetricIdentifier]("metric")
       target <- c.get[io.k8s.api.autoscaling.v2beta2.MetricTarget]("target")
    } yield io.k8s.api.autoscaling.v2beta2.ObjectMetricSource(
      describedObject = describedObject,
      metric = metric,
      target = target
    )

    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1ServerAddressByClientCIDREncoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR] = o =>
      Json.obj(
        "clientCIDR" -> o.clientCIDR.asJson,
      "serverAddress" -> o.serverAddress.asJson
      )
    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1ServerAddressByClientCIDRDecoder : Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR] = (c: HCursor) => for {
       clientCIDR <- c.get[String]("clientCIDR")
       serverAddress <- c.get[String]("serverAddress")
    } yield io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR(
      clientCIDR = clientCIDR,
      serverAddress = serverAddress
    )

    implicit lazy val io_k8s_api_autoscaling_v2MetricIdentifierEncoder : Encoder[io.k8s.api.autoscaling.v2.MetricIdentifier] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "selector" -> o.selector.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2MetricIdentifierDecoder : Decoder[io.k8s.api.autoscaling.v2.MetricIdentifier] = (c: HCursor) => for {
       name <- c.get[String]("name")
       selector <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]]("selector")
    } yield io.k8s.api.autoscaling.v2.MetricIdentifier(
      name = name,
      selector = selector
    )

    implicit lazy val io_k8s_api_core_v1GRPCActionEncoder : Encoder[io.k8s.api.core.v1.GRPCAction] = o =>
      Json.obj(
        "port" -> o.port.asJson,
      "service" -> o.service.asJson
      )
    implicit lazy val io_k8s_api_core_v1GRPCActionDecoder : Decoder[io.k8s.api.core.v1.GRPCAction] = (c: HCursor) => for {
       port <- c.get[Int]("port")
       service <- c.get[Option[String]]("service")
    } yield io.k8s.api.core.v1.GRPCAction(
      port = port,
      service = service
    )

    implicit lazy val io_k8s_api_core_v1CSIPersistentVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.CSIPersistentVolumeSource] = o =>
      Json.obj(
        "nodeStageSecretRef" -> o.nodeStageSecretRef.asJson,
      "readOnly" -> o.readOnly.asJson,
      "fsType" -> o.fsType.asJson,
      "volumeHandle" -> o.volumeHandle.asJson,
      "driver" -> o.driver.asJson,
      "controllerPublishSecretRef" -> o.controllerPublishSecretRef.asJson,
      "volumeAttributes" -> o.volumeAttributes.asJson,
      "controllerExpandSecretRef" -> o.controllerExpandSecretRef.asJson,
      "nodeExpandSecretRef" -> o.nodeExpandSecretRef.asJson,
      "nodePublishSecretRef" -> o.nodePublishSecretRef.asJson
      )
    implicit lazy val io_k8s_api_core_v1CSIPersistentVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.CSIPersistentVolumeSource] = (c: HCursor) => for {
       nodeStageSecretRef <- c.get[Option[io.k8s.api.core.v1.SecretReference]]("nodeStageSecretRef")
       readOnly <- c.get[Option[Boolean]]("readOnly")
       fsType <- c.get[Option[String]]("fsType")
       volumeHandle <- c.get[String]("volumeHandle")
       driver <- c.get[String]("driver")
       controllerPublishSecretRef <- c.get[Option[io.k8s.api.core.v1.SecretReference]]("controllerPublishSecretRef")
       volumeAttributes <- c.get[Option[Map[String, String]]]("volumeAttributes")
       controllerExpandSecretRef <- c.get[Option[io.k8s.api.core.v1.SecretReference]]("controllerExpandSecretRef")
       nodeExpandSecretRef <- c.get[Option[io.k8s.api.core.v1.SecretReference]]("nodeExpandSecretRef")
       nodePublishSecretRef <- c.get[Option[io.k8s.api.core.v1.SecretReference]]("nodePublishSecretRef")
    } yield io.k8s.api.core.v1.CSIPersistentVolumeSource(
      nodeStageSecretRef = nodeStageSecretRef,
      readOnly = readOnly,
      fsType = fsType,
      volumeHandle = volumeHandle,
      driver = driver,
      controllerPublishSecretRef = controllerPublishSecretRef,
      volumeAttributes = volumeAttributes,
      controllerExpandSecretRef = controllerExpandSecretRef,
      nodeExpandSecretRef = nodeExpandSecretRef,
      nodePublishSecretRef = nodePublishSecretRef
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta1SubjectEncoder : Encoder[io.k8s.api.flowcontrol.v1beta1.Subject] = o =>
      Json.obj(
        "group" -> o.group.asJson,
      "serviceAccount" -> o.serviceAccount.asJson,
      "user" -> o.user.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta1SubjectDecoder : Decoder[io.k8s.api.flowcontrol.v1beta1.Subject] = (c: HCursor) => for {
       group <- c.get[Option[io.k8s.api.flowcontrol.v1beta1.GroupSubject]]("group")
       serviceAccount <- c.get[Option[io.k8s.api.flowcontrol.v1beta1.ServiceAccountSubject]]("serviceAccount")
       user <- c.get[Option[io.k8s.api.flowcontrol.v1beta1.UserSubject]]("user")
    } yield io.k8s.api.flowcontrol.v1beta1.Subject(
      group = group,
      serviceAccount = serviceAccount,
      user = user
    )

    implicit lazy val io_k8s_api_core_v1PodConditionEncoder : Encoder[io.k8s.api.core.v1.PodCondition] = o =>
      Json.obj(
        "lastProbeTime" -> o.lastProbeTime.asJson,
      "reason" -> o.reason.asJson,
      "status" -> o.status.asJson,
      "lastTransitionTime" -> o.lastTransitionTime.asJson,
      "message" -> o.message.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_core_v1PodConditionDecoder : Decoder[io.k8s.api.core.v1.PodCondition] = (c: HCursor) => for {
       lastProbeTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastProbeTime")
       reason <- c.get[Option[String]]("reason")
       status <- c.get[String]("status")
       lastTransitionTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastTransitionTime")
       message <- c.get[Option[String]]("message")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.core.v1.PodCondition(
      lastProbeTime = lastProbeTime,
      reason = reason,
      status = status,
      lastTransitionTime = lastTransitionTime,
      message = message,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta2FlowDistinguisherMethodEncoder : Encoder[io.k8s.api.flowcontrol.v1beta2.FlowDistinguisherMethod] = o =>
      Json.obj(
        "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta2FlowDistinguisherMethodDecoder : Decoder[io.k8s.api.flowcontrol.v1beta2.FlowDistinguisherMethod] = (c: HCursor) => for {
       `type` <- c.get[String]("type")
    } yield io.k8s.api.flowcontrol.v1beta2.FlowDistinguisherMethod(
      `type` = `type`
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2MetricValueStatusEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.MetricValueStatus] = o =>
      Json.obj(
        "averageUtilization" -> o.averageUtilization.asJson,
      "averageValue" -> o.averageValue.asJson,
      "value" -> o.value.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2MetricValueStatusDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.MetricValueStatus] = (c: HCursor) => for {
       averageUtilization <- c.get[Option[Int]]("averageUtilization")
       averageValue <- c.get[Option[io.k8s.apimachinery.pkg.api.resource.Quantity]]("averageValue")
       value <- c.get[Option[io.k8s.apimachinery.pkg.api.resource.Quantity]]("value")
    } yield io.k8s.api.autoscaling.v2beta2.MetricValueStatus(
      averageUtilization = averageUtilization,
      averageValue = averageValue,
      value = value
    )

    implicit lazy val io_k8s_api_core_v1GlusterfsVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.GlusterfsVolumeSource] = o =>
      Json.obj(
        "endpoints" -> o.endpoints.asJson,
      "path" -> o.path.asJson,
      "readOnly" -> o.readOnly.asJson
      )
    implicit lazy val io_k8s_api_core_v1GlusterfsVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.GlusterfsVolumeSource] = (c: HCursor) => for {
       endpoints <- c.get[String]("endpoints")
       path <- c.get[String]("path")
       readOnly <- c.get[Option[Boolean]]("readOnly")
    } yield io.k8s.api.core.v1.GlusterfsVolumeSource(
      endpoints = endpoints,
      path = path,
      readOnly = readOnly
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2HPAScalingPolicyEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.HPAScalingPolicy] = o =>
      Json.obj(
        "periodSeconds" -> o.periodSeconds.asJson,
      "type" -> o.`type`.asJson,
      "value" -> o.value.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2HPAScalingPolicyDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.HPAScalingPolicy] = (c: HCursor) => for {
       periodSeconds <- c.get[Int]("periodSeconds")
       `type` <- c.get[String]("type")
       value <- c.get[Int]("value")
    } yield io.k8s.api.autoscaling.v2beta2.HPAScalingPolicy(
      periodSeconds = periodSeconds,
      `type` = `type`,
      value = value
    )

    implicit lazy val io_k8s_api_rbac_v1PolicyRuleEncoder : Encoder[io.k8s.api.rbac.v1.PolicyRule] = o =>
      Json.obj(
        "verbs" -> o.verbs.asJson,
      "apiGroups" -> o.apiGroups.asJson,
      "resources" -> o.resources.asJson,
      "resourceNames" -> o.resourceNames.asJson,
      "nonResourceURLs" -> o.nonResourceURLs.asJson
      )
    implicit lazy val io_k8s_api_rbac_v1PolicyRuleDecoder : Decoder[io.k8s.api.rbac.v1.PolicyRule] = (c: HCursor) => for {
       verbs <- c.get[Seq[String]]("verbs")
       apiGroups <- c.get[Option[Seq[String]]]("apiGroups")
       resources <- c.get[Option[Seq[String]]]("resources")
       resourceNames <- c.get[Option[Seq[String]]]("resourceNames")
       nonResourceURLs <- c.get[Option[Seq[String]]]("nonResourceURLs")
    } yield io.k8s.api.rbac.v1.PolicyRule(
      verbs = verbs,
      apiGroups = apiGroups,
      resources = resources,
      resourceNames = resourceNames,
      nonResourceURLs = nonResourceURLs
    )

    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1ServiceReferenceEncoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ServiceReference] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "namespace" -> o.namespace.asJson,
      "path" -> o.path.asJson,
      "port" -> o.port.asJson
      )
    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1ServiceReferenceDecoder : Decoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ServiceReference] = (c: HCursor) => for {
       name <- c.get[String]("name")
       namespace <- c.get[String]("namespace")
       path <- c.get[Option[String]]("path")
       port <- c.get[Option[Int]]("port")
    } yield io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ServiceReference(
      name = name,
      namespace = namespace,
      path = path,
      port = port
    )

    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1ConditionEncoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.Condition] = o =>
      Json.obj(
        "reason" -> o.reason.asJson,
      "status" -> o.status.asJson,
      "observedGeneration" -> o.observedGeneration.asJson,
      "lastTransitionTime" -> o.lastTransitionTime.asJson,
      "message" -> o.message.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1ConditionDecoder : Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.Condition] = (c: HCursor) => for {
       reason <- c.get[String]("reason")
       status <- c.get[String]("status")
       observedGeneration <- c.get[Option[Int]]("observedGeneration")
       lastTransitionTime <- c.get[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("lastTransitionTime")
       message <- c.get[String]("message")
       `type` <- c.get[String]("type")
    } yield io.k8s.apimachinery.pkg.apis.meta.v1.Condition(
      reason = reason,
      status = status,
      observedGeneration = observedGeneration,
      lastTransitionTime = lastTransitionTime,
      message = message,
      `type` = `type`
    )

    implicit lazy val io_k8s_kube_aggregator_pkg_apis_apiregistration_v1APIServiceStatusEncoder : Encoder[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceStatus] = o =>
      Json.obj(
        "conditions" -> o.conditions.asJson
      )
    implicit lazy val io_k8s_kube_aggregator_pkg_apis_apiregistration_v1APIServiceStatusDecoder : Decoder[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceStatus] = (c: HCursor) => for {
       conditions <- c.get[Option[Seq[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceCondition]]]("conditions")
    } yield io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceStatus(
      conditions = conditions
    )

    implicit lazy val io_k8s_kube_aggregator_pkg_apis_apiregistration_v1ServiceReferenceEncoder : Encoder[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.ServiceReference] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "namespace" -> o.namespace.asJson,
      "port" -> o.port.asJson
      )
    implicit lazy val io_k8s_kube_aggregator_pkg_apis_apiregistration_v1ServiceReferenceDecoder : Decoder[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.ServiceReference] = (c: HCursor) => for {
       name <- c.get[Option[String]]("name")
       namespace <- c.get[Option[String]]("namespace")
       port <- c.get[Option[Int]]("port")
    } yield io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.ServiceReference(
      name = name,
      namespace = namespace,
      port = port
    )

    implicit lazy val io_k8s_api_networking_v1HTTPIngressPathEncoder : Encoder[io.k8s.api.networking.v1.HTTPIngressPath] = o =>
      Json.obj(
        "backend" -> o.backend.asJson,
      "path" -> o.path.asJson,
      "pathType" -> o.pathType.asJson
      )
    implicit lazy val io_k8s_api_networking_v1HTTPIngressPathDecoder : Decoder[io.k8s.api.networking.v1.HTTPIngressPath] = (c: HCursor) => for {
       backend <- c.get[io.k8s.api.networking.v1.IngressBackend]("backend")
       path <- c.get[Option[String]]("path")
       pathType <- c.get[String]("pathType")
    } yield io.k8s.api.networking.v1.HTTPIngressPath(
      backend = backend,
      path = path,
      pathType = pathType
    )

    implicit lazy val io_k8s_api_core_v1VolumeEncoder : Encoder[io.k8s.api.core.v1.Volume] = o =>
      Json.obj(
        "secret" -> o.secret.asJson,
      "scaleIO" -> o.scaleIO.asJson,
      "csi" -> o.csi.asJson,
      "name" -> o.name.asJson,
      "azureDisk" -> o.azureDisk.asJson,
      "azureFile" -> o.azureFile.asJson,
      "hostPath" -> o.hostPath.asJson,
      "rbd" -> o.rbd.asJson,
      "configMap" -> o.configMap.asJson,
      "portworxVolume" -> o.portworxVolume.asJson,
      "glusterfs" -> o.glusterfs.asJson,
      "flocker" -> o.flocker.asJson,
      "fc" -> o.fc.asJson,
      "photonPersistentDisk" -> o.photonPersistentDisk.asJson,
      "gcePersistentDisk" -> o.gcePersistentDisk.asJson,
      "persistentVolumeClaim" -> o.persistentVolumeClaim.asJson,
      "vsphereVolume" -> o.vsphereVolume.asJson,
      "projected" -> o.projected.asJson,
      "ephemeral" -> o.ephemeral.asJson,
      "iscsi" -> o.iscsi.asJson,
      "cinder" -> o.cinder.asJson,
      "gitRepo" -> o.gitRepo.asJson,
      "cephfs" -> o.cephfs.asJson,
      "awsElasticBlockStore" -> o.awsElasticBlockStore.asJson,
      "downwardAPI" -> o.downwardAPI.asJson,
      "flexVolume" -> o.flexVolume.asJson,
      "emptyDir" -> o.emptyDir.asJson,
      "nfs" -> o.nfs.asJson,
      "quobyte" -> o.quobyte.asJson,
      "storageos" -> o.storageos.asJson
      )
    implicit lazy val io_k8s_api_core_v1VolumeDecoder : Decoder[io.k8s.api.core.v1.Volume] = (c: HCursor) => for {
       secret <- c.get[Option[io.k8s.api.core.v1.SecretVolumeSource]]("secret")
       scaleIO <- c.get[Option[io.k8s.api.core.v1.ScaleIOVolumeSource]]("scaleIO")
       csi <- c.get[Option[io.k8s.api.core.v1.CSIVolumeSource]]("csi")
       name <- c.get[String]("name")
       azureDisk <- c.get[Option[io.k8s.api.core.v1.AzureDiskVolumeSource]]("azureDisk")
       azureFile <- c.get[Option[io.k8s.api.core.v1.AzureFileVolumeSource]]("azureFile")
       hostPath <- c.get[Option[io.k8s.api.core.v1.HostPathVolumeSource]]("hostPath")
       rbd <- c.get[Option[io.k8s.api.core.v1.RBDVolumeSource]]("rbd")
       configMap <- c.get[Option[io.k8s.api.core.v1.ConfigMapVolumeSource]]("configMap")
       portworxVolume <- c.get[Option[io.k8s.api.core.v1.PortworxVolumeSource]]("portworxVolume")
       glusterfs <- c.get[Option[io.k8s.api.core.v1.GlusterfsVolumeSource]]("glusterfs")
       flocker <- c.get[Option[io.k8s.api.core.v1.FlockerVolumeSource]]("flocker")
       fc <- c.get[Option[io.k8s.api.core.v1.FCVolumeSource]]("fc")
       photonPersistentDisk <- c.get[Option[io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource]]("photonPersistentDisk")
       gcePersistentDisk <- c.get[Option[io.k8s.api.core.v1.GCEPersistentDiskVolumeSource]]("gcePersistentDisk")
       persistentVolumeClaim <- c.get[Option[io.k8s.api.core.v1.PersistentVolumeClaimVolumeSource]]("persistentVolumeClaim")
       vsphereVolume <- c.get[Option[io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource]]("vsphereVolume")
       projected <- c.get[Option[io.k8s.api.core.v1.ProjectedVolumeSource]]("projected")
       ephemeral <- c.get[Option[io.k8s.api.core.v1.EphemeralVolumeSource]]("ephemeral")
       iscsi <- c.get[Option[io.k8s.api.core.v1.ISCSIVolumeSource]]("iscsi")
       cinder <- c.get[Option[io.k8s.api.core.v1.CinderVolumeSource]]("cinder")
       gitRepo <- c.get[Option[io.k8s.api.core.v1.GitRepoVolumeSource]]("gitRepo")
       cephfs <- c.get[Option[io.k8s.api.core.v1.CephFSVolumeSource]]("cephfs")
       awsElasticBlockStore <- c.get[Option[io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource]]("awsElasticBlockStore")
       downwardAPI <- c.get[Option[io.k8s.api.core.v1.DownwardAPIVolumeSource]]("downwardAPI")
       flexVolume <- c.get[Option[io.k8s.api.core.v1.FlexVolumeSource]]("flexVolume")
       emptyDir <- c.get[Option[io.k8s.api.core.v1.EmptyDirVolumeSource]]("emptyDir")
       nfs <- c.get[Option[io.k8s.api.core.v1.NFSVolumeSource]]("nfs")
       quobyte <- c.get[Option[io.k8s.api.core.v1.QuobyteVolumeSource]]("quobyte")
       storageos <- c.get[Option[io.k8s.api.core.v1.StorageOSVolumeSource]]("storageos")
    } yield io.k8s.api.core.v1.Volume(
      secret = secret,
      scaleIO = scaleIO,
      csi = csi,
      name = name,
      azureDisk = azureDisk,
      azureFile = azureFile,
      hostPath = hostPath,
      rbd = rbd,
      configMap = configMap,
      portworxVolume = portworxVolume,
      glusterfs = glusterfs,
      flocker = flocker,
      fc = fc,
      photonPersistentDisk = photonPersistentDisk,
      gcePersistentDisk = gcePersistentDisk,
      persistentVolumeClaim = persistentVolumeClaim,
      vsphereVolume = vsphereVolume,
      projected = projected,
      ephemeral = ephemeral,
      iscsi = iscsi,
      cinder = cinder,
      gitRepo = gitRepo,
      cephfs = cephfs,
      awsElasticBlockStore = awsElasticBlockStore,
      downwardAPI = downwardAPI,
      flexVolume = flexVolume,
      emptyDir = emptyDir,
      nfs = nfs,
      quobyte = quobyte,
      storageos = storageos
    )

    implicit lazy val io_k8s_api_core_v1EnvFromSourceEncoder : Encoder[io.k8s.api.core.v1.EnvFromSource] = o =>
      Json.obj(
        "configMapRef" -> o.configMapRef.asJson,
      "prefix" -> o.prefix.asJson,
      "secretRef" -> o.secretRef.asJson
      )
    implicit lazy val io_k8s_api_core_v1EnvFromSourceDecoder : Decoder[io.k8s.api.core.v1.EnvFromSource] = (c: HCursor) => for {
       configMapRef <- c.get[Option[io.k8s.api.core.v1.ConfigMapEnvSource]]("configMapRef")
       prefix <- c.get[Option[String]]("prefix")
       secretRef <- c.get[Option[io.k8s.api.core.v1.SecretEnvSource]]("secretRef")
    } yield io.k8s.api.core.v1.EnvFromSource(
      configMapRef = configMapRef,
      prefix = prefix,
      secretRef = secretRef
    )

    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1ExternalDocumentationEncoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ExternalDocumentation] = o =>
      Json.obj(
        "description" -> o.description.asJson,
      "url" -> o.url.asJson
      )
    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1ExternalDocumentationDecoder : Decoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ExternalDocumentation] = (c: HCursor) => for {
       description <- c.get[Option[String]]("description")
       url <- c.get[Option[String]]("url")
    } yield io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ExternalDocumentation(
      description = description,
      url = url
    )

    implicit lazy val io_k8s_api_core_v1PersistentVolumeClaimStatusEncoder : Encoder[io.k8s.api.core.v1.PersistentVolumeClaimStatus] = o =>
      Json.obj(
        "conditions" -> o.conditions.asJson,
      "accessModes" -> o.accessModes.asJson,
      "phase" -> o.phase.asJson,
      "resizeStatus" -> o.resizeStatus.asJson,
      "allocatedResources" -> o.allocatedResources.asJson,
      "capacity" -> o.capacity.asJson
      )
    implicit lazy val io_k8s_api_core_v1PersistentVolumeClaimStatusDecoder : Decoder[io.k8s.api.core.v1.PersistentVolumeClaimStatus] = (c: HCursor) => for {
       conditions <- c.get[Option[Seq[io.k8s.api.core.v1.PersistentVolumeClaimCondition]]]("conditions")
       accessModes <- c.get[Option[Seq[String]]]("accessModes")
       phase <- c.get[Option[String]]("phase")
       resizeStatus <- c.get[Option[String]]("resizeStatus")
       allocatedResources <- c.get[Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]]("allocatedResources")
       capacity <- c.get[Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]]("capacity")
    } yield io.k8s.api.core.v1.PersistentVolumeClaimStatus(
      conditions = conditions,
      accessModes = accessModes,
      phase = phase,
      resizeStatus = resizeStatus,
      allocatedResources = allocatedResources,
      capacity = capacity
    )

    implicit lazy val io_k8s_api_core_v1TopologySelectorTermEncoder : Encoder[io.k8s.api.core.v1.TopologySelectorTerm] = o =>
      Json.obj(
        "matchLabelExpressions" -> o.matchLabelExpressions.asJson
      )
    implicit lazy val io_k8s_api_core_v1TopologySelectorTermDecoder : Decoder[io.k8s.api.core.v1.TopologySelectorTerm] = (c: HCursor) => for {
       matchLabelExpressions <- c.get[Option[Seq[io.k8s.api.core.v1.TopologySelectorLabelRequirement]]]("matchLabelExpressions")
    } yield io.k8s.api.core.v1.TopologySelectorTerm(
      matchLabelExpressions = matchLabelExpressions
    )

    implicit lazy val io_k8s_api_core_v1NodeSelectorEncoder : Encoder[io.k8s.api.core.v1.NodeSelector] = o =>
      Json.obj(
        "nodeSelectorTerms" -> o.nodeSelectorTerms.asJson
      )
    implicit lazy val io_k8s_api_core_v1NodeSelectorDecoder : Decoder[io.k8s.api.core.v1.NodeSelector] = (c: HCursor) => for {
       nodeSelectorTerms <- c.get[Seq[io.k8s.api.core.v1.NodeSelectorTerm]]("nodeSelectorTerms")
    } yield io.k8s.api.core.v1.NodeSelector(
      nodeSelectorTerms = nodeSelectorTerms
    )

    implicit lazy val io_k8s_api_core_v1CinderPersistentVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.CinderPersistentVolumeSource] = o =>
      Json.obj(
        "fsType" -> o.fsType.asJson,
      "readOnly" -> o.readOnly.asJson,
      "secretRef" -> o.secretRef.asJson,
      "volumeID" -> o.volumeID.asJson
      )
    implicit lazy val io_k8s_api_core_v1CinderPersistentVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.CinderPersistentVolumeSource] = (c: HCursor) => for {
       fsType <- c.get[Option[String]]("fsType")
       readOnly <- c.get[Option[Boolean]]("readOnly")
       secretRef <- c.get[Option[io.k8s.api.core.v1.SecretReference]]("secretRef")
       volumeID <- c.get[String]("volumeID")
    } yield io.k8s.api.core.v1.CinderPersistentVolumeSource(
      fsType = fsType,
      readOnly = readOnly,
      secretRef = secretRef,
      volumeID = volumeID
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta2LimitedPriorityLevelConfigurationEncoder : Encoder[io.k8s.api.flowcontrol.v1beta2.LimitedPriorityLevelConfiguration] = o =>
      Json.obj(
        "assuredConcurrencyShares" -> o.assuredConcurrencyShares.asJson,
      "limitResponse" -> o.limitResponse.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta2LimitedPriorityLevelConfigurationDecoder : Decoder[io.k8s.api.flowcontrol.v1beta2.LimitedPriorityLevelConfiguration] = (c: HCursor) => for {
       assuredConcurrencyShares <- c.get[Option[Int]]("assuredConcurrencyShares")
       limitResponse <- c.get[Option[io.k8s.api.flowcontrol.v1beta2.LimitResponse]]("limitResponse")
    } yield io.k8s.api.flowcontrol.v1beta2.LimitedPriorityLevelConfiguration(
      assuredConcurrencyShares = assuredConcurrencyShares,
      limitResponse = limitResponse
    )

    implicit lazy val io_k8s_api_core_v1LifecycleHandlerEncoder : Encoder[io.k8s.api.core.v1.LifecycleHandler] = o =>
      Json.obj(
        "exec" -> o.exec.asJson,
      "httpGet" -> o.httpGet.asJson,
      "tcpSocket" -> o.tcpSocket.asJson
      )
    implicit lazy val io_k8s_api_core_v1LifecycleHandlerDecoder : Decoder[io.k8s.api.core.v1.LifecycleHandler] = (c: HCursor) => for {
       exec <- c.get[Option[io.k8s.api.core.v1.ExecAction]]("exec")
       httpGet <- c.get[Option[io.k8s.api.core.v1.HTTPGetAction]]("httpGet")
       tcpSocket <- c.get[Option[io.k8s.api.core.v1.TCPSocketAction]]("tcpSocket")
    } yield io.k8s.api.core.v1.LifecycleHandler(
      exec = exec,
      httpGet = httpGet,
      tcpSocket = tcpSocket
    )

    implicit lazy val io_k8s_api_core_v1TypedLocalObjectReferenceEncoder : Encoder[io.k8s.api.core.v1.TypedLocalObjectReference] = o =>
      Json.obj(
        "apiGroup" -> o.apiGroup.asJson,
      "name" -> o.name.asJson
      )
    implicit lazy val io_k8s_api_core_v1TypedLocalObjectReferenceDecoder : Decoder[io.k8s.api.core.v1.TypedLocalObjectReference] = (c: HCursor) => for {
       apiGroup <- c.get[Option[String]]("apiGroup")
       name <- c.get[String]("name")
    } yield io.k8s.api.core.v1.TypedLocalObjectReference(
      apiGroup = apiGroup,
      name = name
    )

    implicit lazy val io_k8s_api_autoscaling_v2HorizontalPodAutoscalerStatusEncoder : Encoder[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerStatus] = o =>
      Json.obj(
        "conditions" -> o.conditions.asJson,
      "desiredReplicas" -> o.desiredReplicas.asJson,
      "currentMetrics" -> o.currentMetrics.asJson,
      "lastScaleTime" -> o.lastScaleTime.asJson,
      "observedGeneration" -> o.observedGeneration.asJson,
      "currentReplicas" -> o.currentReplicas.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2HorizontalPodAutoscalerStatusDecoder : Decoder[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerStatus] = (c: HCursor) => for {
       conditions <- c.get[Option[Seq[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerCondition]]]("conditions")
       desiredReplicas <- c.get[Int]("desiredReplicas")
       currentMetrics <- c.get[Option[Seq[io.k8s.api.autoscaling.v2.MetricStatus]]]("currentMetrics")
       lastScaleTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastScaleTime")
       observedGeneration <- c.get[Option[Int]]("observedGeneration")
       currentReplicas <- c.get[Option[Int]]("currentReplicas")
    } yield io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerStatus(
      conditions = conditions,
      desiredReplicas = desiredReplicas,
      currentMetrics = currentMetrics,
      lastScaleTime = lastScaleTime,
      observedGeneration = observedGeneration,
      currentReplicas = currentReplicas
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta1LimitedPriorityLevelConfigurationEncoder : Encoder[io.k8s.api.flowcontrol.v1beta1.LimitedPriorityLevelConfiguration] = o =>
      Json.obj(
        "assuredConcurrencyShares" -> o.assuredConcurrencyShares.asJson,
      "limitResponse" -> o.limitResponse.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta1LimitedPriorityLevelConfigurationDecoder : Decoder[io.k8s.api.flowcontrol.v1beta1.LimitedPriorityLevelConfiguration] = (c: HCursor) => for {
       assuredConcurrencyShares <- c.get[Option[Int]]("assuredConcurrencyShares")
       limitResponse <- c.get[Option[io.k8s.api.flowcontrol.v1beta1.LimitResponse]]("limitResponse")
    } yield io.k8s.api.flowcontrol.v1beta1.LimitedPriorityLevelConfiguration(
      assuredConcurrencyShares = assuredConcurrencyShares,
      limitResponse = limitResponse
    )

    implicit lazy val io_k8s_api_apps_v1RollingUpdateDeploymentEncoder : Encoder[io.k8s.api.apps.v1.RollingUpdateDeployment] = o =>
      Json.obj(
        "maxSurge" -> o.maxSurge.asJson,
      "maxUnavailable" -> o.maxUnavailable.asJson
      )
    implicit lazy val io_k8s_api_apps_v1RollingUpdateDeploymentDecoder : Decoder[io.k8s.api.apps.v1.RollingUpdateDeployment] = (c: HCursor) => for {
       maxSurge <- c.get[Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString]]("maxSurge")
       maxUnavailable <- c.get[Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString]]("maxUnavailable")
    } yield io.k8s.api.apps.v1.RollingUpdateDeployment(
      maxSurge = maxSurge,
      maxUnavailable = maxUnavailable
    )

    implicit lazy val io_k8s_api_batch_v1PodFailurePolicyOnExitCodesRequirementEncoder : Encoder[io.k8s.api.batch.v1.PodFailurePolicyOnExitCodesRequirement] = o =>
      Json.obj(
        "containerName" -> o.containerName.asJson,
      "operator" -> o.operator.asJson,
      "values" -> o.values.asJson
      )
    implicit lazy val io_k8s_api_batch_v1PodFailurePolicyOnExitCodesRequirementDecoder : Decoder[io.k8s.api.batch.v1.PodFailurePolicyOnExitCodesRequirement] = (c: HCursor) => for {
       containerName <- c.get[Option[String]]("containerName")
       operator <- c.get[String]("operator")
       values <- c.get[Seq[Int]]("values")
    } yield io.k8s.api.batch.v1.PodFailurePolicyOnExitCodesRequirement(
      containerName = containerName,
      operator = operator,
      values = values
    )

    implicit lazy val io_k8s_api_core_v1DownwardAPIVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.DownwardAPIVolumeSource] = o =>
      Json.obj(
        "defaultMode" -> o.defaultMode.asJson,
      "items" -> o.items.asJson
      )
    implicit lazy val io_k8s_api_core_v1DownwardAPIVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.DownwardAPIVolumeSource] = (c: HCursor) => for {
       defaultMode <- c.get[Option[Int]]("defaultMode")
       items <- c.get[Option[Seq[io.k8s.api.core.v1.DownwardAPIVolumeFile]]]("items")
    } yield io.k8s.api.core.v1.DownwardAPIVolumeSource(
      defaultMode = defaultMode,
      items = items
    )

    implicit lazy val io_k8s_api_autoscaling_v2ExternalMetricSourceEncoder : Encoder[io.k8s.api.autoscaling.v2.ExternalMetricSource] = o =>
      Json.obj(
        "metric" -> o.metric.asJson,
      "target" -> o.target.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2ExternalMetricSourceDecoder : Decoder[io.k8s.api.autoscaling.v2.ExternalMetricSource] = (c: HCursor) => for {
       metric <- c.get[io.k8s.api.autoscaling.v2.MetricIdentifier]("metric")
       target <- c.get[io.k8s.api.autoscaling.v2.MetricTarget]("target")
    } yield io.k8s.api.autoscaling.v2.ExternalMetricSource(
      metric = metric,
      target = target
    )

    implicit lazy val io_k8s_api_core_v1AzureFilePersistentVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.AzureFilePersistentVolumeSource] = o =>
      Json.obj(
        "readOnly" -> o.readOnly.asJson,
      "secretName" -> o.secretName.asJson,
      "secretNamespace" -> o.secretNamespace.asJson,
      "shareName" -> o.shareName.asJson
      )
    implicit lazy val io_k8s_api_core_v1AzureFilePersistentVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.AzureFilePersistentVolumeSource] = (c: HCursor) => for {
       readOnly <- c.get[Option[Boolean]]("readOnly")
       secretName <- c.get[String]("secretName")
       secretNamespace <- c.get[Option[String]]("secretNamespace")
       shareName <- c.get[String]("shareName")
    } yield io.k8s.api.core.v1.AzureFilePersistentVolumeSource(
      readOnly = readOnly,
      secretName = secretName,
      secretNamespace = secretNamespace,
      shareName = shareName
    )

    implicit lazy val io_k8s_api_core_v1ConfigMapNodeConfigSourceEncoder : Encoder[io.k8s.api.core.v1.ConfigMapNodeConfigSource] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "resourceVersion" -> o.resourceVersion.asJson,
      "kubeletConfigKey" -> o.kubeletConfigKey.asJson,
      "uid" -> o.uid.asJson,
      "namespace" -> o.namespace.asJson
      )
    implicit lazy val io_k8s_api_core_v1ConfigMapNodeConfigSourceDecoder : Decoder[io.k8s.api.core.v1.ConfigMapNodeConfigSource] = (c: HCursor) => for {
       name <- c.get[String]("name")
       resourceVersion <- c.get[Option[String]]("resourceVersion")
       kubeletConfigKey <- c.get[String]("kubeletConfigKey")
       uid <- c.get[Option[String]]("uid")
       namespace <- c.get[String]("namespace")
    } yield io.k8s.api.core.v1.ConfigMapNodeConfigSource(
      name = name,
      resourceVersion = resourceVersion,
      kubeletConfigKey = kubeletConfigKey,
      uid = uid,
      namespace = namespace
    )

    implicit lazy val io_k8s_api_core_v1ContainerStateWaitingEncoder : Encoder[io.k8s.api.core.v1.ContainerStateWaiting] = o =>
      Json.obj(
        "message" -> o.message.asJson,
      "reason" -> o.reason.asJson
      )
    implicit lazy val io_k8s_api_core_v1ContainerStateWaitingDecoder : Decoder[io.k8s.api.core.v1.ContainerStateWaiting] = (c: HCursor) => for {
       message <- c.get[Option[String]]("message")
       reason <- c.get[Option[String]]("reason")
    } yield io.k8s.api.core.v1.ContainerStateWaiting(
      message = message,
      reason = reason
    )

    implicit lazy val io_k8s_api_core_v1ConfigMapEnvSourceEncoder : Encoder[io.k8s.api.core.v1.ConfigMapEnvSource] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "optional" -> o.optional.asJson
      )
    implicit lazy val io_k8s_api_core_v1ConfigMapEnvSourceDecoder : Decoder[io.k8s.api.core.v1.ConfigMapEnvSource] = (c: HCursor) => for {
       name <- c.get[Option[String]]("name")
       optional <- c.get[Option[Boolean]]("optional")
    } yield io.k8s.api.core.v1.ConfigMapEnvSource(
      name = name,
      optional = optional
    )

    implicit lazy val io_k8s_api_batch_v1JobConditionEncoder : Encoder[io.k8s.api.batch.v1.JobCondition] = o =>
      Json.obj(
        "lastProbeTime" -> o.lastProbeTime.asJson,
      "reason" -> o.reason.asJson,
      "status" -> o.status.asJson,
      "lastTransitionTime" -> o.lastTransitionTime.asJson,
      "message" -> o.message.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_batch_v1JobConditionDecoder : Decoder[io.k8s.api.batch.v1.JobCondition] = (c: HCursor) => for {
       lastProbeTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastProbeTime")
       reason <- c.get[Option[String]]("reason")
       status <- c.get[String]("status")
       lastTransitionTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastTransitionTime")
       message <- c.get[Option[String]]("message")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.batch.v1.JobCondition(
      lastProbeTime = lastProbeTime,
      reason = reason,
      status = status,
      lastTransitionTime = lastTransitionTime,
      message = message,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_authentication_v1UserInfoEncoder : Encoder[io.k8s.api.authentication.v1.UserInfo] = o =>
      Json.obj(
        "extra" -> o.extra.asJson,
      "groups" -> o.groups.asJson,
      "uid" -> o.uid.asJson,
      "username" -> o.username.asJson
      )
    implicit lazy val io_k8s_api_authentication_v1UserInfoDecoder : Decoder[io.k8s.api.authentication.v1.UserInfo] = (c: HCursor) => for {
       extra <- c.get[Option[Map[String, Seq[String]]]]("extra")
       groups <- c.get[Option[Seq[String]]]("groups")
       uid <- c.get[Option[String]]("uid")
       username <- c.get[Option[String]]("username")
    } yield io.k8s.api.authentication.v1.UserInfo(
      extra = extra,
      groups = groups,
      uid = uid,
      username = username
    )

    implicit lazy val io_k8s_api_core_v1ReplicationControllerConditionEncoder : Encoder[io.k8s.api.core.v1.ReplicationControllerCondition] = o =>
      Json.obj(
        "reason" -> o.reason.asJson,
      "status" -> o.status.asJson,
      "lastTransitionTime" -> o.lastTransitionTime.asJson,
      "message" -> o.message.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_core_v1ReplicationControllerConditionDecoder : Decoder[io.k8s.api.core.v1.ReplicationControllerCondition] = (c: HCursor) => for {
       reason <- c.get[Option[String]]("reason")
       status <- c.get[String]("status")
       lastTransitionTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastTransitionTime")
       message <- c.get[Option[String]]("message")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.core.v1.ReplicationControllerCondition(
      reason = reason,
      status = status,
      lastTransitionTime = lastTransitionTime,
      message = message,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_core_v1ContainerStateRunningEncoder : Encoder[io.k8s.api.core.v1.ContainerStateRunning] = o =>
      Json.obj(
        "startedAt" -> o.startedAt.asJson
      )
    implicit lazy val io_k8s_api_core_v1ContainerStateRunningDecoder : Decoder[io.k8s.api.core.v1.ContainerStateRunning] = (c: HCursor) => for {
       startedAt <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("startedAt")
    } yield io.k8s.api.core.v1.ContainerStateRunning(
      startedAt = startedAt
    )

    implicit lazy val io_k8s_api_core_v1PodSpecEncoder : Encoder[io.k8s.api.core.v1.PodSpec] = o =>
      Json.obj(
        "priority" -> o.priority.asJson,
      "hostIPC" -> o.hostIPC.asJson,
      "serviceAccount" -> o.serviceAccount.asJson,
      "schedulerName" -> o.schedulerName.asJson,
      "hostname" -> o.hostname.asJson,
      "imagePullSecrets" -> o.imagePullSecrets.asJson,
      "affinity" -> o.affinity.asJson,
      "os" -> o.os.asJson,
      "nodeName" -> o.nodeName.asJson,
      "ephemeralContainers" -> o.ephemeralContainers.asJson,
      "initContainers" -> o.initContainers.asJson,
      "shareProcessNamespace" -> o.shareProcessNamespace.asJson,
      "setHostnameAsFQDN" -> o.setHostnameAsFQDN.asJson,
      "enableServiceLinks" -> o.enableServiceLinks.asJson,
      "preemptionPolicy" -> o.preemptionPolicy.asJson,
      "dnsPolicy" -> o.dnsPolicy.asJson,
      "volumes" -> o.volumes.asJson,
      "hostAliases" -> o.hostAliases.asJson,
      "subdomain" -> o.subdomain.asJson,
      "topologySpreadConstraints" -> o.topologySpreadConstraints.asJson,
      "overhead" -> o.overhead.asJson,
      "tolerations" -> o.tolerations.asJson,
      "automountServiceAccountToken" -> o.automountServiceAccountToken.asJson,
      "nodeSelector" -> o.nodeSelector.asJson,
      "hostPID" -> o.hostPID.asJson,
      "terminationGracePeriodSeconds" -> o.terminationGracePeriodSeconds.asJson,
      "containers" -> o.containers.asJson,
      "dnsConfig" -> o.dnsConfig.asJson,
      "priorityClassName" -> o.priorityClassName.asJson,
      "serviceAccountName" -> o.serviceAccountName.asJson,
      "restartPolicy" -> o.restartPolicy.asJson,
      "hostUsers" -> o.hostUsers.asJson,
      "runtimeClassName" -> o.runtimeClassName.asJson,
      "readinessGates" -> o.readinessGates.asJson,
      "activeDeadlineSeconds" -> o.activeDeadlineSeconds.asJson,
      "hostNetwork" -> o.hostNetwork.asJson,
      "securityContext" -> o.securityContext.asJson
      )
    implicit lazy val io_k8s_api_core_v1PodSpecDecoder : Decoder[io.k8s.api.core.v1.PodSpec] = (c: HCursor) => for {
       priority <- c.get[Option[Int]]("priority")
       hostIPC <- c.get[Option[Boolean]]("hostIPC")
       serviceAccount <- c.get[Option[String]]("serviceAccount")
       schedulerName <- c.get[Option[String]]("schedulerName")
       hostname <- c.get[Option[String]]("hostname")
       imagePullSecrets <- c.get[Option[Seq[io.k8s.api.core.v1.LocalObjectReference]]]("imagePullSecrets")
       affinity <- c.get[Option[io.k8s.api.core.v1.Affinity]]("affinity")
       os <- c.get[Option[io.k8s.api.core.v1.PodOS]]("os")
       nodeName <- c.get[Option[String]]("nodeName")
       ephemeralContainers <- c.get[Option[Seq[io.k8s.api.core.v1.EphemeralContainer]]]("ephemeralContainers")
       initContainers <- c.get[Option[Seq[io.k8s.api.core.v1.Container]]]("initContainers")
       shareProcessNamespace <- c.get[Option[Boolean]]("shareProcessNamespace")
       setHostnameAsFQDN <- c.get[Option[Boolean]]("setHostnameAsFQDN")
       enableServiceLinks <- c.get[Option[Boolean]]("enableServiceLinks")
       preemptionPolicy <- c.get[Option[String]]("preemptionPolicy")
       dnsPolicy <- c.get[Option[String]]("dnsPolicy")
       volumes <- c.get[Option[Seq[io.k8s.api.core.v1.Volume]]]("volumes")
       hostAliases <- c.get[Option[Seq[io.k8s.api.core.v1.HostAlias]]]("hostAliases")
       subdomain <- c.get[Option[String]]("subdomain")
       topologySpreadConstraints <- c.get[Option[Seq[io.k8s.api.core.v1.TopologySpreadConstraint]]]("topologySpreadConstraints")
       overhead <- c.get[Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]]("overhead")
       tolerations <- c.get[Option[Seq[io.k8s.api.core.v1.Toleration]]]("tolerations")
       automountServiceAccountToken <- c.get[Option[Boolean]]("automountServiceAccountToken")
       nodeSelector <- c.get[Option[Map[String, String]]]("nodeSelector")
       hostPID <- c.get[Option[Boolean]]("hostPID")
       terminationGracePeriodSeconds <- c.get[Option[Int]]("terminationGracePeriodSeconds")
       containers <- c.get[Seq[io.k8s.api.core.v1.Container]]("containers")
       dnsConfig <- c.get[Option[io.k8s.api.core.v1.PodDNSConfig]]("dnsConfig")
       priorityClassName <- c.get[Option[String]]("priorityClassName")
       serviceAccountName <- c.get[Option[String]]("serviceAccountName")
       restartPolicy <- c.get[Option[String]]("restartPolicy")
       hostUsers <- c.get[Option[Boolean]]("hostUsers")
       runtimeClassName <- c.get[Option[String]]("runtimeClassName")
       readinessGates <- c.get[Option[Seq[io.k8s.api.core.v1.PodReadinessGate]]]("readinessGates")
       activeDeadlineSeconds <- c.get[Option[Int]]("activeDeadlineSeconds")
       hostNetwork <- c.get[Option[Boolean]]("hostNetwork")
       securityContext <- c.get[Option[io.k8s.api.core.v1.PodSecurityContext]]("securityContext")
    } yield io.k8s.api.core.v1.PodSpec(
      priority = priority,
      hostIPC = hostIPC,
      serviceAccount = serviceAccount,
      schedulerName = schedulerName,
      hostname = hostname,
      imagePullSecrets = imagePullSecrets,
      affinity = affinity,
      os = os,
      nodeName = nodeName,
      ephemeralContainers = ephemeralContainers,
      initContainers = initContainers,
      shareProcessNamespace = shareProcessNamespace,
      setHostnameAsFQDN = setHostnameAsFQDN,
      enableServiceLinks = enableServiceLinks,
      preemptionPolicy = preemptionPolicy,
      dnsPolicy = dnsPolicy,
      volumes = volumes,
      hostAliases = hostAliases,
      subdomain = subdomain,
      topologySpreadConstraints = topologySpreadConstraints,
      overhead = overhead,
      tolerations = tolerations,
      automountServiceAccountToken = automountServiceAccountToken,
      nodeSelector = nodeSelector,
      hostPID = hostPID,
      terminationGracePeriodSeconds = terminationGracePeriodSeconds,
      containers = containers,
      dnsConfig = dnsConfig,
      priorityClassName = priorityClassName,
      serviceAccountName = serviceAccountName,
      restartPolicy = restartPolicy,
      hostUsers = hostUsers,
      runtimeClassName = runtimeClassName,
      readinessGates = readinessGates,
      activeDeadlineSeconds = activeDeadlineSeconds,
      hostNetwork = hostNetwork,
      securityContext = securityContext
    )

    implicit lazy val io_k8s_api_certificates_v1CertificateSigningRequestSpecEncoder : Encoder[io.k8s.api.certificates.v1.CertificateSigningRequestSpec] = o =>
      Json.obj(
        "usages" -> o.usages.asJson,
      "request" -> o.request.asJson,
      "username" -> o.username.asJson,
      "expirationSeconds" -> o.expirationSeconds.asJson,
      "groups" -> o.groups.asJson,
      "uid" -> o.uid.asJson,
      "extra" -> o.extra.asJson,
      "signerName" -> o.signerName.asJson
      )
    implicit lazy val io_k8s_api_certificates_v1CertificateSigningRequestSpecDecoder : Decoder[io.k8s.api.certificates.v1.CertificateSigningRequestSpec] = (c: HCursor) => for {
       usages <- c.get[Option[Seq[String]]]("usages")
       request <- c.get[String]("request")
       username <- c.get[Option[String]]("username")
       expirationSeconds <- c.get[Option[Int]]("expirationSeconds")
       groups <- c.get[Option[Seq[String]]]("groups")
       uid <- c.get[Option[String]]("uid")
       extra <- c.get[Option[Map[String, Seq[String]]]]("extra")
       signerName <- c.get[String]("signerName")
    } yield io.k8s.api.certificates.v1.CertificateSigningRequestSpec(
      usages = usages,
      request = request,
      username = username,
      expirationSeconds = expirationSeconds,
      groups = groups,
      uid = uid,
      extra = extra,
      signerName = signerName
    )

    implicit lazy val io_k8s_api_apps_v1DeploymentStatusEncoder : Encoder[io.k8s.api.apps.v1.DeploymentStatus] = o =>
      Json.obj(
        "conditions" -> o.conditions.asJson,
      "collisionCount" -> o.collisionCount.asJson,
      "replicas" -> o.replicas.asJson,
      "availableReplicas" -> o.availableReplicas.asJson,
      "unavailableReplicas" -> o.unavailableReplicas.asJson,
      "observedGeneration" -> o.observedGeneration.asJson,
      "updatedReplicas" -> o.updatedReplicas.asJson,
      "readyReplicas" -> o.readyReplicas.asJson
      )
    implicit lazy val io_k8s_api_apps_v1DeploymentStatusDecoder : Decoder[io.k8s.api.apps.v1.DeploymentStatus] = (c: HCursor) => for {
       conditions <- c.get[Option[Seq[io.k8s.api.apps.v1.DeploymentCondition]]]("conditions")
       collisionCount <- c.get[Option[Int]]("collisionCount")
       replicas <- c.get[Option[Int]]("replicas")
       availableReplicas <- c.get[Option[Int]]("availableReplicas")
       unavailableReplicas <- c.get[Option[Int]]("unavailableReplicas")
       observedGeneration <- c.get[Option[Int]]("observedGeneration")
       updatedReplicas <- c.get[Option[Int]]("updatedReplicas")
       readyReplicas <- c.get[Option[Int]]("readyReplicas")
    } yield io.k8s.api.apps.v1.DeploymentStatus(
      conditions = conditions,
      collisionCount = collisionCount,
      replicas = replicas,
      availableReplicas = availableReplicas,
      unavailableReplicas = unavailableReplicas,
      observedGeneration = observedGeneration,
      updatedReplicas = updatedReplicas,
      readyReplicas = readyReplicas
    )

    implicit lazy val io_k8s_api_apps_v1DeploymentStrategyEncoder : Encoder[io.k8s.api.apps.v1.DeploymentStrategy] = o =>
      Json.obj(
        "rollingUpdate" -> o.rollingUpdate.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_apps_v1DeploymentStrategyDecoder : Decoder[io.k8s.api.apps.v1.DeploymentStrategy] = (c: HCursor) => for {
       rollingUpdate <- c.get[Option[io.k8s.api.apps.v1.RollingUpdateDeployment]]("rollingUpdate")
       `type` <- c.get[Option[String]]("type")
    } yield io.k8s.api.apps.v1.DeploymentStrategy(
      rollingUpdate = rollingUpdate,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2PodsMetricSourceEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.PodsMetricSource] = o =>
      Json.obj(
        "metric" -> o.metric.asJson,
      "target" -> o.target.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2PodsMetricSourceDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.PodsMetricSource] = (c: HCursor) => for {
       metric <- c.get[io.k8s.api.autoscaling.v2beta2.MetricIdentifier]("metric")
       target <- c.get[io.k8s.api.autoscaling.v2beta2.MetricTarget]("target")
    } yield io.k8s.api.autoscaling.v2beta2.PodsMetricSource(
      metric = metric,
      target = target
    )

    implicit lazy val io_k8s_api_core_v1VolumeMountEncoder : Encoder[io.k8s.api.core.v1.VolumeMount] = o =>
      Json.obj(
        "subPath" -> o.subPath.asJson,
      "name" -> o.name.asJson,
      "mountPropagation" -> o.mountPropagation.asJson,
      "readOnly" -> o.readOnly.asJson,
      "mountPath" -> o.mountPath.asJson,
      "subPathExpr" -> o.subPathExpr.asJson
      )
    implicit lazy val io_k8s_api_core_v1VolumeMountDecoder : Decoder[io.k8s.api.core.v1.VolumeMount] = (c: HCursor) => for {
       subPath <- c.get[Option[String]]("subPath")
       name <- c.get[String]("name")
       mountPropagation <- c.get[Option[String]]("mountPropagation")
       readOnly <- c.get[Option[Boolean]]("readOnly")
       mountPath <- c.get[String]("mountPath")
       subPathExpr <- c.get[Option[String]]("subPathExpr")
    } yield io.k8s.api.core.v1.VolumeMount(
      subPath = subPath,
      name = name,
      mountPropagation = mountPropagation,
      readOnly = readOnly,
      mountPath = mountPath,
      subPathExpr = subPathExpr
    )

    implicit lazy val io_k8s_api_apps_v1StatefulSetUpdateStrategyEncoder : Encoder[io.k8s.api.apps.v1.StatefulSetUpdateStrategy] = o =>
      Json.obj(
        "rollingUpdate" -> o.rollingUpdate.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_apps_v1StatefulSetUpdateStrategyDecoder : Decoder[io.k8s.api.apps.v1.StatefulSetUpdateStrategy] = (c: HCursor) => for {
       rollingUpdate <- c.get[Option[io.k8s.api.apps.v1.RollingUpdateStatefulSetStrategy]]("rollingUpdate")
       `type` <- c.get[Option[String]]("type")
    } yield io.k8s.api.apps.v1.StatefulSetUpdateStrategy(
      rollingUpdate = rollingUpdate,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_core_v1TopologySpreadConstraintEncoder : Encoder[io.k8s.api.core.v1.TopologySpreadConstraint] = o =>
      Json.obj(
        "maxSkew" -> o.maxSkew.asJson,
      "matchLabelKeys" -> o.matchLabelKeys.asJson,
      "minDomains" -> o.minDomains.asJson,
      "labelSelector" -> o.labelSelector.asJson,
      "nodeAffinityPolicy" -> o.nodeAffinityPolicy.asJson,
      "nodeTaintsPolicy" -> o.nodeTaintsPolicy.asJson,
      "topologyKey" -> o.topologyKey.asJson,
      "whenUnsatisfiable" -> o.whenUnsatisfiable.asJson
      )
    implicit lazy val io_k8s_api_core_v1TopologySpreadConstraintDecoder : Decoder[io.k8s.api.core.v1.TopologySpreadConstraint] = (c: HCursor) => for {
       maxSkew <- c.get[Int]("maxSkew")
       matchLabelKeys <- c.get[Option[Seq[String]]]("matchLabelKeys")
       minDomains <- c.get[Option[Int]]("minDomains")
       labelSelector <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]]("labelSelector")
       nodeAffinityPolicy <- c.get[Option[String]]("nodeAffinityPolicy")
       nodeTaintsPolicy <- c.get[Option[String]]("nodeTaintsPolicy")
       topologyKey <- c.get[String]("topologyKey")
       whenUnsatisfiable <- c.get[String]("whenUnsatisfiable")
    } yield io.k8s.api.core.v1.TopologySpreadConstraint(
      maxSkew = maxSkew,
      matchLabelKeys = matchLabelKeys,
      minDomains = minDomains,
      labelSelector = labelSelector,
      nodeAffinityPolicy = nodeAffinityPolicy,
      nodeTaintsPolicy = nodeTaintsPolicy,
      topologyKey = topologyKey,
      whenUnsatisfiable = whenUnsatisfiable
    )

    implicit lazy val io_k8s_api_core_v1DownwardAPIVolumeFileEncoder : Encoder[io.k8s.api.core.v1.DownwardAPIVolumeFile] = o =>
      Json.obj(
        "fieldRef" -> o.fieldRef.asJson,
      "mode" -> o.mode.asJson,
      "path" -> o.path.asJson,
      "resourceFieldRef" -> o.resourceFieldRef.asJson
      )
    implicit lazy val io_k8s_api_core_v1DownwardAPIVolumeFileDecoder : Decoder[io.k8s.api.core.v1.DownwardAPIVolumeFile] = (c: HCursor) => for {
       fieldRef <- c.get[Option[io.k8s.api.core.v1.ObjectFieldSelector]]("fieldRef")
       mode <- c.get[Option[Int]]("mode")
       path <- c.get[String]("path")
       resourceFieldRef <- c.get[Option[io.k8s.api.core.v1.ResourceFieldSelector]]("resourceFieldRef")
    } yield io.k8s.api.core.v1.DownwardAPIVolumeFile(
      fieldRef = fieldRef,
      mode = mode,
      path = path,
      resourceFieldRef = resourceFieldRef
    )

    implicit lazy val io_k8s_api_authorization_v1SelfSubjectRulesReviewSpecEncoder : Encoder[io.k8s.api.authorization.v1.SelfSubjectRulesReviewSpec] = o =>
      Json.obj(
        "namespace" -> o.namespace.asJson
      )
    implicit lazy val io_k8s_api_authorization_v1SelfSubjectRulesReviewSpecDecoder : Decoder[io.k8s.api.authorization.v1.SelfSubjectRulesReviewSpec] = (c: HCursor) => for {
       namespace <- c.get[Option[String]]("namespace")
    } yield io.k8s.api.authorization.v1.SelfSubjectRulesReviewSpec(
      namespace = namespace
    )

    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1OwnerReferenceEncoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "blockOwnerDeletion" -> o.blockOwnerDeletion.asJson,
      "uid" -> o.uid.asJson,
      "controller" -> o.controller.asJson
      )
    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1OwnerReferenceDecoder : Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference] = (c: HCursor) => for {
       name <- c.get[String]("name")
       blockOwnerDeletion <- c.get[Option[Boolean]]("blockOwnerDeletion")
       uid <- c.get[String]("uid")
       controller <- c.get[Option[Boolean]]("controller")
    } yield io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference(
      name = name,
      blockOwnerDeletion = blockOwnerDeletion,
      uid = uid,
      controller = controller
    )

    implicit lazy val io_k8s_api_core_v1PersistentVolumeClaimConditionEncoder : Encoder[io.k8s.api.core.v1.PersistentVolumeClaimCondition] = o =>
      Json.obj(
        "lastProbeTime" -> o.lastProbeTime.asJson,
      "reason" -> o.reason.asJson,
      "status" -> o.status.asJson,
      "lastTransitionTime" -> o.lastTransitionTime.asJson,
      "message" -> o.message.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_core_v1PersistentVolumeClaimConditionDecoder : Decoder[io.k8s.api.core.v1.PersistentVolumeClaimCondition] = (c: HCursor) => for {
       lastProbeTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastProbeTime")
       reason <- c.get[Option[String]]("reason")
       status <- c.get[String]("status")
       lastTransitionTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastTransitionTime")
       message <- c.get[Option[String]]("message")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.core.v1.PersistentVolumeClaimCondition(
      lastProbeTime = lastProbeTime,
      reason = reason,
      status = status,
      lastTransitionTime = lastTransitionTime,
      message = message,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_core_v1DownwardAPIProjectionEncoder : Encoder[io.k8s.api.core.v1.DownwardAPIProjection] = o =>
      Json.obj(
        "items" -> o.items.asJson
      )
    implicit lazy val io_k8s_api_core_v1DownwardAPIProjectionDecoder : Decoder[io.k8s.api.core.v1.DownwardAPIProjection] = (c: HCursor) => for {
       items <- c.get[Option[Seq[io.k8s.api.core.v1.DownwardAPIVolumeFile]]]("items")
    } yield io.k8s.api.core.v1.DownwardAPIProjection(
      items = items
    )

    implicit lazy val io_k8s_api_apps_v1StatefulSetConditionEncoder : Encoder[io.k8s.api.apps.v1.StatefulSetCondition] = o =>
      Json.obj(
        "reason" -> o.reason.asJson,
      "status" -> o.status.asJson,
      "lastTransitionTime" -> o.lastTransitionTime.asJson,
      "message" -> o.message.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_apps_v1StatefulSetConditionDecoder : Decoder[io.k8s.api.apps.v1.StatefulSetCondition] = (c: HCursor) => for {
       reason <- c.get[Option[String]]("reason")
       status <- c.get[String]("status")
       lastTransitionTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastTransitionTime")
       message <- c.get[Option[String]]("message")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.apps.v1.StatefulSetCondition(
      reason = reason,
      status = status,
      lastTransitionTime = lastTransitionTime,
      message = message,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_core_v1NodeAddressEncoder : Encoder[io.k8s.api.core.v1.NodeAddress] = o =>
      Json.obj(
        "address" -> o.address.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_core_v1NodeAddressDecoder : Decoder[io.k8s.api.core.v1.NodeAddress] = (c: HCursor) => for {
       address <- c.get[String]("address")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.core.v1.NodeAddress(
      address = address,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_core_v1PortworxVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.PortworxVolumeSource] = o =>
      Json.obj(
        "fsType" -> o.fsType.asJson,
      "readOnly" -> o.readOnly.asJson,
      "volumeID" -> o.volumeID.asJson
      )
    implicit lazy val io_k8s_api_core_v1PortworxVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.PortworxVolumeSource] = (c: HCursor) => for {
       fsType <- c.get[Option[String]]("fsType")
       readOnly <- c.get[Option[Boolean]]("readOnly")
       volumeID <- c.get[String]("volumeID")
    } yield io.k8s.api.core.v1.PortworxVolumeSource(
      fsType = fsType,
      readOnly = readOnly,
      volumeID = volumeID
    )

    implicit lazy val io_k8s_api_core_v1PersistentVolumeStatusEncoder : Encoder[io.k8s.api.core.v1.PersistentVolumeStatus] = o =>
      Json.obj(
        "message" -> o.message.asJson,
      "phase" -> o.phase.asJson,
      "reason" -> o.reason.asJson
      )
    implicit lazy val io_k8s_api_core_v1PersistentVolumeStatusDecoder : Decoder[io.k8s.api.core.v1.PersistentVolumeStatus] = (c: HCursor) => for {
       message <- c.get[Option[String]]("message")
       phase <- c.get[Option[String]]("phase")
       reason <- c.get[Option[String]]("reason")
    } yield io.k8s.api.core.v1.PersistentVolumeStatus(
      message = message,
      phase = phase,
      reason = reason
    )

    implicit lazy val io_k8s_api_core_v1NodeConditionEncoder : Encoder[io.k8s.api.core.v1.NodeCondition] = o =>
      Json.obj(
        "reason" -> o.reason.asJson,
      "status" -> o.status.asJson,
      "lastTransitionTime" -> o.lastTransitionTime.asJson,
      "message" -> o.message.asJson,
      "type" -> o.`type`.asJson,
      "lastHeartbeatTime" -> o.lastHeartbeatTime.asJson
      )
    implicit lazy val io_k8s_api_core_v1NodeConditionDecoder : Decoder[io.k8s.api.core.v1.NodeCondition] = (c: HCursor) => for {
       reason <- c.get[Option[String]]("reason")
       status <- c.get[String]("status")
       lastTransitionTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastTransitionTime")
       message <- c.get[Option[String]]("message")
       `type` <- c.get[String]("type")
       lastHeartbeatTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastHeartbeatTime")
    } yield io.k8s.api.core.v1.NodeCondition(
      reason = reason,
      status = status,
      lastTransitionTime = lastTransitionTime,
      message = message,
      `type` = `type`,
      lastHeartbeatTime = lastHeartbeatTime
    )

    implicit lazy val io_k8s_api_autoscaling_v2MetricStatusEncoder : Encoder[io.k8s.api.autoscaling.v2.MetricStatus] = o =>
      Json.obj(
        "object" -> o.`object`.asJson,
      "external" -> o.external.asJson,
      "containerResource" -> o.containerResource.asJson,
      "resource" -> o.resource.asJson,
      "pods" -> o.pods.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2MetricStatusDecoder : Decoder[io.k8s.api.autoscaling.v2.MetricStatus] = (c: HCursor) => for {
       `object` <- c.get[Option[io.k8s.api.autoscaling.v2.ObjectMetricStatus]]("object")
       external <- c.get[Option[io.k8s.api.autoscaling.v2.ExternalMetricStatus]]("external")
       containerResource <- c.get[Option[io.k8s.api.autoscaling.v2.ContainerResourceMetricStatus]]("containerResource")
       resource <- c.get[Option[io.k8s.api.autoscaling.v2.ResourceMetricStatus]]("resource")
       pods <- c.get[Option[io.k8s.api.autoscaling.v2.PodsMetricStatus]]("pods")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.autoscaling.v2.MetricStatus(
      `object` = `object`,
      external = external,
      containerResource = containerResource,
      resource = resource,
      pods = pods,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_core_v1VolumeNodeAffinityEncoder : Encoder[io.k8s.api.core.v1.VolumeNodeAffinity] = o =>
      Json.obj(
        "required" -> o.required.asJson
      )
    implicit lazy val io_k8s_api_core_v1VolumeNodeAffinityDecoder : Decoder[io.k8s.api.core.v1.VolumeNodeAffinity] = (c: HCursor) => for {
       required <- c.get[Option[io.k8s.api.core.v1.NodeSelector]]("required")
    } yield io.k8s.api.core.v1.VolumeNodeAffinity(
      required = required
    )

    implicit lazy val io_k8s_api_core_v1SecretReferenceEncoder : Encoder[io.k8s.api.core.v1.SecretReference] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "namespace" -> o.namespace.asJson
      )
    implicit lazy val io_k8s_api_core_v1SecretReferenceDecoder : Decoder[io.k8s.api.core.v1.SecretReference] = (c: HCursor) => for {
       name <- c.get[Option[String]]("name")
       namespace <- c.get[Option[String]]("namespace")
    } yield io.k8s.api.core.v1.SecretReference(
      name = name,
      namespace = namespace
    )

    implicit lazy val io_k8s_api_core_v1ReplicationControllerSpecEncoder : Encoder[io.k8s.api.core.v1.ReplicationControllerSpec] = o =>
      Json.obj(
        "minReadySeconds" -> o.minReadySeconds.asJson,
      "replicas" -> o.replicas.asJson,
      "selector" -> o.selector.asJson,
      "template" -> o.template.asJson
      )
    implicit lazy val io_k8s_api_core_v1ReplicationControllerSpecDecoder : Decoder[io.k8s.api.core.v1.ReplicationControllerSpec] = (c: HCursor) => for {
       minReadySeconds <- c.get[Option[Int]]("minReadySeconds")
       replicas <- c.get[Option[Int]]("replicas")
       selector <- c.get[Option[Map[String, String]]]("selector")
       template <- c.get[Option[io.k8s.api.core.v1.PodTemplateSpec]]("template")
    } yield io.k8s.api.core.v1.ReplicationControllerSpec(
      minReadySeconds = minReadySeconds,
      replicas = replicas,
      selector = selector,
      template = template
    )

    implicit lazy val io_k8s_api_core_v1FlexVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.FlexVolumeSource] = o =>
      Json.obj(
        "readOnly" -> o.readOnly.asJson,
      "fsType" -> o.fsType.asJson,
      "secretRef" -> o.secretRef.asJson,
      "options" -> o.options.asJson,
      "driver" -> o.driver.asJson
      )
    implicit lazy val io_k8s_api_core_v1FlexVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.FlexVolumeSource] = (c: HCursor) => for {
       readOnly <- c.get[Option[Boolean]]("readOnly")
       fsType <- c.get[Option[String]]("fsType")
       secretRef <- c.get[Option[io.k8s.api.core.v1.LocalObjectReference]]("secretRef")
       options <- c.get[Option[Map[String, String]]]("options")
       driver <- c.get[String]("driver")
    } yield io.k8s.api.core.v1.FlexVolumeSource(
      readOnly = readOnly,
      fsType = fsType,
      secretRef = secretRef,
      options = options,
      driver = driver
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta1NonResourcePolicyRuleEncoder : Encoder[io.k8s.api.flowcontrol.v1beta1.NonResourcePolicyRule] = o =>
      Json.obj(
        "nonResourceURLs" -> o.nonResourceURLs.asJson,
      "verbs" -> o.verbs.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta1NonResourcePolicyRuleDecoder : Decoder[io.k8s.api.flowcontrol.v1beta1.NonResourcePolicyRule] = (c: HCursor) => for {
       nonResourceURLs <- c.get[Seq[String]]("nonResourceURLs")
       verbs <- c.get[Seq[String]]("verbs")
    } yield io.k8s.api.flowcontrol.v1beta1.NonResourcePolicyRule(
      nonResourceURLs = nonResourceURLs,
      verbs = verbs
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta2GroupSubjectEncoder : Encoder[io.k8s.api.flowcontrol.v1beta2.GroupSubject] = o =>
      Json.obj(
        "name" -> o.name.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta2GroupSubjectDecoder : Decoder[io.k8s.api.flowcontrol.v1beta2.GroupSubject] = (c: HCursor) => for {
       name <- c.get[String]("name")
    } yield io.k8s.api.flowcontrol.v1beta2.GroupSubject(
      name = name
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2HorizontalPodAutoscalerConditionEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerCondition] = o =>
      Json.obj(
        "reason" -> o.reason.asJson,
      "status" -> o.status.asJson,
      "lastTransitionTime" -> o.lastTransitionTime.asJson,
      "message" -> o.message.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2HorizontalPodAutoscalerConditionDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerCondition] = (c: HCursor) => for {
       reason <- c.get[Option[String]]("reason")
       status <- c.get[String]("status")
       lastTransitionTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastTransitionTime")
       message <- c.get[Option[String]]("message")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerCondition(
      reason = reason,
      status = status,
      lastTransitionTime = lastTransitionTime,
      message = message,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_storage_v1CSINodeDriverEncoder : Encoder[io.k8s.api.storage.v1.CSINodeDriver] = o =>
      Json.obj(
        "allocatable" -> o.allocatable.asJson,
      "name" -> o.name.asJson,
      "nodeID" -> o.nodeID.asJson,
      "topologyKeys" -> o.topologyKeys.asJson
      )
    implicit lazy val io_k8s_api_storage_v1CSINodeDriverDecoder : Decoder[io.k8s.api.storage.v1.CSINodeDriver] = (c: HCursor) => for {
       allocatable <- c.get[Option[io.k8s.api.storage.v1.VolumeNodeResources]]("allocatable")
       name <- c.get[String]("name")
       nodeID <- c.get[String]("nodeID")
       topologyKeys <- c.get[Option[Seq[String]]]("topologyKeys")
    } yield io.k8s.api.storage.v1.CSINodeDriver(
      allocatable = allocatable,
      name = name,
      nodeID = nodeID,
      topologyKeys = topologyKeys
    )

    implicit lazy val io_k8s_api_core_v1ProbeEncoder : Encoder[io.k8s.api.core.v1.Probe] = o =>
      Json.obj(
        "timeoutSeconds" -> o.timeoutSeconds.asJson,
      "grpc" -> o.grpc.asJson,
      "tcpSocket" -> o.tcpSocket.asJson,
      "initialDelaySeconds" -> o.initialDelaySeconds.asJson,
      "failureThreshold" -> o.failureThreshold.asJson,
      "httpGet" -> o.httpGet.asJson,
      "terminationGracePeriodSeconds" -> o.terminationGracePeriodSeconds.asJson,
      "exec" -> o.exec.asJson,
      "periodSeconds" -> o.periodSeconds.asJson,
      "successThreshold" -> o.successThreshold.asJson
      )
    implicit lazy val io_k8s_api_core_v1ProbeDecoder : Decoder[io.k8s.api.core.v1.Probe] = (c: HCursor) => for {
       timeoutSeconds <- c.get[Option[Int]]("timeoutSeconds")
       grpc <- c.get[Option[io.k8s.api.core.v1.GRPCAction]]("grpc")
       tcpSocket <- c.get[Option[io.k8s.api.core.v1.TCPSocketAction]]("tcpSocket")
       initialDelaySeconds <- c.get[Option[Int]]("initialDelaySeconds")
       failureThreshold <- c.get[Option[Int]]("failureThreshold")
       httpGet <- c.get[Option[io.k8s.api.core.v1.HTTPGetAction]]("httpGet")
       terminationGracePeriodSeconds <- c.get[Option[Int]]("terminationGracePeriodSeconds")
       exec <- c.get[Option[io.k8s.api.core.v1.ExecAction]]("exec")
       periodSeconds <- c.get[Option[Int]]("periodSeconds")
       successThreshold <- c.get[Option[Int]]("successThreshold")
    } yield io.k8s.api.core.v1.Probe(
      timeoutSeconds = timeoutSeconds,
      grpc = grpc,
      tcpSocket = tcpSocket,
      initialDelaySeconds = initialDelaySeconds,
      failureThreshold = failureThreshold,
      httpGet = httpGet,
      terminationGracePeriodSeconds = terminationGracePeriodSeconds,
      exec = exec,
      periodSeconds = periodSeconds,
      successThreshold = successThreshold
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta2NonResourcePolicyRuleEncoder : Encoder[io.k8s.api.flowcontrol.v1beta2.NonResourcePolicyRule] = o =>
      Json.obj(
        "nonResourceURLs" -> o.nonResourceURLs.asJson,
      "verbs" -> o.verbs.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta2NonResourcePolicyRuleDecoder : Decoder[io.k8s.api.flowcontrol.v1beta2.NonResourcePolicyRule] = (c: HCursor) => for {
       nonResourceURLs <- c.get[Seq[String]]("nonResourceURLs")
       verbs <- c.get[Seq[String]]("verbs")
    } yield io.k8s.api.flowcontrol.v1beta2.NonResourcePolicyRule(
      nonResourceURLs = nonResourceURLs,
      verbs = verbs
    )

    implicit lazy val io_k8s_api_core_v1EnvVarEncoder : Encoder[io.k8s.api.core.v1.EnvVar] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "value" -> o.value.asJson,
      "valueFrom" -> o.valueFrom.asJson
      )
    implicit lazy val io_k8s_api_core_v1EnvVarDecoder : Decoder[io.k8s.api.core.v1.EnvVar] = (c: HCursor) => for {
       name <- c.get[String]("name")
       value <- c.get[Option[String]]("value")
       valueFrom <- c.get[Option[io.k8s.api.core.v1.EnvVarSource]]("valueFrom")
    } yield io.k8s.api.core.v1.EnvVar(
      name = name,
      value = value,
      valueFrom = valueFrom
    )

    implicit lazy val io_k8s_api_core_v1AWSElasticBlockStoreVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource] = o =>
      Json.obj(
        "fsType" -> o.fsType.asJson,
      "partition" -> o.partition.asJson,
      "readOnly" -> o.readOnly.asJson,
      "volumeID" -> o.volumeID.asJson
      )
    implicit lazy val io_k8s_api_core_v1AWSElasticBlockStoreVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource] = (c: HCursor) => for {
       fsType <- c.get[Option[String]]("fsType")
       partition <- c.get[Option[Int]]("partition")
       readOnly <- c.get[Option[Boolean]]("readOnly")
       volumeID <- c.get[String]("volumeID")
    } yield io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource(
      fsType = fsType,
      partition = partition,
      readOnly = readOnly,
      volumeID = volumeID
    )

    implicit lazy val io_k8s_api_core_v1VolumeDeviceEncoder : Encoder[io.k8s.api.core.v1.VolumeDevice] = o =>
      Json.obj(
        "devicePath" -> o.devicePath.asJson,
      "name" -> o.name.asJson
      )
    implicit lazy val io_k8s_api_core_v1VolumeDeviceDecoder : Decoder[io.k8s.api.core.v1.VolumeDevice] = (c: HCursor) => for {
       devicePath <- c.get[String]("devicePath")
       name <- c.get[String]("name")
    } yield io.k8s.api.core.v1.VolumeDevice(
      devicePath = devicePath,
      name = name
    )

    implicit lazy val io_k8s_api_core_v1EventSeriesEncoder : Encoder[io.k8s.api.core.v1.EventSeries] = o =>
      Json.obj(
        "count" -> o.count.asJson,
      "lastObservedTime" -> o.lastObservedTime.asJson
      )
    implicit lazy val io_k8s_api_core_v1EventSeriesDecoder : Decoder[io.k8s.api.core.v1.EventSeries] = (c: HCursor) => for {
       count <- c.get[Option[Int]]("count")
       lastObservedTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime]]("lastObservedTime")
    } yield io.k8s.api.core.v1.EventSeries(
      count = count,
      lastObservedTime = lastObservedTime
    )

    implicit lazy val io_k8s_api_core_v1SELinuxOptionsEncoder : Encoder[io.k8s.api.core.v1.SELinuxOptions] = o =>
      Json.obj(
        "level" -> o.level.asJson,
      "role" -> o.role.asJson,
      "type" -> o.`type`.asJson,
      "user" -> o.user.asJson
      )
    implicit lazy val io_k8s_api_core_v1SELinuxOptionsDecoder : Decoder[io.k8s.api.core.v1.SELinuxOptions] = (c: HCursor) => for {
       level <- c.get[Option[String]]("level")
       role <- c.get[Option[String]]("role")
       `type` <- c.get[Option[String]]("type")
       user <- c.get[Option[String]]("user")
    } yield io.k8s.api.core.v1.SELinuxOptions(
      level = level,
      role = role,
      `type` = `type`,
      user = user
    )

    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceDefinitionNamesEncoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames] = o =>
      Json.obj(
        "plural" -> o.plural.asJson,
      "singular" -> o.singular.asJson,
      "listKind" -> o.listKind.asJson,
      "categories" -> o.categories.asJson,
      "shortNames" -> o.shortNames.asJson
      )
    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceDefinitionNamesDecoder : Decoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames] = (c: HCursor) => for {
       plural <- c.get[String]("plural")
       singular <- c.get[Option[String]]("singular")
       listKind <- c.get[Option[String]]("listKind")
       categories <- c.get[Option[Seq[String]]]("categories")
       shortNames <- c.get[Option[Seq[String]]]("shortNames")
    } yield io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames(
      plural = plural,
      singular = singular,
      listKind = listKind,
      categories = categories,
      shortNames = shortNames
    )

    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1StatusDetailsEncoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "causes" -> o.causes.asJson,
      "uid" -> o.uid.asJson,
      "retryAfterSeconds" -> o.retryAfterSeconds.asJson,
      "group" -> o.group.asJson
      )
    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1StatusDetailsDecoder : Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails] = (c: HCursor) => for {
       name <- c.get[Option[String]]("name")
       causes <- c.get[Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.StatusCause]]]("causes")
       uid <- c.get[Option[String]]("uid")
       retryAfterSeconds <- c.get[Option[Int]]("retryAfterSeconds")
       group <- c.get[Option[String]]("group")
    } yield io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails(
      name = name,
      causes = causes,
      uid = uid,
      retryAfterSeconds = retryAfterSeconds,
      group = group
    )

    implicit lazy val io_k8s_api_networking_v1ServiceBackendPortEncoder : Encoder[io.k8s.api.networking.v1.ServiceBackendPort] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "number" -> o.number.asJson
      )
    implicit lazy val io_k8s_api_networking_v1ServiceBackendPortDecoder : Decoder[io.k8s.api.networking.v1.ServiceBackendPort] = (c: HCursor) => for {
       name <- c.get[Option[String]]("name")
       number <- c.get[Option[Int]]("number")
    } yield io.k8s.api.networking.v1.ServiceBackendPort(
      name = name,
      number = number
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta2PriorityLevelConfigurationStatusEncoder : Encoder[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationStatus] = o =>
      Json.obj(
        "conditions" -> o.conditions.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta2PriorityLevelConfigurationStatusDecoder : Decoder[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationStatus] = (c: HCursor) => for {
       conditions <- c.get[Option[Seq[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationCondition]]]("conditions")
    } yield io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationStatus(
      conditions = conditions
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2ResourceMetricSourceEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.ResourceMetricSource] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "target" -> o.target.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2ResourceMetricSourceDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.ResourceMetricSource] = (c: HCursor) => for {
       name <- c.get[String]("name")
       target <- c.get[io.k8s.api.autoscaling.v2beta2.MetricTarget]("target")
    } yield io.k8s.api.autoscaling.v2beta2.ResourceMetricSource(
      name = name,
      target = target
    )

    implicit lazy val io_k8s_api_core_v1NodeDaemonEndpointsEncoder : Encoder[io.k8s.api.core.v1.NodeDaemonEndpoints] = o =>
      Json.obj(
        "kubeletEndpoint" -> o.kubeletEndpoint.asJson
      )
    implicit lazy val io_k8s_api_core_v1NodeDaemonEndpointsDecoder : Decoder[io.k8s.api.core.v1.NodeDaemonEndpoints] = (c: HCursor) => for {
       kubeletEndpoint <- c.get[Option[io.k8s.api.core.v1.DaemonEndpoint]]("kubeletEndpoint")
    } yield io.k8s.api.core.v1.NodeDaemonEndpoints(
      kubeletEndpoint = kubeletEndpoint
    )

    implicit lazy val io_k8s_api_authentication_v1TokenRequestSpecEncoder : Encoder[io.k8s.api.authentication.v1.TokenRequestSpec] = o =>
      Json.obj(
        "audiences" -> o.audiences.asJson,
      "boundObjectRef" -> o.boundObjectRef.asJson,
      "expirationSeconds" -> o.expirationSeconds.asJson
      )
    implicit lazy val io_k8s_api_authentication_v1TokenRequestSpecDecoder : Decoder[io.k8s.api.authentication.v1.TokenRequestSpec] = (c: HCursor) => for {
       audiences <- c.get[Seq[String]]("audiences")
       boundObjectRef <- c.get[Option[io.k8s.api.authentication.v1.BoundObjectReference]]("boundObjectRef")
       expirationSeconds <- c.get[Option[Int]]("expirationSeconds")
    } yield io.k8s.api.authentication.v1.TokenRequestSpec(
      audiences = audiences,
      boundObjectRef = boundObjectRef,
      expirationSeconds = expirationSeconds
    )

    implicit lazy val io_k8s_api_authorization_v1SubjectAccessReviewSpecEncoder : Encoder[io.k8s.api.authorization.v1.SubjectAccessReviewSpec] = o =>
      Json.obj(
        "groups" -> o.groups.asJson,
      "resourceAttributes" -> o.resourceAttributes.asJson,
      "uid" -> o.uid.asJson,
      "extra" -> o.extra.asJson,
      "user" -> o.user.asJson,
      "nonResourceAttributes" -> o.nonResourceAttributes.asJson
      )
    implicit lazy val io_k8s_api_authorization_v1SubjectAccessReviewSpecDecoder : Decoder[io.k8s.api.authorization.v1.SubjectAccessReviewSpec] = (c: HCursor) => for {
       groups <- c.get[Option[Seq[String]]]("groups")
       resourceAttributes <- c.get[Option[io.k8s.api.authorization.v1.ResourceAttributes]]("resourceAttributes")
       uid <- c.get[Option[String]]("uid")
       extra <- c.get[Option[Map[String, Seq[String]]]]("extra")
       user <- c.get[Option[String]]("user")
       nonResourceAttributes <- c.get[Option[io.k8s.api.authorization.v1.NonResourceAttributes]]("nonResourceAttributes")
    } yield io.k8s.api.authorization.v1.SubjectAccessReviewSpec(
      groups = groups,
      resourceAttributes = resourceAttributes,
      uid = uid,
      extra = extra,
      user = user,
      nonResourceAttributes = nonResourceAttributes
    )

    implicit lazy val io_k8s_api_core_v1EndpointSubsetEncoder : Encoder[io.k8s.api.core.v1.EndpointSubset] = o =>
      Json.obj(
        "addresses" -> o.addresses.asJson,
      "notReadyAddresses" -> o.notReadyAddresses.asJson,
      "ports" -> o.ports.asJson
      )
    implicit lazy val io_k8s_api_core_v1EndpointSubsetDecoder : Decoder[io.k8s.api.core.v1.EndpointSubset] = (c: HCursor) => for {
       addresses <- c.get[Option[Seq[io.k8s.api.core.v1.EndpointAddress]]]("addresses")
       notReadyAddresses <- c.get[Option[Seq[io.k8s.api.core.v1.EndpointAddress]]]("notReadyAddresses")
       ports <- c.get[Option[Seq[io.k8s.api.core.v1.EndpointPort]]]("ports")
    } yield io.k8s.api.core.v1.EndpointSubset(
      addresses = addresses,
      notReadyAddresses = notReadyAddresses,
      ports = ports
    )

    implicit lazy val io_k8s_api_core_v1NodeSpecEncoder : Encoder[io.k8s.api.core.v1.NodeSpec] = o =>
      Json.obj(
        "externalID" -> o.externalID.asJson,
      "taints" -> o.taints.asJson,
      "configSource" -> o.configSource.asJson,
      "unschedulable" -> o.unschedulable.asJson,
      "podCIDR" -> o.podCIDR.asJson,
      "providerID" -> o.providerID.asJson,
      "podCIDRs" -> o.podCIDRs.asJson
      )
    implicit lazy val io_k8s_api_core_v1NodeSpecDecoder : Decoder[io.k8s.api.core.v1.NodeSpec] = (c: HCursor) => for {
       externalID <- c.get[Option[String]]("externalID")
       taints <- c.get[Option[Seq[io.k8s.api.core.v1.Taint]]]("taints")
       configSource <- c.get[Option[io.k8s.api.core.v1.NodeConfigSource]]("configSource")
       unschedulable <- c.get[Option[Boolean]]("unschedulable")
       podCIDR <- c.get[Option[String]]("podCIDR")
       providerID <- c.get[Option[String]]("providerID")
       podCIDRs <- c.get[Option[Seq[String]]]("podCIDRs")
    } yield io.k8s.api.core.v1.NodeSpec(
      externalID = externalID,
      taints = taints,
      configSource = configSource,
      unschedulable = unschedulable,
      podCIDR = podCIDR,
      providerID = providerID,
      podCIDRs = podCIDRs
    )

    implicit lazy val io_k8s_apimachinery_pkg_versionInfoEncoder : Encoder[io.k8s.apimachinery.pkg.version.Info] = o =>
      Json.obj(
        "gitCommit" -> o.gitCommit.asJson,
      "goVersion" -> o.goVersion.asJson,
      "compiler" -> o.compiler.asJson,
      "gitVersion" -> o.gitVersion.asJson,
      "gitTreeState" -> o.gitTreeState.asJson,
      "platform" -> o.platform.asJson,
      "buildDate" -> o.buildDate.asJson,
      "major" -> o.major.asJson,
      "minor" -> o.minor.asJson
      )
    implicit lazy val io_k8s_apimachinery_pkg_versionInfoDecoder : Decoder[io.k8s.apimachinery.pkg.version.Info] = (c: HCursor) => for {
       gitCommit <- c.get[String]("gitCommit")
       goVersion <- c.get[String]("goVersion")
       compiler <- c.get[String]("compiler")
       gitVersion <- c.get[String]("gitVersion")
       gitTreeState <- c.get[String]("gitTreeState")
       platform <- c.get[String]("platform")
       buildDate <- c.get[String]("buildDate")
       major <- c.get[String]("major")
       minor <- c.get[String]("minor")
    } yield io.k8s.apimachinery.pkg.version.Info(
      gitCommit = gitCommit,
      goVersion = goVersion,
      compiler = compiler,
      gitVersion = gitVersion,
      gitTreeState = gitTreeState,
      platform = platform,
      buildDate = buildDate,
      major = major,
      minor = minor
    )

    implicit lazy val io_k8s_api_autoscaling_v2PodsMetricSourceEncoder : Encoder[io.k8s.api.autoscaling.v2.PodsMetricSource] = o =>
      Json.obj(
        "metric" -> o.metric.asJson,
      "target" -> o.target.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2PodsMetricSourceDecoder : Decoder[io.k8s.api.autoscaling.v2.PodsMetricSource] = (c: HCursor) => for {
       metric <- c.get[io.k8s.api.autoscaling.v2.MetricIdentifier]("metric")
       target <- c.get[io.k8s.api.autoscaling.v2.MetricTarget]("target")
    } yield io.k8s.api.autoscaling.v2.PodsMetricSource(
      metric = metric,
      target = target
    )

    implicit lazy val io_k8s_api_core_v1ContainerImageEncoder : Encoder[io.k8s.api.core.v1.ContainerImage] = o =>
      Json.obj(
        "names" -> o.names.asJson,
      "sizeBytes" -> o.sizeBytes.asJson
      )
    implicit lazy val io_k8s_api_core_v1ContainerImageDecoder : Decoder[io.k8s.api.core.v1.ContainerImage] = (c: HCursor) => for {
       names <- c.get[Option[Seq[String]]]("names")
       sizeBytes <- c.get[Option[Int]]("sizeBytes")
    } yield io.k8s.api.core.v1.ContainerImage(
      names = names,
      sizeBytes = sizeBytes
    )

    implicit lazy val io_k8s_api_core_v1ConfigMapProjectionEncoder : Encoder[io.k8s.api.core.v1.ConfigMapProjection] = o =>
      Json.obj(
        "items" -> o.items.asJson,
      "name" -> o.name.asJson,
      "optional" -> o.optional.asJson
      )
    implicit lazy val io_k8s_api_core_v1ConfigMapProjectionDecoder : Decoder[io.k8s.api.core.v1.ConfigMapProjection] = (c: HCursor) => for {
       items <- c.get[Option[Seq[io.k8s.api.core.v1.KeyToPath]]]("items")
       name <- c.get[Option[String]]("name")
       optional <- c.get[Option[Boolean]]("optional")
    } yield io.k8s.api.core.v1.ConfigMapProjection(
      items = items,
      name = name,
      optional = optional
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta2LimitResponseEncoder : Encoder[io.k8s.api.flowcontrol.v1beta2.LimitResponse] = o =>
      Json.obj(
        "queuing" -> o.queuing.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta2LimitResponseDecoder : Decoder[io.k8s.api.flowcontrol.v1beta2.LimitResponse] = (c: HCursor) => for {
       queuing <- c.get[Option[io.k8s.api.flowcontrol.v1beta2.QueuingConfiguration]]("queuing")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.flowcontrol.v1beta2.LimitResponse(
      queuing = queuing,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_core_v1PersistentVolumeClaimVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.PersistentVolumeClaimVolumeSource] = o =>
      Json.obj(
        "claimName" -> o.claimName.asJson,
      "readOnly" -> o.readOnly.asJson
      )
    implicit lazy val io_k8s_api_core_v1PersistentVolumeClaimVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.PersistentVolumeClaimVolumeSource] = (c: HCursor) => for {
       claimName <- c.get[String]("claimName")
       readOnly <- c.get[Option[Boolean]]("readOnly")
    } yield io.k8s.api.core.v1.PersistentVolumeClaimVolumeSource(
      claimName = claimName,
      readOnly = readOnly
    )

    implicit lazy val io_k8s_api_core_v1ExecActionEncoder : Encoder[io.k8s.api.core.v1.ExecAction] = o =>
      Json.obj(
        "command" -> o.command.asJson
      )
    implicit lazy val io_k8s_api_core_v1ExecActionDecoder : Decoder[io.k8s.api.core.v1.ExecAction] = (c: HCursor) => for {
       command <- c.get[Option[Seq[String]]]("command")
    } yield io.k8s.api.core.v1.ExecAction(
      command = command
    )

    implicit lazy val io_k8s_api_node_v1SchedulingEncoder : Encoder[io.k8s.api.node.v1.Scheduling] = o =>
      Json.obj(
        "nodeSelector" -> o.nodeSelector.asJson,
      "tolerations" -> o.tolerations.asJson
      )
    implicit lazy val io_k8s_api_node_v1SchedulingDecoder : Decoder[io.k8s.api.node.v1.Scheduling] = (c: HCursor) => for {
       nodeSelector <- c.get[Option[Map[String, String]]]("nodeSelector")
       tolerations <- c.get[Option[Seq[io.k8s.api.core.v1.Toleration]]]("tolerations")
    } yield io.k8s.api.node.v1.Scheduling(
      nodeSelector = nodeSelector,
      tolerations = tolerations
    )

    implicit lazy val io_k8s_api_core_v1QuobyteVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.QuobyteVolumeSource] = o =>
      Json.obj(
        "registry" -> o.registry.asJson,
      "readOnly" -> o.readOnly.asJson,
      "tenant" -> o.tenant.asJson,
      "group" -> o.group.asJson,
      "user" -> o.user.asJson,
      "volume" -> o.volume.asJson
      )
    implicit lazy val io_k8s_api_core_v1QuobyteVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.QuobyteVolumeSource] = (c: HCursor) => for {
       registry <- c.get[String]("registry")
       readOnly <- c.get[Option[Boolean]]("readOnly")
       tenant <- c.get[Option[String]]("tenant")
       group <- c.get[Option[String]]("group")
       user <- c.get[Option[String]]("user")
       volume <- c.get[String]("volume")
    } yield io.k8s.api.core.v1.QuobyteVolumeSource(
      registry = registry,
      readOnly = readOnly,
      tenant = tenant,
      group = group,
      user = user,
      volume = volume
    )

    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceSubresourceScaleEncoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceScale] = o =>
      Json.obj(
        "labelSelectorPath" -> o.labelSelectorPath.asJson,
      "specReplicasPath" -> o.specReplicasPath.asJson,
      "statusReplicasPath" -> o.statusReplicasPath.asJson
      )
    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceSubresourceScaleDecoder : Decoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceScale] = (c: HCursor) => for {
       labelSelectorPath <- c.get[Option[String]]("labelSelectorPath")
       specReplicasPath <- c.get[String]("specReplicasPath")
       statusReplicasPath <- c.get[String]("statusReplicasPath")
    } yield io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceScale(
      labelSelectorPath = labelSelectorPath,
      specReplicasPath = specReplicasPath,
      statusReplicasPath = statusReplicasPath
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2ExternalMetricSourceEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.ExternalMetricSource] = o =>
      Json.obj(
        "metric" -> o.metric.asJson,
      "target" -> o.target.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2ExternalMetricSourceDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.ExternalMetricSource] = (c: HCursor) => for {
       metric <- c.get[io.k8s.api.autoscaling.v2beta2.MetricIdentifier]("metric")
       target <- c.get[io.k8s.api.autoscaling.v2beta2.MetricTarget]("target")
    } yield io.k8s.api.autoscaling.v2beta2.ExternalMetricSource(
      metric = metric,
      target = target
    )

    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceColumnDefinitionEncoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition] = o =>
      Json.obj(
        "format" -> o.format.asJson,
      "name" -> o.name.asJson,
      "priority" -> o.priority.asJson,
      "description" -> o.description.asJson,
      "jsonPath" -> o.jsonPath.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceColumnDefinitionDecoder : Decoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition] = (c: HCursor) => for {
       format <- c.get[Option[String]]("format")
       name <- c.get[String]("name")
       priority <- c.get[Option[Int]]("priority")
       description <- c.get[Option[String]]("description")
       jsonPath <- c.get[String]("jsonPath")
       `type` <- c.get[String]("type")
    } yield io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition(
      format = format,
      name = name,
      priority = priority,
      description = description,
      jsonPath = jsonPath,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_core_v1GlusterfsPersistentVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.GlusterfsPersistentVolumeSource] = o =>
      Json.obj(
        "endpoints" -> o.endpoints.asJson,
      "endpointsNamespace" -> o.endpointsNamespace.asJson,
      "path" -> o.path.asJson,
      "readOnly" -> o.readOnly.asJson
      )
    implicit lazy val io_k8s_api_core_v1GlusterfsPersistentVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.GlusterfsPersistentVolumeSource] = (c: HCursor) => for {
       endpoints <- c.get[String]("endpoints")
       endpointsNamespace <- c.get[Option[String]]("endpointsNamespace")
       path <- c.get[String]("path")
       readOnly <- c.get[Option[Boolean]]("readOnly")
    } yield io.k8s.api.core.v1.GlusterfsPersistentVolumeSource(
      endpoints = endpoints,
      endpointsNamespace = endpointsNamespace,
      path = path,
      readOnly = readOnly
    )

    implicit lazy val io_k8s_api_core_v1LoadBalancerStatusEncoder : Encoder[io.k8s.api.core.v1.LoadBalancerStatus] = o =>
      Json.obj(
        "ingress" -> o.ingress.asJson
      )
    implicit lazy val io_k8s_api_core_v1LoadBalancerStatusDecoder : Decoder[io.k8s.api.core.v1.LoadBalancerStatus] = (c: HCursor) => for {
       ingress <- c.get[Option[Seq[io.k8s.api.core.v1.LoadBalancerIngress]]]("ingress")
    } yield io.k8s.api.core.v1.LoadBalancerStatus(
      ingress = ingress
    )

    implicit lazy val io_k8s_api_batch_v1CronJobSpecEncoder : Encoder[io.k8s.api.batch.v1.CronJobSpec] = o =>
      Json.obj(
        "startingDeadlineSeconds" -> o.startingDeadlineSeconds.asJson,
      "concurrencyPolicy" -> o.concurrencyPolicy.asJson,
      "failedJobsHistoryLimit" -> o.failedJobsHistoryLimit.asJson,
      "successfulJobsHistoryLimit" -> o.successfulJobsHistoryLimit.asJson,
      "suspend" -> o.suspend.asJson,
      "schedule" -> o.schedule.asJson,
      "jobTemplate" -> o.jobTemplate.asJson,
      "timeZone" -> o.timeZone.asJson
      )
    implicit lazy val io_k8s_api_batch_v1CronJobSpecDecoder : Decoder[io.k8s.api.batch.v1.CronJobSpec] = (c: HCursor) => for {
       startingDeadlineSeconds <- c.get[Option[Int]]("startingDeadlineSeconds")
       concurrencyPolicy <- c.get[Option[String]]("concurrencyPolicy")
       failedJobsHistoryLimit <- c.get[Option[Int]]("failedJobsHistoryLimit")
       successfulJobsHistoryLimit <- c.get[Option[Int]]("successfulJobsHistoryLimit")
       suspend <- c.get[Option[Boolean]]("suspend")
       schedule <- c.get[String]("schedule")
       jobTemplate <- c.get[io.k8s.api.batch.v1.JobTemplateSpec]("jobTemplate")
       timeZone <- c.get[Option[String]]("timeZone")
    } yield io.k8s.api.batch.v1.CronJobSpec(
      startingDeadlineSeconds = startingDeadlineSeconds,
      concurrencyPolicy = concurrencyPolicy,
      failedJobsHistoryLimit = failedJobsHistoryLimit,
      successfulJobsHistoryLimit = successfulJobsHistoryLimit,
      suspend = suspend,
      schedule = schedule,
      jobTemplate = jobTemplate,
      timeZone = timeZone
    )

    implicit lazy val io_k8s_api_authorization_v1NonResourceAttributesEncoder : Encoder[io.k8s.api.authorization.v1.NonResourceAttributes] = o =>
      Json.obj(
        "path" -> o.path.asJson,
      "verb" -> o.verb.asJson
      )
    implicit lazy val io_k8s_api_authorization_v1NonResourceAttributesDecoder : Decoder[io.k8s.api.authorization.v1.NonResourceAttributes] = (c: HCursor) => for {
       path <- c.get[Option[String]]("path")
       verb <- c.get[Option[String]]("verb")
    } yield io.k8s.api.authorization.v1.NonResourceAttributes(
      path = path,
      verb = verb
    )

    implicit lazy val io_k8s_api_core_v1HTTPGetActionEncoder : Encoder[io.k8s.api.core.v1.HTTPGetAction] = o =>
      Json.obj(
        "path" -> o.path.asJson,
      "host" -> o.host.asJson,
      "port" -> o.port.asJson,
      "scheme" -> o.scheme.asJson,
      "httpHeaders" -> o.httpHeaders.asJson
      )
    implicit lazy val io_k8s_api_core_v1HTTPGetActionDecoder : Decoder[io.k8s.api.core.v1.HTTPGetAction] = (c: HCursor) => for {
       path <- c.get[Option[String]]("path")
       host <- c.get[Option[String]]("host")
       port <- c.get[io.k8s.apimachinery.pkg.util.intstr.IntOrString]("port")
       scheme <- c.get[Option[String]]("scheme")
       httpHeaders <- c.get[Option[Seq[io.k8s.api.core.v1.HTTPHeader]]]("httpHeaders")
    } yield io.k8s.api.core.v1.HTTPGetAction(
      path = path,
      host = host,
      port = port,
      scheme = scheme,
      httpHeaders = httpHeaders
    )

    implicit lazy val io_k8s_api_core_v1TopologySelectorLabelRequirementEncoder : Encoder[io.k8s.api.core.v1.TopologySelectorLabelRequirement] = o =>
      Json.obj(
        "key" -> o.key.asJson,
      "values" -> o.values.asJson
      )
    implicit lazy val io_k8s_api_core_v1TopologySelectorLabelRequirementDecoder : Decoder[io.k8s.api.core.v1.TopologySelectorLabelRequirement] = (c: HCursor) => for {
       key <- c.get[String]("key")
       values <- c.get[Seq[String]]("values")
    } yield io.k8s.api.core.v1.TopologySelectorLabelRequirement(
      key = key,
      values = values
    )

    implicit lazy val io_k8s_api_core_v1LocalVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.LocalVolumeSource] = o =>
      Json.obj(
        "fsType" -> o.fsType.asJson,
      "path" -> o.path.asJson
      )
    implicit lazy val io_k8s_api_core_v1LocalVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.LocalVolumeSource] = (c: HCursor) => for {
       fsType <- c.get[Option[String]]("fsType")
       path <- c.get[String]("path")
    } yield io.k8s.api.core.v1.LocalVolumeSource(
      fsType = fsType,
      path = path
    )

    implicit lazy val io_k8s_api_networking_v1IngressClassParametersReferenceEncoder : Encoder[io.k8s.api.networking.v1.IngressClassParametersReference] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "scope" -> o.scope.asJson,
      "apiGroup" -> o.apiGroup.asJson,
      "namespace" -> o.namespace.asJson
      )
    implicit lazy val io_k8s_api_networking_v1IngressClassParametersReferenceDecoder : Decoder[io.k8s.api.networking.v1.IngressClassParametersReference] = (c: HCursor) => for {
       name <- c.get[String]("name")
       scope <- c.get[Option[String]]("scope")
       apiGroup <- c.get[Option[String]]("apiGroup")
       namespace <- c.get[Option[String]]("namespace")
    } yield io.k8s.api.networking.v1.IngressClassParametersReference(
      name = name,
      scope = scope,
      apiGroup = apiGroup,
      namespace = namespace
    )

    implicit lazy val io_k8s_api_core_v1RBDPersistentVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.RBDPersistentVolumeSource] = o =>
      Json.obj(
        "readOnly" -> o.readOnly.asJson,
      "fsType" -> o.fsType.asJson,
      "image" -> o.image.asJson,
      "secretRef" -> o.secretRef.asJson,
      "pool" -> o.pool.asJson,
      "keyring" -> o.keyring.asJson,
      "monitors" -> o.monitors.asJson,
      "user" -> o.user.asJson
      )
    implicit lazy val io_k8s_api_core_v1RBDPersistentVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.RBDPersistentVolumeSource] = (c: HCursor) => for {
       readOnly <- c.get[Option[Boolean]]("readOnly")
       fsType <- c.get[Option[String]]("fsType")
       image <- c.get[String]("image")
       secretRef <- c.get[Option[io.k8s.api.core.v1.SecretReference]]("secretRef")
       pool <- c.get[Option[String]]("pool")
       keyring <- c.get[Option[String]]("keyring")
       monitors <- c.get[Seq[String]]("monitors")
       user <- c.get[Option[String]]("user")
    } yield io.k8s.api.core.v1.RBDPersistentVolumeSource(
      readOnly = readOnly,
      fsType = fsType,
      image = image,
      secretRef = secretRef,
      pool = pool,
      keyring = keyring,
      monitors = monitors,
      user = user
    )

    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1ObjectMetaEncoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "ownerReferences" -> o.ownerReferences.asJson,
      "creationTimestamp" -> o.creationTimestamp.asJson,
      "generation" -> o.generation.asJson,
      "resourceVersion" -> o.resourceVersion.asJson,
      "generateName" -> o.generateName.asJson,
      "deletionGracePeriodSeconds" -> o.deletionGracePeriodSeconds.asJson,
      "selfLink" -> o.selfLink.asJson,
      "finalizers" -> o.finalizers.asJson,
      "annotations" -> o.annotations.asJson,
      "managedFields" -> o.managedFields.asJson,
      "labels" -> o.labels.asJson,
      "uid" -> o.uid.asJson,
      "namespace" -> o.namespace.asJson,
      "deletionTimestamp" -> o.deletionTimestamp.asJson
      )
    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1ObjectMetaDecoder : Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = (c: HCursor) => for {
       name <- c.get[Option[String]]("name")
       ownerReferences <- c.get[Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference]]]("ownerReferences")
       creationTimestamp <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("creationTimestamp")
       generation <- c.get[Option[Int]]("generation")
       resourceVersion <- c.get[Option[String]]("resourceVersion")
       generateName <- c.get[Option[String]]("generateName")
       deletionGracePeriodSeconds <- c.get[Option[Int]]("deletionGracePeriodSeconds")
       selfLink <- c.get[Option[String]]("selfLink")
       finalizers <- c.get[Option[Seq[String]]]("finalizers")
       annotations <- c.get[Option[Map[String, String]]]("annotations")
       managedFields <- c.get[Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry]]]("managedFields")
       labels <- c.get[Option[Map[String, String]]]("labels")
       uid <- c.get[Option[String]]("uid")
       namespace <- c.get[Option[String]]("namespace")
       deletionTimestamp <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("deletionTimestamp")
    } yield io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta(
      name = name,
      ownerReferences = ownerReferences,
      creationTimestamp = creationTimestamp,
      generation = generation,
      resourceVersion = resourceVersion,
      generateName = generateName,
      deletionGracePeriodSeconds = deletionGracePeriodSeconds,
      selfLink = selfLink,
      finalizers = finalizers,
      annotations = annotations,
      managedFields = managedFields,
      labels = labels,
      uid = uid,
      namespace = namespace,
      deletionTimestamp = deletionTimestamp
    )

    implicit lazy val io_k8s_api_core_v1ISCSIPersistentVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.ISCSIPersistentVolumeSource] = o =>
      Json.obj(
        "portals" -> o.portals.asJson,
      "readOnly" -> o.readOnly.asJson,
      "chapAuthDiscovery" -> o.chapAuthDiscovery.asJson,
      "fsType" -> o.fsType.asJson,
      "secretRef" -> o.secretRef.asJson,
      "iqn" -> o.iqn.asJson,
      "initiatorName" -> o.initiatorName.asJson,
      "iscsiInterface" -> o.iscsiInterface.asJson,
      "targetPortal" -> o.targetPortal.asJson,
      "lun" -> o.lun.asJson,
      "chapAuthSession" -> o.chapAuthSession.asJson
      )
    implicit lazy val io_k8s_api_core_v1ISCSIPersistentVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.ISCSIPersistentVolumeSource] = (c: HCursor) => for {
       portals <- c.get[Option[Seq[String]]]("portals")
       readOnly <- c.get[Option[Boolean]]("readOnly")
       chapAuthDiscovery <- c.get[Option[Boolean]]("chapAuthDiscovery")
       fsType <- c.get[Option[String]]("fsType")
       secretRef <- c.get[Option[io.k8s.api.core.v1.SecretReference]]("secretRef")
       iqn <- c.get[String]("iqn")
       initiatorName <- c.get[Option[String]]("initiatorName")
       iscsiInterface <- c.get[Option[String]]("iscsiInterface")
       targetPortal <- c.get[String]("targetPortal")
       lun <- c.get[Int]("lun")
       chapAuthSession <- c.get[Option[Boolean]]("chapAuthSession")
    } yield io.k8s.api.core.v1.ISCSIPersistentVolumeSource(
      portals = portals,
      readOnly = readOnly,
      chapAuthDiscovery = chapAuthDiscovery,
      fsType = fsType,
      secretRef = secretRef,
      iqn = iqn,
      initiatorName = initiatorName,
      iscsiInterface = iscsiInterface,
      targetPortal = targetPortal,
      lun = lun,
      chapAuthSession = chapAuthSession
    )

    implicit lazy val io_k8s_api_core_v1ServicePortEncoder : Encoder[io.k8s.api.core.v1.ServicePort] = o =>
      Json.obj(
        "nodePort" -> o.nodePort.asJson,
      "name" -> o.name.asJson,
      "port" -> o.port.asJson,
      "targetPort" -> o.targetPort.asJson,
      "protocol" -> o.protocol.asJson,
      "appProtocol" -> o.appProtocol.asJson
      )
    implicit lazy val io_k8s_api_core_v1ServicePortDecoder : Decoder[io.k8s.api.core.v1.ServicePort] = (c: HCursor) => for {
       nodePort <- c.get[Option[Int]]("nodePort")
       name <- c.get[Option[String]]("name")
       port <- c.get[Int]("port")
       targetPort <- c.get[Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString]]("targetPort")
       protocol <- c.get[Option[String]]("protocol")
       appProtocol <- c.get[Option[String]]("appProtocol")
    } yield io.k8s.api.core.v1.ServicePort(
      nodePort = nodePort,
      name = name,
      port = port,
      targetPort = targetPort,
      protocol = protocol,
      appProtocol = appProtocol
    )

    implicit lazy val io_k8s_api_core_v1ClientIPConfigEncoder : Encoder[io.k8s.api.core.v1.ClientIPConfig] = o =>
      Json.obj(
        "timeoutSeconds" -> o.timeoutSeconds.asJson
      )
    implicit lazy val io_k8s_api_core_v1ClientIPConfigDecoder : Decoder[io.k8s.api.core.v1.ClientIPConfig] = (c: HCursor) => for {
       timeoutSeconds <- c.get[Option[Int]]("timeoutSeconds")
    } yield io.k8s.api.core.v1.ClientIPConfig(
      timeoutSeconds = timeoutSeconds
    )

    implicit lazy val io_k8s_api_batch_v1UncountedTerminatedPodsEncoder : Encoder[io.k8s.api.batch.v1.UncountedTerminatedPods] = o =>
      Json.obj(
        "failed" -> o.failed.asJson,
      "succeeded" -> o.succeeded.asJson
      )
    implicit lazy val io_k8s_api_batch_v1UncountedTerminatedPodsDecoder : Decoder[io.k8s.api.batch.v1.UncountedTerminatedPods] = (c: HCursor) => for {
       failed <- c.get[Option[Seq[String]]]("failed")
       succeeded <- c.get[Option[Seq[String]]]("succeeded")
    } yield io.k8s.api.batch.v1.UncountedTerminatedPods(
      failed = failed,
      succeeded = succeeded
    )

    implicit lazy val io_k8s_api_networking_v1alpha1ClusterCIDRSpecEncoder : Encoder[io.k8s.api.networking.v1alpha1.ClusterCIDRSpec] = o =>
      Json.obj(
        "ipv4" -> o.ipv4.asJson,
      "ipv6" -> o.ipv6.asJson,
      "nodeSelector" -> o.nodeSelector.asJson,
      "perNodeHostBits" -> o.perNodeHostBits.asJson
      )
    implicit lazy val io_k8s_api_networking_v1alpha1ClusterCIDRSpecDecoder : Decoder[io.k8s.api.networking.v1alpha1.ClusterCIDRSpec] = (c: HCursor) => for {
       ipv4 <- c.get[Option[String]]("ipv4")
       ipv6 <- c.get[Option[String]]("ipv6")
       nodeSelector <- c.get[Option[io.k8s.api.core.v1.NodeSelector]]("nodeSelector")
       perNodeHostBits <- c.get[Int]("perNodeHostBits")
    } yield io.k8s.api.networking.v1alpha1.ClusterCIDRSpec(
      ipv4 = ipv4,
      ipv6 = ipv6,
      nodeSelector = nodeSelector,
      perNodeHostBits = perNodeHostBits
    )

    implicit lazy val io_k8s_api_networking_v1NetworkPolicySpecEncoder : Encoder[io.k8s.api.networking.v1.NetworkPolicySpec] = o =>
      Json.obj(
        "egress" -> o.egress.asJson,
      "ingress" -> o.ingress.asJson,
      "podSelector" -> o.podSelector.asJson,
      "policyTypes" -> o.policyTypes.asJson
      )
    implicit lazy val io_k8s_api_networking_v1NetworkPolicySpecDecoder : Decoder[io.k8s.api.networking.v1.NetworkPolicySpec] = (c: HCursor) => for {
       egress <- c.get[Option[Seq[io.k8s.api.networking.v1.NetworkPolicyEgressRule]]]("egress")
       ingress <- c.get[Option[Seq[io.k8s.api.networking.v1.NetworkPolicyIngressRule]]]("ingress")
       podSelector <- c.get[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]("podSelector")
       policyTypes <- c.get[Option[Seq[String]]]("policyTypes")
    } yield io.k8s.api.networking.v1.NetworkPolicySpec(
      egress = egress,
      ingress = ingress,
      podSelector = podSelector,
      policyTypes = policyTypes
    )

    implicit lazy val io_k8s_api_core_v1SecretKeySelectorEncoder : Encoder[io.k8s.api.core.v1.SecretKeySelector] = o =>
      Json.obj(
        "key" -> o.key.asJson,
      "name" -> o.name.asJson,
      "optional" -> o.optional.asJson
      )
    implicit lazy val io_k8s_api_core_v1SecretKeySelectorDecoder : Decoder[io.k8s.api.core.v1.SecretKeySelector] = (c: HCursor) => for {
       key <- c.get[String]("key")
       name <- c.get[Option[String]]("name")
       optional <- c.get[Option[Boolean]]("optional")
    } yield io.k8s.api.core.v1.SecretKeySelector(
      key = key,
      name = name,
      optional = optional
    )

    implicit lazy val io_k8s_api_apps_v1ReplicaSetStatusEncoder : Encoder[io.k8s.api.apps.v1.ReplicaSetStatus] = o =>
      Json.obj(
        "conditions" -> o.conditions.asJson,
      "replicas" -> o.replicas.asJson,
      "availableReplicas" -> o.availableReplicas.asJson,
      "observedGeneration" -> o.observedGeneration.asJson,
      "readyReplicas" -> o.readyReplicas.asJson,
      "fullyLabeledReplicas" -> o.fullyLabeledReplicas.asJson
      )
    implicit lazy val io_k8s_api_apps_v1ReplicaSetStatusDecoder : Decoder[io.k8s.api.apps.v1.ReplicaSetStatus] = (c: HCursor) => for {
       conditions <- c.get[Option[Seq[io.k8s.api.apps.v1.ReplicaSetCondition]]]("conditions")
       replicas <- c.get[Int]("replicas")
       availableReplicas <- c.get[Option[Int]]("availableReplicas")
       observedGeneration <- c.get[Option[Int]]("observedGeneration")
       readyReplicas <- c.get[Option[Int]]("readyReplicas")
       fullyLabeledReplicas <- c.get[Option[Int]]("fullyLabeledReplicas")
    } yield io.k8s.api.apps.v1.ReplicaSetStatus(
      conditions = conditions,
      replicas = replicas,
      availableReplicas = availableReplicas,
      observedGeneration = observedGeneration,
      readyReplicas = readyReplicas,
      fullyLabeledReplicas = fullyLabeledReplicas
    )

    implicit lazy val io_k8s_api_core_v1SecretVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.SecretVolumeSource] = o =>
      Json.obj(
        "defaultMode" -> o.defaultMode.asJson,
      "items" -> o.items.asJson,
      "optional" -> o.optional.asJson,
      "secretName" -> o.secretName.asJson
      )
    implicit lazy val io_k8s_api_core_v1SecretVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.SecretVolumeSource] = (c: HCursor) => for {
       defaultMode <- c.get[Option[Int]]("defaultMode")
       items <- c.get[Option[Seq[io.k8s.api.core.v1.KeyToPath]]]("items")
       optional <- c.get[Option[Boolean]]("optional")
       secretName <- c.get[Option[String]]("secretName")
    } yield io.k8s.api.core.v1.SecretVolumeSource(
      defaultMode = defaultMode,
      items = items,
      optional = optional,
      secretName = secretName
    )

    implicit lazy val io_k8s_api_core_v1PodOSEncoder : Encoder[io.k8s.api.core.v1.PodOS] = o =>
      Json.obj(
        "name" -> o.name.asJson
      )
    implicit lazy val io_k8s_api_core_v1PodOSDecoder : Decoder[io.k8s.api.core.v1.PodOS] = (c: HCursor) => for {
       name <- c.get[String]("name")
    } yield io.k8s.api.core.v1.PodOS(
      name = name
    )

    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceValidationEncoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation] = o =>
      Json.obj(
        "openAPIV3Schema" -> o.openAPIV3Schema.asJson
      )
    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceValidationDecoder : Decoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation] = (c: HCursor) => for {
       openAPIV3Schema <- c.get[Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]]("openAPIV3Schema")
    } yield io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation(
      openAPIV3Schema = openAPIV3Schema
    )

    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1ManagedFieldsEntryEncoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry] = o =>
      Json.obj(
        "operation" -> o.operation.asJson,
      "manager" -> o.manager.asJson,
      "fieldsV1" -> o.fieldsV1.asJson,
      "time" -> o.time.asJson,
      "fieldsType" -> o.fieldsType.asJson,
      "subresource" -> o.subresource.asJson
      )
    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1ManagedFieldsEntryDecoder : Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry] = (c: HCursor) => for {
       operation <- c.get[Option[String]]("operation")
       manager <- c.get[Option[String]]("manager")
       fieldsV1 <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.FieldsV1]]("fieldsV1")
       time <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("time")
       fieldsType <- c.get[Option[String]]("fieldsType")
       subresource <- c.get[Option[String]]("subresource")
    } yield io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry(
      operation = operation,
      manager = manager,
      fieldsV1 = fieldsV1,
      time = time,
      fieldsType = fieldsType,
      subresource = subresource
    )

    implicit lazy val io_k8s_api_core_v1HostAliasEncoder : Encoder[io.k8s.api.core.v1.HostAlias] = o =>
      Json.obj(
        "hostnames" -> o.hostnames.asJson,
      "ip" -> o.ip.asJson
      )
    implicit lazy val io_k8s_api_core_v1HostAliasDecoder : Decoder[io.k8s.api.core.v1.HostAlias] = (c: HCursor) => for {
       hostnames <- c.get[Option[Seq[String]]]("hostnames")
       ip <- c.get[Option[String]]("ip")
    } yield io.k8s.api.core.v1.HostAlias(
      hostnames = hostnames,
      ip = ip
    )

    implicit lazy val io_k8s_api_networking_v1HTTPIngressRuleValueEncoder : Encoder[io.k8s.api.networking.v1.HTTPIngressRuleValue] = o =>
      Json.obj(
        "paths" -> o.paths.asJson
      )
    implicit lazy val io_k8s_api_networking_v1HTTPIngressRuleValueDecoder : Decoder[io.k8s.api.networking.v1.HTTPIngressRuleValue] = (c: HCursor) => for {
       paths <- c.get[Seq[io.k8s.api.networking.v1.HTTPIngressPath]]("paths")
    } yield io.k8s.api.networking.v1.HTTPIngressRuleValue(
      paths = paths
    )

    implicit lazy val io_k8s_api_core_v1PodAntiAffinityEncoder : Encoder[io.k8s.api.core.v1.PodAntiAffinity] = o =>
      Json.obj(
        "preferredDuringSchedulingIgnoredDuringExecution" -> o.preferredDuringSchedulingIgnoredDuringExecution.asJson,
      "requiredDuringSchedulingIgnoredDuringExecution" -> o.requiredDuringSchedulingIgnoredDuringExecution.asJson
      )
    implicit lazy val io_k8s_api_core_v1PodAntiAffinityDecoder : Decoder[io.k8s.api.core.v1.PodAntiAffinity] = (c: HCursor) => for {
       preferredDuringSchedulingIgnoredDuringExecution <- c.get[Option[Seq[io.k8s.api.core.v1.WeightedPodAffinityTerm]]]("preferredDuringSchedulingIgnoredDuringExecution")
       requiredDuringSchedulingIgnoredDuringExecution <- c.get[Option[Seq[io.k8s.api.core.v1.PodAffinityTerm]]]("requiredDuringSchedulingIgnoredDuringExecution")
    } yield io.k8s.api.core.v1.PodAntiAffinity(
      preferredDuringSchedulingIgnoredDuringExecution = preferredDuringSchedulingIgnoredDuringExecution,
      requiredDuringSchedulingIgnoredDuringExecution = requiredDuringSchedulingIgnoredDuringExecution
    )

    implicit lazy val io_k8s_api_core_v1AffinityEncoder : Encoder[io.k8s.api.core.v1.Affinity] = o =>
      Json.obj(
        "nodeAffinity" -> o.nodeAffinity.asJson,
      "podAffinity" -> o.podAffinity.asJson,
      "podAntiAffinity" -> o.podAntiAffinity.asJson
      )
    implicit lazy val io_k8s_api_core_v1AffinityDecoder : Decoder[io.k8s.api.core.v1.Affinity] = (c: HCursor) => for {
       nodeAffinity <- c.get[Option[io.k8s.api.core.v1.NodeAffinity]]("nodeAffinity")
       podAffinity <- c.get[Option[io.k8s.api.core.v1.PodAffinity]]("podAffinity")
       podAntiAffinity <- c.get[Option[io.k8s.api.core.v1.PodAntiAffinity]]("podAntiAffinity")
    } yield io.k8s.api.core.v1.Affinity(
      nodeAffinity = nodeAffinity,
      podAffinity = podAffinity,
      podAntiAffinity = podAntiAffinity
    )

    implicit lazy val io_k8s_api_autoscaling_v2ContainerResourceMetricStatusEncoder : Encoder[io.k8s.api.autoscaling.v2.ContainerResourceMetricStatus] = o =>
      Json.obj(
        "container" -> o.container.asJson,
      "current" -> o.current.asJson,
      "name" -> o.name.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2ContainerResourceMetricStatusDecoder : Decoder[io.k8s.api.autoscaling.v2.ContainerResourceMetricStatus] = (c: HCursor) => for {
       container <- c.get[String]("container")
       current <- c.get[io.k8s.api.autoscaling.v2.MetricValueStatus]("current")
       name <- c.get[String]("name")
    } yield io.k8s.api.autoscaling.v2.ContainerResourceMetricStatus(
      container = container,
      current = current,
      name = name
    )

    implicit lazy val io_k8s_api_core_v1AzureDiskVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.AzureDiskVolumeSource] = o =>
      Json.obj(
        "readOnly" -> o.readOnly.asJson,
      "fsType" -> o.fsType.asJson,
      "diskURI" -> o.diskURI.asJson,
      "diskName" -> o.diskName.asJson,
      "cachingMode" -> o.cachingMode.asJson
      )
    implicit lazy val io_k8s_api_core_v1AzureDiskVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.AzureDiskVolumeSource] = (c: HCursor) => for {
       readOnly <- c.get[Option[Boolean]]("readOnly")
       fsType <- c.get[Option[String]]("fsType")
       diskURI <- c.get[String]("diskURI")
       diskName <- c.get[String]("diskName")
       cachingMode <- c.get[Option[String]]("cachingMode")
    } yield io.k8s.api.core.v1.AzureDiskVolumeSource(
      readOnly = readOnly,
      fsType = fsType,
      diskURI = diskURI,
      diskName = diskName,
      cachingMode = cachingMode
    )

    implicit lazy val io_k8s_api_core_v1NFSVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.NFSVolumeSource] = o =>
      Json.obj(
        "path" -> o.path.asJson,
      "readOnly" -> o.readOnly.asJson,
      "server" -> o.server.asJson
      )
    implicit lazy val io_k8s_api_core_v1NFSVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.NFSVolumeSource] = (c: HCursor) => for {
       path <- c.get[String]("path")
       readOnly <- c.get[Option[Boolean]]("readOnly")
       server <- c.get[String]("server")
    } yield io.k8s.api.core.v1.NFSVolumeSource(
      path = path,
      readOnly = readOnly,
      server = server
    )

    implicit lazy val io_k8s_api_networking_v1IngressBackendEncoder : Encoder[io.k8s.api.networking.v1.IngressBackend] = o =>
      Json.obj(
        "resource" -> o.resource.asJson,
      "service" -> o.service.asJson
      )
    implicit lazy val io_k8s_api_networking_v1IngressBackendDecoder : Decoder[io.k8s.api.networking.v1.IngressBackend] = (c: HCursor) => for {
       resource <- c.get[Option[io.k8s.api.core.v1.TypedLocalObjectReference]]("resource")
       service <- c.get[Option[io.k8s.api.networking.v1.IngressServiceBackend]]("service")
    } yield io.k8s.api.networking.v1.IngressBackend(
      resource = resource,
      service = service
    )

    implicit lazy val io_k8s_api_apps_v1ReplicaSetConditionEncoder : Encoder[io.k8s.api.apps.v1.ReplicaSetCondition] = o =>
      Json.obj(
        "reason" -> o.reason.asJson,
      "status" -> o.status.asJson,
      "lastTransitionTime" -> o.lastTransitionTime.asJson,
      "message" -> o.message.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_apps_v1ReplicaSetConditionDecoder : Decoder[io.k8s.api.apps.v1.ReplicaSetCondition] = (c: HCursor) => for {
       reason <- c.get[Option[String]]("reason")
       status <- c.get[String]("status")
       lastTransitionTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastTransitionTime")
       message <- c.get[Option[String]]("message")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.apps.v1.ReplicaSetCondition(
      reason = reason,
      status = status,
      lastTransitionTime = lastTransitionTime,
      message = message,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_flowcontrol_v1beta1FlowSchemaConditionEncoder : Encoder[io.k8s.api.flowcontrol.v1beta1.FlowSchemaCondition] = o =>
      Json.obj(
        "reason" -> o.reason.asJson,
      "status" -> o.status.asJson,
      "lastTransitionTime" -> o.lastTransitionTime.asJson,
      "message" -> o.message.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_flowcontrol_v1beta1FlowSchemaConditionDecoder : Decoder[io.k8s.api.flowcontrol.v1beta1.FlowSchemaCondition] = (c: HCursor) => for {
       reason <- c.get[Option[String]]("reason")
       status <- c.get[Option[String]]("status")
       lastTransitionTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastTransitionTime")
       message <- c.get[Option[String]]("message")
       `type` <- c.get[Option[String]]("type")
    } yield io.k8s.api.flowcontrol.v1beta1.FlowSchemaCondition(
      reason = reason,
      status = status,
      lastTransitionTime = lastTransitionTime,
      message = message,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_core_v1EphemeralContainerEncoder : Encoder[io.k8s.api.core.v1.EphemeralContainer] = o =>
      Json.obj(
        "readinessProbe" -> o.readinessProbe.asJson,
      "name" -> o.name.asJson,
      "livenessProbe" -> o.livenessProbe.asJson,
      "lifecycle" -> o.lifecycle.asJson,
      "image" -> o.image.asJson,
      "stdinOnce" -> o.stdinOnce.asJson,
      "ports" -> o.ports.asJson,
      "startupProbe" -> o.startupProbe.asJson,
      "command" -> o.command.asJson,
      "terminationMessagePolicy" -> o.terminationMessagePolicy.asJson,
      "targetContainerName" -> o.targetContainerName.asJson,
      "stdin" -> o.stdin.asJson,
      "terminationMessagePath" -> o.terminationMessagePath.asJson,
      "resources" -> o.resources.asJson,
      "envFrom" -> o.envFrom.asJson,
      "volumeDevices" -> o.volumeDevices.asJson,
      "args" -> o.args.asJson,
      "tty" -> o.tty.asJson,
      "imagePullPolicy" -> o.imagePullPolicy.asJson,
      "workingDir" -> o.workingDir.asJson,
      "volumeMounts" -> o.volumeMounts.asJson,
      "env" -> o.env.asJson,
      "securityContext" -> o.securityContext.asJson
      )
    implicit lazy val io_k8s_api_core_v1EphemeralContainerDecoder : Decoder[io.k8s.api.core.v1.EphemeralContainer] = (c: HCursor) => for {
       readinessProbe <- c.get[Option[io.k8s.api.core.v1.Probe]]("readinessProbe")
       name <- c.get[String]("name")
       livenessProbe <- c.get[Option[io.k8s.api.core.v1.Probe]]("livenessProbe")
       lifecycle <- c.get[Option[io.k8s.api.core.v1.Lifecycle]]("lifecycle")
       image <- c.get[Option[String]]("image")
       stdinOnce <- c.get[Option[Boolean]]("stdinOnce")
       ports <- c.get[Option[Seq[io.k8s.api.core.v1.ContainerPort]]]("ports")
       startupProbe <- c.get[Option[io.k8s.api.core.v1.Probe]]("startupProbe")
       command <- c.get[Option[Seq[String]]]("command")
       terminationMessagePolicy <- c.get[Option[String]]("terminationMessagePolicy")
       targetContainerName <- c.get[Option[String]]("targetContainerName")
       stdin <- c.get[Option[Boolean]]("stdin")
       terminationMessagePath <- c.get[Option[String]]("terminationMessagePath")
       resources <- c.get[Option[io.k8s.api.core.v1.ResourceRequirements]]("resources")
       envFrom <- c.get[Option[Seq[io.k8s.api.core.v1.EnvFromSource]]]("envFrom")
       volumeDevices <- c.get[Option[Seq[io.k8s.api.core.v1.VolumeDevice]]]("volumeDevices")
       args <- c.get[Option[Seq[String]]]("args")
       tty <- c.get[Option[Boolean]]("tty")
       imagePullPolicy <- c.get[Option[String]]("imagePullPolicy")
       workingDir <- c.get[Option[String]]("workingDir")
       volumeMounts <- c.get[Option[Seq[io.k8s.api.core.v1.VolumeMount]]]("volumeMounts")
       env <- c.get[Option[Seq[io.k8s.api.core.v1.EnvVar]]]("env")
       securityContext <- c.get[Option[io.k8s.api.core.v1.SecurityContext]]("securityContext")
    } yield io.k8s.api.core.v1.EphemeralContainer(
      readinessProbe = readinessProbe,
      name = name,
      livenessProbe = livenessProbe,
      lifecycle = lifecycle,
      image = image,
      stdinOnce = stdinOnce,
      ports = ports,
      startupProbe = startupProbe,
      command = command,
      terminationMessagePolicy = terminationMessagePolicy,
      targetContainerName = targetContainerName,
      stdin = stdin,
      terminationMessagePath = terminationMessagePath,
      resources = resources,
      envFrom = envFrom,
      volumeDevices = volumeDevices,
      args = args,
      tty = tty,
      imagePullPolicy = imagePullPolicy,
      workingDir = workingDir,
      volumeMounts = volumeMounts,
      env = env,
      securityContext = securityContext
    )

    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceSubresourcesEncoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources] = o =>
      Json.obj(
        "scale" -> o.scale.asJson,
      "status" -> o.status.asJson
      )
    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceSubresourcesDecoder : Decoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources] = (c: HCursor) => for {
       scale <- c.get[Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceScale]]("scale")
       status <- c.get[Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceStatus]]("status")
    } yield io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources(
      scale = scale,
      status = status
    )

    implicit lazy val io_k8s_api_core_v1PodDNSConfigOptionEncoder : Encoder[io.k8s.api.core.v1.PodDNSConfigOption] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "value" -> o.value.asJson
      )
    implicit lazy val io_k8s_api_core_v1PodDNSConfigOptionDecoder : Decoder[io.k8s.api.core.v1.PodDNSConfigOption] = (c: HCursor) => for {
       name <- c.get[Option[String]]("name")
       value <- c.get[Option[String]]("value")
    } yield io.k8s.api.core.v1.PodDNSConfigOption(
      name = name,
      value = value
    )

    implicit lazy val io_k8s_api_core_v1NodeConfigStatusEncoder : Encoder[io.k8s.api.core.v1.NodeConfigStatus] = o =>
      Json.obj(
        "active" -> o.active.asJson,
      "assigned" -> o.assigned.asJson,
      "error" -> o.error.asJson,
      "lastKnownGood" -> o.lastKnownGood.asJson
      )
    implicit lazy val io_k8s_api_core_v1NodeConfigStatusDecoder : Decoder[io.k8s.api.core.v1.NodeConfigStatus] = (c: HCursor) => for {
       active <- c.get[Option[io.k8s.api.core.v1.NodeConfigSource]]("active")
       assigned <- c.get[Option[io.k8s.api.core.v1.NodeConfigSource]]("assigned")
       error <- c.get[Option[String]]("error")
       lastKnownGood <- c.get[Option[io.k8s.api.core.v1.NodeConfigSource]]("lastKnownGood")
    } yield io.k8s.api.core.v1.NodeConfigStatus(
      active = active,
      assigned = assigned,
      error = error,
      lastKnownGood = lastKnownGood
    )

    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1LabelSelectorRequirementEncoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement] = o =>
      Json.obj(
        "key" -> o.key.asJson,
      "operator" -> o.operator.asJson,
      "values" -> o.values.asJson
      )
    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1LabelSelectorRequirementDecoder : Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement] = (c: HCursor) => for {
       key <- c.get[String]("key")
       operator <- c.get[String]("operator")
       values <- c.get[Option[Seq[String]]]("values")
    } yield io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement(
      key = key,
      operator = operator,
      values = values
    )

    implicit lazy val io_k8s_api_autoscaling_v2ObjectMetricStatusEncoder : Encoder[io.k8s.api.autoscaling.v2.ObjectMetricStatus] = o =>
      Json.obj(
        "current" -> o.current.asJson,
      "describedObject" -> o.describedObject.asJson,
      "metric" -> o.metric.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2ObjectMetricStatusDecoder : Decoder[io.k8s.api.autoscaling.v2.ObjectMetricStatus] = (c: HCursor) => for {
       current <- c.get[io.k8s.api.autoscaling.v2.MetricValueStatus]("current")
       describedObject <- c.get[io.k8s.api.autoscaling.v2.CrossVersionObjectReference]("describedObject")
       metric <- c.get[io.k8s.api.autoscaling.v2.MetricIdentifier]("metric")
    } yield io.k8s.api.autoscaling.v2.ObjectMetricStatus(
      current = current,
      describedObject = describedObject,
      metric = metric
    )

    implicit lazy val io_k8s_api_core_v1ProjectedVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.ProjectedVolumeSource] = o =>
      Json.obj(
        "defaultMode" -> o.defaultMode.asJson,
      "sources" -> o.sources.asJson
      )
    implicit lazy val io_k8s_api_core_v1ProjectedVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.ProjectedVolumeSource] = (c: HCursor) => for {
       defaultMode <- c.get[Option[Int]]("defaultMode")
       sources <- c.get[Option[Seq[io.k8s.api.core.v1.VolumeProjection]]]("sources")
    } yield io.k8s.api.core.v1.ProjectedVolumeSource(
      defaultMode = defaultMode,
      sources = sources
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2MetricSpecEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.MetricSpec] = o =>
      Json.obj(
        "object" -> o.`object`.asJson,
      "external" -> o.external.asJson,
      "containerResource" -> o.containerResource.asJson,
      "resource" -> o.resource.asJson,
      "pods" -> o.pods.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2MetricSpecDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.MetricSpec] = (c: HCursor) => for {
       `object` <- c.get[Option[io.k8s.api.autoscaling.v2beta2.ObjectMetricSource]]("object")
       external <- c.get[Option[io.k8s.api.autoscaling.v2beta2.ExternalMetricSource]]("external")
       containerResource <- c.get[Option[io.k8s.api.autoscaling.v2beta2.ContainerResourceMetricSource]]("containerResource")
       resource <- c.get[Option[io.k8s.api.autoscaling.v2beta2.ResourceMetricSource]]("resource")
       pods <- c.get[Option[io.k8s.api.autoscaling.v2beta2.PodsMetricSource]]("pods")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.autoscaling.v2beta2.MetricSpec(
      `object` = `object`,
      external = external,
      containerResource = containerResource,
      resource = resource,
      pods = pods,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_networking_v1IngressTLSEncoder : Encoder[io.k8s.api.networking.v1.IngressTLS] = o =>
      Json.obj(
        "hosts" -> o.hosts.asJson,
      "secretName" -> o.secretName.asJson
      )
    implicit lazy val io_k8s_api_networking_v1IngressTLSDecoder : Decoder[io.k8s.api.networking.v1.IngressTLS] = (c: HCursor) => for {
       hosts <- c.get[Option[Seq[String]]]("hosts")
       secretName <- c.get[Option[String]]("secretName")
    } yield io.k8s.api.networking.v1.IngressTLS(
      hosts = hosts,
      secretName = secretName
    )

    implicit lazy val io_k8s_api_networking_v1NetworkPolicyEgressRuleEncoder : Encoder[io.k8s.api.networking.v1.NetworkPolicyEgressRule] = o =>
      Json.obj(
        "ports" -> o.ports.asJson,
      "to" -> o.to.asJson
      )
    implicit lazy val io_k8s_api_networking_v1NetworkPolicyEgressRuleDecoder : Decoder[io.k8s.api.networking.v1.NetworkPolicyEgressRule] = (c: HCursor) => for {
       ports <- c.get[Option[Seq[io.k8s.api.networking.v1.NetworkPolicyPort]]]("ports")
       to <- c.get[Option[Seq[io.k8s.api.networking.v1.NetworkPolicyPeer]]]("to")
    } yield io.k8s.api.networking.v1.NetworkPolicyEgressRule(
      ports = ports,
      to = to
    )

    implicit lazy val io_k8s_api_core_v1RBDVolumeSourceEncoder : Encoder[io.k8s.api.core.v1.RBDVolumeSource] = o =>
      Json.obj(
        "readOnly" -> o.readOnly.asJson,
      "fsType" -> o.fsType.asJson,
      "image" -> o.image.asJson,
      "secretRef" -> o.secretRef.asJson,
      "pool" -> o.pool.asJson,
      "keyring" -> o.keyring.asJson,
      "monitors" -> o.monitors.asJson,
      "user" -> o.user.asJson
      )
    implicit lazy val io_k8s_api_core_v1RBDVolumeSourceDecoder : Decoder[io.k8s.api.core.v1.RBDVolumeSource] = (c: HCursor) => for {
       readOnly <- c.get[Option[Boolean]]("readOnly")
       fsType <- c.get[Option[String]]("fsType")
       image <- c.get[String]("image")
       secretRef <- c.get[Option[io.k8s.api.core.v1.LocalObjectReference]]("secretRef")
       pool <- c.get[Option[String]]("pool")
       keyring <- c.get[Option[String]]("keyring")
       monitors <- c.get[Seq[String]]("monitors")
       user <- c.get[Option[String]]("user")
    } yield io.k8s.api.core.v1.RBDVolumeSource(
      readOnly = readOnly,
      fsType = fsType,
      image = image,
      secretRef = secretRef,
      pool = pool,
      keyring = keyring,
      monitors = monitors,
      user = user
    )

    implicit lazy val io_k8s_api_apiserverinternal_v1alpha1StorageVersionConditionEncoder : Encoder[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionCondition] = o =>
      Json.obj(
        "reason" -> o.reason.asJson,
      "status" -> o.status.asJson,
      "observedGeneration" -> o.observedGeneration.asJson,
      "lastTransitionTime" -> o.lastTransitionTime.asJson,
      "message" -> o.message.asJson,
      "type" -> o.`type`.asJson
      )
    implicit lazy val io_k8s_api_apiserverinternal_v1alpha1StorageVersionConditionDecoder : Decoder[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionCondition] = (c: HCursor) => for {
       reason <- c.get[String]("reason")
       status <- c.get[String]("status")
       observedGeneration <- c.get[Option[Int]]("observedGeneration")
       lastTransitionTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastTransitionTime")
       message <- c.get[Option[String]]("message")
       `type` <- c.get[String]("type")
    } yield io.k8s.api.apiserverinternal.v1alpha1.StorageVersionCondition(
      reason = reason,
      status = status,
      observedGeneration = observedGeneration,
      lastTransitionTime = lastTransitionTime,
      message = message,
      `type` = `type`
    )

    implicit lazy val io_k8s_api_storage_v1VolumeAttachmentSpecEncoder : Encoder[io.k8s.api.storage.v1.VolumeAttachmentSpec] = o =>
      Json.obj(
        "attacher" -> o.attacher.asJson,
      "nodeName" -> o.nodeName.asJson,
      "source" -> o.source.asJson
      )
    implicit lazy val io_k8s_api_storage_v1VolumeAttachmentSpecDecoder : Decoder[io.k8s.api.storage.v1.VolumeAttachmentSpec] = (c: HCursor) => for {
       attacher <- c.get[String]("attacher")
       nodeName <- c.get[String]("nodeName")
       source <- c.get[io.k8s.api.storage.v1.VolumeAttachmentSource]("source")
    } yield io.k8s.api.storage.v1.VolumeAttachmentSpec(
      attacher = attacher,
      nodeName = nodeName,
      source = source
    )

    implicit lazy val io_k8s_api_core_v1PersistentVolumeClaimSpecEncoder : Encoder[io.k8s.api.core.v1.PersistentVolumeClaimSpec] = o =>
      Json.obj(
        "accessModes" -> o.accessModes.asJson,
      "volumeMode" -> o.volumeMode.asJson,
      "dataSourceRef" -> o.dataSourceRef.asJson,
      "storageClassName" -> o.storageClassName.asJson,
      "dataSource" -> o.dataSource.asJson,
      "volumeName" -> o.volumeName.asJson,
      "resources" -> o.resources.asJson,
      "selector" -> o.selector.asJson
      )
    implicit lazy val io_k8s_api_core_v1PersistentVolumeClaimSpecDecoder : Decoder[io.k8s.api.core.v1.PersistentVolumeClaimSpec] = (c: HCursor) => for {
       accessModes <- c.get[Option[Seq[String]]]("accessModes")
       volumeMode <- c.get[Option[String]]("volumeMode")
       dataSourceRef <- c.get[Option[io.k8s.api.core.v1.TypedLocalObjectReference]]("dataSourceRef")
       storageClassName <- c.get[Option[String]]("storageClassName")
       dataSource <- c.get[Option[io.k8s.api.core.v1.TypedLocalObjectReference]]("dataSource")
       volumeName <- c.get[Option[String]]("volumeName")
       resources <- c.get[Option[io.k8s.api.core.v1.ResourceRequirements]]("resources")
       selector <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]]("selector")
    } yield io.k8s.api.core.v1.PersistentVolumeClaimSpec(
      accessModes = accessModes,
      volumeMode = volumeMode,
      dataSourceRef = dataSourceRef,
      storageClassName = storageClassName,
      dataSource = dataSource,
      volumeName = volumeName,
      resources = resources,
      selector = selector
    )

    implicit lazy val io_k8s_api_policy_v1PodDisruptionBudgetStatusEncoder : Encoder[io.k8s.api.policy.v1.PodDisruptionBudgetStatus] = o =>
      Json.obj(
        "conditions" -> o.conditions.asJson,
      "disruptionsAllowed" -> o.disruptionsAllowed.asJson,
      "disruptedPods" -> o.disruptedPods.asJson,
      "desiredHealthy" -> o.desiredHealthy.asJson,
      "expectedPods" -> o.expectedPods.asJson,
      "observedGeneration" -> o.observedGeneration.asJson,
      "currentHealthy" -> o.currentHealthy.asJson
      )
    implicit lazy val io_k8s_api_policy_v1PodDisruptionBudgetStatusDecoder : Decoder[io.k8s.api.policy.v1.PodDisruptionBudgetStatus] = (c: HCursor) => for {
       conditions <- c.get[Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]]]("conditions")
       disruptionsAllowed <- c.get[Int]("disruptionsAllowed")
       disruptedPods <- c.get[Option[Map[String, io.k8s.apimachinery.pkg.apis.meta.v1.Time]]]("disruptedPods")
       desiredHealthy <- c.get[Int]("desiredHealthy")
       expectedPods <- c.get[Int]("expectedPods")
       observedGeneration <- c.get[Option[Int]]("observedGeneration")
       currentHealthy <- c.get[Int]("currentHealthy")
    } yield io.k8s.api.policy.v1.PodDisruptionBudgetStatus(
      conditions = conditions,
      disruptionsAllowed = disruptionsAllowed,
      disruptedPods = disruptedPods,
      desiredHealthy = desiredHealthy,
      expectedPods = expectedPods,
      observedGeneration = observedGeneration,
      currentHealthy = currentHealthy
    )

    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1JSONSchemaPropsEncoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps] = o =>
      Json.obj(
        "exclusiveMaximum" -> o.exclusiveMaximum.asJson,
      "format" -> o.format.asJson,
      "$ref" -> o.$ref.asJson,
      "nullable" -> o.nullable.asJson,
      "x-kubernetes-map-type" -> o.`x-kubernetes-map-type`.asJson,
      "pattern" -> o.pattern.asJson,
      "description" -> o.description.asJson,
      "anyOf" -> o.anyOf.asJson,
      "x-kubernetes-list-type" -> o.`x-kubernetes-list-type`.asJson,
      "patternProperties" -> o.patternProperties.asJson,
      "items" -> o.items.asJson,
      "additionalItems" -> o.additionalItems.asJson,
      "maxProperties" -> o.maxProperties.asJson,
      "maxItems" -> o.maxItems.asJson,
      "x-kubernetes-int-or-string" -> o.`x-kubernetes-int-or-string`.asJson,
      "x-kubernetes-embedded-resource" -> o.`x-kubernetes-embedded-resource`.asJson,
      "maximum" -> o.maximum.asJson,
      "multipleOf" -> o.multipleOf.asJson,
      "id" -> o.id.asJson,
      "properties" -> o.properties.asJson,
      "exclusiveMinimum" -> o.exclusiveMinimum.asJson,
      "x-kubernetes-validations" -> o.`x-kubernetes-validations`.asJson,
      "enum" -> o.`enum`.asJson,
      "x-kubernetes-preserve-unknown-fields" -> o.`x-kubernetes-preserve-unknown-fields`.asJson,
      "additionalProperties" -> o.additionalProperties.asJson,
      "default" -> o.default.asJson,
      "minItems" -> o.minItems.asJson,
      "not" -> o.not.asJson,
      "definitions" -> o.definitions.asJson,
      "minLength" -> o.minLength.asJson,
      "x-kubernetes-list-map-keys" -> o.`x-kubernetes-list-map-keys`.asJson,
      "title" -> o.title.asJson,
      "minimum" -> o.minimum.asJson,
      "type" -> o.`type`.asJson,
      "required" -> o.required.asJson,
      "example" -> o.example.asJson,
      "$schema" -> o.$schema.asJson,
      "oneOf" -> o.oneOf.asJson,
      "uniqueItems" -> o.uniqueItems.asJson,
      "minProperties" -> o.minProperties.asJson,
      "dependencies" -> o.dependencies.asJson,
      "externalDocs" -> o.externalDocs.asJson,
      "maxLength" -> o.maxLength.asJson,
      "allOf" -> o.allOf.asJson
      )
    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1JSONSchemaPropsDecoder : Decoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps] = (c: HCursor) => for {
       exclusiveMaximum <- c.get[Option[Boolean]]("exclusiveMaximum")
       format <- c.get[Option[String]]("format")
       $ref <- c.get[Option[String]]("$ref")
       nullable <- c.get[Option[Boolean]]("nullable")
       `x-kubernetes-map-type` <- c.get[Option[String]]("x-kubernetes-map-type")
       pattern <- c.get[Option[String]]("pattern")
       description <- c.get[Option[String]]("description")
       anyOf <- c.get[Option[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]]]("anyOf")
       `x-kubernetes-list-type` <- c.get[Option[String]]("x-kubernetes-list-type")
       patternProperties <- c.get[Option[Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]]]("patternProperties")
       items <- c.get[Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrArray]]("items")
       additionalItems <- c.get[Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrBool]]("additionalItems")
       maxProperties <- c.get[Option[Int]]("maxProperties")
       maxItems <- c.get[Option[Int]]("maxItems")
       `x-kubernetes-int-or-string` <- c.get[Option[Boolean]]("x-kubernetes-int-or-string")
       `x-kubernetes-embedded-resource` <- c.get[Option[Boolean]]("x-kubernetes-embedded-resource")
       maximum <- c.get[Option[Double]]("maximum")
       multipleOf <- c.get[Option[Double]]("multipleOf")
       id <- c.get[Option[String]]("id")
       properties <- c.get[Option[Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]]]("properties")
       exclusiveMinimum <- c.get[Option[Boolean]]("exclusiveMinimum")
       `x-kubernetes-validations` <- c.get[Option[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule]]]("x-kubernetes-validations")
       `enum` <- c.get[Option[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON]]]("enum")
       `x-kubernetes-preserve-unknown-fields` <- c.get[Option[Boolean]]("x-kubernetes-preserve-unknown-fields")
       additionalProperties <- c.get[Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrBool]]("additionalProperties")
       default <- c.get[Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON]]("default")
       minItems <- c.get[Option[Int]]("minItems")
       not <- c.get[Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]]("not")
       definitions <- c.get[Option[Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]]]("definitions")
       minLength <- c.get[Option[Int]]("minLength")
       `x-kubernetes-list-map-keys` <- c.get[Option[Seq[String]]]("x-kubernetes-list-map-keys")
       title <- c.get[Option[String]]("title")
       minimum <- c.get[Option[Double]]("minimum")
       `type` <- c.get[Option[String]]("type")
       required <- c.get[Option[Seq[String]]]("required")
       example <- c.get[Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON]]("example")
       $schema <- c.get[Option[String]]("$schema")
       oneOf <- c.get[Option[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]]]("oneOf")
       uniqueItems <- c.get[Option[Boolean]]("uniqueItems")
       minProperties <- c.get[Option[Int]]("minProperties")
       dependencies <- c.get[Option[Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrStringArray]]]("dependencies")
       externalDocs <- c.get[Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ExternalDocumentation]]("externalDocs")
       maxLength <- c.get[Option[Int]]("maxLength")
       allOf <- c.get[Option[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]]]("allOf")
    } yield io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps(
      exclusiveMaximum = exclusiveMaximum,
      format = format,
      $ref = $ref,
      nullable = nullable,
      `x-kubernetes-map-type` = `x-kubernetes-map-type`,
      pattern = pattern,
      description = description,
      anyOf = anyOf,
      `x-kubernetes-list-type` = `x-kubernetes-list-type`,
      patternProperties = patternProperties,
      items = items,
      additionalItems = additionalItems,
      maxProperties = maxProperties,
      maxItems = maxItems,
      `x-kubernetes-int-or-string` = `x-kubernetes-int-or-string`,
      `x-kubernetes-embedded-resource` = `x-kubernetes-embedded-resource`,
      maximum = maximum,
      multipleOf = multipleOf,
      id = id,
      properties = properties,
      exclusiveMinimum = exclusiveMinimum,
      `x-kubernetes-validations` = `x-kubernetes-validations`,
      `enum` = `enum`,
      `x-kubernetes-preserve-unknown-fields` = `x-kubernetes-preserve-unknown-fields`,
      additionalProperties = additionalProperties,
      default = default,
      minItems = minItems,
      not = not,
      definitions = definitions,
      minLength = minLength,
      `x-kubernetes-list-map-keys` = `x-kubernetes-list-map-keys`,
      title = title,
      minimum = minimum,
      `type` = `type`,
      required = required,
      example = example,
      $schema = $schema,
      oneOf = oneOf,
      uniqueItems = uniqueItems,
      minProperties = minProperties,
      dependencies = dependencies,
      externalDocs = externalDocs,
      maxLength = maxLength,
      allOf = allOf
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2MetricTargetEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.MetricTarget] = o =>
      Json.obj(
        "averageUtilization" -> o.averageUtilization.asJson,
      "averageValue" -> o.averageValue.asJson,
      "type" -> o.`type`.asJson,
      "value" -> o.value.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2MetricTargetDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.MetricTarget] = (c: HCursor) => for {
       averageUtilization <- c.get[Option[Int]]("averageUtilization")
       averageValue <- c.get[Option[io.k8s.apimachinery.pkg.api.resource.Quantity]]("averageValue")
       `type` <- c.get[String]("type")
       value <- c.get[Option[io.k8s.apimachinery.pkg.api.resource.Quantity]]("value")
    } yield io.k8s.api.autoscaling.v2beta2.MetricTarget(
      averageUtilization = averageUtilization,
      averageValue = averageValue,
      `type` = `type`,
      value = value
    )

    implicit lazy val io_k8s_api_core_v1ConfigMapKeySelectorEncoder : Encoder[io.k8s.api.core.v1.ConfigMapKeySelector] = o =>
      Json.obj(
        "key" -> o.key.asJson,
      "name" -> o.name.asJson,
      "optional" -> o.optional.asJson
      )
    implicit lazy val io_k8s_api_core_v1ConfigMapKeySelectorDecoder : Decoder[io.k8s.api.core.v1.ConfigMapKeySelector] = (c: HCursor) => for {
       key <- c.get[String]("key")
       name <- c.get[Option[String]]("name")
       optional <- c.get[Option[Boolean]]("optional")
    } yield io.k8s.api.core.v1.ConfigMapKeySelector(
      key = key,
      name = name,
      optional = optional
    )

    implicit lazy val io_k8s_api_core_v1PodAffinityEncoder : Encoder[io.k8s.api.core.v1.PodAffinity] = o =>
      Json.obj(
        "preferredDuringSchedulingIgnoredDuringExecution" -> o.preferredDuringSchedulingIgnoredDuringExecution.asJson,
      "requiredDuringSchedulingIgnoredDuringExecution" -> o.requiredDuringSchedulingIgnoredDuringExecution.asJson
      )
    implicit lazy val io_k8s_api_core_v1PodAffinityDecoder : Decoder[io.k8s.api.core.v1.PodAffinity] = (c: HCursor) => for {
       preferredDuringSchedulingIgnoredDuringExecution <- c.get[Option[Seq[io.k8s.api.core.v1.WeightedPodAffinityTerm]]]("preferredDuringSchedulingIgnoredDuringExecution")
       requiredDuringSchedulingIgnoredDuringExecution <- c.get[Option[Seq[io.k8s.api.core.v1.PodAffinityTerm]]]("requiredDuringSchedulingIgnoredDuringExecution")
    } yield io.k8s.api.core.v1.PodAffinity(
      preferredDuringSchedulingIgnoredDuringExecution = preferredDuringSchedulingIgnoredDuringExecution,
      requiredDuringSchedulingIgnoredDuringExecution = requiredDuringSchedulingIgnoredDuringExecution
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2ResourceMetricStatusEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.ResourceMetricStatus] = o =>
      Json.obj(
        "current" -> o.current.asJson,
      "name" -> o.name.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2ResourceMetricStatusDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.ResourceMetricStatus] = (c: HCursor) => for {
       current <- c.get[io.k8s.api.autoscaling.v2beta2.MetricValueStatus]("current")
       name <- c.get[String]("name")
    } yield io.k8s.api.autoscaling.v2beta2.ResourceMetricStatus(
      current = current,
      name = name
    )

    implicit lazy val io_k8s_api_batch_v1JobStatusEncoder : Encoder[io.k8s.api.batch.v1.JobStatus] = o =>
      Json.obj(
        "conditions" -> o.conditions.asJson,
      "uncountedTerminatedPods" -> o.uncountedTerminatedPods.asJson,
      "completedIndexes" -> o.completedIndexes.asJson,
      "startTime" -> o.startTime.asJson,
      "ready" -> o.ready.asJson,
      "failed" -> o.failed.asJson,
      "succeeded" -> o.succeeded.asJson,
      "completionTime" -> o.completionTime.asJson,
      "active" -> o.active.asJson
      )
    implicit lazy val io_k8s_api_batch_v1JobStatusDecoder : Decoder[io.k8s.api.batch.v1.JobStatus] = (c: HCursor) => for {
       conditions <- c.get[Option[Seq[io.k8s.api.batch.v1.JobCondition]]]("conditions")
       uncountedTerminatedPods <- c.get[Option[io.k8s.api.batch.v1.UncountedTerminatedPods]]("uncountedTerminatedPods")
       completedIndexes <- c.get[Option[String]]("completedIndexes")
       startTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("startTime")
       ready <- c.get[Option[Int]]("ready")
       failed <- c.get[Option[Int]]("failed")
       succeeded <- c.get[Option[Int]]("succeeded")
       completionTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("completionTime")
       active <- c.get[Option[Int]]("active")
    } yield io.k8s.api.batch.v1.JobStatus(
      conditions = conditions,
      uncountedTerminatedPods = uncountedTerminatedPods,
      completedIndexes = completedIndexes,
      startTime = startTime,
      ready = ready,
      failed = failed,
      succeeded = succeeded,
      completionTime = completionTime,
      active = active
    )

    implicit lazy val io_k8s_api_core_v1EndpointAddressEncoder : Encoder[io.k8s.api.core.v1.EndpointAddress] = o =>
      Json.obj(
        "hostname" -> o.hostname.asJson,
      "ip" -> o.ip.asJson,
      "nodeName" -> o.nodeName.asJson,
      "targetRef" -> o.targetRef.asJson
      )
    implicit lazy val io_k8s_api_core_v1EndpointAddressDecoder : Decoder[io.k8s.api.core.v1.EndpointAddress] = (c: HCursor) => for {
       hostname <- c.get[Option[String]]("hostname")
       ip <- c.get[String]("ip")
       nodeName <- c.get[Option[String]]("nodeName")
       targetRef <- c.get[Option[io.k8s.api.core.v1.ObjectReference]]("targetRef")
    } yield io.k8s.api.core.v1.EndpointAddress(
      hostname = hostname,
      ip = ip,
      nodeName = nodeName,
      targetRef = targetRef
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2HorizontalPodAutoscalerStatusEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerStatus] = o =>
      Json.obj(
        "conditions" -> o.conditions.asJson,
      "desiredReplicas" -> o.desiredReplicas.asJson,
      "currentMetrics" -> o.currentMetrics.asJson,
      "lastScaleTime" -> o.lastScaleTime.asJson,
      "observedGeneration" -> o.observedGeneration.asJson,
      "currentReplicas" -> o.currentReplicas.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2HorizontalPodAutoscalerStatusDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerStatus] = (c: HCursor) => for {
       conditions <- c.get[Option[Seq[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerCondition]]]("conditions")
       desiredReplicas <- c.get[Int]("desiredReplicas")
       currentMetrics <- c.get[Option[Seq[io.k8s.api.autoscaling.v2beta2.MetricStatus]]]("currentMetrics")
       lastScaleTime <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("lastScaleTime")
       observedGeneration <- c.get[Option[Int]]("observedGeneration")
       currentReplicas <- c.get[Int]("currentReplicas")
    } yield io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerStatus(
      conditions = conditions,
      desiredReplicas = desiredReplicas,
      currentMetrics = currentMetrics,
      lastScaleTime = lastScaleTime,
      observedGeneration = observedGeneration,
      currentReplicas = currentReplicas
    )

    implicit lazy val io_k8s_api_autoscaling_v2HorizontalPodAutoscalerSpecEncoder : Encoder[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec] = o =>
      Json.obj(
        "maxReplicas" -> o.maxReplicas.asJson,
      "scaleTargetRef" -> o.scaleTargetRef.asJson,
      "minReplicas" -> o.minReplicas.asJson,
      "metrics" -> o.metrics.asJson,
      "behavior" -> o.behavior.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2HorizontalPodAutoscalerSpecDecoder : Decoder[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec] = (c: HCursor) => for {
       maxReplicas <- c.get[Int]("maxReplicas")
       scaleTargetRef <- c.get[io.k8s.api.autoscaling.v2.CrossVersionObjectReference]("scaleTargetRef")
       minReplicas <- c.get[Option[Int]]("minReplicas")
       metrics <- c.get[Option[Seq[io.k8s.api.autoscaling.v2.MetricSpec]]]("metrics")
       behavior <- c.get[Option[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerBehavior]]("behavior")
    } yield io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec(
      maxReplicas = maxReplicas,
      scaleTargetRef = scaleTargetRef,
      minReplicas = minReplicas,
      metrics = metrics,
      behavior = behavior
    )

    implicit lazy val io_k8s_api_core_v1PersistentVolumeClaimTemplateEncoder : Encoder[io.k8s.api.core.v1.PersistentVolumeClaimTemplate] = o =>
      Json.obj(
        "metadata" -> o.metadata.asJson,
      "spec" -> o.spec.asJson
      )
    implicit lazy val io_k8s_api_core_v1PersistentVolumeClaimTemplateDecoder : Decoder[io.k8s.api.core.v1.PersistentVolumeClaimTemplate] = (c: HCursor) => for {
       metadata <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]]("metadata")
       spec <- c.get[io.k8s.api.core.v1.PersistentVolumeClaimSpec]("spec")
    } yield io.k8s.api.core.v1.PersistentVolumeClaimTemplate(
      metadata = metadata,
      spec = spec
    )

    implicit lazy val io_k8s_api_autoscaling_v2ContainerResourceMetricSourceEncoder : Encoder[io.k8s.api.autoscaling.v2.ContainerResourceMetricSource] = o =>
      Json.obj(
        "container" -> o.container.asJson,
      "name" -> o.name.asJson,
      "target" -> o.target.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2ContainerResourceMetricSourceDecoder : Decoder[io.k8s.api.autoscaling.v2.ContainerResourceMetricSource] = (c: HCursor) => for {
       container <- c.get[String]("container")
       name <- c.get[String]("name")
       target <- c.get[io.k8s.api.autoscaling.v2.MetricTarget]("target")
    } yield io.k8s.api.autoscaling.v2.ContainerResourceMetricSource(
      container = container,
      name = name,
      target = target
    )

    implicit lazy val io_k8s_api_core_v1ContainerStateTerminatedEncoder : Encoder[io.k8s.api.core.v1.ContainerStateTerminated] = o =>
      Json.obj(
        "exitCode" -> o.exitCode.asJson,
      "reason" -> o.reason.asJson,
      "startedAt" -> o.startedAt.asJson,
      "message" -> o.message.asJson,
      "finishedAt" -> o.finishedAt.asJson,
      "containerID" -> o.containerID.asJson,
      "signal" -> o.signal.asJson
      )
    implicit lazy val io_k8s_api_core_v1ContainerStateTerminatedDecoder : Decoder[io.k8s.api.core.v1.ContainerStateTerminated] = (c: HCursor) => for {
       exitCode <- c.get[Int]("exitCode")
       reason <- c.get[Option[String]]("reason")
       startedAt <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("startedAt")
       message <- c.get[Option[String]]("message")
       finishedAt <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time]]("finishedAt")
       containerID <- c.get[Option[String]]("containerID")
       signal <- c.get[Option[Int]]("signal")
    } yield io.k8s.api.core.v1.ContainerStateTerminated(
      exitCode = exitCode,
      reason = reason,
      startedAt = startedAt,
      message = message,
      finishedAt = finishedAt,
      containerID = containerID,
      signal = signal
    )

    implicit lazy val io_k8s_api_autoscaling_v1ScaleStatusEncoder : Encoder[io.k8s.api.autoscaling.v1.ScaleStatus] = o =>
      Json.obj(
        "replicas" -> o.replicas.asJson,
      "selector" -> o.selector.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v1ScaleStatusDecoder : Decoder[io.k8s.api.autoscaling.v1.ScaleStatus] = (c: HCursor) => for {
       replicas <- c.get[Int]("replicas")
       selector <- c.get[Option[String]]("selector")
    } yield io.k8s.api.autoscaling.v1.ScaleStatus(
      replicas = replicas,
      selector = selector
    )

    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceDefinitionVersionEncoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion] = o =>
      Json.obj(
        "name" -> o.name.asJson,
      "deprecationWarning" -> o.deprecationWarning.asJson,
      "served" -> o.served.asJson,
      "deprecated" -> o.deprecated.asJson,
      "subresources" -> o.subresources.asJson,
      "schema" -> o.schema.asJson,
      "additionalPrinterColumns" -> o.additionalPrinterColumns.asJson,
      "storage" -> o.storage.asJson
      )
    implicit lazy val io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceDefinitionVersionDecoder : Decoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion] = (c: HCursor) => for {
       name <- c.get[String]("name")
       deprecationWarning <- c.get[Option[String]]("deprecationWarning")
       served <- c.get[Boolean]("served")
       deprecated <- c.get[Option[Boolean]]("deprecated")
       subresources <- c.get[Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources]]("subresources")
       schema <- c.get[Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation]]("schema")
       additionalPrinterColumns <- c.get[Option[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition]]]("additionalPrinterColumns")
       storage <- c.get[Boolean]("storage")
    } yield io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion(
      name = name,
      deprecationWarning = deprecationWarning,
      served = served,
      deprecated = deprecated,
      subresources = subresources,
      schema = schema,
      additionalPrinterColumns = additionalPrinterColumns,
      storage = storage
    )

    implicit lazy val io_k8s_api_autoscaling_v2beta2HorizontalPodAutoscalerSpecEncoder : Encoder[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec] = o =>
      Json.obj(
        "maxReplicas" -> o.maxReplicas.asJson,
      "scaleTargetRef" -> o.scaleTargetRef.asJson,
      "minReplicas" -> o.minReplicas.asJson,
      "metrics" -> o.metrics.asJson,
      "behavior" -> o.behavior.asJson
      )
    implicit lazy val io_k8s_api_autoscaling_v2beta2HorizontalPodAutoscalerSpecDecoder : Decoder[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec] = (c: HCursor) => for {
       maxReplicas <- c.get[Int]("maxReplicas")
       scaleTargetRef <- c.get[io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference]("scaleTargetRef")
       minReplicas <- c.get[Option[Int]]("minReplicas")
       metrics <- c.get[Option[Seq[io.k8s.api.autoscaling.v2beta2.MetricSpec]]]("metrics")
       behavior <- c.get[Option[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior]]("behavior")
    } yield io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec(
      maxReplicas = maxReplicas,
      scaleTargetRef = scaleTargetRef,
      minReplicas = minReplicas,
      metrics = metrics,
      behavior = behavior
    )

    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1DeleteOptionsEncoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions] = o =>
      Json.obj(
        "orphanDependents" -> o.orphanDependents.asJson,
      "preconditions" -> o.preconditions.asJson,
      "propagationPolicy" -> o.propagationPolicy.asJson,
      "gracePeriodSeconds" -> o.gracePeriodSeconds.asJson,
      "dryRun" -> o.dryRun.asJson
      )
    implicit lazy val io_k8s_apimachinery_pkg_apis_meta_v1DeleteOptionsDecoder : Decoder[io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions] = (c: HCursor) => for {
       orphanDependents <- c.get[Option[Boolean]]("orphanDependents")
       preconditions <- c.get[Option[io.k8s.apimachinery.pkg.apis.meta.v1.Preconditions]]("preconditions")
       propagationPolicy <- c.get[Option[String]]("propagationPolicy")
       gracePeriodSeconds <- c.get[Option[Int]]("gracePeriodSeconds")
       dryRun <- c.get[Option[Seq[String]]]("dryRun")
      kind <- c.get[String]("kind")
      apiVersion <- c.get[String]("apiVersion")
    } yield io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions(
      orphanDependents = orphanDependents,
      preconditions = preconditions,
      propagationPolicy = propagationPolicy,
      gracePeriodSeconds = gracePeriodSeconds,
      dryRun = dryRun,
      kind = kind,
      apiVersion = apiVersion
    )
}

