/*
 * Copyright 2021 Hossein Naderi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package lepus.codecs

import lepus.protocol.*
import org.scalacheck.Arbitrary
import org.scalacheck.Gen
import scodec.bits.ByteVector

import DomainGenerators.*

object FrameGenerators {
  val method: Gen[Frame.Method] = for {
    ch <- channelNumber
    vl <- AllClassesDataGenerator.methods
  } yield Frame.Method(ch, vl)

  val header: Gen[Frame.Header] = for {
    ch <- channelNumber
    cls <- classIds
    size <- Gen.posNum[Long]
    props <- properties
  } yield Frame.Header(ch, cls, size, props)

  val body: Gen[Frame.Body] = for {
    ch <- channelNumber
    pl <- blob
  } yield Frame.Body(ch, pl)

  val heartbeat: Gen[Frame.Heartbeat.type] =
    Gen.const(Frame.Heartbeat)

  val frames: Gen[Frame] =
    Gen.oneOf(method, header, body, heartbeat)

  val blob: Gen[ByteVector] =
    Gen.containerOf[Array, Byte](Arbitrary.arbitrary[Byte]).map(ByteVector(_))
}
