/*
 * Decompiled with CFR 0.152.
 */
package lepus.client;

import cats.Functor;
import cats.MonadError;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.implicits$;
import fs2.Stream;
import fs2.Stream$;
import fs2.concurrent.Signal;
import java.io.Serializable;
import lepus.client.Channel$;
import lepus.client.Channel$Status$;
import lepus.client.Confirmation;
import lepus.client.DeliveredMessage;
import lepus.client.Envelope;
import lepus.client.ExchangeAPI;
import lepus.client.ExchangeAPIImpl;
import lepus.client.QueueAPI;
import lepus.client.QueueAPIImpl;
import lepus.client.ReturnedMessage;
import lepus.client.apis.Consuming;
import lepus.client.apis.MessagingChannel;
import lepus.client.apis.NormalMessagingChannel;
import lepus.client.apis.ReliablePublishingMessagingChannel;
import lepus.client.apis.Transaction;
import lepus.client.apis.TransactionalMessagingChannel;
import lepus.client.internal.ChannelTransmitter;
import lepus.client.internal.RPCCallDef;
import lepus.client.internal.RPCCallDef$;
import lepus.client.internal.SequentialTagger;
import lepus.protocol.BasicClass;
import lepus.protocol.Method;
import lepus.protocol.TxClass$Commit$;
import lepus.protocol.TxClass$Rollback$;
import lepus.protocol.domains.FieldTable$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.Enum;
import scala.util.NotGiven$;
import scodec.bits.ByteVector;

public interface Channel<F, M extends MessagingChannel> {
    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static Object call(ChannelTransmitter channelTransmitter, Method method, RPCCallDef rPCCallDef) {
        return Channel$.MODULE$.call(channelTransmitter, method, rPCCallDef);
    }

    public static <F> Channel<F, NormalMessagingChannel<F>> normal(ChannelTransmitter<F> channelTransmitter, GenConcurrent<F, Throwable> genConcurrent) {
        return Channel$.MODULE$.normal(channelTransmitter, genConcurrent);
    }

    public static <F> Object reliable(ChannelTransmitter<F> channelTransmitter, GenConcurrent<F, Throwable> genConcurrent) {
        return Channel$.MODULE$.reliable(channelTransmitter, genConcurrent);
    }

    public static <F> Object transactional(ChannelTransmitter<F> channelTransmitter, GenConcurrent<F, Throwable> genConcurrent) {
        return Channel$.MODULE$.transactional(channelTransmitter, genConcurrent);
    }

    public ExchangeAPI<F> exchange();

    public QueueAPI<F> queue();

    public M messaging();

    public Signal<F, Status> status();

    public static final class ChannelImpl<F, M extends MessagingChannel>
    implements Channel<F, M> {
        private final ChannelTransmitter<F> transmitter;
        private final MessagingChannel messaging;
        private final MonadError<F, Throwable> x$3;

        public ChannelImpl(ChannelTransmitter<F> transmitter, M messaging, MonadError<F, Throwable> x$3) {
            this.transmitter = transmitter;
            this.messaging = messaging;
            this.x$3 = x$3;
        }

        @Override
        public M messaging() {
            return (M)this.messaging;
        }

        @Override
        public Signal<F, Status> status() {
            return this.transmitter.status();
        }

        @Override
        public final ExchangeAPI<F> exchange() {
            return new ExchangeAPIImpl<F>(this.transmitter, this.x$3);
        }

        @Override
        public final QueueAPI<F> queue() {
            return new QueueAPIImpl<F>(this.transmitter, this.x$3);
        }
    }

    public static abstract class ConsumingImpl<F>
    implements Consuming<F> {
        private final ChannelTransmitter<F> channel;
        private final GenConcurrent<F, Throwable> evidence$1;

        public ConsumingImpl(ChannelTransmitter<F> channel, GenConcurrent<F, Throwable> evidence$1) {
            this.channel = channel;
            this.evidence$1 = evidence$1;
        }

        @Override
        public F qos(int prefetchSize, short prefetchCount, boolean global) {
            return (F)Channel$.MODULE$.call(this.channel, (Method)BasicClass.Qos$.MODULE$.apply(prefetchSize, prefetchCount, global), RPCCallDef$.MODULE$.BasicClass_Qos(this.evidence$1));
        }

        @Override
        public Stream<F, DeliveredMessage<ByteVector>> consumeRaw(String queue, boolean noLocal, boolean noAck, boolean exclusive, Map arguments, Option<String> ctag) {
            return Stream$.MODULE$.resource(this.channel.delivered(ctag), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String ctag = (String)tuple2._1();
                    Stream data = (Stream)tuple2._2();
                    Stream recv = Stream$.MODULE$.eval(Channel$.MODULE$.call(this.channel, (Method)BasicClass.Consume$.MODULE$.apply(queue, ctag, noLocal, noAck, exclusive, true, arguments), RPCCallDef$.MODULE$.BasicClass_Consume(this.evidence$1))).$greater$greater(() -> this.$anonfun$1(data), NotGiven$.MODULE$.value());
                    return recv.onFinalize(implicits$.MODULE$.toFunctorOps(Channel$.MODULE$.call(this.channel, (Method)BasicClass.Cancel$.MODULE$.apply(ctag, true), RPCCallDef$.MODULE$.BasicClass_Cancel(this.evidence$1)), this.evidence$1).void(), this.evidence$1);
                }
                throw new MatchError((Object)tuple2);
            }, NotGiven$.MODULE$.value());
        }

        @Override
        public boolean consumeRaw$default$2() {
            return false;
        }

        @Override
        public boolean consumeRaw$default$3() {
            return true;
        }

        @Override
        public boolean consumeRaw$default$4() {
            return false;
        }

        @Override
        public Map consumeRaw$default$5() {
            return FieldTable$.MODULE$.empty();
        }

        @Override
        public F get(String queue, boolean noAck) {
            return this.channel.get(BasicClass.Get$.MODULE$.apply(queue, noAck));
        }

        @Override
        public F ack(long deliveryTag, boolean multiple) {
            return (F)Channel$.MODULE$.call(this.channel, (Method)BasicClass.Ack$.MODULE$.apply(deliveryTag, multiple), RPCCallDef$.MODULE$.BasicClass_Ack(this.evidence$1));
        }

        @Override
        public boolean ack$default$2() {
            return false;
        }

        @Override
        public F reject(long deliveryTag, boolean requeue) {
            return (F)Channel$.MODULE$.call(this.channel, (Method)BasicClass.Reject$.MODULE$.apply(deliveryTag, requeue), RPCCallDef$.MODULE$.BasicClass_Reject(this.evidence$1));
        }

        @Override
        public boolean reject$default$2() {
            return true;
        }

        @Override
        public F recoverAsync(boolean requeue) {
            return (F)Channel$.MODULE$.call(this.channel, (Method)BasicClass.RecoverAsync$.MODULE$.apply(requeue), RPCCallDef$.MODULE$.BasicClass_RecoverAsync(this.evidence$1));
        }

        @Override
        public F recover(boolean requeue) {
            return (F)Channel$.MODULE$.call(this.channel, (Method)BasicClass.Recover$.MODULE$.apply(requeue), RPCCallDef$.MODULE$.BasicClass_Recover(this.evidence$1));
        }

        @Override
        public F nack(long deliveryTag, boolean multiple, boolean requeue) {
            return (F)Channel$.MODULE$.call(this.channel, (Method)BasicClass.Nack$.MODULE$.apply(deliveryTag, multiple, requeue), RPCCallDef$.MODULE$.BasicClass_Nack(this.evidence$1));
        }

        @Override
        public boolean nack$default$2() {
            return false;
        }

        @Override
        public boolean nack$default$3() {
            return true;
        }

        private final Stream $anonfun$1(Stream data$1) {
            return data$1;
        }
    }

    public static class NormalPublishingImpl<F>
    extends ConsumingImpl<F>
    implements NormalMessagingChannel<F> {
        private final ChannelTransmitter<F> channel;

        public NormalPublishingImpl(ChannelTransmitter<F> channel, GenConcurrent<F, Throwable> evidence$2) {
            this.channel = channel;
            super(channel, evidence$2);
        }

        @Override
        public Stream<F, ReturnedMessage<ByteVector>> returned() {
            return this.channel.returned();
        }

        @Override
        public F publishRaw(Envelope<ByteVector> env) {
            return this.channel.publish(BasicClass.Publish$.MODULE$.apply(env.exchange(), env.routingKey(), env.mandatory(), false), env.message());
        }
    }

    public static final class ReliablePublishingImpl<F>
    extends ConsumingImpl<F>
    implements ReliablePublishingMessagingChannel<F> {
        private final ChannelTransmitter<F> channel;
        private final SequentialTagger<F> tagger;

        public ReliablePublishingImpl(ChannelTransmitter<F> channel, SequentialTagger<F> tagger, GenConcurrent<F, Throwable> evidence$3) {
            this.channel = channel;
            this.tagger = tagger;
            super(channel, evidence$3);
        }

        @Override
        public F publishRaw(Envelope<ByteVector> env) {
            return this.tagger.next(this.channel.publish(BasicClass.Publish$.MODULE$.apply(env.exchange(), env.routingKey(), env.mandatory(), false), env.message()));
        }

        @Override
        public Stream<F, Confirmation> confirmations() {
            return this.channel.confirmed();
        }

        @Override
        public Stream<F, ReturnedMessage<ByteVector>> returned() {
            return this.channel.returned();
        }
    }

    public static abstract class Status
    implements Product,
    Enum {
        public static Status fromOrdinal(int n) {
            return Channel$Status$.MODULE$.fromOrdinal(n);
        }

        public static Status valueOf(String string) {
            return Channel$Status$.MODULE$.valueOf(string);
        }

        public static Status[] values() {
            return Channel$Status$.MODULE$.values();
        }
    }

    public static final class TransactionalMessagingImpl<F>
    extends NormalPublishingImpl<F>
    implements TransactionalMessagingChannel<F> {
        public final ChannelTransmitter<F> lepus$client$Channel$TransactionalMessagingImpl$$channel;
        public final GenConcurrent<F, Throwable> lepus$client$Channel$TransactionalMessagingImpl$$evidence$4;

        public TransactionalMessagingImpl(ChannelTransmitter<F> channel, GenConcurrent<F, Throwable> evidence$4) {
            this.lepus$client$Channel$TransactionalMessagingImpl$$channel = channel;
            this.lepus$client$Channel$TransactionalMessagingImpl$$evidence$4 = evidence$4;
            super(channel, evidence$4);
        }

        private Transaction<F> trx() {
            return new Transaction<F>(this){
                private final /* synthetic */ TransactionalMessagingImpl $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Object commit() {
                    return implicits$.MODULE$.toFunctorOps(Channel$.MODULE$.call(this.$outer.lepus$client$Channel$TransactionalMessagingImpl$$channel, (Method)TxClass$Commit$.MODULE$, RPCCallDef$.MODULE$.TxClass_Commit_type(this.$outer.lepus$client$Channel$TransactionalMessagingImpl$$evidence$4)), this.$outer.lepus$client$Channel$TransactionalMessagingImpl$$evidence$4).void();
                }

                public Object rollback() {
                    return implicits$.MODULE$.toFunctorOps(Channel$.MODULE$.call(this.$outer.lepus$client$Channel$TransactionalMessagingImpl$$channel, (Method)TxClass$Rollback$.MODULE$, RPCCallDef$.MODULE$.TxClass_Rollback_type(this.$outer.lepus$client$Channel$TransactionalMessagingImpl$$evidence$4)), this.$outer.lepus$client$Channel$TransactionalMessagingImpl$$evidence$4).void();
                }
            };
        }

        @Override
        public Resource<F, Transaction<F>> transaction() {
            return (Resource)implicits$.MODULE$.toFunctorOps((Object)Resource$.MODULE$.onFinalizeCase((Function1 & Serializable)x$1 -> {
                Resource.ExitCase exitCase = x$1;
                if (Resource.ExitCase$.Succeeded$.MODULE$.equals(exitCase)) {
                    return this.trx().commit();
                }
                if (exitCase instanceof Resource.ExitCase$.Errored) {
                    Throwable throwable;
                    Resource.ExitCase$.Errored errored = Resource.ExitCase$.Errored$.MODULE$.unapply((Resource.ExitCase$.Errored)exitCase);
                    Throwable e = throwable = errored._1();
                    return this.trx().rollback();
                }
                if (Resource.ExitCase$.Canceled$.MODULE$.equals(exitCase)) {
                    return this.trx().rollback();
                }
                throw new MatchError((Object)exitCase);
            }, this.lepus$client$Channel$TransactionalMessagingImpl$$evidence$4), (Functor)Resource$.MODULE$.catsEffectConcurrentForResource(this.lepus$client$Channel$TransactionalMessagingImpl$$evidence$4)).as(this.trx());
        }
    }
}

