/*
 * Copyright 2021 Hossein Naderi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package edomata.backend

import cats.effect.kernel.Async
import cats.implicits.*

trait Cache[F[_], I, T] {
  def add(key: I, value: T): F[Option[(I, T)]]
  def get(key: I): F[Option[T]]
}

object Cache {
  def lru[F[_]: Async, Id, State](size: Int): F[Cache[F, Id, State]] =
    LRUCache(size).widen
}
