/*
 * Decompiled with CFR 0.152.
 */
package edomata.backend;

import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.effect.std.Semaphore;
import cats.implicits$;
import cats.syntax.ApplicativeIdOps$;
import edomata.backend.Cache;
import edomata.backend.LRUCache$;
import edomata.backend.LRUCache$CacheItem$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.mutable.Map;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class LRUCache<F, I, T>
implements Cache<F, I, T> {
    private final Map values;
    private Option head;
    private Option last;
    private final Semaphore sem;
    private final int maxSize;
    private final Sync<F> F;

    public static <F, Id, State> Object apply(int n, Async<F> async) {
        return LRUCache$.MODULE$.apply(n, async);
    }

    public LRUCache(Map<I, CacheItem<I, T>> values, Option<CacheItem<I, T>> head, Option<CacheItem<I, T>> last, Semaphore<F> sem, int maxSize, Sync<F> F) {
        this.values = values;
        this.head = head;
        this.last = last;
        this.sem = sem;
        this.maxSize = maxSize;
        this.F = F;
    }

    private Map<I, CacheItem<I, T>> values() {
        return this.values;
    }

    private Option<CacheItem<I, T>> head() {
        return this.head;
    }

    private void head_$eq(Option<CacheItem<I, T>> x$0) {
        this.head = x$0;
    }

    private Option<CacheItem<I, T>> last() {
        return this.last;
    }

    private void last_$eq(Option<CacheItem<I, T>> x$0) {
        this.last = x$0;
    }

    private Semaphore<F> sem() {
        return this.sem;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public F size() {
        return (F)this.sem().permit().use((Function1 & Serializable)_$2 -> {
            Integer n = (Integer)implicits$.MODULE$.catsSyntaxApplicativeId((Object)BoxesRunTime.boxToInteger((int)this.values().size()));
            return ApplicativeIdOps$.MODULE$.pure$extension((Object)n, this.F);
        }, this.F);
    }

    public Resource<F, Iterable<T>> allValues() {
        return this.sem().permit().map((Function1 & Serializable)_$3 -> (Iterable)this.values().values().map((Function1 & Serializable)_$4 -> _$4.value()));
    }

    public Resource<F, Iterator<Tuple2<I, T>>> iterator() {
        return this.sem().permit().map((Function1 & Serializable)_$5 -> this.values().view().mapValues((Function1 & Serializable)_$6 -> _$6.value()).iterator());
    }

    public F firstValue() {
        return (F)this.sem().permit().use((Function1 & Serializable)_$7 -> {
            Option option = (Option)implicits$.MODULE$.catsSyntaxApplicativeId((Object)this.head().map((Function1 & Serializable)_$8 -> _$8.value()));
            return ApplicativeIdOps$.MODULE$.pure$extension((Object)option, this.F);
        }, this.F);
    }

    public F lastValue() {
        return (F)this.sem().permit().use((Function1 & Serializable)_$9 -> {
            Option option = (Option)implicits$.MODULE$.catsSyntaxApplicativeId((Object)this.last().map((Function1 & Serializable)_$10 -> _$10.value()));
            return ApplicativeIdOps$.MODULE$.pure$extension((Object)option, this.F);
        }, this.F);
    }

    public Resource<F, Iterator<T>> valuesByUsage() {
        return this.byUsage().map((Function1 & Serializable)_$11 -> _$11.map((Function1 & Serializable)_$12 -> _$12._2()));
    }

    public Resource<F, Iterator<Tuple2<I, T>>> byUsage() {
        return this.sem().permit().map((Function1 & Serializable)_$13 -> package$.MODULE$.LazyList().iterate(this::byUsage$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$14 -> _$14.flatMap((Function1 & Serializable)_$15 -> _$15.next())).takeWhile((Function1 & Serializable)_$16 -> _$16.isDefined()).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Option x) {
                boolean bl;
                Option option = x;
                if (option instanceof Some) {
                    CacheItem v = (CacheItem)((Some)option).value();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(Option x, Function1 function1) {
                Object object;
                Option option = x;
                if (option instanceof Some) {
                    CacheItem v = (CacheItem)((Some)option).value();
                    object = Tuple2$.MODULE$.apply(v.key(), v.value());
                } else {
                    object = function1.apply((Object)x);
                }
                return object;
            }
        }).iterator());
    }

    @Override
    public F add(I key, T value) {
        return (F)this.sem().permit().use((Function1 & Serializable)_$17 -> this.F.delay(() -> this.add$$anonfun$1$$anonfun$1(key, value)), this.F);
    }

    @Override
    public F get(I key) {
        return (F)this.sem().permit().use((Function1 & Serializable)_$18 -> this.F.delay(() -> this.get$$anonfun$1$$anonfun$1(key)), this.F);
    }

    private Option<Tuple2<I, T>> evict() {
        None$ none$;
        if (this.values().size() > this.maxSize()) {
            Option lastValue = this.last().map((Function1 & Serializable)_$19 -> _$19.key()).flatMap((Function1 & Serializable)key -> this.values().remove(key));
            Option beforeLast = this.last().flatMap((Function1 & Serializable)_$20 -> _$20.prev());
            beforeLast.foreach((Function1 & Serializable)_$21 -> {
                _$21.next_$eq(None$.MODULE$);
                return BoxedUnit.UNIT;
            });
            this.last_$eq(beforeLast);
            none$ = lastValue.map((Function1 & Serializable)v -> Tuple2$.MODULE$.apply(v.key(), v.value()));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private void makeHead(CacheItem<I, T> item) {
        if (this.head().contains(item)) {
            return;
        }
        if (this.head().exists((Function1 & Serializable)_$22 -> _$22.next().isEmpty())) {
            this.last_$eq(this.head());
        }
        if (this.last().contains(item)) {
            this.last_$eq(item.prev());
        }
        item.prev().foreach((Function1 & Serializable)_$23 -> {
            _$23.next_$eq(item.next());
            return BoxedUnit.UNIT;
        });
        item.next().foreach((Function1 & Serializable)_$24 -> {
            _$24.prev_$eq(item.prev());
            return BoxedUnit.UNIT;
        });
        item.prev_$eq((Option<CacheItem<I, T>>)None$.MODULE$);
        item.next_$eq(this.head());
        this.head().foreach((Function1 & Serializable)_$25 -> {
            _$25.prev_$eq(Some$.MODULE$.apply((Object)item));
            return BoxedUnit.UNIT;
        });
        this.head_$eq((Option<CacheItem<I, T>>)Some$.MODULE$.apply(item));
    }

    private final Option byUsage$$anonfun$1$$anonfun$1() {
        return this.head();
    }

    private final Option add$$anonfun$1$$anonfun$1(Object key$2, Object value$2) {
        Option option = this.values().get(key$2);
        if (option instanceof Some) {
            CacheItem existing = (CacheItem)((Some)option).value();
            existing.value_$eq(value$2);
            this.makeHead(existing);
        } else if (None$.MODULE$.equals(option)) {
            CacheItem<Object, Object> newItem = LRUCache$CacheItem$.MODULE$.apply(key$2, value$2, None$.MODULE$, this.head());
            this.values().update(key$2, newItem);
            this.makeHead(newItem);
        } else {
            throw new MatchError((Object)option);
        }
        return this.evict();
    }

    private final Option get$$anonfun$1$$anonfun$1(Object key$4) {
        None$ none$;
        Option option = this.values().get(key$4);
        if (option instanceof Some) {
            CacheItem existing = (CacheItem)((Some)option).value();
            this.makeHead(existing);
            none$ = Some$.MODULE$.apply(existing.value());
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return none$;
    }

    public static final class CacheItem<I, T>
    implements Product,
    Serializable {
        private final Object key;
        private Object value;
        private Option prev;
        private Option next;

        public static <I, T> CacheItem<I, T> apply(I i, T t, Option<CacheItem<I, T>> option, Option<CacheItem<I, T>> option2) {
            return LRUCache$CacheItem$.MODULE$.apply(i, t, option, option2);
        }

        public static CacheItem<?, ?> fromProduct(Product product) {
            return LRUCache$CacheItem$.MODULE$.fromProduct(product);
        }

        public static <I, T> CacheItem<I, T> unapply(CacheItem<I, T> cacheItem) {
            return LRUCache$CacheItem$.MODULE$.unapply(cacheItem);
        }

        public CacheItem(I key, T value, Option<CacheItem<I, T>> prev, Option<CacheItem<I, T>> next) {
            this.key = key;
            this.value = value;
            this.prev = prev;
            this.next = next;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CacheItem)) return false;
            CacheItem cacheItem = (CacheItem)object;
            if (!BoxesRunTime.equals(this.key(), cacheItem.key())) return false;
            if (!BoxesRunTime.equals(this.value(), cacheItem.value())) return false;
            Option<CacheItem<I, T>> option = this.prev();
            Option<CacheItem<I, T>> option2 = cacheItem.prev();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<CacheItem<I, T>> option3 = this.next();
            Option<CacheItem<I, T>> option4 = cacheItem.next();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CacheItem;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "CacheItem";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                case 3: {
                    object = this._4();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "key";
                    break;
                }
                case 1: {
                    string = "value";
                    break;
                }
                case 2: {
                    string = "prev";
                    break;
                }
                case 3: {
                    string = "next";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public I key() {
            return (I)this.key;
        }

        public T value() {
            return (T)this.value;
        }

        public void value_$eq(T x$1) {
            this.value = x$1;
        }

        public Option<CacheItem<I, T>> prev() {
            return this.prev;
        }

        public void prev_$eq(Option<CacheItem<I, T>> x$1) {
            this.prev = x$1;
        }

        public Option<CacheItem<I, T>> next() {
            return this.next;
        }

        public void next_$eq(Option<CacheItem<I, T>> x$1) {
            this.next = x$1;
        }

        public <I, T> CacheItem<I, T> copy(I key, T value, Option<CacheItem<I, T>> prev, Option<CacheItem<I, T>> next) {
            return new CacheItem<I, T>(key, value, prev, next);
        }

        public <I, T> I copy$default$1() {
            return this.key();
        }

        public <I, T> T copy$default$2() {
            return this.value();
        }

        public <I, T> Option<CacheItem<I, T>> copy$default$3() {
            return this.prev();
        }

        public <I, T> Option<CacheItem<I, T>> copy$default$4() {
            return this.next();
        }

        public I _1() {
            return this.key();
        }

        public T _2() {
            return this.value();
        }

        public Option<CacheItem<I, T>> _3() {
            return this.prev();
        }

        public Option<CacheItem<I, T>> _4() {
            return this.next();
        }
    }
}

