/*
 * Decompiled with CFR 0.152.
 */
package edomata.backend;

import cats.effect.kernel.GenTemporal;
import cats.effect.std.Queue;
import cats.implicits$;
import cats.syntax.ApplicativeIdOps$;
import edomata.backend.AggregateState;
import edomata.backend.LRUCache;
import edomata.backend.SnapshotPersistence;
import edomata.backend.SnapshotStore;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.duration.FiniteDuration;

public final class PersistedSnapshotStoreImpl<F, S>
implements SnapshotStore<F, S> {
    private final LRUCache<F, String, AggregateState.Valid<S>> cache;
    private final SnapshotPersistence<F, S> p;
    private final Queue<F, Tuple2<String, AggregateState.Valid<S>>> q;
    private final GenTemporal<F, Throwable> F;

    public PersistedSnapshotStoreImpl(LRUCache<F, String, AggregateState.Valid<S>> cache, SnapshotPersistence<F, S> p, Queue<F, Tuple2<String, AggregateState.Valid<S>>> q, int maxBuffer, FiniteDuration maxWait, GenTemporal<F, Throwable> F) {
        this.cache = cache;
        this.p = p;
        this.q = q;
        this.F = F;
    }

    @Override
    public F get(String id) {
        return (F)implicits$.MODULE$.toFlatMapOps(this.getFast(id), this.F).flatMap((Function1 & Serializable)x$1 -> {
            Object object;
            Option option = x$1;
            if (option instanceof Some) {
                Some c = (Some)option;
                Option option2 = (Option)implicits$.MODULE$.catsSyntaxApplicativeId((Object)c);
                object = ApplicativeIdOps$.MODULE$.pure$extension((Object)option2, this.F);
            } else if (None$.MODULE$.equals(option)) {
                object = this.p.get(id);
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        });
    }

    @Override
    public F put(String id, AggregateState.Valid<S> state) {
        return (F)implicits$.MODULE$.toFlatMapOps(this.cache.add(id, state), this.F).flatMap((Function1 & Serializable)x$1 -> {
            Object object;
            Option option = x$1;
            if (option instanceof Some) {
                Tuple2 evicted = (Tuple2)((Some)option).value();
                object = implicits$.MODULE$.toFunctorOps(this.q.tryOffer((Object)evicted), this.F).void();
            } else if (None$.MODULE$.equals(option)) {
                object = this.F.unit();
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        });
    }

    @Override
    public F getFast(String id) {
        return this.cache.get(id);
    }
}

