/*
 * Decompiled with CFR 0.152.
 */
package edomata.backend;

import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.implicits$;
import cats.syntax.FlatMapOps$;
import edomata.backend.Backend;
import edomata.backend.BackendCodec;
import edomata.backend.CachedRepository;
import edomata.backend.CommandHandler;
import edomata.backend.CommandHandler$;
import edomata.backend.CommandStore$;
import edomata.backend.JournalReader;
import edomata.backend.Notifications;
import edomata.backend.Notifications$;
import edomata.backend.NotificationsConsumer;
import edomata.backend.OutboxReader;
import edomata.backend.Queries;
import edomata.backend.Queries$;
import edomata.backend.Repository;
import edomata.backend.RepositoryReader;
import edomata.backend.RepositoryReader$;
import edomata.backend.SkunkBackend$;
import edomata.backend.SkunkBackend$DomainBuilder$;
import edomata.backend.SkunkJournalReader;
import edomata.backend.SkunkOutboxReader;
import edomata.backend.SkunkRepository;
import edomata.backend.SkunkSnapshotPersistence$;
import edomata.backend.SnapshotPersistence;
import edomata.backend.SnapshotReader;
import edomata.backend.SnapshotStore;
import edomata.backend.SnapshotStore$;
import edomata.core.Domain;
import edomata.core.ModelTC;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.Tuple5;
import scala.Tuple5$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import skunk.Session;

public final class SkunkBackend {
    public static <F> PartialBuilder<F> apply(Resource<F, Session<F>> resource, Async<F> async) {
        return SkunkBackend$.MODULE$.apply(resource, async);
    }

    public static final class DomainBuilder<F, C, S, E, R, N>
    implements Product,
    Serializable {
        private final Resource pool;
        private final boolean domain;
        private final ModelTC model;
        private final String namespace;
        private final Resource snapshot;
        private final int maxRetry;
        private final FiniteDuration retryInitialDelay;
        private final boolean cached;
        private final Async<F> evidence$3;

        public static <F, C, S, E, R, N> DomainBuilder<F, C, S, E, R, N> apply(Resource<F, Session<F>> resource, boolean bl, ModelTC<S, E, R> modelTC, String string, Resource<F, SnapshotStore<F, S>> resource2, int n, FiniteDuration finiteDuration, boolean bl2, Async<F> async) {
            return SkunkBackend$DomainBuilder$.MODULE$.apply(resource, bl, modelTC, string, resource2, n, finiteDuration, bl2, async);
        }

        public static <F, C, S, E, R, N> DomainBuilder<F, C, S, E, R, N> unapply(DomainBuilder<F, C, S, E, R, N> domainBuilder) {
            return SkunkBackend$DomainBuilder$.MODULE$.unapply(domainBuilder);
        }

        public static <F, C, S, E, R, N> int $lessinit$greater$default$6() {
            return SkunkBackend$DomainBuilder$.MODULE$.$lessinit$greater$default$6();
        }

        public static <F, C, S, E, R, N> FiniteDuration $lessinit$greater$default$7() {
            return SkunkBackend$DomainBuilder$.MODULE$.$lessinit$greater$default$7();
        }

        public static <F, C, S, E, R, N> boolean $lessinit$greater$default$8() {
            return SkunkBackend$DomainBuilder$.MODULE$.$lessinit$greater$default$8();
        }

        public DomainBuilder(Resource<F, Session<F>> pool, boolean domain, ModelTC<S, E, R> model, String namespace, Resource<F, SnapshotStore<F, S>> snapshot, int maxRetry, FiniteDuration retryInitialDelay, boolean cached, Async<F> evidence$3) {
            this.pool = pool;
            this.domain = domain;
            this.model = model;
            this.namespace = namespace;
            this.snapshot = snapshot;
            this.maxRetry = maxRetry;
            this.retryInitialDelay = retryInitialDelay;
            this.cached = cached;
            this.evidence$3 = evidence$3;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.pool()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)new Domain(this.domain())));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.model()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.namespace()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.snapshot()));
            n = Statics.mix((int)n, (int)this.maxRetry());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.retryInitialDelay()));
            n = Statics.mix((int)n, (int)(this.cached() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)8);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DomainBuilder)) return false;
            DomainBuilder domainBuilder = (DomainBuilder)object;
            if (this.maxRetry() != domainBuilder.maxRetry()) return false;
            if (this.cached() != domainBuilder.cached()) return false;
            Resource<F, Session<F>> resource = this.pool();
            Resource<F, Session<F>> resource2 = domainBuilder.pool();
            if (resource == null) {
                if (resource2 != null) {
                    return false;
                }
            } else if (!resource.equals(resource2)) return false;
            if (this.domain() != domainBuilder.domain()) return false;
            ModelTC<S, E, R> modelTC = this.model();
            ModelTC<S, E, R> modelTC2 = domainBuilder.model();
            if (modelTC == null) {
                if (modelTC2 != null) {
                    return false;
                }
            } else if (!modelTC.equals(modelTC2)) return false;
            String string = this.namespace();
            String string2 = domainBuilder.namespace();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Resource<F, SnapshotStore<F, S>> resource3 = this.snapshot();
            Resource<F, SnapshotStore<F, S>> resource4 = domainBuilder.snapshot();
            if (resource3 == null) {
                if (resource4 != null) {
                    return false;
                }
            } else if (!resource3.equals(resource4)) return false;
            FiniteDuration finiteDuration = this.retryInitialDelay();
            FiniteDuration finiteDuration2 = domainBuilder.retryInitialDelay();
            if (finiteDuration == null) {
                if (finiteDuration2 == null) return true;
                return false;
            } else {
                if (!finiteDuration.equals(finiteDuration2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DomainBuilder;
        }

        public int productArity() {
            return 8;
        }

        public String productPrefix() {
            return "DomainBuilder";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = new Domain(this._2());
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                case 3: {
                    object = this._4();
                    break;
                }
                case 4: {
                    object = this._5();
                    break;
                }
                case 5: {
                    object = BoxesRunTime.boxToInteger((int)this._6());
                    break;
                }
                case 6: {
                    object = this._7();
                    break;
                }
                case 7: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._8());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "pool";
                    break;
                }
                case 1: {
                    string = "domain";
                    break;
                }
                case 2: {
                    string = "model";
                    break;
                }
                case 3: {
                    string = "namespace";
                    break;
                }
                case 4: {
                    string = "snapshot";
                    break;
                }
                case 5: {
                    string = "maxRetry";
                    break;
                }
                case 6: {
                    string = "retryInitialDelay";
                    break;
                }
                case 7: {
                    string = "cached";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        private Resource<F, Session<F>> pool() {
            return this.pool;
        }

        private boolean domain() {
            return this.domain;
        }

        private ModelTC<S, E, R> model() {
            return this.model;
        }

        public String namespace() {
            return this.namespace;
        }

        private Resource<F, SnapshotStore<F, S>> snapshot() {
            return this.snapshot;
        }

        public int maxRetry() {
            return this.maxRetry;
        }

        public FiniteDuration retryInitialDelay() {
            return this.retryInitialDelay;
        }

        public boolean cached() {
            return this.cached;
        }

        public DomainBuilder<F, C, S, E, R, N> persistedSnapshot(int maxInMem, int maxBuffer, FiniteDuration maxWait, BackendCodec<S> codec) {
            Resource resource = Resource$.MODULE$.eval(SkunkSnapshotPersistence$.MODULE$.apply(this.pool(), this.namespace(), this.evidence$3, codec)).flatMap((Function1 & Serializable)store -> SnapshotStore$.MODULE$.persisted((SnapshotPersistence)store, maxInMem, maxBuffer, maxWait, SnapshotStore$.MODULE$.persisted$default$5(), this.evidence$3));
            Resource<F, Session<F>> resource2 = this.copy$default$1();
            boolean bl = this.copy$default$2();
            ModelTC<S, E, R> modelTC = this.copy$default$3();
            String string = this.copy$default$4();
            int n = this.copy$default$6();
            FiniteDuration finiteDuration = this.copy$default$7();
            boolean bl2 = this.copy$default$8();
            return this.copy(resource2, bl, modelTC, string, resource, n, finiteDuration, bl2, this.evidence$3);
        }

        public int persistedSnapshot$default$1() {
            return 1000;
        }

        public int persistedSnapshot$default$2() {
            return 100;
        }

        public FiniteDuration persistedSnapshot$default$3() {
            return new package.DurationInt(package$.MODULE$.DurationInt(1)).minute();
        }

        public DomainBuilder<F, C, S, E, R, N> disableCache() {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), false, this.evidence$3);
        }

        public DomainBuilder<F, C, S, E, R, N> inMemSnapshot(int maxInMem) {
            Resource resource = Resource$.MODULE$.eval(SnapshotStore$.MODULE$.inMem(maxInMem, this.evidence$3));
            Resource<F, Session<F>> resource2 = this.copy$default$1();
            boolean bl = this.copy$default$2();
            ModelTC<S, E, R> modelTC = this.copy$default$3();
            String string = this.copy$default$4();
            int n = this.copy$default$6();
            FiniteDuration finiteDuration = this.copy$default$7();
            boolean bl2 = this.copy$default$8();
            return this.copy(resource2, bl, modelTC, string, resource, n, finiteDuration, bl2, this.evidence$3);
        }

        public int inMemSnapshot$default$1() {
            return 1000;
        }

        public DomainBuilder<F, C, S, E, R, N> withSnapshot(Resource<F, SnapshotStore<F, S>> s) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), s, this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.evidence$3);
        }

        public DomainBuilder<F, C, S, E, R, N> withRetryConfig(int maxRetry, FiniteDuration retryInitialDelay) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), maxRetry, retryInitialDelay, this.copy$default$8(), this.evidence$3);
        }

        public int withRetryConfig$default$1() {
            return this.maxRetry();
        }

        public FiniteDuration withRetryConfig$default$2() {
            return this.retryInitialDelay();
        }

        private F _setup(BackendCodec<E> event, BackendCodec<N> notifs) {
            Queries.Journal<E> jQ = new Queries.Journal<E>(this.namespace(), event);
            Queries.Outbox<N> nQ = new Queries.Outbox<N>(this.namespace(), notifs);
            Queries.Commands cQ = new Queries.Commands(this.namespace());
            return (F)implicits$.MODULE$.toFunctorOps(this.pool().use((Function1 & Serializable)s -> {
                Object object = implicits$.MODULE$.catsSyntaxFlatMapOps(s.execute(Queries$.MODULE$.setupSchema(this.namespace())), this.evidence$3);
                Object object2 = implicits$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this._setup$$anonfun$1$$anonfun$1(jQ, s), this.evidence$3), this.evidence$3);
                Object object3 = implicits$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(object2, () -> this._setup$$anonfun$1$$anonfun$2(nQ, s), this.evidence$3), this.evidence$3);
                return FlatMapOps$.MODULE$.$greater$greater$extension(object3, () -> this._setup$$anonfun$1$$anonfun$3(cQ, s), this.evidence$3);
            }, this.evidence$3), this.evidence$3).as((Object)Tuple3$.MODULE$.apply(jQ, nQ, (Object)cQ));
        }

        public F setup(BackendCodec<E> event, BackendCodec<N> notifs) {
            return (F)implicits$.MODULE$.toFunctorOps(this._setup(event, notifs), this.evidence$3).void();
        }

        public Resource<F, Backend<F, S, E, R, N>> build(BackendCodec<E> event, BackendCodec<N> notifs) {
            return Resource$.MODULE$.eval(this._setup(event, notifs)).map((Function1 & Serializable)qs -> {
                Tuple3 tuple3 = qs;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                Queries.Journal jQ = (Queries.Journal)tuple3._1();
                Queries.Outbox nQ = (Queries.Outbox)tuple3._2();
                Queries.Commands cQ = (Queries.Commands)tuple3._3();
                Tuple3 $1$ = tuple3;
                Tuple4 tuple4 = Tuple4$.MODULE$.apply((Object)$1$, (Object)jQ, (Object)nQ, (Object)cQ);
                Tuple3 $1$2 = (Tuple3)tuple4._1();
                Queries.Journal jQ2 = (Queries.Journal)tuple4._2();
                Queries.Outbox nQ2 = (Queries.Outbox)tuple4._3();
                Queries.Commands cQ2 = (Queries.Commands)tuple4._4();
                ModelTC<S, E, R> modelTC = this.model();
                if (!(modelTC instanceof ModelTC)) {
                    throw new MatchError(modelTC);
                }
                ModelTC<S, E, R> $2$ = modelTC;
                ModelTC<S, E, R> $2$2 = $2$;
                return Tuple3$.MODULE$.apply(qs, (Object)$1$2, $2$2);
            }).flatMap((Function1 & Serializable)x$1 -> {
                Queries.Commands cQ;
                Queries.Outbox nQ;
                Queries.Journal jQ;
                ModelTC modelTC;
                block3: {
                    Tuple3 tuple3;
                    block2: {
                        tuple3 = x$1;
                        if (tuple3 == null) break block2;
                        Tuple3 tuple32 = (Tuple3)tuple3._2();
                        modelTC = (ModelTC)tuple3._3();
                        Tuple3 qs = (Tuple3)tuple3._1();
                        if (tuple32 == null) break block2;
                        jQ = (Queries.Journal)tuple32._1();
                        nQ = (Queries.Outbox)tuple32._2();
                        cQ = (Queries.Commands)tuple32._3();
                        if (modelTC instanceof ModelTC) break block3;
                    }
                    throw new MatchError((Object)tuple3);
                }
                ModelTC given_ModelTC_S_E_R = modelTC;
                return this.snapshot().flatMap((Function1 & Serializable)s -> Resource$.MODULE$.eval(Notifications$.MODULE$.apply(this.evidence$3)).map((Function1 & Serializable)updates -> {
                    SkunkOutboxReader _outbox = new SkunkOutboxReader(this.pool(), nQ, this.evidence$3, this.evidence$3);
                    SkunkJournalReader _journal = new SkunkJournalReader(this.pool(), jQ, this.evidence$3);
                    RepositoryReader _repo = RepositoryReader$.MODULE$.apply(_journal, (SnapshotReader)s, this.evidence$3, given_ModelTC_S_E_R);
                    SkunkRepository skRepo = new SkunkRepository(this.pool(), jQ, nQ, cQ, _repo, updates, this.evidence$3, this.evidence$3);
                    return Tuple5$.MODULE$.apply(updates, _outbox, _journal, (Object)_repo, skRepo);
                }).flatMap((Function1 & Serializable)x$12 -> {
                    SkunkRepository skRepo;
                    RepositoryReader _repo;
                    SkunkJournalReader _journal;
                    SkunkOutboxReader _outbox;
                    Notifications updates;
                    Tuple5 tuple5 = x$12;
                    if (tuple5 != null) {
                        updates = (Notifications)tuple5._1();
                        _outbox = (SkunkOutboxReader)tuple5._2();
                        _journal = (SkunkJournalReader)tuple5._3();
                        _repo = (RepositoryReader)tuple5._4();
                        skRepo = (SkunkRepository)tuple5._5();
                    } else {
                        throw new MatchError((Object)tuple5);
                    }
                    return (this.cached() ? Resource$.MODULE$.eval(CommandStore$.MODULE$.inMem(100, this.evidence$3)).map((Function1 & Serializable)_$4 -> new CachedRepository((Repository)skRepo, _$4, s, this.evidence$3)) : Resource$.MODULE$.pure((Object)skRepo)).map((Function1 & Serializable)compiler -> {
                        CommandHandler h = CommandHandler$.MODULE$.withRetry(compiler, this.maxRetry(), this.retryInitialDelay(), this.evidence$3);
                        return Tuple2$.MODULE$.apply(compiler, (Object)h);
                    }).map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Repository compiler = (Repository)tuple2._1();
                        CommandHandler h = (CommandHandler)tuple2._2();
                        return new Backend(h, (OutboxReader)_outbox, (JournalReader)_journal, _repo, (NotificationsConsumer)updates);
                    });
                }));
            });
        }

        public <F, C, S, E, R, N> DomainBuilder<F, C, S, E, R, N> copy(Resource<F, Session<F>> pool, boolean domain, ModelTC<S, E, R> model, String namespace, Resource<F, SnapshotStore<F, S>> snapshot, int maxRetry, FiniteDuration retryInitialDelay, boolean cached, Async<F> evidence$3) {
            return new DomainBuilder<F, C, S, E, R, N>(pool, domain, model, namespace, snapshot, maxRetry, retryInitialDelay, cached, evidence$3);
        }

        public <F, C, S, E, R, N> Resource<F, Session<F>> copy$default$1() {
            return this.pool();
        }

        public boolean copy$default$2() {
            return this.domain();
        }

        public <F, C, S, E, R, N> ModelTC<S, E, R> copy$default$3() {
            return this.model();
        }

        public <F, C, S, E, R, N> String copy$default$4() {
            return this.namespace();
        }

        public <F, C, S, E, R, N> Resource<F, SnapshotStore<F, S>> copy$default$5() {
            return this.snapshot();
        }

        public int copy$default$6() {
            return this.maxRetry();
        }

        public <F, C, S, E, R, N> FiniteDuration copy$default$7() {
            return this.retryInitialDelay();
        }

        public boolean copy$default$8() {
            return this.cached();
        }

        public Resource<F, Session<F>> _1() {
            return this.pool();
        }

        public boolean _2() {
            return this.domain();
        }

        public ModelTC<S, E, R> _3() {
            return this.model();
        }

        public String _4() {
            return this.namespace();
        }

        public Resource<F, SnapshotStore<F, S>> _5() {
            return this.snapshot();
        }

        public int _6() {
            return this.maxRetry();
        }

        public FiniteDuration _7() {
            return this.retryInitialDelay();
        }

        public boolean _8() {
            return this.cached();
        }

        private final Object _setup$$anonfun$1$$anonfun$1(Queries.Journal jQ$1, Session s$1) {
            return s$1.execute(jQ$1.setup());
        }

        private final Object _setup$$anonfun$1$$anonfun$2(Queries.Outbox nQ$2, Session s$2) {
            return s$2.execute(nQ$2.setup());
        }

        private final Object _setup$$anonfun$1$$anonfun$3(Queries.Commands cQ$2, Session s$3) {
            return s$3.execute(cQ$2.setup());
        }
    }

    public static final class PartialBuilder<F> {
        private final Resource<F, Session<F>> pool;
        private final Async<F> evidence$2;

        public PartialBuilder(Resource<F, Session<F>> pool, Async<F> evidence$2) {
            this.pool = pool;
            this.evidence$2 = evidence$2;
        }

        public Resource<F, Session<F>> inline$pool() {
            return this.pool;
        }

        public Async<F> inline$evidence$2() {
            return this.evidence$2;
        }

        public <F, C, S, E, R, N> DomainBuilder<F, C, S, E, R, N> inline$apply$i1(SkunkBackend$DomainBuilder$ x$0, Resource<F, Session<F>> pool, boolean domain, ModelTC<S, E, R> model, String namespace, Resource<F, SnapshotStore<F, S>> snapshot, int maxRetry, FiniteDuration retryInitialDelay, boolean cached, Async<F> evidence$3) {
            return x$0.apply(pool, domain, model, namespace, snapshot, maxRetry, retryInitialDelay, cached, evidence$3);
        }

        public <F, C, S, E, R, N> int inline$$lessinit$greater$default$6$i1(SkunkBackend$DomainBuilder$ x$0) {
            return x$0.$lessinit$greater$default$6();
        }

        public <F, C, S, E, R, N> FiniteDuration inline$$lessinit$greater$default$7$i1(SkunkBackend$DomainBuilder$ x$0) {
            return x$0.$lessinit$greater$default$7();
        }

        public <F, C, S, E, R, N> boolean inline$$lessinit$greater$default$8$i1(SkunkBackend$DomainBuilder$ x$0) {
            return x$0.$lessinit$greater$default$8();
        }

        public <F, C, S, E, R, N> DomainBuilder<F, C, S, E, R, N> inline$apply$i2(SkunkBackend$DomainBuilder$ x$0, Resource<F, Session<F>> pool, boolean domain, ModelTC<S, E, R> model, String namespace, Resource<F, SnapshotStore<F, S>> snapshot, int maxRetry, FiniteDuration retryInitialDelay, boolean cached, Async<F> evidence$3) {
            return x$0.apply(pool, domain, model, namespace, snapshot, maxRetry, retryInitialDelay, cached, evidence$3);
        }

        public <F, C, S, E, R, N> int inline$$lessinit$greater$default$6$i2(SkunkBackend$DomainBuilder$ x$0) {
            return x$0.$lessinit$greater$default$6();
        }

        public <F, C, S, E, R, N> FiniteDuration inline$$lessinit$greater$default$7$i2(SkunkBackend$DomainBuilder$ x$0) {
            return x$0.$lessinit$greater$default$7();
        }

        public <F, C, S, E, R, N> boolean inline$$lessinit$greater$default$8$i2(SkunkBackend$DomainBuilder$ x$0) {
            return x$0.$lessinit$greater$default$8();
        }
    }
}

