/*
 * Decompiled with CFR 0.152.
 */
package edomata.backend;

import edomata.backend.AggregateState;
import edomata.backend.BackendCodec;
import edomata.backend.EventMessage;
import edomata.backend.EventMessage$;
import edomata.backend.EventMetadata$;
import edomata.backend.OutboxItem;
import edomata.backend.OutboxItem$;
import edomata.backend.Queries$;
import edomata.backend.Queries$Journal$InsertRow$;
import edomata.core.CommandMessage;
import edomata.core.MessageMetadata;
import edomata.core.MessageMetadata$;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.UUID;
import org.tpolecat.sourcepos.SourcePos;
import org.tpolecat.sourcepos.SourcePos$;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3$;
import scala.Tuple4;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import skunk.Codec;
import skunk.Command;
import skunk.Decoder;
import skunk.Encoder;
import skunk.Fragment;
import skunk.Query;
import skunk.Void;
import skunk.Void$;
import skunk.codec.all$;
import skunk.package;
import skunk.syntax.StringContextOps;
import skunk.syntax.StringContextOps$;
import skunk.util.Origin$;

public final class Queries {
    public static Command<Void> setupSchema(String string) {
        return Queries$.MODULE$.setupSchema(string);
    }

    public static final class Commands {
        private final Fragment<Void> table;
        private final Command setup;
        private final Query count;
        private final Encoder<CommandMessage<?>> command;

        public Commands(String namespace) {
            SourcePos sp = SourcePos$.MODULE$.apply("/home/runner/work/edomata/edomata/modules/skunk/src/main/scala/Queries.scala", 185);
            this.table = StringContextOps$.MODULE$.fragmentFromParts((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringContextOps.Part[]{StringContextOps.Str$.MODULE$.apply(""), StringContextOps.Str$.MODULE$.apply(namespace), StringContextOps.Str$.MODULE$.apply(".commands")})), (Encoder)Void$.MODULE$.codec(), Origin$.MODULE$.apply(sp.file(), sp.line()));
            SourcePos sp2 = SourcePos$.MODULE$.apply("/home/runner/work/edomata/edomata/modules/skunk/src/main/scala/Queries.scala", 187);
            this.setup = StringContextOps$.MODULE$.fragmentFromParts((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringContextOps.Part[]{StringContextOps.Str$.MODULE$.apply("\nCREATE TABLE IF NOT EXISTS "), StringContextOps.Emb$.MODULE$.apply(this.table.parts()), StringContextOps.Str$.MODULE$.apply(" (\n  id text NOT NULL,\n  \"time\" timestamptz NOT NULL,\n  address text NOT NULL,\n  CONSTRAINT commands_pk PRIMARY KEY (id)\n);\n")})), (Encoder)Void$.MODULE$.codec(), Origin$.MODULE$.apply(sp2.file(), sp2.line())).command();
            SourcePos sp3 = SourcePos$.MODULE$.apply("/home/runner/work/edomata/edomata/modules/skunk/src/main/scala/Queries.scala", 197);
            this.count = StringContextOps$.MODULE$.fragmentFromParts((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringContextOps.Part[]{StringContextOps.Str$.MODULE$.apply("select count(*) from "), StringContextOps.Emb$.MODULE$.apply(this.table.parts()), StringContextOps.Str$.MODULE$.apply(" where id = "), StringContextOps.Par$.MODULE$.apply(all$.MODULE$.text().sql()), StringContextOps.Str$.MODULE$.apply("")})), (Encoder)all$.MODULE$.text(), Origin$.MODULE$.apply(sp3.file(), sp3.line())).query((Decoder)all$.MODULE$.int8());
            Codec instant = all$.MODULE$.timestamptz().imap((Function1 & Serializable)_$1 -> _$1.toInstant(), (Function1 & Serializable)_$2 -> _$2.atOffset(ZoneOffset.UTC));
            this.command = package.implicits$.MODULE$.toCodecOps(package.implicits$.MODULE$.toCodecOpsLow(instant).$times$colon(all$.MODULE$.text())).$times$colon(all$.MODULE$.text()).contramap((Function1 & Serializable)c -> Tuple3$.MODULE$.apply((Object)c.id(), (Object)c.address(), (Object)c.time()));
        }

        public Command<Void> setup() {
            return this.setup;
        }

        public Query<String, Object> count() {
            return this.count;
        }

        public Command<CommandMessage<?>> insert() {
            SourcePos sp = SourcePos$.MODULE$.apply("/home/runner/work/edomata/edomata/modules/skunk/src/main/scala/Queries.scala", 205);
            return StringContextOps$.MODULE$.fragmentFromParts((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringContextOps.Part[]{StringContextOps.Str$.MODULE$.apply("\ninsert into "), StringContextOps.Emb$.MODULE$.apply(this.table.parts()), StringContextOps.Str$.MODULE$.apply(" (id, address, \"time\") values ("), StringContextOps.Par$.MODULE$.apply(this.command.sql()), StringContextOps.Str$.MODULE$.apply(");\n")})), this.command, Origin$.MODULE$.apply(sp.file(), sp.line())).command();
        }
    }

    public static final class Journal<E> {
        private final BackendCodec<E> codec;
        private final Fragment<Void> table;
        public final Queries$Journal$InsertRow$ InsertRow$lzy1;
        private final Codec<InsertRow> insertRow;
        private final Fragment<Void> readFields;
        private final Codec<EventMessage<E>> readCodec;

        public Journal(String namespace, BackendCodec<E> codec) {
            this.codec = codec;
            this.InsertRow$lzy1 = new Queries$Journal$InsertRow$(this);
            SourcePos sp = SourcePos$.MODULE$.apply("/home/runner/work/edomata/edomata/modules/skunk/src/main/scala/Queries.scala", 36);
            this.table = StringContextOps$.MODULE$.fragmentFromParts((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringContextOps.Part[]{StringContextOps.Str$.MODULE$.apply(""), StringContextOps.Str$.MODULE$.apply(namespace), StringContextOps.Str$.MODULE$.apply(".journal")})), (Encoder)Void$.MODULE$.codec(), Origin$.MODULE$.apply(sp.file(), sp.line()));
            Codec<E> event = codec.codec();
            this.insertRow = package.implicits$.MODULE$.toCodecOps(package.implicits$.MODULE$.toCodecOps(package.implicits$.MODULE$.toCodecOps(package.implicits$.MODULE$.toCodecOps(package.implicits$.MODULE$.toCodecOpsLow(event).$times$colon(all$.MODULE$.int8())).$times$colon(all$.MODULE$.timestamptz())).$times$colon(all$.MODULE$.text())).$times$colon(all$.MODULE$.uuid())).pimap((Mirror.Product)this.InsertRow(), $less$colon$less$.MODULE$.refl());
            SourcePos sp2 = SourcePos$.MODULE$.apply("/home/runner/work/edomata/edomata/modules/skunk/src/main/scala/Queries.scala", 77);
            this.readFields = StringContextOps$.MODULE$.fragmentFromParts((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringContextOps.Part[]{StringContextOps.Str$.MODULE$.apply("id, time, seqnr, version, stream, payload")})), (Encoder)Void$.MODULE$.codec(), Origin$.MODULE$.apply(sp2.file(), sp2.line()));
            Codec metaCodec = package.implicits$.MODULE$.toCodecOps(package.implicits$.MODULE$.toCodecOps(package.implicits$.MODULE$.toCodecOps(package.implicits$.MODULE$.toCodecOps(package.implicits$.MODULE$.toCodecOpsLow(all$.MODULE$.text()).$times$colon(all$.MODULE$.int8())).$times$colon(all$.MODULE$.int8())).$times$colon(all$.MODULE$.timestamptz())).$times$colon(all$.MODULE$.uuid())).pimap((Mirror.Product)EventMetadata$.MODULE$, $less$colon$less$.MODULE$.refl());
            this.readCodec = package.implicits$.MODULE$.toCodecOps(package.implicits$.MODULE$.toCodecOpsLow(event).$times$colon(metaCodec)).pimap((Mirror.Product)EventMessage$.MODULE$, $less$colon$less$.MODULE$.refl());
        }

        public Command<Void> setup() {
            SourcePos sp = SourcePos$.MODULE$.apply("/home/runner/work/edomata/edomata/modules/skunk/src/main/scala/Queries.scala", 39);
            return StringContextOps$.MODULE$.fragmentFromParts((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringContextOps.Part[]{StringContextOps.Str$.MODULE$.apply("\nDO $$ begin\n\nCREATE TABLE IF NOT EXISTS "), StringContextOps.Emb$.MODULE$.apply(this.table.parts()), StringContextOps.Str$.MODULE$.apply(" (\n  id uuid NOT NULL,\n  \"time\" timestamptz NOT NULL,\n  seqnr bigserial NOT NULL,\n  \"version\" int8 NOT NULL,\n  stream text NOT NULL,\n  payload "), StringContextOps.Str$.MODULE$.apply(this.codec.oid().name()), StringContextOps.Str$.MODULE$.apply(" NOT NULL,\n  CONSTRAINT journal_pk PRIMARY KEY (id),\n  CONSTRAINT journal_un UNIQUE (stream, version)\n);\n\nCREATE INDEX IF NOT EXISTS journal_seqnr_idx ON "), StringContextOps.Emb$.MODULE$.apply(this.table.parts()), StringContextOps.Str$.MODULE$.apply(" USING btree (seqnr);\n\nCREATE INDEX IF NOT EXISTS journal_stream_idx ON "), StringContextOps.Emb$.MODULE$.apply(this.table.parts()), StringContextOps.Str$.MODULE$.apply(" USING btree (stream, version);\n\nEND $$;\n")})), (Encoder)Void$.MODULE$.codec(), Origin$.MODULE$.apply(sp.file(), sp.line())).command();
        }

        public final Queries$Journal$InsertRow$ InsertRow() {
            return this.InsertRow$lzy1;
        }

        public Command<List<InsertRow>> append(List<InsertRow> n) {
            SourcePos sp = SourcePos$.MODULE$.apply("/home/runner/work/edomata/edomata/modules/skunk/src/main/scala/Queries.scala", 74);
            return StringContextOps$.MODULE$.fragmentFromParts((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringContextOps.Part[]{StringContextOps.Str$.MODULE$.apply("insert into "), StringContextOps.Emb$.MODULE$.apply(this.table.parts()), StringContextOps.Str$.MODULE$.apply(" (\"id\", \"stream\", \"time\", \"version\", \"payload\") values "), StringContextOps.Par$.MODULE$.apply(this.insertRow.values().list(n).sql()), StringContextOps.Str$.MODULE$.apply("")})), this.insertRow.values().list(n), Origin$.MODULE$.apply(sp.file(), sp.line())).command();
        }

        public Query<Void, EventMessage<E>> readAll() {
            SourcePos sp = SourcePos$.MODULE$.apply("/home/runner/work/edomata/edomata/modules/skunk/src/main/scala/Queries.scala", 84);
            return StringContextOps$.MODULE$.fragmentFromParts((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringContextOps.Part[]{StringContextOps.Str$.MODULE$.apply("select "), StringContextOps.Emb$.MODULE$.apply(this.readFields.parts()), StringContextOps.Str$.MODULE$.apply(" from "), StringContextOps.Emb$.MODULE$.apply(this.table.parts()), StringContextOps.Str$.MODULE$.apply(" order by seqnr asc")})), (Encoder)Void$.MODULE$.codec(), Origin$.MODULE$.apply(sp.file(), sp.line())).query(this.readCodec);
        }

        public Query<Object, EventMessage<E>> readAllAfter() {
            SourcePos sp = SourcePos$.MODULE$.apply("/home/runner/work/edomata/edomata/modules/skunk/src/main/scala/Queries.scala", 87);
            return StringContextOps$.MODULE$.fragmentFromParts((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringContextOps.Part[]{StringContextOps.Str$.MODULE$.apply("select "), StringContextOps.Emb$.MODULE$.apply(this.readFields.parts()), StringContextOps.Str$.MODULE$.apply(" from "), StringContextOps.Emb$.MODULE$.apply(this.table.parts()), StringContextOps.Str$.MODULE$.apply(" where seqnr > "), StringContextOps.Par$.MODULE$.apply(all$.MODULE$.int8().sql()), StringContextOps.Str$.MODULE$.apply(" order by seqnr asc")})), (Encoder)all$.MODULE$.int8(), Origin$.MODULE$.apply(sp.file(), sp.line())).query(this.readCodec);
        }

        public Query<String, EventMessage<E>> readStream() {
            SourcePos sp = SourcePos$.MODULE$.apply("/home/runner/work/edomata/edomata/modules/skunk/src/main/scala/Queries.scala", 91);
            return StringContextOps$.MODULE$.fragmentFromParts((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringContextOps.Part[]{StringContextOps.Str$.MODULE$.apply("select "), StringContextOps.Emb$.MODULE$.apply(this.readFields.parts()), StringContextOps.Str$.MODULE$.apply(" from "), StringContextOps.Emb$.MODULE$.apply(this.table.parts()), StringContextOps.Str$.MODULE$.apply(" where stream = "), StringContextOps.Par$.MODULE$.apply(all$.MODULE$.text().sql()), StringContextOps.Str$.MODULE$.apply(" order by version asc")})), (Encoder)all$.MODULE$.text(), Origin$.MODULE$.apply(sp.file(), sp.line())).query(this.readCodec);
        }

        public Query<Tuple2<String, Object>, EventMessage<E>> readStreamAfter() {
            SourcePos sp = SourcePos$.MODULE$.apply("/home/runner/work/edomata/edomata/modules/skunk/src/main/scala/Queries.scala", 95);
            return StringContextOps$.MODULE$.fragmentFromParts((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringContextOps.Part[]{StringContextOps.Str$.MODULE$.apply("select "), StringContextOps.Emb$.MODULE$.apply(this.readFields.parts()), StringContextOps.Str$.MODULE$.apply(" from "), StringContextOps.Emb$.MODULE$.apply(this.table.parts()), StringContextOps.Str$.MODULE$.apply(" where stream = "), StringContextOps.Par$.MODULE$.apply(all$.MODULE$.text().sql()), StringContextOps.Str$.MODULE$.apply(" and version > "), StringContextOps.Par$.MODULE$.apply(all$.MODULE$.int8().sql()), StringContextOps.Str$.MODULE$.apply(" order by version asc")})), all$.MODULE$.text().$tilde((Encoder)all$.MODULE$.int8()), Origin$.MODULE$.apply(sp.file(), sp.line())).query(this.readCodec);
        }

        public Query<Tuple2<String, Object>, EventMessage<E>> readStreamBefore() {
            SourcePos sp = SourcePos$.MODULE$.apply("/home/runner/work/edomata/edomata/modules/skunk/src/main/scala/Queries.scala", 99);
            return StringContextOps$.MODULE$.fragmentFromParts((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringContextOps.Part[]{StringContextOps.Str$.MODULE$.apply("select "), StringContextOps.Emb$.MODULE$.apply(this.readFields.parts()), StringContextOps.Str$.MODULE$.apply(" from "), StringContextOps.Emb$.MODULE$.apply(this.table.parts()), StringContextOps.Str$.MODULE$.apply(" where stream = "), StringContextOps.Par$.MODULE$.apply(all$.MODULE$.text().sql()), StringContextOps.Str$.MODULE$.apply(" and version < "), StringContextOps.Par$.MODULE$.apply(all$.MODULE$.int8().sql()), StringContextOps.Str$.MODULE$.apply(" order by version asc")})), all$.MODULE$.text().$tilde((Encoder)all$.MODULE$.int8()), Origin$.MODULE$.apply(sp.file(), sp.line())).query(this.readCodec);
        }

        public final class InsertRow
        implements Product,
        Serializable {
            private final UUID id;
            private final String streamId;
            private final OffsetDateTime time;
            private final long version;
            private final Object event;
            private final /* synthetic */ Journal $outer;

            public InsertRow(Journal $outer, UUID id, String streamId, OffsetDateTime time, long version, E event) {
                this.id = id;
                this.streamId = streamId;
                this.time = time;
                this.version = version;
                this.event = event;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.id()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.streamId()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.time()));
                n = Statics.mix((int)n, (int)Statics.longHash((long)this.version()));
                n = Statics.mix((int)n, (int)Statics.anyHash(this.event()));
                return Statics.finalizeHash((int)n, (int)5);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof InsertRow)) return false;
                if (((InsertRow)object).edomata$backend$Queries$Journal$InsertRow$$$outer() != this.$outer) return false;
                InsertRow insertRow = (InsertRow)object;
                UUID uUID = this.id();
                UUID uUID2 = insertRow.id();
                if (uUID == null) {
                    if (uUID2 != null) {
                        return false;
                    }
                } else if (!((Object)uUID).equals(uUID2)) return false;
                String string = this.streamId();
                String string2 = insertRow.streamId();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                OffsetDateTime offsetDateTime = this.time();
                OffsetDateTime offsetDateTime2 = insertRow.time();
                if (offsetDateTime == null) {
                    if (offsetDateTime2 != null) {
                        return false;
                    }
                } else if (!((Object)offsetDateTime).equals(offsetDateTime2)) return false;
                if (this.version() != insertRow.version()) return false;
                if (!BoxesRunTime.equals(this.event(), insertRow.event())) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof InsertRow;
            }

            public int productArity() {
                return 5;
            }

            public String productPrefix() {
                return "InsertRow";
            }

            public Object productElement(int n) {
                Object object;
                int n2 = n;
                switch (n2) {
                    case 0: {
                        object = this._1();
                        break;
                    }
                    case 1: {
                        object = this._2();
                        break;
                    }
                    case 2: {
                        object = this._3();
                        break;
                    }
                    case 3: {
                        object = BoxesRunTime.boxToLong((long)this._4());
                        break;
                    }
                    case 4: {
                        object = this._5();
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                    }
                }
                return object;
            }

            public String productElementName(int n) {
                String string;
                int n2 = n;
                switch (n2) {
                    case 0: {
                        string = "id";
                        break;
                    }
                    case 1: {
                        string = "streamId";
                        break;
                    }
                    case 2: {
                        string = "time";
                        break;
                    }
                    case 3: {
                        string = "version";
                        break;
                    }
                    case 4: {
                        string = "event";
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                    }
                }
                return string;
            }

            public UUID id() {
                return this.id;
            }

            public String streamId() {
                return this.streamId;
            }

            public OffsetDateTime time() {
                return this.time;
            }

            public long version() {
                return this.version;
            }

            public E event() {
                return this.event;
            }

            public InsertRow copy(UUID id, String streamId, OffsetDateTime time, long version, E event) {
                return new InsertRow(this.$outer, id, streamId, time, version, event);
            }

            public UUID copy$default$1() {
                return this.id();
            }

            public String copy$default$2() {
                return this.streamId();
            }

            public OffsetDateTime copy$default$3() {
                return this.time();
            }

            public long copy$default$4() {
                return this.version();
            }

            public E copy$default$5() {
                return this.event();
            }

            public UUID _1() {
                return this.id();
            }

            public String _2() {
                return this.streamId();
            }

            public OffsetDateTime _3() {
                return this.time();
            }

            public long _4() {
                return this.version();
            }

            public E _5() {
                return this.event();
            }

            public final /* synthetic */ Journal edomata$backend$Queries$Journal$InsertRow$$$outer() {
                return this.$outer;
            }
        }
    }

    public static final class Outbox<N> {
        private final Fragment<Void> table;
        private final Command setup;
        private final Query read;
        private final Codec<Object> insertCodec;

        public Outbox(String namespace, BackendCodec<N> codec) {
            SourcePos sp = SourcePos$.MODULE$.apply("/home/runner/work/edomata/edomata/modules/skunk/src/main/scala/Queries.scala", 104);
            this.table = StringContextOps$.MODULE$.fragmentFromParts((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringContextOps.Part[]{StringContextOps.Str$.MODULE$.apply(""), StringContextOps.Str$.MODULE$.apply(namespace), StringContextOps.Str$.MODULE$.apply(".outbox")})), (Encoder)Void$.MODULE$.codec(), Origin$.MODULE$.apply(sp.file(), sp.line()));
            Codec<N> notification = codec.codec();
            SourcePos sp2 = SourcePos$.MODULE$.apply("/home/runner/work/edomata/edomata/modules/skunk/src/main/scala/Queries.scala", 107);
            this.setup = StringContextOps$.MODULE$.fragmentFromParts((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringContextOps.Part[]{StringContextOps.Str$.MODULE$.apply("\nCREATE TABLE IF NOT EXISTS "), StringContextOps.Emb$.MODULE$.apply(this.table.parts()), StringContextOps.Str$.MODULE$.apply("(\n  seqnr bigserial NOT NULL,\n  stream text NOT NULL,\n  correlation text NULL,\n  causation text NULL,\n  payload "), StringContextOps.Str$.MODULE$.apply(codec.oid().name()), StringContextOps.Str$.MODULE$.apply(" NOT NULL,\n  created timestamptz NOT NULL,\n  published timestamptz NULL,\n  CONSTRAINT outbox_pk PRIMARY KEY (seqnr)\n);\n")})), (Encoder)Void$.MODULE$.codec(), Origin$.MODULE$.apply(sp2.file(), sp2.line())).command();
            Codec codec2 = all$.MODULE$.text().opt();
            Codec metadata = package.implicits$.MODULE$.toCodecOps(package.implicits$.MODULE$.toCodecOpsLow(all$.MODULE$.text().opt()).$times$colon(codec2)).pimap((Mirror.Product)MessageMetadata$.MODULE$, $less$colon$less$.MODULE$.refl());
            Codec itemCodec = package.implicits$.MODULE$.toCodecOps(package.implicits$.MODULE$.toCodecOps(package.implicits$.MODULE$.toCodecOps(package.implicits$.MODULE$.toCodecOps(package.implicits$.MODULE$.toCodecOpsLow(metadata).$times$colon(notification)).$times$colon(all$.MODULE$.timestamptz())).$times$colon(all$.MODULE$.text())).$times$colon(all$.MODULE$.int8())).pimap((Mirror.Product)OutboxItem$.MODULE$, $less$colon$less$.MODULE$.refl());
            SourcePos sp3 = SourcePos$.MODULE$.apply("/home/runner/work/edomata/edomata/modules/skunk/src/main/scala/Queries.scala", 132);
            this.read = StringContextOps$.MODULE$.fragmentFromParts((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringContextOps.Part[]{StringContextOps.Str$.MODULE$.apply("\nselect seqnr, stream, created, payload, correlation, causation\nfrom "), StringContextOps.Emb$.MODULE$.apply(this.table.parts()), StringContextOps.Str$.MODULE$.apply("\nwhere published is NULL\norder by seqnr asc\n")})), (Encoder)Void$.MODULE$.codec(), Origin$.MODULE$.apply(sp3.file(), sp3.line())).query((Decoder)itemCodec);
            this.insertCodec = package.implicits$.MODULE$.toCodecOps(package.implicits$.MODULE$.toCodecOps(package.implicits$.MODULE$.toCodecOpsLow(metadata).$times$colon(all$.MODULE$.timestamptz())).$times$colon(all$.MODULE$.text())).$times$colon(notification);
        }

        public Command<Void> setup() {
            return this.setup;
        }

        public Command<Tuple2<OffsetDateTime, List<Object>>> markAsPublished(List<Object> l) {
            SourcePos sp = SourcePos$.MODULE$.apply("/home/runner/work/edomata/edomata/modules/skunk/src/main/scala/Queries.scala", 121);
            return StringContextOps$.MODULE$.fragmentFromParts((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringContextOps.Part[]{StringContextOps.Str$.MODULE$.apply("\nupdate "), StringContextOps.Emb$.MODULE$.apply(this.table.parts()), StringContextOps.Str$.MODULE$.apply("\nset published = "), StringContextOps.Par$.MODULE$.apply(all$.MODULE$.timestamptz().sql()), StringContextOps.Str$.MODULE$.apply("\nwhere seqnr in "), StringContextOps.Par$.MODULE$.apply(all$.MODULE$.int8().values().list(l).sql()), StringContextOps.Str$.MODULE$.apply("\n")})), all$.MODULE$.timestamptz().$tilde(all$.MODULE$.int8().values().list(l)), Origin$.MODULE$.apply(sp.file(), sp.line())).command();
        }

        public Query<Void, OutboxItem<N>> read() {
            return this.read;
        }

        public Command<List<Tuple4<N, String, OffsetDateTime, MessageMetadata>>> insertAll(List<Tuple4<N, String, OffsetDateTime, MessageMetadata>> items) {
            SourcePos sp = SourcePos$.MODULE$.apply("/home/runner/work/edomata/edomata/modules/skunk/src/main/scala/Queries.scala", 143);
            return StringContextOps$.MODULE$.fragmentFromParts((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringContextOps.Part[]{StringContextOps.Str$.MODULE$.apply("\ninsert into "), StringContextOps.Emb$.MODULE$.apply(this.table.parts()), StringContextOps.Str$.MODULE$.apply(" (payload, stream, created, correlation, causation) values "), StringContextOps.Par$.MODULE$.apply(this.insertCodec.values().list(items).sql()), StringContextOps.Str$.MODULE$.apply("\n")})), this.insertCodec.values().list(items), Origin$.MODULE$.apply(sp.file(), sp.line())).command();
        }
    }

    public static final class Snapshot<S> {
        private final Fragment<Void> table;
        private final Codec<S> state;
        private final Command setup;
        private final Encoder<Object> insertCodec;

        public Snapshot(String namespace, BackendCodec<S> codec) {
            SourcePos sp = SourcePos$.MODULE$.apply("/home/runner/work/edomata/edomata/modules/skunk/src/main/scala/Queries.scala", 153);
            this.table = StringContextOps$.MODULE$.fragmentFromParts((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringContextOps.Part[]{StringContextOps.Str$.MODULE$.apply(""), StringContextOps.Str$.MODULE$.apply(namespace), StringContextOps.Str$.MODULE$.apply(".snapshots")})), (Encoder)Void$.MODULE$.codec(), Origin$.MODULE$.apply(sp.file(), sp.line()));
            this.state = codec.codec();
            SourcePos sp2 = SourcePos$.MODULE$.apply("/home/runner/work/edomata/edomata/modules/skunk/src/main/scala/Queries.scala", 156);
            this.setup = StringContextOps$.MODULE$.fragmentFromParts((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringContextOps.Part[]{StringContextOps.Str$.MODULE$.apply("\nCREATE TABLE IF NOT EXISTS "), StringContextOps.Emb$.MODULE$.apply(this.table.parts()), StringContextOps.Str$.MODULE$.apply(" (\n  id text NOT NULL,\n  \"version\" int8 NOT NULL,\n  state "), StringContextOps.Str$.MODULE$.apply(codec.oid().name()), StringContextOps.Str$.MODULE$.apply(" NOT NULL,\n  CONSTRAINT snapshots_pk PRIMARY KEY (id)\n);\n")})), (Encoder)Void$.MODULE$.codec(), Origin$.MODULE$.apply(sp2.file(), sp2.line())).command();
            this.insertCodec = package.implicits$.MODULE$.toCodecOpsLow(this.aggregateStateCodec()).$times$colon(all$.MODULE$.text()).values();
        }

        public Command<Void> setup() {
            return this.setup;
        }

        private Codec<AggregateState.Valid<S>> aggregateStateCodec() {
            return package.implicits$.MODULE$.toCodecOps(package.implicits$.MODULE$.toCodecOpsLow(all$.MODULE$.int8()).$times$colon(this.state)).pimap((Mirror.Product)AggregateState.Valid$.MODULE$, $less$colon$less$.MODULE$.refl());
        }

        public Command<List<Tuple2<String, AggregateState.Valid<S>>>> put(List<Tuple2<String, AggregateState.Valid<S>>> l) {
            SourcePos sp = SourcePos$.MODULE$.apply("/home/runner/work/edomata/edomata/modules/skunk/src/main/scala/Queries.scala", 171);
            return StringContextOps$.MODULE$.fragmentFromParts((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringContextOps.Part[]{StringContextOps.Str$.MODULE$.apply("\ninsert into "), StringContextOps.Emb$.MODULE$.apply(this.table.parts()), StringContextOps.Str$.MODULE$.apply(" (id, state, \"version\") values "), StringContextOps.Par$.MODULE$.apply(this.insertCodec.list(l).sql()), StringContextOps.Str$.MODULE$.apply("\non conflict (id) do update\nset version = excluded.version,\n    state   = excluded.state\n         ")})), this.insertCodec.list(l), Origin$.MODULE$.apply(sp.file(), sp.line())).command();
        }

        public Query<String, AggregateState.Valid<S>> get() {
            SourcePos sp = SourcePos$.MODULE$.apply("/home/runner/work/edomata/edomata/modules/skunk/src/main/scala/Queries.scala", 179);
            return StringContextOps$.MODULE$.fragmentFromParts((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringContextOps.Part[]{StringContextOps.Str$.MODULE$.apply("select state , version from "), StringContextOps.Emb$.MODULE$.apply(this.table.parts()), StringContextOps.Str$.MODULE$.apply(" where id = "), StringContextOps.Par$.MODULE$.apply(all$.MODULE$.text().sql()), StringContextOps.Str$.MODULE$.apply("")})), (Encoder)all$.MODULE$.text(), Origin$.MODULE$.apply(sp.file(), sp.line())).query(this.aggregateStateCodec());
        }
    }
}

