/*
 * Decompiled with CFR 0.152.
 */
package edomata.backend;

import scala.Function1;
import scala.util.Either;
import skunk.Codec;
import skunk.Codec$;
import skunk.codec.binary$;
import skunk.data.Type;
import skunk.data.Type$;

public interface BackendCodec<T> {
    public Type oid();

    public Codec<T> codec();

    public static final class Binary<T>
    implements BackendCodec<T> {
        private final Function1<T, byte[]> encode;
        private final Function1<byte[], Either<String, T>> decode;

        public Binary(Function1<T, byte[]> encode, Function1<byte[], Either<String, T>> decode) {
            this.encode = encode;
            this.decode = decode;
        }

        @Override
        public Type oid() {
            return Type$.MODULE$.bytea();
        }

        @Override
        public Codec<T> codec() {
            return binary$.MODULE$.bytea().eimap(this.decode, this.encode);
        }
    }

    public static final class Json<T>
    implements BackendCodec<T> {
        private final Function1<T, String> encode;
        private final Function1<String, Either<String, T>> decode;

        public Json(Function1<T, String> encode, Function1<String, Either<String, T>> decode) {
            this.encode = encode;
            this.decode = decode;
        }

        @Override
        public final Type oid() {
            return Type$.MODULE$.json();
        }

        @Override
        public Codec<T> codec() {
            return Codec$.MODULE$.simple(this.encode, this.decode, this.oid());
        }
    }

    public static final class JsonB<T>
    implements BackendCodec<T> {
        private final Function1<T, String> encode;
        private final Function1<String, Either<String, T>> decode;

        public JsonB(Function1<T, String> encode, Function1<String, Either<String, T>> decode) {
            this.encode = encode;
            this.decode = decode;
        }

        @Override
        public final Type oid() {
            return Type$.MODULE$.jsonb();
        }

        @Override
        public Codec<T> codec() {
            return Codec$.MODULE$.simple(this.encode, this.decode, this.oid());
        }
    }
}

