/*
 * Decompiled with CFR 0.152.
 */
package edomata.backend.eventsourcing;

import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.std.Random;
import cats.effect.std.Random$;
import edomata.backend.CommandStore;
import edomata.backend.CommandStore$;
import edomata.backend.eventsourcing.Backend;
import edomata.backend.eventsourcing.BackendBuilder$;
import edomata.backend.eventsourcing.BackendImpl$;
import edomata.backend.eventsourcing.CachedRepository;
import edomata.backend.eventsourcing.CommandHandler;
import edomata.backend.eventsourcing.CommandHandler$;
import edomata.backend.eventsourcing.Repository;
import edomata.backend.eventsourcing.SnapshotStore;
import edomata.backend.eventsourcing.SnapshotStore$;
import edomata.backend.eventsourcing.Storage;
import edomata.backend.eventsourcing.StorageDriver;
import edomata.core.ModelTC;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;

public final class BackendBuilder<F, Codec, C, S, E, R, N> {
    private final Resource<F, StorageDriver<F, Codec>> driver;
    private final boolean domain;
    private final Function1<StorageDriver<F, Codec>, Resource<F, SnapshotStore<F, S>>> snapshot;
    private final Option<Resource<F, CommandStore<F>>> commandCache;
    private final int maxRetry;
    private final FiniteDuration retryInitialDelay;
    private final Async<F> evidence$1;
    private final ModelTC<S, E, R> x$7;

    public static <F, Codec, C, S, E, R, N> int $lessinit$greater$default$5() {
        return BackendBuilder$.MODULE$.$lessinit$greater$default$5();
    }

    public static <F, Codec, C, S, E, R, N> FiniteDuration $lessinit$greater$default$6() {
        return BackendBuilder$.MODULE$.$lessinit$greater$default$6();
    }

    public BackendBuilder(Resource<F, StorageDriver<F, Codec>> driver, boolean domain, Function1<StorageDriver<F, Codec>, Resource<F, SnapshotStore<F, S>>> snapshot, Option<Resource<F, CommandStore<F>>> commandCache, int maxRetry, FiniteDuration retryInitialDelay, Async<F> evidence$1, ModelTC<S, E, R> x$7) {
        this.driver = driver;
        this.domain = domain;
        this.snapshot = snapshot;
        this.commandCache = commandCache;
        this.maxRetry = maxRetry;
        this.retryInitialDelay = retryInitialDelay;
        this.evidence$1 = evidence$1;
        this.x$7 = x$7;
    }

    public int maxRetry() {
        return this.maxRetry;
    }

    public FiniteDuration retryInitialDelay() {
        return this.retryInitialDelay;
    }

    private BackendBuilder<F, Codec, C, S, E, R, N> copy(Resource<F, StorageDriver<F, Codec>> driver, boolean domain, Function1<StorageDriver<F, Codec>, Resource<F, SnapshotStore<F, S>>> snapshot, Option<Resource<F, CommandStore<F>>> commandCache, int maxRetry, FiniteDuration retryInitialDelay) {
        return new BackendBuilder<F, Codec, C, S, E, R, N>(driver, domain, snapshot, commandCache, maxRetry, retryInitialDelay, this.evidence$1, this.x$7);
    }

    private Resource<F, StorageDriver<F, Codec>> copy$default$1() {
        return this.driver;
    }

    private boolean copy$default$2() {
        return this.domain;
    }

    private Function1<StorageDriver<F, Codec>, Resource<F, SnapshotStore<F, S>>> copy$default$3() {
        return this.snapshot;
    }

    private Option<Resource<F, CommandStore<F>>> copy$default$4() {
        return this.commandCache;
    }

    private int copy$default$5() {
        return this.maxRetry();
    }

    private FiniteDuration copy$default$6() {
        return this.retryInitialDelay();
    }

    public BackendBuilder<F, Codec, C, S, E, R, N> persistedSnapshot(int maxInMem, int maxBuffer, FiniteDuration maxWait, Codec codec) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), (Function1 & Serializable)_$4 -> _$4.snapshot(codec).flatMap((Function1 & Serializable)store -> SnapshotStore$.MODULE$.persisted(store, maxInMem, maxBuffer, maxWait, SnapshotStore$.MODULE$.persisted$default$5(), this.evidence$1)), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public int persistedSnapshot$default$1() {
        return 1000;
    }

    public int persistedSnapshot$default$2() {
        return 100;
    }

    public FiniteDuration persistedSnapshot$default$3() {
        return new package.DurationInt(package$.MODULE$.DurationInt(1)).minute();
    }

    public BackendBuilder<F, Codec, C, S, E, R, N> disableCache() {
        None$ none$ = None$.MODULE$;
        Resource<F, StorageDriver<F, Codec>> resource = this.copy$default$1();
        boolean bl = this.copy$default$2();
        Function1<StorageDriver<F, Codec>, Resource<F, SnapshotStore<F, S>>> function1 = this.copy$default$3();
        int n = this.copy$default$5();
        FiniteDuration finiteDuration = this.copy$default$6();
        return this.copy(resource, bl, function1, (Option<Resource<F, CommandStore<F>>>)none$, n, finiteDuration);
    }

    public BackendBuilder<F, Codec, C, S, E, R, N> withCommandCache(Resource<F, CommandStore<F>> cache) {
        Some some = Some$.MODULE$.apply(cache);
        Resource<F, StorageDriver<F, Codec>> resource = this.copy$default$1();
        boolean bl = this.copy$default$2();
        Function1<StorageDriver<F, Codec>, Resource<F, SnapshotStore<F, S>>> function1 = this.copy$default$3();
        int n = this.copy$default$5();
        FiniteDuration finiteDuration = this.copy$default$6();
        return this.copy(resource, bl, function1, (Option<Resource<F, CommandStore<F>>>)some, n, finiteDuration);
    }

    public BackendBuilder<F, Codec, C, S, E, R, N> withCommandCache(CommandStore<F> cache) {
        return this.withCommandCache((F)Resource$.MODULE$.pure(cache));
    }

    public BackendBuilder<F, Codec, C, S, E, R, N> withCommandCache(F cache) {
        return this.withCommandCache((F)Resource$.MODULE$.eval(cache));
    }

    public BackendBuilder<F, Codec, C, S, E, R, N> withCommandCacheSize(int maxCommandsToCache) {
        Some some = Some$.MODULE$.apply((Object)Resource$.MODULE$.eval(CommandStore$.MODULE$.inMem(maxCommandsToCache, this.evidence$1)));
        Resource<F, StorageDriver<F, Codec>> resource = this.copy$default$1();
        boolean bl = this.copy$default$2();
        Function1<StorageDriver<F, Codec>, Resource<F, SnapshotStore<F, S>>> function1 = this.copy$default$3();
        int n = this.copy$default$5();
        FiniteDuration finiteDuration = this.copy$default$6();
        return this.copy(resource, bl, function1, (Option<Resource<F, CommandStore<F>>>)some, n, finiteDuration);
    }

    public BackendBuilder<F, Codec, C, S, E, R, N> inMemSnapshot(int maxInMem) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), (Function1 & Serializable)_$5 -> Resource$.MODULE$.eval(SnapshotStore$.MODULE$.inMem(maxInMem, this.evidence$1)), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public int inMemSnapshot$default$1() {
        return 1000;
    }

    public BackendBuilder<F, Codec, C, S, E, R, N> withSnapshot(Resource<F, SnapshotStore<F, S>> s) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), (Function1 & Serializable)_$6 -> s, this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public BackendBuilder<F, Codec, C, S, E, R, N> withRetryConfig(int maxRetry, FiniteDuration retryInitialDelay) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), maxRetry, retryInitialDelay);
    }

    public int withRetryConfig$default$1() {
        return this.maxRetry();
    }

    public FiniteDuration withRetryConfig$default$2() {
        return this.retryInitialDelay();
    }

    public Resource<F, Backend<F, S, E, R, N>> build(Codec event, Codec notifs) {
        return this.driver.flatMap((Function1 & Serializable)dr -> ((Resource)this.snapshot.apply(dr)).flatMap((Function1 & Serializable)s -> dr.build(s, this.x$7, event, notifs).flatMap((Function1 & Serializable)storage -> Resource$.MODULE$.eval(Random$.MODULE$.scalaUtilRandom(this.evidence$1)).flatMap((Function1 & Serializable)x$12 -> {
            Random random = x$12;
            if (random instanceof Random) {
                Random given_Random_F = random;
                return ((Resource)this.commandCache.fold(() -> BackendBuilder.build$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(storage), (Function1 & Serializable)_$7 -> _$7.map((Function1 & Serializable)_$8 -> new CachedRepository(storage.repository(), _$8, s, this.evidence$1)))).map((Function1 & Serializable)compiler -> {
                    CommandHandler h = CommandHandler$.MODULE$.withRetry(compiler, this.maxRetry(), this.retryInitialDelay(), this.evidence$1, given_Random_F);
                    return Tuple2$.MODULE$.apply(compiler, h);
                }).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Repository compiler = (Repository)tuple2._1();
                        CommandHandler h = (CommandHandler)tuple2._2();
                        return BackendImpl$.MODULE$.apply(h, storage.outbox(), storage.journal(), storage.reader(), storage.updates());
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)random);
        }))));
    }

    private static final Resource build$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(Storage storage$2) {
        return Resource$.MODULE$.pure(storage$2.repository());
    }
}

