/*
 * Decompiled with CFR 0.152.
 */
package edomata.backend.cqrs;

import cats.Monad;
import cats.data.Chain;
import cats.effect.kernel.Async;
import cats.implicits$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.IfMOps$;
import edomata.backend.Cache;
import edomata.backend.CommandState$Redundant$;
import edomata.backend.CommandStore;
import edomata.backend.cqrs.AggregateState;
import edomata.backend.cqrs.AggregateState$;
import edomata.backend.cqrs.CachedRepository$;
import edomata.backend.cqrs.Repository;
import edomata.core.CommandMessage;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;

public final class CachedRepository<F, S, E>
implements Repository<F, S, E> {
    private final CommandStore<F> commands;
    private final Cache<F, String, AggregateState<S>> cache;
    private final Repository<F, S, E> underlying;
    private final Monad<F> evidence$1;

    public static <F, S, E> Object apply(Repository<F, S, E> repository, CommandStore<F> commandStore, int n, Async<F> async) {
        return CachedRepository$.MODULE$.apply(repository, commandStore, n, async);
    }

    public static <F, S, E> Object build(Repository<F, S, E> repository, int n, int n2, Async<F> async) {
        return CachedRepository$.MODULE$.build(repository, n, n2, async);
    }

    public static <F, S, E> CachedRepository<F, S, E> from(Repository<F, S, E> repository, CommandStore<F> commandStore, Cache<F, String, AggregateState<S>> cache, Async<F> async) {
        return CachedRepository$.MODULE$.from(repository, commandStore, cache, async);
    }

    public static <F, S, E> int build$default$2() {
        return CachedRepository$.MODULE$.build$default$2();
    }

    public static <F, S, E> int apply$default$3() {
        return CachedRepository$.MODULE$.apply$default$3();
    }

    public static <F, S, E> int build$default$3() {
        return CachedRepository$.MODULE$.build$default$3();
    }

    public CachedRepository(CommandStore<F> commands, Cache<F, String, AggregateState<S>> cache, Repository<F, S, E> underlying, Monad<F> evidence$1) {
        this.commands = commands;
        this.cache = cache;
        this.underlying = underlying;
        this.evidence$1 = evidence$1;
    }

    @Override
    public F get(String id) {
        return this.underlying.get(id);
    }

    @Override
    public F load(CommandMessage<?> cmd) {
        Object object = implicits$.MODULE$.catsSyntaxIfM(this.commands.contains(cmd.id()), this.evidence$1);
        return (F)IfMOps$.MODULE$.ifM$extension(object, this::load$$anonfun$1, () -> this.load$$anonfun$2(cmd), this.evidence$1);
    }

    @Override
    public F save(CommandMessage<?> ctx, long version, S newState, Chain<E> events) {
        Object object = implicits$.MODULE$.catsSyntaxFlatMapOps(this.underlying.save(ctx, version, newState, events), this.evidence$1);
        Object object2 = implicits$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.save$$anonfun$1(ctx, newState, version), this.evidence$1), this.evidence$1);
        return (F)FlatMapOps$.MODULE$.$greater$greater$extension(object2, () -> this.save$$anonfun$2(ctx), this.evidence$1);
    }

    @Override
    public F notify(CommandMessage<?> ctx, Object notifications) {
        return this.underlying.notify(ctx, notifications);
    }

    private final Object load$$anonfun$1() {
        Serializable serializable = (Serializable)implicits$.MODULE$.catsSyntaxApplicativeId((Object)CommandState$Redundant$.MODULE$);
        return ApplicativeIdOps$.MODULE$.pure$extension((Object)serializable, this.evidence$1);
    }

    private final Object load$$anonfun$2(CommandMessage cmd$1) {
        return implicits$.MODULE$.toFlatMapOps(this.cache.get(cmd$1.address()), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return this.underlying.load(cmd$1);
            }
            if (option instanceof Some) {
                AggregateState value = (AggregateState)((Some)option).value();
                Serializable serializable = (Serializable)implicits$.MODULE$.catsSyntaxApplicativeId((Object)value);
                return ApplicativeIdOps$.MODULE$.pure$extension((Object)serializable, this.evidence$1);
            }
            throw new MatchError((Object)option);
        });
    }

    private final Object save$$anonfun$1(CommandMessage ctx$1, Object newState$1, long version$1) {
        return this.cache.replace(ctx$1.address(), AggregateState$.MODULE$.apply(newState$1, version$1 + 1L), (Function1 & Serializable)_$2 -> _$2.version() <= version$1);
    }

    private final Object save$$anonfun$2(CommandMessage ctx$2) {
        return this.commands.append(ctx$2);
    }
}

