/*
 * Decompiled with CFR 0.152.
 */
package edomata.backend;

import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.effect.std.Semaphore;
import cats.implicits$;
import cats.syntax.ApplicativeIdOps$;
import edomata.backend.Cache;
import edomata.backend.LRUCache$;
import edomata.backend.LRUCache$CacheItem$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.mutable.Map;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class LRUCache<F, I, T>
implements Cache<F, I, T> {
    private final Map values;
    private Option head;
    private Option last;
    private final Semaphore sem;
    private final int maxSize;
    private final Sync<F> F;

    public static <F, Id, State> Object apply(int n, Async<F> async) {
        return LRUCache$.MODULE$.apply(n, async);
    }

    public LRUCache(Map<I, CacheItem<I, T>> values, Option<CacheItem<I, T>> head, Option<CacheItem<I, T>> last, Semaphore<F> sem, int maxSize, Sync<F> F) {
        this.values = values;
        this.head = head;
        this.last = last;
        this.sem = sem;
        this.maxSize = maxSize;
        this.F = F;
    }

    private Map<I, CacheItem<I, T>> values() {
        return this.values;
    }

    private Option<CacheItem<I, T>> head() {
        return this.head;
    }

    private void head_$eq(Option<CacheItem<I, T>> x$0) {
        this.head = x$0;
    }

    private Option<CacheItem<I, T>> last() {
        return this.last;
    }

    private void last_$eq(Option<CacheItem<I, T>> x$0) {
        this.last = x$0;
    }

    private Semaphore<F> sem() {
        return this.sem;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public F size() {
        return (F)this.sem().permit().use((Function1 & Serializable)_$2 -> {
            Integer n = (Integer)implicits$.MODULE$.catsSyntaxApplicativeId((Object)BoxesRunTime.boxToInteger((int)this.values().size()));
            return ApplicativeIdOps$.MODULE$.pure$extension((Object)n, this.F);
        }, this.F);
    }

    public Resource<F, Iterable<T>> allValues() {
        return this.sem().permit().map((Function1 & Serializable)_$3 -> (Iterable)this.values().values().map((Function1 & Serializable)_$4 -> _$4.value()));
    }

    public Resource<F, Iterator<Tuple2<I, T>>> iterator() {
        return this.sem().permit().map((Function1 & Serializable)_$5 -> this.values().view().mapValues((Function1 & Serializable)_$6 -> _$6.value()).iterator());
    }

    public F firstValue() {
        return (F)this.sem().permit().use((Function1 & Serializable)_$7 -> {
            Option option = (Option)implicits$.MODULE$.catsSyntaxApplicativeId((Object)this.head().map((Function1 & Serializable)_$8 -> _$8.value()));
            return ApplicativeIdOps$.MODULE$.pure$extension((Object)option, this.F);
        }, this.F);
    }

    public F lastValue() {
        return (F)this.sem().permit().use((Function1 & Serializable)_$9 -> {
            Option option = (Option)implicits$.MODULE$.catsSyntaxApplicativeId((Object)this.last().map((Function1 & Serializable)_$10 -> _$10.value()));
            return ApplicativeIdOps$.MODULE$.pure$extension((Object)option, this.F);
        }, this.F);
    }

    public Resource<F, Iterator<T>> valuesByUsage() {
        return this.byUsage().map((Function1 & Serializable)_$11 -> _$11.map((Function1 & Serializable)_$12 -> _$12._2()));
    }

    public Resource<F, Iterator<Tuple2<I, T>>> byUsage() {
        return this.sem().permit().map((Function1 & Serializable)_$13 -> package$.MODULE$.LazyList().iterate(this::byUsage$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$14 -> _$14.flatMap((Function1 & Serializable)_$15 -> _$15.next())).takeWhile((Function1 & Serializable)_$16 -> _$16.isDefined()).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Option x) {
                Option option = x;
                if (option instanceof Some) {
                    CacheItem v = (CacheItem)((Some)option).value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Option x, Function1 function1) {
                Option option = x;
                if (option instanceof Some) {
                    CacheItem v = (CacheItem)((Some)option).value();
                    return Tuple2$.MODULE$.apply(v.key(), v.value());
                }
                return function1.apply((Object)x);
            }
        }).iterator());
    }

    @Override
    public F add(I key, T value) {
        return this.replace(key, value, (Function1 & Serializable)_$17 -> true);
    }

    @Override
    public F get(I key) {
        return (F)this.sem().permit().use((Function1 & Serializable)_$18 -> this.F.delay(() -> this.get$$anonfun$1$$anonfun$1(key)), this.F);
    }

    @Override
    public F replace(I key, T value, Function1<T, Object> pred) {
        return (F)this.sem().permit().use((Function1 & Serializable)_$19 -> this.F.delay(() -> this.replace$$anonfun$1$$anonfun$1(key, value, pred)), this.F);
    }

    private Option<Tuple2<I, T>> evict() {
        if (this.values().size() > this.maxSize()) {
            Option lastValue = this.last().map((Function1 & Serializable)_$20 -> _$20.key()).flatMap((Function1 & Serializable)key -> this.values().remove(key));
            Option beforeLast = this.last().flatMap((Function1 & Serializable)_$21 -> _$21.prev());
            beforeLast.foreach((Function1)(JProcedure1 & Serializable)_$22 -> _$22.next_$eq(None$.MODULE$));
            this.last_$eq(beforeLast);
            return lastValue.map((Function1 & Serializable)v -> Tuple2$.MODULE$.apply(v.key(), v.value()));
        }
        return None$.MODULE$;
    }

    private void makeHead(CacheItem<I, T> item) {
        if (this.head().contains(item)) {
            return;
        }
        if (this.head().exists((Function1 & Serializable)_$23 -> _$23.next().isEmpty())) {
            this.last_$eq(this.head());
        }
        if (this.last().contains(item)) {
            this.last_$eq(item.prev());
        }
        item.prev().foreach((Function1)(JProcedure1 & Serializable)_$24 -> _$24.next_$eq(item.next()));
        item.next().foreach((Function1)(JProcedure1 & Serializable)_$25 -> _$25.prev_$eq(item.prev()));
        item.prev_$eq((Option<CacheItem<I, T>>)None$.MODULE$);
        item.next_$eq(this.head());
        this.head().foreach((Function1)(JProcedure1 & Serializable)_$26 -> _$26.prev_$eq(Some$.MODULE$.apply((Object)item)));
        this.head_$eq((Option<CacheItem<I, T>>)Some$.MODULE$.apply(item));
    }

    private final Option byUsage$$anonfun$1$$anonfun$1() {
        return this.head();
    }

    private final Option get$$anonfun$1$$anonfun$1(Object key$2) {
        Option option = this.values().get(key$2);
        if (option instanceof Some) {
            CacheItem existing = (CacheItem)((Some)option).value();
            this.makeHead(existing);
            return Some$.MODULE$.apply(existing.value());
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    private final Option replace$$anonfun$1$$anonfun$1(Object key$4, Object value$2, Function1 pred$2) {
        block1: {
            Option option;
            block0: {
                CacheItem existing;
                option = this.values().get(key$4);
                if (!(option instanceof Some) || !BoxesRunTime.unboxToBoolean((Object)pred$2.apply((existing = (CacheItem)((Some)option).value()).value()))) break block0;
                existing.value_$eq(value$2);
                this.makeHead(existing);
                break block1;
            }
            if (!None$.MODULE$.equals(option)) break block1;
            CacheItem<Object, Object> newItem = LRUCache$CacheItem$.MODULE$.apply(key$4, value$2, None$.MODULE$, this.head());
            this.values().update(key$4, newItem);
            this.makeHead(newItem);
        }
        return this.evict();
    }

    public static final class CacheItem<I, T>
    implements Product,
    Serializable {
        private final Object key;
        private Object value;
        private Option prev;
        private Option next;

        public static <I, T> CacheItem<I, T> apply(I i, T t, Option<CacheItem<I, T>> option, Option<CacheItem<I, T>> option2) {
            return LRUCache$CacheItem$.MODULE$.apply(i, t, option, option2);
        }

        public static CacheItem<?, ?> fromProduct(Product product) {
            return LRUCache$CacheItem$.MODULE$.fromProduct(product);
        }

        public static <I, T> CacheItem<I, T> unapply(CacheItem<I, T> cacheItem) {
            return LRUCache$CacheItem$.MODULE$.unapply(cacheItem);
        }

        public CacheItem(I key, T value, Option<CacheItem<I, T>> prev, Option<CacheItem<I, T>> next) {
            this.key = key;
            this.value = value;
            this.prev = prev;
            this.next = next;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CacheItem)) return false;
            CacheItem cacheItem = (CacheItem)object;
            if (!BoxesRunTime.equals(this.key(), cacheItem.key())) return false;
            if (!BoxesRunTime.equals(this.value(), cacheItem.value())) return false;
            Option<CacheItem<I, T>> option = this.prev();
            Option<CacheItem<I, T>> option2 = cacheItem.prev();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<CacheItem<I, T>> option3 = this.next();
            Option<CacheItem<I, T>> option4 = cacheItem.next();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CacheItem;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "CacheItem";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "key";
                }
                case 1: {
                    return "value";
                }
                case 2: {
                    return "prev";
                }
                case 3: {
                    return "next";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public I key() {
            return (I)this.key;
        }

        public T value() {
            return (T)this.value;
        }

        public void value_$eq(T x$1) {
            this.value = x$1;
        }

        public Option<CacheItem<I, T>> prev() {
            return this.prev;
        }

        public void prev_$eq(Option<CacheItem<I, T>> x$1) {
            this.prev = x$1;
        }

        public Option<CacheItem<I, T>> next() {
            return this.next;
        }

        public void next_$eq(Option<CacheItem<I, T>> x$1) {
            this.next = x$1;
        }

        public <I, T> CacheItem<I, T> copy(I key, T value, Option<CacheItem<I, T>> prev, Option<CacheItem<I, T>> next) {
            return new CacheItem<I, T>(key, value, prev, next);
        }

        public <I, T> I copy$default$1() {
            return this.key();
        }

        public <I, T> T copy$default$2() {
            return this.value();
        }

        public <I, T> Option<CacheItem<I, T>> copy$default$3() {
            return this.prev();
        }

        public <I, T> Option<CacheItem<I, T>> copy$default$4() {
            return this.next();
        }

        public I _1() {
            return this.key();
        }

        public T _2() {
            return this.value();
        }

        public Option<CacheItem<I, T>> _3() {
            return this.prev();
        }

        public Option<CacheItem<I, T>> _4() {
            return this.next();
        }
    }
}

