/*
 * Decompiled with CFR 0.152.
 */
package edomata.backend;

import cats.Monad;
import cats.effect.kernel.Async;
import cats.effect.kernel.Ref;
import cats.implicits$;
import edomata.backend.Cache;
import edomata.backend.CommandStore$;
import edomata.core.CommandMessage;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.HashSet;
import scala.runtime.BoxedUnit;

public interface CommandStore<F> {
    public static <F> Object inMem(int n, Async<F> async) {
        return CommandStore$.MODULE$.inMem(n, async);
    }

    public F append(CommandMessage<?> var1);

    public F contains(String var1);

    public static final class InMemoryCommandStore<F>
    implements CommandStore<F> {
        private final Cache<F, String, BoxedUnit> cache;
        private final Ref<F, HashSet<String>> set;
        private final Monad<F> evidence$1;

        public InMemoryCommandStore(Cache<F, String, BoxedUnit> cache, Ref<F, HashSet<String>> set, Monad<F> evidence$1) {
            this.cache = cache;
            this.set = set;
            this.evidence$1 = evidence$1;
        }

        @Override
        public F append(CommandMessage<?> cmd) {
            return (F)implicits$.MODULE$.toFlatMapOps(this.cache.add(cmd.id(), BoxedUnit.UNIT), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                Option option = x$1;
                if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                    String id = (String)tuple2._1();
                    return this.set.update((Function1 & Serializable)_$6 -> (HashSet)_$6.$minus((Object)id).$plus((Object)cmd.id()));
                }
                if (None$.MODULE$.equals(option)) {
                    return this.set.update((Function1 & Serializable)_$7 -> (HashSet)_$7.$plus((Object)cmd.id()));
                }
                throw new MatchError((Object)option);
            });
        }

        @Override
        public F contains(String id) {
            return (F)implicits$.MODULE$.toFunctorOps(this.set.get(), this.evidence$1).map((Function1 & Serializable)_$8 -> _$8.contains((Object)id));
        }
    }
}

