/*
 * Decompiled with CFR 0.152.
 */
package ganymede.shell.builtin;

import ball.annotation.ServiceProviderFor;
import com.fasterxml.jackson.core.JsonProcessingException;
import ganymede.notebook.Description;
import ganymede.notebook.Magic;
import ganymede.shell.Builtin;
import ganymede.shell.Shell;
import java.io.InputStream;
import java.io.PrintStream;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.aether.RepositoryException;

@ServiceProviderFor(value={Builtin.class, Magic.class})
@Description(value="Define the Notebook's Project Object Model")
public class POM
extends Builtin {
    @Generated
    private static final Logger log = LogManager.getLogger(POM.class);

    @Override
    public void execute(Shell shell, InputStream in, PrintStream out, PrintStream err, Magic.Application application) throws Exception {
        try {
            String code = application.getCode();
            if (!code.isBlank()) {
                code = HELPER.replacePlaceholders(code, System.getProperties());
                shell.resolve(ganymede.dependency.POM.parse(code));
            } else {
                shell.resolver().pom().writeTo(out);
            }
        }
        catch (RepositoryException exception) {
            err.println(exception.getMessage());
        }
        catch (JsonProcessingException exception) {
            err.println(exception.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace(err);
        }
    }

    @Generated
    public POM() {
    }

    @Generated
    public String toString() {
        return "POM()";
    }
}

