/*
 * Decompiled with CFR 0.152.
 */
package ganymede.shell.builtin;

import ball.annotation.ServiceProviderFor;
import ganymede.notebook.Description;
import ganymede.notebook.Magic;
import ganymede.shell.Builtin;
import ganymede.shell.Shell;
import ganymede.util.PathPropertyMap;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ServiceProviderFor(value={Builtin.class, Magic.class})
@Description(value="Add to or print JShell classpath")
public class Classpath
extends Builtin {
    @Generated
    private static final Logger log = LogManager.getLogger(Classpath.class);
    private static final String SEPARATOR = System.getProperty("path.separator");

    @Override
    public void execute(Shell shell, InputStream in, PrintStream out, PrintStream err, Magic.Application application) throws Exception {
        String code = application.getCode();
        if (!code.isBlank()) {
            File[] files = (File[])HELPER.replacePlaceholders(code, System.getProperties()).lines().filter(t -> !t.isBlank()).map(String::strip).flatMap(t -> Stream.of(t.split(SEPARATOR))).filter(t -> !t.isBlank()).map(String::strip).map(File::new).toArray(File[]::new);
            shell.addToClasspath(files);
        } else {
            PathPropertyMap map = new PathPropertyMap();
            shell.resolver().classpath().stream().map(Object::toString).map(arg_0 -> ((PathPropertyMap)map).shorten(arg_0)).forEach(out::println);
        }
    }

    @Generated
    public Classpath() {
    }

    @Generated
    public String toString() {
        return "Classpath()";
    }
}

