/*
 * Decompiled with CFR 0.152.
 */
package ganymede.shell;

import com.fasterxml.jackson.databind.JsonNode;
import ganymede.dependency.POM;
import ganymede.dependency.Resolver;
import ganymede.kernel.Kernel;
import ganymede.notebook.Description;
import ganymede.notebook.Magic;
import ganymede.notebook.MagicMap;
import ganymede.notebook.MagicNames;
import ganymede.notebook.NotebookContext;
import ganymede.server.Message;
import ganymede.shell.Builtin;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import jdk.jshell.JShell;
import jdk.jshell.Snippet;
import jdk.jshell.SnippetEvent;
import jdk.jshell.SourceCodeAnalysis;
import lombok.Generated;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.io.IoBuilder;

public class Shell
implements AutoCloseable {
    @Generated
    private static final Logger log = LogManager.getLogger(Shell.class);
    @Generated
    private final Object $lock = new Object[0];
    private static final String[] VMOPTIONS = (String[])Stream.of("--illegal-access=permit", "--add-opens", "java.base/jdk.internal.misc=ALL-UNNAMED", "-Dio.netty.tryReflectionSetAccessible=true", "-Djava.awt.headless=true").toArray(String[]::new);
    private final Kernel kernel;
    private Locale locale = null;
    private final AtomicInteger restarts = new AtomicInteger(0);
    private final Java java = new Java();
    private final BuiltinMap builtins = new BuiltinMap();
    private final Resolver resolver = new Resolver();
    private JShell jshell = null;
    private InputStream in = null;
    private PrintStream out = null;
    private PrintStream err = null;

    public Shell(Kernel kernel) {
        this.kernel = Objects.requireNonNull(kernel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(InputStream in, PrintStream out, PrintStream err) {
        Object object = this.$lock;
        synchronized (object) {
            this.in = in;
            this.out = out;
            this.err = err;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(InputStream in, PrintStream out, PrintStream err) {
        Object object = this.$lock;
        synchronized (object) {
            this.close();
            if (!this.kernel().isTerminating()) {
                this.start(in, out, err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.$lock;
        synchronized (object) {
            try (JShell jshell = this.jshell;){
                this.jshell = null;
                if (jshell != null) {
                    this.restarts.incrementAndGet();
                }
            }
        }
    }

    public Kernel kernel() {
        return this.kernel;
    }

    public Resolver resolver() {
        return this.resolver;
    }

    public void resolve(POM pom) {
        List<File> files = this.resolver().resolve(this, this.out, this.err, pom);
        JShell jshell = this.jshell;
        if (jshell != null) {
            files.stream().map(Object::toString).forEach(jshell::addToClasspath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToClasspath(File ... files) {
        Object object = this.$lock;
        synchronized (object) {
            for (File file : this.resolver.addToClasspath(files)) {
                JShell jshell = this.jshell;
                if (jshell == null) break;
                jshell.addToClasspath(file.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKnownDependenciesToClasspath(File parent) {
        Object object = this.$lock;
        synchronized (object) {
            for (File file : this.resolver.addKnownDependenciesToClasspath(parent)) {
                JShell jshell = this.jshell;
                if (jshell == null) break;
                jshell.addToClasspath(file.toString());
            }
        }
    }

    public Set<File> classpath() {
        return this.resolver.classpath();
    }

    public Set<String> imports() {
        Set imports = Set.of();
        JShell jshell = this.jshell;
        if (jshell != null) {
            imports = NotebookContext.imports((JShell)jshell);
        }
        return imports;
    }

    public Map<String, String> variables() {
        Map variables = Map.of();
        JShell jshell = this.jshell;
        if (jshell != null) {
            variables = NotebookContext.variables((JShell)jshell);
        }
        return variables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JShell jshell() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.jshell == null) {
                ArrayList<CallSite> options = new ArrayList<CallSite>();
                String[] definitions = (String[])Stream.of(ProcessHandle.current().info().arguments()).flatMap(Optional::stream).flatMap(Stream::of).takeWhile(t -> !Objects.equals(t, "-jar")).filter(t -> t.startsWith("-D")).toArray(String[]::new);
                Collections.addAll(options, definitions);
                Collections.addAll(options, VMOPTIONS);
                options.add((CallSite)((Object)("-D" + Map.entry("kernel.port", this.kernel.getPort()))));
                if (!this.kernel.isTerminating()) {
                    try {
                        this.jshell = JShell.builder().remoteVMOptions(options.toArray(new String[0])).in(this.in).out(this.out).err(this.err).build();
                        this.resolver().classpath().forEach(t -> this.jshell.addToClasspath(t.toString()));
                        InputStream logIn = IoBuilder.forLogger((Logger)log).setLevel(Level.WARN).filter(InputStream.nullInputStream()).buildInputStream();
                        PrintStream logOut = IoBuilder.forLogger((Logger)log).setLevel(Level.WARN).buildPrintStream();
                        this.java.execute(this.jshell, logIn, logOut, logOut, NotebookContext.bootstrap());
                    }
                    catch (Exception exception) {
                        log.warn("{}", (Object)exception, (Object)exception);
                    }
                }
            }
            return this.jshell;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String code) {
        JShell jshell = this.jshell();
        try {
            Java builtin;
            NotebookContext.preExecute((JShell)jshell);
            Magic.Application application = new Magic.Application(code);
            String name = application.getMagicName();
            Builtin builtin2 = builtin = name != null ? this.builtins.get(name) : this.java;
            if (builtin != null) {
                ((Builtin)builtin).execute(this, this.in, this.out, this.err, application);
            } else {
                NotebookContext.invoke((JShell)jshell, (String)name);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(this.err);
        }
        finally {
            NotebookContext.postExecute((JShell)jshell);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String evaluate(String expression) throws Exception {
        Object object = this.$lock;
        synchronized (object) {
            String result = "";
            JShell jshell = this.jshell();
            if (jshell != null) {
                SourceCodeAnalysis analyzer = jshell.sourceCodeAnalysis();
                SourceCodeAnalysis.CompletionInfo info = analyzer.analyzeCompletion(expression);
                if (!info.completeness().isComplete()) {
                    throw new IllegalArgumentException(expression);
                }
                result = NotebookContext.unescape((String)jshell.eval(info.source()).get(0).value());
            }
            return result;
        }
    }

    public Magic.completeness isComplete(String code) {
        Magic.completeness completeness2 = Magic.completeness.unknown;
        Magic.Application application = new Magic.Application(code);
        String name = application.getMagicName();
        if (name == null || this.builtins.containsKey(name)) {
            Java builtin = name != null ? this.builtins.get(name) : this.java;
            completeness2 = builtin.isComplete(application.getLine0(), application.getCode());
        } else {
            completeness2 = Magic.completeness.invalid;
        }
        return completeness2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.$lock;
        synchronized (object) {
            JShell jshell = this.jshell;
            if (jshell != null) {
                jshell.stop();
            }
        }
    }

    public int restarts() {
        return this.restarts.intValue();
    }

    @Generated
    public String toString() {
        return "Shell(kernel=" + this.kernel + ", locale=" + this.locale + ", restarts=" + this.restarts + ", java=" + this.java + ", builtins=" + this.builtins + ", resolver=" + this.resolver + ", jshell=" + this.jshell + ", in=" + this.in + ", out=" + this.out + ", err=" + this.err + ")";
    }

    private class UnknownParseException
    extends ParseException {
        private static final long serialVersionUID = -336967204687913199L;

        public UnknownParseException(int offset) {
            super("Unknown input", offset);
        }
    }

    private class IncompleteParseException
    extends ParseException {
        private static final long serialVersionUID = -2830925996685540774L;

        public IncompleteParseException(int offset) {
            super("Incomplete input", offset);
        }
    }

    private class BuiltinMap
    extends MagicMap {
        private static final long serialVersionUID = 1258050942509042030L;

        public BuiltinMap() {
            super(Builtin.class, null);
            this.reload();
        }

        public BuiltinMap reload() {
            super.reload();
            Stream.of(Shell.this.java.getMagicNames()).forEach(t -> this.put(t, (Object)Shell.this.java));
            return this;
        }

        public Builtin get(Object key) {
            return (Builtin)((Object)super.get(key));
        }
    }

    @MagicNames(value={"java"})
    @Description(value="Execute code in Java REPL")
    private class Java
    extends Builtin {
        @Override
        public void execute(Shell shell, InputStream in, PrintStream out, PrintStream err, Magic.Application application) throws Exception {
            String code = application.getCode();
            if (!code.isBlank()) {
                this.execute(shell.jshell(), in, out, err, code);
            } else if (application.getLine0() != null) {
                NotebookContext.invoke((JShell)Shell.this.jshell(), (String)this.getMagicNames()[0]);
            }
        }

        public Magic.completeness isComplete(String line0, String code) {
            Magic.completeness completeness2;
            block6: {
                completeness2 = Magic.completeness.unknown;
                if (!code.isBlank()) {
                    JShell jshell = Shell.this.jshell;
                    if (jshell != null) {
                        try {
                            if (!this.parse(jshell, code).isEmpty()) {
                                completeness2 = Magic.completeness.complete;
                                break block6;
                            }
                            completeness2 = Magic.completeness.incomplete;
                        }
                        catch (ParseException exception) {
                            completeness2 = Magic.completeness.incomplete;
                        }
                    }
                } else {
                    completeness2 = Magic.completeness.incomplete;
                }
            }
            return completeness2;
        }

        private SortedMap<Integer, SourceCodeAnalysis.CompletionInfo> parse(JShell jshell, String code) throws ParseException {
            TreeMap<Integer, SourceCodeAnalysis.CompletionInfo> map = new TreeMap<Integer, SourceCodeAnalysis.CompletionInfo>();
            SourceCodeAnalysis analyzer = jshell.sourceCodeAnalysis();
            int offset = 0;
            String remaining = code;
            while (!remaining.isEmpty()) {
                SourceCodeAnalysis.CompletionInfo value = analyzer.analyzeCompletion(remaining);
                switch (value.completeness()) {
                    case DEFINITELY_INCOMPLETE: {
                        throw new IncompleteParseException(offset);
                    }
                    case UNKNOWN: {
                        throw new UnknownParseException(offset);
                    }
                }
                map.put(offset, value);
                offset += value.source().length();
                if (!(remaining = remaining.substring(value.source().length())).isBlank()) continue;
                break;
            }
            return map;
        }

        public void configure(NotebookContext context) {
            throw new IllegalStateException();
        }

        @Override
        public void execute(String line0, String code, JsonNode metadata) throws Exception {
            throw new IllegalStateException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void execute(JShell jshell, InputStream in, PrintStream out, PrintStream err, String code) {
            try {
                Iterator<Map.Entry<Integer, SourceCodeAnalysis.CompletionInfo>> iterator = this.parse(jshell, code).entrySet().iterator();
                boolean errored = false;
                block16: while (!errored && iterator.hasNext()) {
                    Map.Entry<Integer, SourceCodeAnalysis.CompletionInfo> entry = iterator.next();
                    SourceCodeAnalysis.CompletionInfo info = entry.getValue();
                    switch (info.completeness()) {
                        case EMPTY: {
                            continue block16;
                        }
                        case COMPLETE: 
                        case COMPLETE_WITH_SEMI: 
                        case CONSIDERED_INCOMPLETE: {
                            List<SnippetEvent> events = jshell.eval(info.source());
                            for (SnippetEvent event : events) {
                                if (!event.status().equals((Object)Snippet.Status.REJECTED)) {
                                    if (event.exception() == null) continue;
                                    errored |= true;
                                    event.exception().printStackTrace(err);
                                    continue;
                                }
                                errored |= true;
                                err.format("%s %s\n%s\n", new Object[]{event.status(), event.snippet().kind(), event.snippet().source()});
                                jshell.diagnostics(event.snippet()).map(t -> t.getMessage(Shell.this.locale)).forEach(err::println);
                            }
                            if (errored || iterator.hasNext() || events.isEmpty()) continue block16;
                            SnippetEvent event = events.get(events.size() - 1);
                            switch (event.snippet().subKind()) {
                                case TEMP_VAR_EXPRESSION_SUBKIND: 
                                case VAR_VALUE_SUBKIND: {
                                    Shell.this.kernel.print((JsonNode)Message.mime_bundle(NotebookContext.unescape((String)event.value()), new Object[0]));
                                    break;
                                }
                            }
                            continue block16;
                        }
                    }
                    throw new IllegalStateException(String.valueOf((Object)info.completeness()));
                }
            }
            catch (IncompleteParseException exception) {
                err.format("Incomplete input:\n%s\n", code.substring(exception.getErrorOffset()));
            }
            catch (UnknownParseException exception) {
                err.format("Unknown input:\n%s\n", code.substring(exception.getErrorOffset()));
            }
            catch (Exception exception) {
                exception.printStackTrace(err);
            }
            finally {
                out.flush();
                err.flush();
            }
        }

        @Generated
        public Java() {
        }

        @Generated
        public String toString() {
            return "Shell.Java()";
        }
    }
}

